/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.ui.tree;

import com.intellij.ide.bookmark.BookmarkBundle;
import com.intellij.ide.bookmark.BookmarkGroup;
import com.intellij.ide.bookmark.BookmarksListProvider;
import com.intellij.ide.bookmark.BookmarksManager;
import com.intellij.ide.bookmark.ui.GroupRenameDialog;
import com.intellij.ide.bookmark.ui.tree.ExtensionsKt;
import com.intellij.ide.bookmark.ui.tree.GroupNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\fH\u0016J\u0012\u0010\r\u001a\f0\u000e\u00a2\u0006\u0002\b\u000f\u00a2\u0006\u0002\b\u0010H\u0016J\u0012\u0010\u0011\u001a\f0\u000e\u00a2\u0006\u0002\b\u000f\u00a2\u0006\u0002\b\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0003H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u001c\u0010\u0015\u001a\u00020\u00162\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ide/bookmark/ui/tree/GroupListProvider;", "Lcom/intellij/ide/bookmark/BookmarksListProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "canDelete", "", "selection", "", "canEdit", "", "createNode", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "getDeleteActionText", "", "Lorg/jetbrains/annotations/Nls;", "Lorg/jetbrains/annotations/NotNull;", "getEditActionText", "getProject", "getWeight", "", "performDelete", "", "parent", "Ljavax/swing/JComponent;", "performEdit", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nGroupListProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GroupListProvider.kt\ncom/intellij/ide/bookmark/ui/tree/GroupListProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,33:1\n1726#2,3:34\n1855#2,2:37\n*S KotlinDebug\n*F\n+ 1 GroupListProvider.kt\ncom/intellij/ide/bookmark/ui/tree/GroupListProvider\n*L\n27#1:34,3\n28#1:37,2\n*E\n"})
public final class GroupListProvider
implements BookmarksListProvider {
    @NotNull
    private final Project project;

    public GroupListProvider(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    @Override
    public int getWeight() {
        return Integer.MAX_VALUE;
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Override
    @Nullable
    public AbstractTreeNode<?> createNode() {
        return null;
    }

    @Override
    @NotNull
    public String getEditActionText() {
        String string2 = BookmarkBundle.message("bookmark.group.rename.action.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"bookmark.group.rename.action.text\")");
        return string2;
    }

    @Override
    public boolean canEdit(@NotNull Object selection) {
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        return selection instanceof GroupNode;
    }

    @Override
    public void performEdit(@NotNull Object selection, @NotNull JComponent parent2) {
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        GroupNode groupNode = selection instanceof GroupNode ? (GroupNode)((Object)selection) : null;
        if (groupNode == null) {
            return;
        }
        GroupNode node2 = groupNode;
        BookmarkGroup bookmarkGroup = (BookmarkGroup)node2.getValue();
        if (bookmarkGroup == null) {
            return;
        }
        BookmarkGroup group2 = bookmarkGroup;
        BookmarksManager bookmarksManager = ExtensionsKt.getBookmarksManager(node2);
        if (bookmarksManager == null) {
            return;
        }
        BookmarksManager manager = bookmarksManager;
        new GroupRenameDialog(this.project, parent2, manager, group2).showAndGetGroup();
    }

    @Override
    @NotNull
    public String getDeleteActionText() {
        String string2 = BookmarkBundle.message("bookmark.group.delete.action.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"bookmark.group.delete.action.text\")");
        return string2;
    }

    @Override
    public boolean canDelete(@NotNull List<?> selection) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(selection, (String)"selection");
            Iterable $this$all$iv = selection;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator2 = $this$all$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv;
                    Object it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    if (it instanceof GroupNode) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public void performDelete(@NotNull List<?> selection, @NotNull JComponent parent2) {
        Intrinsics.checkNotNullParameter(selection, (String)"selection");
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        Iterable $this$forEach$iv = selection;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator2.next();
            boolean bl = false;
            GroupNode node2 = it instanceof GroupNode ? (GroupNode)((Object)it) : null;
            Object object = node2;
            if (object == null || (object = (BookmarkGroup)object.getValue()) == null) continue;
            object.remove();
        }
    }
}

