/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.ui.tree;

import com.intellij.icons.AllIcons;
import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.BookmarkBundle;
import com.intellij.ide.bookmark.BookmarkGroup;
import com.intellij.ide.bookmark.BookmarkProvider;
import com.intellij.ide.bookmark.LineBookmark;
import com.intellij.ide.bookmark.ui.BookmarksView;
import com.intellij.ide.bookmark.ui.tree.BookmarkNode;
import com.intellij.ide.bookmark.ui.tree.ExtensionsKt;
import com.intellij.ide.bookmark.ui.tree.GroupNode;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeNodeCache;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.ui.SimpleTextAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00010\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ide/bookmark/ui/tree/GroupNode;", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "Lcom/intellij/ide/bookmark/BookmarkGroup;", "project", "Lcom/intellij/openapi/project/Project;", "group", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ide/bookmark/BookmarkGroup;)V", "cache", "Lcom/intellij/ide/util/treeView/AbstractTreeNodeCache;", "Lcom/intellij/ide/bookmark/Bookmark;", "getChildren", "", "update", "", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nGroupNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GroupNode.kt\ncom/intellij/ide/bookmark/ui/tree/GroupNode\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,43:1\n800#2,11:44\n2634#2:55\n1054#2:57\n1855#2,2:58\n1#3:56\n*S KotlinDebug\n*F\n+ 1 GroupNode.kt\ncom/intellij/ide/bookmark/ui/tree/GroupNode\n*L\n25#1:44,11\n29#1:55\n30#1:57\n30#1:58,2\n29#1:56\n*E\n"})
public final class GroupNode
extends AbstractTreeNode<BookmarkGroup> {
    @NotNull
    private final AbstractTreeNodeCache<Bookmark, AbstractTreeNode<?>> cache;

    public GroupNode(@NotNull Project project2, @NotNull BookmarkGroup group2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        super(project2, (Object)group2);
        this.cache = new AbstractTreeNodeCache((AbstractTreeNode)this, (Function1)cache.1.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<AbstractTreeNode<?>> getChildren() {
        List bookmarks = ((BookmarkGroup)this.getValue()).getBookmarks();
        Object object = ExtensionsKt.getParentRootNode(this);
        boolean bl = object != null && (object = (BookmarksView)object.getValue()) != null ? ((BookmarksView)object).isPopup() : false;
        if (bl && AdvancedSettings.Companion.getBoolean("show.line.bookmarks.in.popup")) {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = bookmarks;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Iterator element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof LineBookmark)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            bookmarks = (List)destination$iv$iv;
        }
        List<AbstractTreeNode<?>> nodes2 = null;
        List<AbstractTreeNode<?>> $this$onEach$iv = this.cache.getNodes((Collection)bookmarks);
        boolean $i$f$onEach = false;
        List<AbstractTreeNode<?>> list2 = $this$onEach$iv;
        List<AbstractTreeNode<?>> $this$onEach_u24lambda_u2416$iv = list2;
        boolean bl2 = false;
        for (Object t : $this$onEach_u24lambda_u2416$iv) {
            AbstractTreeNode it = (AbstractTreeNode)t;
            boolean bl3 = false;
            if (!(it instanceof BookmarkNode)) continue;
            ((BookmarkNode)it).setBookmarkGroup((BookmarkGroup)this.getValue());
        }
        nodes2 = list2;
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        Iterable $this$sortedByDescending$iv = BookmarkProvider.EP.getExtensions(project2);
        boolean $i$f$sortedByDescending = false;
        Iterable $this$forEach$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                BookmarkProvider it = (BookmarkProvider)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getWeight());
                it = (BookmarkProvider)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getWeight()));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BookmarkProvider it = (BookmarkProvider)element$iv;
            boolean bl4 = false;
            Intrinsics.checkNotNullExpressionValue(it.prepareGroup(nodes2), (String)"it.prepareGroup(nodes)");
        }
        return nodes2;
    }

    protected void update(@NotNull PresentationData presentation2) {
        Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
        presentation2.setPresentableText(((BookmarkGroup)this.getValue()).getName());
        presentation2.setIcon(AllIcons.Nodes.BookmarkGroup);
        if (((BookmarkGroup)this.getValue()).isDefault()) {
            presentation2.addText(presentation2.getPresentableText() + "  ", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            presentation2.addText(BookmarkBundle.message("default.group.marker", new Object[0]), SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
    }
}

