/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.extensionResources;

import com.intellij.ide.extensionResources.ResourceVersions;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginDependency;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.DigestUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExtensionsRootType
extends RootType {
    static final Logger LOG = Logger.getInstance(ExtensionsRootType.class);
    @NonNls
    private static final String EXTENSIONS_PATH = "extensions";
    @NonNls
    private static final String BACKUP_FILE_EXTENSION = "old";

    ExtensionsRootType() {
        super(EXTENSIONS_PATH, LangBundle.message("root.type.extensions", new Object[0]));
    }

    @NotNull
    public static ExtensionsRootType getInstance() {
        ExtensionsRootType extensionsRootType = ExtensionsRootType.findByClass(ExtensionsRootType.class);
        if (extensionsRootType == null) {
            ExtensionsRootType.$$$reportNull$$$0(0);
        }
        return extensionsRootType;
    }

    @NotNull
    public static Predicate<Path> regularFileFilter() {
        Predicate<Path> predicate2 = file2 -> {
            try {
                if (Files.isDirectory(file2, new LinkOption[0]) || Files.isHidden(file2)) {
                    return false;
                }
            }
            catch (IOException e) {
                return false;
            }
            String fileName = file2.getFileName().toString();
            int index2 = fileName.lastIndexOf(46);
            return index2 >= 0 && !fileName.endsWith(".txt") && !fileName.endsWith(".properties") && !fileName.regionMatches(index2 + 1, BACKUP_FILE_EXTENSION, 0, BACKUP_FILE_EXTENSION.length());
        };
        if (predicate2 == null) {
            ExtensionsRootType.$$$reportNull$$$0(1);
        }
        return predicate2;
    }

    @Nullable
    public PluginId getOwner(@Nullable VirtualFile resource) {
        VirtualFile file2 = resource == null ? null : this.getPluginResourcesDirectoryFor(resource);
        return file2 == null ? null : PluginId.findId(file2.getName());
    }

    @Nullable
    public Path findResource(@NotNull PluginId pluginId, @NotNull String path2) throws IOException {
        if (pluginId == null) {
            ExtensionsRootType.$$$reportNull$$$0(2);
        }
        if (path2 == null) {
            ExtensionsRootType.$$$reportNull$$$0(3);
        }
        this.extractBundledExtensionsIfNeeded(pluginId);
        return this.findExtensionImpl(pluginId, path2);
    }

    @NotNull
    public Path findResourceDirectory(@NotNull PluginId pluginId, @NotNull String path2, boolean createIfMissing) throws IOException {
        if (pluginId == null) {
            ExtensionsRootType.$$$reportNull$$$0(4);
        }
        if (path2 == null) {
            ExtensionsRootType.$$$reportNull$$$0(5);
        }
        this.extractBundledExtensionsIfNeeded(pluginId);
        return this.findExtensionsDirectoryImpl(pluginId, path2, createIfMissing);
    }

    public void extractBundledResources(@NotNull PluginId pluginId, @NotNull String path2) throws IOException {
        List<URL> bundledResources;
        if (pluginId == null) {
            ExtensionsRootType.$$$reportNull$$$0(6);
        }
        if (path2 == null) {
            ExtensionsRootType.$$$reportNull$$$0(7);
        }
        if ((bundledResources = ExtensionsRootType.getBundledResourceUrls(pluginId, path2)).isEmpty()) {
            return;
        }
        Path resourcesDirectory = this.findExtensionsDirectoryImpl(pluginId, path2, true);
        for (URL bundledResourceDirUrl : bundledResources) {
            VirtualFile bundledResourcesDir = VfsUtil.findFileByURL(bundledResourceDirUrl);
            if (bundledResourcesDir == null || !bundledResourcesDir.isDirectory()) continue;
            if (LOG.isTraceEnabled()) {
                LOG.trace(new Throwable("Extract bundled resources " + pluginId.getIdString() + " to " + resourcesDirectory));
            }
            ExtensionsRootType.extractResources(bundledResourcesDir, resourcesDirectory);
        }
    }

    @Override
    @Nullable
    public String substituteName(@NotNull Project project2, @NotNull VirtualFile file2) {
        String name;
        VirtualFile resourcesDir;
        if (project2 == null) {
            ExtensionsRootType.$$$reportNull$$$0(8);
        }
        if (file2 == null) {
            ExtensionsRootType.$$$reportNull$$$0(9);
        }
        if (file2.equals(resourcesDir = this.getPluginResourcesDirectoryFor(file2)) && (name = this.getPluginResourcesRootName(resourcesDir)) != null) {
            return name;
        }
        return super.substituteName(project2, file2);
    }

    @Nullable
    String getPath(@Nullable VirtualFile resource) {
        VirtualFile pluginResourcesDir = resource == null ? null : this.getPluginResourcesDirectoryFor(resource);
        PluginId pluginId = this.getOwner(pluginResourcesDir);
        return pluginResourcesDir != null && pluginId != null ? VfsUtilCore.getRelativePath(resource, pluginResourcesDir) : null;
    }

    @Nullable
    private Path findExtensionImpl(@NotNull PluginId pluginId, @NotNull String path2) {
        Path file2;
        if (pluginId == null) {
            ExtensionsRootType.$$$reportNull$$$0(10);
        }
        if (path2 == null) {
            ExtensionsRootType.$$$reportNull$$$0(11);
        }
        return Files.isRegularFile(file2 = Path.of(this.getPath(pluginId, ""), new String[0]).resolve(path2), new LinkOption[0]) ? file2 : null;
    }

    @NotNull
    private Path findExtensionsDirectoryImpl(@NotNull PluginId pluginId, @NotNull String path2, boolean createIfMissing) throws IOException {
        if (pluginId == null) {
            ExtensionsRootType.$$$reportNull$$$0(12);
        }
        if (path2 == null) {
            ExtensionsRootType.$$$reportNull$$$0(13);
        }
        Path dir = Path.of(this.getPath(pluginId, path2), new String[0]);
        if (createIfMissing) {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        Path path3 = dir;
        if (path3 == null) {
            ExtensionsRootType.$$$reportNull$$$0(14);
        }
        return path3;
    }

    @Nullable
    private String getPluginResourcesRootName(VirtualFile resourcesDir) {
        PluginId ownerPluginId = this.getOwner(resourcesDir);
        if (ownerPluginId == null) {
            return null;
        }
        if (PluginManagerCore.CORE_ID.equals(ownerPluginId)) {
            return PlatformUtils.getPlatformPrefix();
        }
        IdeaPluginDescriptor plugin = PluginManagerCore.getPlugin(ownerPluginId);
        if (plugin != null) {
            return plugin.getName();
        }
        return null;
    }

    private VirtualFile getPluginResourcesDirectoryFor(@NotNull VirtualFile resource) {
        if (resource == null) {
            ExtensionsRootType.$$$reportNull$$$0(15);
        }
        String rootPath = ScratchFileService.getInstance().getRootPath(this);
        VirtualFile root = LocalFileSystem.getInstance().findFileByPath(rootPath);
        if (root == null) {
            return null;
        }
        VirtualFile parent2 = resource;
        VirtualFile file2 = resource;
        while (parent2 != null && !root.equals(parent2)) {
            file2 = parent2;
            parent2 = file2.getParent();
        }
        return parent2 != null && file2.isDirectory() ? file2 : null;
    }

    @NotNull
    private String getPath(@NotNull PluginId pluginId, @NotNull String path2) {
        if (pluginId == null) {
            ExtensionsRootType.$$$reportNull$$$0(16);
        }
        if (path2 == null) {
            ExtensionsRootType.$$$reportNull$$$0(17);
        }
        String string2 = ScratchFileService.getInstance().getRootPath(this) + "/" + pluginId.getIdString() + (String)(Strings.isEmpty(path2) ? "" : "/" + path2);
        if (string2 == null) {
            ExtensionsRootType.$$$reportNull$$$0(18);
        }
        return string2;
    }

    @NotNull
    private static List<URL> getBundledResourceUrls(@NotNull PluginId pluginId, @NotNull String path2) throws IOException {
        IdeaPluginDescriptorImpl plugin;
        if (pluginId == null) {
            ExtensionsRootType.$$$reportNull$$$0(19);
        }
        if (path2 == null) {
            ExtensionsRootType.$$$reportNull$$$0(20);
        }
        if ((plugin = (IdeaPluginDescriptorImpl)PluginManager.getInstance().findEnabledPlugin(pluginId)) == null) {
            List<URL> list2 = Collections.emptyList();
            if (list2 == null) {
                ExtensionsRootType.$$$reportNull$$$0(21);
            }
            return list2;
        }
        ClassLoader pluginClassLoader = plugin.getClassLoader();
        Enumeration<URL> resources = pluginClassLoader.getResources("extensions/" + path2);
        if (resources == null) {
            List<URL> list3 = Collections.emptyList();
            if (list3 == null) {
                ExtensionsRootType.$$$reportNull$$$0(22);
            }
            return list3;
        }
        if (plugin.isUseIdeaClassLoader) {
            List<URL> list4 = ContainerUtil.toList(resources);
            if (list4 == null) {
                ExtensionsRootType.$$$reportNull$$$0(23);
            }
            return list4;
        }
        LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
        while (resources.hasMoreElements()) {
            urls.add(resources.nextElement());
        }
        for (PluginDependency it : plugin.pluginDependencies) {
            ClassLoader loader;
            IdeaPluginDescriptor descriptor2 = PluginManagerCore.getPlugin(it.getPluginId());
            if (descriptor2 == null || (loader = descriptor2.getClassLoader()) == pluginClassLoader) continue;
            Enumeration<URL> pluginResources = loader.getResources("extensions/" + path2);
            while (pluginResources.hasMoreElements()) {
                urls.remove(pluginResources.nextElement());
            }
        }
        return new ArrayList<URL>(urls);
    }

    private static void extractResources(final @NotNull VirtualFile from, final @NotNull Path to) throws IOException {
        if (from == null) {
            ExtensionsRootType.$$$reportNull$$$0(24);
        }
        if (to == null) {
            ExtensionsRootType.$$$reportNull$$$0(25);
        }
        VfsUtilCore.visitChildrenRecursively(from, new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[]{VirtualFileVisitor.NO_FOLLOW_SYMLINKS}){

            @Override
            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file2) {
                VirtualFileVisitor.Result result2;
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    result2 = this.visitImpl(file2);
                }
                catch (IOException e) {
                    throw new VirtualFileVisitor.VisitorException(e);
                }
                if (result2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return result2;
            }

            VirtualFileVisitor.Result visitImpl(@NotNull VirtualFile file2) throws IOException {
                File dir;
                File child;
                if (file2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((child = to.resolve(Objects.requireNonNull(VfsUtilCore.getRelativePath(file2, from))).toFile()).exists() && child.isDirectory() != file2.isDirectory()) {
                    ExtensionsRootType.renameToBackupCopy(child);
                }
                File file3 = dir = file2.isDirectory() ? child : child.getParentFile();
                if (!dir.exists() && !dir.mkdirs()) {
                    LOG.warn("Failed to create dir: " + dir.getPath());
                    return SKIP_CHILDREN;
                }
                if (file2.isDirectory()) {
                    return CONTINUE;
                }
                if (file2.getFileType().isBinary()) {
                    return CONTINUE;
                }
                if (file2.getLength() > (long)FileUtilRt.LARGE_FOR_CONTENT_LOADING) {
                    return CONTINUE;
                }
                String newText = FileUtil.loadTextAndClose(file2.getInputStream());
                String oldText = child.exists() ? FileUtil.loadFile(child) : "";
                String newHash = ExtensionsRootType.hash(newText);
                String oldHash = ExtensionsRootType.hash(oldText);
                boolean upToDate = StringUtil.equals(oldHash, newHash);
                if (upToDate) {
                    return CONTINUE;
                }
                if (child.exists()) {
                    ExtensionsRootType.renameToBackupCopy(child);
                }
                FileUtil.writeToFile(child, newText);
                return CONTINUE;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/extensionResources/ExtensionsRootType$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/extensionResources/ExtensionsRootType$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitFileEx";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitFileEx";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "visitImpl";
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string2);
                    case 1 -> new IllegalStateException(string2);
                };
            }
        }, IOException.class);
    }

    @NotNull
    private static String hash(@NotNull String s) {
        byte[] digest;
        if (s == null) {
            ExtensionsRootType.$$$reportNull$$$0(26);
        }
        MessageDigest md52 = DigestUtil.md5();
        StringBuilder sb = new StringBuilder();
        for (byte b : digest = md52.digest(s.getBytes(StandardCharsets.UTF_8))) {
            sb.append(Integer.toHexString(b));
        }
        String string2 = sb.toString();
        if (string2 == null) {
            ExtensionsRootType.$$$reportNull$$$0(27);
        }
        return string2;
    }

    private static void renameToBackupCopy(@NotNull File file2) throws IOException {
        if (file2 == null) {
            ExtensionsRootType.$$$reportNull$$$0(28);
        }
        File parent2 = file2.getParentFile();
        int i2 = 0;
        String newName2 = file2.getName() + ".old";
        while (new File(parent2, newName2).exists()) {
            newName2 = file2.getName() + ".old_" + i2;
            ++i2;
        }
        FileUtil.rename(file2, newName2);
    }

    private void extractBundledExtensionsIfNeeded(@NotNull PluginId pluginId) throws IOException {
        if (pluginId == null) {
            ExtensionsRootType.$$$reportNull$$$0(29);
        }
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            return;
        }
        IdeaPluginDescriptor plugin = PluginManagerCore.getPlugin(pluginId);
        if (plugin == null || !ResourceVersions.getInstance().shouldUpdateResourcesOf(plugin)) {
            return;
        }
        this.extractBundledResources(pluginId, "");
        ResourceVersions.getInstance().resourcesUpdated(plugin);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 15, 16, 17, 19, 20, 24, 25, 26, 28, 29 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/extensionResources/ExtensionsRootType";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 10: 
            case 12: 
            case 16: 
            case 19: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 11: 
            case 13: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resource";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "regularFileFilter";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/extensionResources/ExtensionsRootType";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "findExtensionsDirectoryImpl";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundledResourceUrls";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "hash";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findResource";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findResourceDirectory";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "extractBundledResources";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "substituteName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findExtensionImpl";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findExtensionsDirectoryImpl";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getPluginResourcesDirectoryFor";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getPath";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getBundledResourceUrls";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "extractResources";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "hash";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "renameToBackupCopy";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "extractBundledExtensionsIfNeeded";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 15, 16, 17, 19, 20, 24, 25, 26, 28, 29 -> new IllegalArgumentException(string2);
        };
    }
}

