/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeView;
import com.intellij.ide.actions.EditFileTemplatesAction;
import com.intellij.ide.fileTemplates.CreateFromTemplateActionReplacer;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.fileTemplates.actions.CreateFromTemplateAction;
import com.intellij.ide.fileTemplates.actions.CreateFromTemplateActionBase;
import com.intellij.ide.fileTemplates.impl.FileTemplateBase;
import com.intellij.ide.fileTemplates.ui.SelectTemplateDialog;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.psi.PsiDirectory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateFromTemplateGroup
extends ActionGroup
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            CreateFromTemplateGroup.$$$reportNull$$$0(0);
        }
        super.update(e);
        Presentation presentation2 = e.getPresentation();
        Project project2 = e.getProject();
        if (project2 != null && !project2.isDisposed()) {
            FileTemplate[] allTemplates;
            for (FileTemplate template : allTemplates = FileTemplateManager.getInstance((Project)project2).getAllTemplates()) {
                if (!CreateFromTemplateGroup.canCreateFromTemplate(e, template)) continue;
                presentation2.setEnabled(true);
                return;
            }
        }
        presentation2.setEnabled(false);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            CreateFromTemplateGroup.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        boolean showAll;
        if (e == null) {
            if (EMPTY_ARRAY == null) {
                CreateFromTemplateGroup.$$$reportNull$$$0(2);
            }
            return EMPTY_ARRAY;
        }
        Project project2 = e.getProject();
        if (project2 == null || project2.isDisposed()) {
            if (EMPTY_ARRAY == null) {
                CreateFromTemplateGroup.$$$reportNull$$$0(3);
            }
            return EMPTY_ARRAY;
        }
        FileTemplateManager manager = FileTemplateManager.getInstance((Project)project2);
        FileTemplate[] templates = manager.getAllTemplates();
        boolean bl = showAll = templates.length <= 25;
        if (!showAll) {
            Collection recentNames = manager.getRecentNames();
            templates = new FileTemplate[recentNames.size()];
            int i2 = 0;
            for (String name : recentNames) {
                templates[i2] = manager.getTemplate(name);
                ++i2;
            }
        }
        Arrays.sort(templates, (template1, template2) -> {
            if (template1.isTemplateOfType((FileType)StdFileTypes.JAVA) && !template2.isTemplateOfType((FileType)StdFileTypes.JAVA)) {
                return -1;
            }
            if (template2.isTemplateOfType((FileType)StdFileTypes.JAVA) && !template1.isTemplateOfType((FileType)StdFileTypes.JAVA)) {
                return 1;
            }
            int i2 = template1.getExtension().compareTo(template2.getExtension());
            if (i2 != 0) {
                return i2;
            }
            return template1.getName().compareTo(template2.getName());
        });
        ArrayList<Object> result2 = new ArrayList<Object>();
        for (FileTemplate template : templates) {
            if (FileTemplateBase.isChild(template) || !CreateFromTemplateGroup.canCreateFromTemplate(e, template)) continue;
            AnAction action2 = CreateFromTemplateGroup.replaceAction(template);
            if (action2 == null) {
                action2 = new CreateFromTemplateAction(template);
            }
            result2.add(action2);
        }
        if (!result2.isEmpty() || !showAll) {
            if (!showAll) {
                result2.add((Object)new CreateFromTemplatesAction(IdeBundle.message((String)"action.from.file.template", (Object[])new Object[0])));
            }
            result2.add(Separator.getInstance());
            result2.add((Object)new EditFileTemplatesAction(IdeBundle.message((String)"action.edit.file.templates", (Object[])new Object[0])));
        }
        AnAction[] anActionArray = result2.toArray(AnAction.EMPTY_ARRAY);
        if (anActionArray == null) {
            CreateFromTemplateGroup.$$$reportNull$$$0(4);
        }
        return anActionArray;
    }

    private static AnAction replaceAction(FileTemplate template) {
        for (CreateFromTemplateActionReplacer actionFactory : CreateFromTemplateActionReplacer.CREATE_FROM_TEMPLATE_REPLACER.getExtensionList()) {
            AnAction action2 = actionFactory.replaceCreateFromFileTemplateAction(template);
            if (action2 == null) continue;
            return action2;
        }
        return null;
    }

    static boolean canCreateFromTemplate(AnActionEvent e, @NotNull FileTemplate template) {
        if (template == null) {
            CreateFromTemplateGroup.$$$reportNull$$$0(5);
        }
        if (e == null) {
            return false;
        }
        DataContext dataContext2 = e.getDataContext();
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext2);
        if (view == null) {
            return false;
        }
        PsiDirectory[] dirs = view.getDirectories();
        if (dirs.length == 0) {
            return false;
        }
        return FileTemplateUtil.canCreateFromTemplate(dirs, template);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/fileTemplates/actions/CreateFromTemplateGroup";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/fileTemplates/actions/CreateFromTemplateGroup";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "canCreateFromTemplate";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2, 3, 4 -> new IllegalStateException(string2);
        };
    }

    private static class CreateFromTemplatesAction
    extends CreateFromTemplateActionBase {
        CreateFromTemplatesAction(@NlsActions.ActionText String title) {
            super(title, null, null);
        }

        @Override
        protected AnAction getReplacedAction(FileTemplate template) {
            return CreateFromTemplateGroup.replaceAction(template);
        }

        @Override
        protected FileTemplate getTemplate(Project project2, PsiDirectory dir) {
            SelectTemplateDialog dialog = new SelectTemplateDialog(project2, dir);
            dialog.show();
            return dialog.getSelectedTemplate();
        }
    }
}

