/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.CommonBundle;
import com.intellij.application.options.schemes.AbstractSchemeActions;
import com.intellij.application.options.schemes.AbstractSchemesPanel;
import com.intellij.application.options.schemes.SchemesModel;
import com.intellij.application.options.schemes.SimpleSchemesPanel;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateGroupDescriptor;
import com.intellij.ide.fileTemplates.FileTemplateGroupDescriptorFactory;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.fileTemplates.FileTemplatesScheme;
import com.intellij.ide.fileTemplates.InternalTemplateBean;
import com.intellij.ide.fileTemplates.impl.BundledFileTemplate;
import com.intellij.ide.fileTemplates.impl.CustomFileTemplate;
import com.intellij.ide.fileTemplates.impl.FileTemplateBase;
import com.intellij.ide.fileTemplates.impl.FileTemplateConfigurable;
import com.intellij.ide.fileTemplates.impl.FileTemplateManagerImpl;
import com.intellij.ide.fileTemplates.impl.FileTemplateTab;
import com.intellij.ide.fileTemplates.impl.FileTemplateTabAsList;
import com.intellij.ide.fileTemplates.impl.FileTemplateTabAsTree;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.IdeLanguageCustomization;
import com.intellij.lang.LangBundle;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.BaseExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableProvider;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.lang.invoke.CallSite;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class AllFileTemplatesConfigurable
implements SearchableConfigurable,
Configurable.NoMargin,
Configurable.NoScroll,
Configurable.VariableProjectAppLevel,
Configurable.WithEpDependencies {
    private static final Logger LOG = Logger.getInstance(AllFileTemplatesConfigurable.class);
    private final Project myProject;
    private final FileTemplateManager manager;
    private JPanel myMainPanel;
    private FileTemplateTab currentTab;
    private FileTemplateTab myTemplatesList;
    private FileTemplateTab myIncludesList;
    private FileTemplateTab myCodeTemplatesList;
    @Nullable
    private FileTemplateTab otherTemplatesList;
    private JComponent myToolBar;
    private TabbedPaneWrapper myTabbedPane;
    private FileTemplateConfigurable editor;
    private boolean isModified;
    private JComponent myEditorComponent;
    private JPanel myLeftPanel;
    private SchemesPanel mySchemesPanel;
    private FileTemplateTab[] myTabs;
    private Disposable myUIDisposable;
    private Set<String> internalTemplateNames;
    private FileTemplatesScheme myScheme;
    private final Map<FileTemplatesScheme, Map<String, List<FileTemplate>>> changesCache = new HashMap<FileTemplatesScheme, Map<String, List<FileTemplate>>>();
    private static final String CURRENT_TAB = "FileTemplates.CurrentTab";
    private static final String SELECTED_TEMPLATE = "FileTemplates.SelectedTemplate";

    public AllFileTemplatesConfigurable(Project project2) {
        this.myProject = project2;
        this.manager = FileTemplateManager.getInstance((Project)project2);
        this.myScheme = this.manager.getCurrentScheme();
    }

    private void onRemove() {
        this.currentTab.removeSelected();
        this.isModified = true;
    }

    private void onAdd(boolean child) {
        String ext = StringUtil.notNullize(JBIterable.from(IdeLanguageCustomization.getInstance().getPrimaryIdeLanguages()).filterMap(Language::getAssociatedFileType).filterMap(FileType::getDefaultExtension).first(), "txt");
        FileTemplateBase selected = ObjectUtils.tryCast(this.getSelectedTemplate(), FileTemplateBase.class);
        if (selected == null && child) {
            return;
        }
        String name = child ? selected.getChildName(selected.getChildren().length) : IdeBundle.message((String)"template.unnamed", (Object[])new Object[0]);
        FileTemplate template = this.createTemplate(name, ext, "", child);
        if (child) {
            selected.addChild(template);
        }
    }

    @NotNull
    FileTemplate createTemplate(@NotNull String prefName, @NotNull String extension2, @NotNull String content2, boolean child) {
        if (prefName == null) {
            AllFileTemplatesConfigurable.$$$reportNull$$$0(0);
        }
        if (extension2 == null) {
            AllFileTemplatesConfigurable.$$$reportNull$$$0(1);
        }
        if (content2 == null) {
            AllFileTemplatesConfigurable.$$$reportNull$$$0(2);
        }
        List<FileTemplate> templates = this.currentTab.getTemplates();
        FileTemplate newTemplate = FileTemplateUtil.createTemplate(prefName, extension2, content2, templates);
        if (child) {
            int index2 = this.currentTab.getTemplates().indexOf(this.getSelectedTemplate());
            this.currentTab.insertTemplate(newTemplate, index2 + 1);
        } else {
            this.currentTab.addTemplate(newTemplate);
        }
        this.isModified = true;
        this.currentTab.selectTemplate(newTemplate);
        this.fireListChanged();
        this.editor.focusToNameField();
        FileTemplate fileTemplate = newTemplate;
        if (fileTemplate == null) {
            AllFileTemplatesConfigurable.$$$reportNull$$$0(3);
        }
        return fileTemplate;
    }

    private void onClone() {
        try {
            this.editor.apply();
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        FileTemplate selected = this.getSelectedTemplate();
        if (selected == null) {
            return;
        }
        List<FileTemplate> templates = this.currentTab.getTemplates();
        HashSet<String> names = new HashSet<String>(templates.size());
        for (FileTemplate template2 : templates) {
            names.add(template2.getName());
        }
        String nameTemplate = IdeBundle.message((String)"template.copy.N.of.T", (Object[])new Object[0]);
        String name = FileTemplateBase.isChild(selected) && selected instanceof FileTemplateBase ? ((FileTemplateBase)selected).getChildName(selected.getChildren().length) : MessageFormat.format(nameTemplate, "", selected.getName());
        int i2 = 0;
        while (names.contains(name)) {
            name = MessageFormat.format(nameTemplate, ++i2 + " ", selected.getName());
        }
        CustomFileTemplate newTemplate = new CustomFileTemplate(name, selected.getExtension());
        newTemplate.setText(selected.getText());
        newTemplate.setFileName(selected.getFileName());
        newTemplate.setReformatCode(selected.isReformatCode());
        newTemplate.setLiveTemplateEnabled(selected.isLiveTemplateEnabled());
        newTemplate.setChildren(ContainerUtil.map2Array(selected.getChildren(), FileTemplate.class, template -> template.clone()));
        newTemplate.updateChildrenNames();
        this.currentTab.addTemplate(newTemplate);
        for (FileTemplate child : newTemplate.getChildren()) {
            this.currentTab.addTemplate(child);
        }
        this.isModified = true;
        this.currentTab.selectTemplate(newTemplate);
        this.fireListChanged();
    }

    public String getDisplayName() {
        return IdeBundle.message((String)"title.file.templates", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        int index2 = this.myTabbedPane.getSelectedIndex();
        return switch (index2) {
            case 0 -> "fileTemplates.templates";
            case 1 -> "fileTemplates.includes";
            case 2 -> "fileTemplates.code";
            case 3 -> "fileTemplates.j2ee";
            default -> throw new IllegalStateException("wrong index: " + index2);
        };
    }

    public JComponent createComponent() {
        this.internalTemplateNames = ContainerUtil.map2Set(this.manager.getInternalTemplates(), FileTemplate::getName);
        this.myUIDisposable = Disposer.newDisposable();
        this.myTemplatesList = new FileTemplateTabAsList(AllFileTemplatesConfigurable.getTemplatesTitle()){

            @Override
            public void onTemplateSelected() {
                AllFileTemplatesConfigurable.this.onListSelectionChanged();
            }
        };
        this.myIncludesList = new FileTemplateTabAsList(AllFileTemplatesConfigurable.getIncludesTitle()){

            @Override
            public void onTemplateSelected() {
                AllFileTemplatesConfigurable.this.onListSelectionChanged();
            }
        };
        this.myCodeTemplatesList = new FileTemplateTabAsList(AllFileTemplatesConfigurable.getCodeTitle()){

            @Override
            public void onTemplateSelected() {
                AllFileTemplatesConfigurable.this.onListSelectionChanged();
            }
        };
        this.currentTab = this.myTemplatesList;
        ArrayList<FileTemplateTab> allTabs = new ArrayList<FileTemplateTab>(Arrays.asList(this.myTemplatesList, this.myIncludesList, this.myCodeTemplatesList));
        final List<FileTemplateGroupDescriptorFactory> factories2 = FileTemplateGroupDescriptorFactory.EXTENSION_POINT_NAME.getExtensionList();
        if (!factories2.isEmpty()) {
            this.otherTemplatesList = new FileTemplateTabAsTree(AllFileTemplatesConfigurable.getOtherTitle()){

                @Override
                public void onTemplateSelected() {
                    AllFileTemplatesConfigurable.this.onListSelectionChanged();
                }

                @Override
                protected FileTemplateTabAsTree.FileTemplateNode initModel() {
                    TreeSet<FileTemplateGroupDescriptor> categories = new TreeSet<FileTemplateGroupDescriptor>(Comparator.comparing(FileTemplateGroupDescriptor::getTitle));
                    for (FileTemplateGroupDescriptorFactory templateGroupFactory : factories2) {
                        ContainerUtil.addIfNotNull(categories, templateGroupFactory.getFileTemplatesDescriptor());
                    }
                    return new FileTemplateTabAsTree.FileTemplateNode("ROOT", null, ContainerUtil.map2List(categories, FileTemplateTabAsTree.FileTemplateNode::new));
                }
            };
            allTabs.add(this.otherTemplatesList);
        }
        this.editor = new FileTemplateConfigurable(this.myProject);
        this.editor.addChangeListener(__ -> this.onEditorChanged());
        this.myEditorComponent = this.editor.createComponent();
        this.myEditorComponent.setBorder(JBUI.Borders.empty(10, 0, 10, 10));
        this.myTabs = allTabs.toArray(new FileTemplateTab[0]);
        this.myTabbedPane = new TabbedPaneWrapper(this.myUIDisposable);
        this.myTabbedPane.setTabLayoutPolicy(1);
        this.myLeftPanel = new JPanel(new CardLayout());
        for (FileTemplateTab tab : this.myTabs) {
            this.myLeftPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)tab.getComponent()), tab.getTitle());
            JPanel fakePanel = new JPanel();
            fakePanel.setPreferredSize(new Dimension(0, 0));
            this.myTabbedPane.addTab(tab.getTitle(), (JComponent)fakePanel);
        }
        this.myTabbedPane.addChangeListener(__ -> this.onTabChanged());
        DefaultActionGroup group2 = new DefaultActionGroup();
        DumbAwareAction removeAction = new DumbAwareAction(IdeBundle.message((String)"action.remove.template", (Object[])new Object[0]), null, AllIcons.General.Remove){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                AllFileTemplatesConfigurable.this.onRemove();
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(1);
                }
                if (AllFileTemplatesConfigurable.this.currentTab == null) {
                    e.getPresentation().setEnabled(false);
                    return;
                }
                FileTemplate selectedItem = AllFileTemplatesConfigurable.this.getSelectedTemplate();
                e.getPresentation().setEnabled(selectedItem != null && !AllFileTemplatesConfigurable.isInternalTemplate(selectedItem.getName(), AllFileTemplatesConfigurable.this.currentTab.getTitle()));
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    5.$$$reportNull$$$0(2);
                }
                return actionUpdateThread;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/fileTemplates/impl/AllFileTemplatesConfigurable$5";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/fileTemplates/impl/AllFileTemplatesConfigurable$5";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string2);
                    case 2 -> new IllegalStateException(string2);
                };
            }
        };
        DumbAwareAction addAction = new DumbAwareAction(IdeBundle.message((String)"action.create.template", (Object[])new Object[0]), null, AllIcons.General.Add){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(0);
                }
                AllFileTemplatesConfigurable.this.onAdd(false);
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(1);
                }
                e.getPresentation().setEnabled(AllFileTemplatesConfigurable.this.currentTab != AllFileTemplatesConfigurable.this.myCodeTemplatesList && AllFileTemplatesConfigurable.this.currentTab != AllFileTemplatesConfigurable.this.otherTemplatesList);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    6.$$$reportNull$$$0(2);
                }
                return actionUpdateThread;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/fileTemplates/impl/AllFileTemplatesConfigurable$6";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/fileTemplates/impl/AllFileTemplatesConfigurable$6";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string2);
                    case 2 -> new IllegalStateException(string2);
                };
            }
        };
        DumbAwareAction addChildAction = new DumbAwareAction(IdeBundle.message((String)"action.create.child.template", (Object[])new Object[0]), null, AllIcons.Actions.AddFile){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    7.$$$reportNull$$$0(0);
                }
                AllFileTemplatesConfigurable.this.onAdd(true);
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    7.$$$reportNull$$$0(1);
                }
                e.getPresentation().setEnabled(AllFileTemplatesConfigurable.this.getSelectedTemplate() != null && AllFileTemplatesConfigurable.this.currentTab != null && !AllFileTemplatesConfigurable.isInternalTemplate(AllFileTemplatesConfigurable.this.getSelectedTemplate().getName(), AllFileTemplatesConfigurable.this.currentTab.getTitle()) && !FileTemplateBase.isChild(AllFileTemplatesConfigurable.this.getSelectedTemplate()) && AllFileTemplatesConfigurable.this.currentTab == AllFileTemplatesConfigurable.this.myTemplatesList);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    7.$$$reportNull$$$0(2);
                }
                return actionUpdateThread;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/fileTemplates/impl/AllFileTemplatesConfigurable$7";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/fileTemplates/impl/AllFileTemplatesConfigurable$7";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string2);
                    case 2 -> new IllegalStateException(string2);
                };
            }
        };
        DumbAwareAction cloneAction = new DumbAwareAction(IdeBundle.message((String)"action.copy.template", (Object[])new Object[0]), null, PlatformIcons.COPY_ICON){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    8.$$$reportNull$$$0(0);
                }
                AllFileTemplatesConfigurable.this.onClone();
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    8.$$$reportNull$$$0(1);
                }
                e.getPresentation().setEnabled(AllFileTemplatesConfigurable.this.currentTab != AllFileTemplatesConfigurable.this.myCodeTemplatesList && AllFileTemplatesConfigurable.this.currentTab != AllFileTemplatesConfigurable.this.otherTemplatesList && AllFileTemplatesConfigurable.this.getSelectedTemplate() != null);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    8.$$$reportNull$$$0(2);
                }
                return actionUpdateThread;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/fileTemplates/impl/AllFileTemplatesConfigurable$8";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/fileTemplates/impl/AllFileTemplatesConfigurable$8";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string2);
                    case 2 -> new IllegalStateException(string2);
                };
            }
        };
        DumbAwareAction resetAction = new DumbAwareAction(IdeBundle.message((String)"action.reset.to.default", (Object[])new Object[0]), null, AllIcons.Actions.Rollback){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    9.$$$reportNull$$$0(0);
                }
                AllFileTemplatesConfigurable.this.onReset();
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    9.$$$reportNull$$$0(1);
                }
                if (AllFileTemplatesConfigurable.this.currentTab == null) {
                    e.getPresentation().setEnabled(false);
                    return;
                }
                FileTemplate selectedItem = AllFileTemplatesConfigurable.this.getSelectedTemplate();
                e.getPresentation().setEnabled(selectedItem instanceof BundledFileTemplate && !selectedItem.isDefault());
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    9.$$$reportNull$$$0(2);
                }
                return actionUpdateThread;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/fileTemplates/impl/AllFileTemplatesConfigurable$9";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/fileTemplates/impl/AllFileTemplatesConfigurable$9";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string2);
                    case 2 -> new IllegalStateException(string2);
                };
            }
        };
        group2.add((AnAction)addAction);
        group2.add((AnAction)addChildAction);
        group2.add((AnAction)removeAction);
        group2.add((AnAction)cloneAction);
        group2.add((AnAction)resetAction);
        addAction.registerCustomShortcutSet(CommonShortcuts.INSERT, this.currentTab.getComponent());
        removeAction.registerCustomShortcutSet(CommonShortcuts.getDelete(), this.currentTab.getComponent());
        this.myToolBar = ActionManager.getInstance().createActionToolbar("FileTemplatesConfigurable", (ActionGroup)group2, true).getComponent();
        this.myToolBar.setBorder(new CustomLineBorder(1, 1, 0, 1));
        this.mySchemesPanel = new SchemesPanel();
        this.mySchemesPanel.setBorder(JBUI.Borders.empty(5, 10, 0, 10));
        this.mySchemesPanel.resetSchemes(Arrays.asList(FileTemplatesScheme.DEFAULT, this.manager.getProjectScheme()));
        JPanel leftPanelWrapper = new JPanel(new BorderLayout());
        leftPanelWrapper.setBorder(JBUI.Borders.empty(10, 10, 10, 0));
        leftPanelWrapper.add("North", this.myToolBar);
        leftPanelWrapper.add("Center", this.myLeftPanel);
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.add((Component)this.myTabbedPane.getComponent(), "North");
        Splitter splitter = new Splitter(false, 0.3f);
        splitter.setDividerWidth(JBUIScale.scale(10));
        splitter.setFirstComponent(leftPanelWrapper);
        splitter.setSecondComponent(this.myEditorComponent);
        centerPanel.add((Component)splitter, "Center");
        this.myMainPanel = new JPanel(new BorderLayout());
        this.myMainPanel.add((Component)((Object)this.mySchemesPanel), "North");
        this.myMainPanel.add((Component)centerPanel, "Center");
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        String tabName = propertiesComponent.getValue(CURRENT_TAB);
        this.selectTab(tabName);
        return this.myMainPanel;
    }

    @Nullable
    private FileTemplate getSelectedTemplate() {
        return this.currentTab.getSelectedTemplate();
    }

    private void onReset() {
        FileTemplate selected = this.getSelectedTemplate();
        if (selected instanceof BundledFileTemplate) {
            if (Messages.showOkCancelDialog((String)IdeBundle.message((String)"prompt.reset.to.original.template", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.reset.template", (Object[])new Object[0]), (String)LangBundle.message("button.reset", new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon()) != 0) {
                return;
            }
            ((BundledFileTemplate)selected).revertToDefaults();
            this.editor.reset();
            this.isModified = true;
        }
    }

    private void onEditorChanged() {
        this.fireListChanged();
    }

    private void onTabChanged() {
        this.applyEditor(this.getSelectedTemplate());
        FileTemplateTab tab = this.currentTab;
        int selectedIndex = this.myTabbedPane.getSelectedIndex();
        if (0 <= selectedIndex && selectedIndex < this.myTabs.length) {
            this.currentTab = this.myTabs[selectedIndex];
        }
        ((CardLayout)this.myLeftPanel.getLayout()).show(this.myLeftPanel, this.currentTab.getTitle());
        this.onListSelectionChanged();
        if (tab != this.currentTab) {
            EventQueue.invokeLater(this.currentTab.getComponent()::requestFocus);
        }
    }

    private void onListSelectionChanged() {
        FileTemplate prevTemplate;
        FileTemplate selectedValue = this.getSelectedTemplate();
        FileTemplate fileTemplate = prevTemplate = this.editor == null ? null : this.editor.getTemplate();
        if (prevTemplate != selectedValue) {
            LOG.assertTrue(this.editor != null, "selected:" + selectedValue + "; prev:" + prevTemplate);
            if (prevTemplate != null && this.currentTab.getTemplates().contains(prevTemplate) && !this.applyEditor(prevTemplate)) {
                return;
            }
            if (selectedValue == null) {
                this.editor.setTemplate(null, FileTemplateManagerImpl.getInstanceImpl(this.myProject).getDefaultTemplateDescription());
                this.myEditorComponent.repaint();
            } else {
                this.selectTemplate(selectedValue);
            }
        }
    }

    private boolean applyEditor(FileTemplate prevTemplate) {
        if (this.editor.isModified()) {
            try {
                this.isModified = true;
                this.editor.apply();
                this.fireListChanged();
            }
            catch (ConfigurationException e) {
                if (this.currentTab.getTemplates().contains(prevTemplate)) {
                    this.currentTab.selectTemplate(prevTemplate);
                }
                Messages.showErrorDialog((Component)this.myMainPanel, (String)e.getMessage(), (String)IdeBundle.message((String)"title.cannot.save.current.template", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private void selectTemplate(FileTemplate template) {
        Supplier<String> defDesc = null;
        if (this.currentTab == this.myTemplatesList) {
            defDesc = FileTemplateManagerImpl.getInstanceImpl(this.myProject).getDefaultTemplateDescription();
        } else if (this.currentTab == this.myIncludesList) {
            defDesc = FileTemplateManagerImpl.getInstanceImpl(this.myProject).getDefaultIncludeDescription();
        }
        if (this.editor.getTemplate() != template) {
            boolean isInternal = template != null && AllFileTemplatesConfigurable.isInternalTemplate(template.getName(), this.currentTab.getTitle());
            this.editor.setTemplate(template, defDesc, isInternal);
            this.editor.setShowAdjustCheckBox(this.myTemplatesList == this.currentTab);
        }
    }

    public boolean isProjectLevel() {
        return this.myScheme != null && this.myScheme != FileTemplatesScheme.DEFAULT && !this.myScheme.getProject().isDefault();
    }

    private static boolean isInternalTemplate(String templateName, String templateTabTitle) {
        if (templateName == null) {
            return false;
        }
        if (Comparing.strEqual(templateTabTitle, AllFileTemplatesConfigurable.getTemplatesTitle())) {
            return AllFileTemplatesConfigurable.isInternalTemplateName(templateName);
        }
        if (Comparing.strEqual(templateTabTitle, AllFileTemplatesConfigurable.getCodeTitle())) {
            return true;
        }
        if (Comparing.strEqual(templateTabTitle, AllFileTemplatesConfigurable.getOtherTitle())) {
            return true;
        }
        if (Comparing.strEqual(templateTabTitle, AllFileTemplatesConfigurable.getIncludesTitle())) {
            return Comparing.strEqual(templateName, "File Header");
        }
        return false;
    }

    private static boolean isInternalTemplateName(String templateName) {
        for (InternalTemplateBean bean : InternalTemplateBean.EP_NAME.getExtensionList()) {
            if (!Comparing.strEqual(templateName, bean.name)) continue;
            return true;
        }
        return false;
    }

    private void initLists() {
        FileTemplatesScheme scheme = this.manager.getCurrentScheme();
        this.manager.setCurrentScheme(this.myScheme);
        this.myTemplatesList.init(this.getTemplates("Default"));
        this.myIncludesList.init(this.getTemplates("Includes"));
        this.myCodeTemplatesList.init(this.getTemplates("Code"));
        this.myTabbedPane.setEnabledAt(2, !this.myCodeTemplatesList.templates.isEmpty());
        if (this.otherTemplatesList != null) {
            this.otherTemplatesList.init(this.getTemplates("J2EE"));
        }
        this.manager.setCurrentScheme(scheme);
    }

    private List<FileTemplate> getTemplates(String category) {
        Map<String, List<FileTemplate>> templates = this.changesCache.get(this.myScheme);
        return templates == null ? List.of(this.manager.getTemplates(category)) : templates.get(category);
    }

    public boolean isModified() {
        return this.myScheme != this.manager.getCurrentScheme() || !this.changesCache.isEmpty() || this.isSchemeModified();
    }

    private boolean isSchemeModified() {
        return this.isModified || this.editor != null && this.editor.isModified();
    }

    private void checkCanApply(FileTemplateTab list2) throws ConfigurationException {
        List<FileTemplate> templates = this.currentTab.getTemplates();
        HashSet<CallSite> allNames = new HashSet<CallSite>();
        FileTemplate itemWithError = null;
        String errorString = null;
        for (FileTemplate template : templates) {
            String currName = template.getName();
            if (currName.isEmpty()) {
                itemWithError = template;
                errorString = IdeBundle.message((String)"error.please.specify.template.name", (Object[])new Object[0]);
                break;
            }
            if (allNames.add((CallSite)((Object)(currName + "." + template.getExtension())))) continue;
            itemWithError = template;
            errorString = LangBundle.message("dialog.message.template.with.name.already.exists", currName);
            break;
        }
        if (itemWithError != null) {
            this.myTabbedPane.setSelectedIndex(Arrays.asList(this.myTabs).indexOf(list2));
            this.selectTemplate(itemWithError);
            list2.selectTemplate(itemWithError);
            ApplicationManager.getApplication().invokeLater(this.editor::focusToNameField);
            throw new ConfigurationException(errorString);
        }
    }

    private void fireListChanged() {
        if (this.currentTab != null) {
            this.currentTab.fireDataChanged();
        }
        if (this.myMainPanel != null) {
            this.myMainPanel.revalidate();
        }
    }

    public void apply() throws ConfigurationException {
        if (this.editor != null && this.editor.isModified()) {
            this.isModified = true;
            this.editor.apply();
        }
        for (FileTemplateTab list2 : this.myTabs) {
            this.checkCanApply(list2);
        }
        this.updateCache();
        for (Map.Entry entry : this.changesCache.entrySet()) {
            this.manager.setCurrentScheme((FileTemplatesScheme)entry.getKey());
            Map templates = (Map)entry.getValue();
            this.manager.setTemplates("Default", (Collection)templates.get("Default"));
            this.manager.setTemplates("Internal", (Collection)templates.get("Internal"));
            this.manager.setTemplates("Includes", (Collection)templates.get("Includes"));
            this.manager.setTemplates("Code", (Collection)templates.get("Code"));
            this.manager.setTemplates("J2EE", (Collection)templates.get("J2EE"));
        }
        this.changesCache.clear();
        this.manager.setCurrentScheme(this.myScheme);
        if (this.editor != null) {
            this.isModified = false;
            this.fireListChanged();
        }
    }

    private void selectTab(String tabName) {
        int idx = 0;
        for (FileTemplateTab tab : this.myTabs) {
            if (Comparing.strEqual(tab.getTitle(), tabName)) {
                this.currentTab = tab;
                this.myTabbedPane.setSelectedIndex(idx);
                return;
            }
            ++idx;
        }
    }

    public void reset() {
        this.editor.reset();
        this.changeScheme(this.manager.getCurrentScheme());
        this.mySchemesPanel.selectScheme((Scheme)this.myScheme);
        this.changesCache.clear();
        this.isModified = false;
    }

    public void disposeUIResources() {
        if (this.currentTab != null) {
            PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
            propertiesComponent.setValue(CURRENT_TAB, this.currentTab.getTitle(), AllFileTemplatesConfigurable.getTemplatesTitle());
            FileTemplate template = this.getSelectedTemplate();
            if (template != null) {
                propertiesComponent.setValue(SELECTED_TEMPLATE, template.getName());
            }
        }
        if (this.editor != null) {
            this.editor.disposeUIResources();
            this.editor = null;
            this.myEditorComponent = null;
        }
        this.myMainPanel = null;
        if (this.myUIDisposable != null) {
            Disposer.dispose(this.myUIDisposable);
            this.myUIDisposable = null;
        }
        this.myTabbedPane = null;
        this.myToolBar = null;
        this.myTabs = null;
        this.currentTab = null;
        this.myTemplatesList = null;
        this.myCodeTemplatesList = null;
        this.myIncludesList = null;
        this.otherTemplatesList = null;
    }

    @NotNull
    public String getId() {
        return "fileTemplates";
    }

    public static void editCodeTemplate(@NotNull String templateId, Project project2) {
        if (templateId == null) {
            AllFileTemplatesConfigurable.$$$reportNull$$$0(4);
        }
        ShowSettingsUtil util = ShowSettingsUtil.getInstance();
        AllFileTemplatesConfigurable configurable2 = new AllFileTemplatesConfigurable(project2);
        util.editConfigurable(project2, (Configurable)configurable2, () -> {
            configurable2.myTabbedPane.setSelectedIndex(ArrayUtil.indexOf(configurable2.myTabs, configurable2.myCodeTemplatesList));
            for (FileTemplate template : configurable2.myCodeTemplatesList.getTemplates()) {
                if (!Objects.equals(templateId, template.getName())) continue;
                configurable2.myCodeTemplatesList.selectTemplate(template);
                break;
            }
        });
    }

    public static void editOtherTemplate(@NotNull String templateFileName, Project project2) {
        if (templateFileName == null) {
            AllFileTemplatesConfigurable.$$$reportNull$$$0(5);
        }
        ShowSettingsUtil util = ShowSettingsUtil.getInstance();
        AllFileTemplatesConfigurable configurable2 = new AllFileTemplatesConfigurable(project2);
        util.editConfigurable(project2, (Configurable)configurable2, () -> {
            FileTemplateTab otherTemplatesList = configurable2.otherTemplatesList;
            if (otherTemplatesList == null) {
                return;
            }
            configurable2.myTabbedPane.setSelectedIndex(ArrayUtil.indexOf(configurable2.myTabs, otherTemplatesList));
            for (FileTemplate template : otherTemplatesList.getTemplates()) {
                Object fileName = template.getName();
                if (!template.getExtension().isEmpty()) {
                    fileName = (String)fileName + "." + template.getExtension();
                }
                if (!Objects.equals(templateFileName, fileName)) continue;
                otherTemplatesList.selectTemplate(template);
                break;
            }
        });
    }

    void changeScheme(@NotNull FileTemplatesScheme scheme) {
        if (scheme == null) {
            AllFileTemplatesConfigurable.$$$reportNull$$$0(6);
        }
        if (this.editor != null && this.editor.isModified()) {
            this.isModified = true;
            try {
                this.editor.apply();
            }
            catch (ConfigurationException e) {
                Messages.showErrorDialog((Component)this.myEditorComponent, (String)e.getMessage(), (String)e.getTitle());
                return;
            }
        }
        this.updateCache();
        this.myScheme = scheme;
        this.initLists();
    }

    private void updateCache() {
        if (!this.isSchemeModified() || this.changesCache.containsKey(this.myScheme) || this.internalTemplateNames == null) {
            return;
        }
        HashMap<String, List<Object>> templates = new HashMap<String, List<Object>>();
        List<FileTemplate> allTemplates = this.myTemplatesList.getTemplates();
        templates.put("Default", ContainerUtil.filter(allTemplates, it -> !this.internalTemplateNames.contains(it.getName())));
        templates.put("Internal", ContainerUtil.filter(allTemplates, it -> this.internalTemplateNames.contains(it.getName())));
        templates.put("Includes", this.myIncludesList.getTemplates());
        templates.put("Code", this.myCodeTemplatesList.getTemplates());
        templates.put("J2EE", this.otherTemplatesList == null ? Collections.emptyList() : this.otherTemplatesList.getTemplates());
        this.changesCache.put(this.myScheme, templates);
    }

    @NotNull
    public FileTemplateManager getManager() {
        FileTemplateManager fileTemplateManager = this.manager;
        if (fileTemplateManager == null) {
            AllFileTemplatesConfigurable.$$$reportNull$$$0(7);
        }
        return fileTemplateManager;
    }

    @TestOnly
    FileTemplateTab[] getTabs() {
        return this.myTabs;
    }

    @NlsContexts.TabTitle
    private static String getTemplatesTitle() {
        return IdeBundle.message((String)"tab.filetemplates.templates", (Object[])new Object[0]);
    }

    @NlsContexts.TabTitle
    private static String getIncludesTitle() {
        return IdeBundle.message((String)"tab.filetemplates.includes", (Object[])new Object[0]);
    }

    @NlsContexts.TabTitle
    private static String getCodeTitle() {
        return IdeBundle.message((String)"tab.filetemplates.code", (Object[])new Object[0]);
    }

    @NlsContexts.TabTitle
    private static String getOtherTitle() {
        return IdeBundle.message((String)"tab.filetemplates.j2ee", (Object[])new Object[0]);
    }

    @NotNull
    public Collection<BaseExtensionPointName<?>> getDependencies() {
        Set<BaseExtensionPointName<?>> set2 = Collections.singleton(InternalTemplateBean.EP_NAME);
        if (set2 == null) {
            AllFileTemplatesConfigurable.$$$reportNull$$$0(8);
        }
        return set2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/fileTemplates/impl/AllFileTemplatesConfigurable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateFileName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/fileTemplates/impl/AllFileTemplatesConfigurable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createTemplate";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getManager";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createTemplate";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "editCodeTemplate";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "editOtherTemplate";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "changeScheme";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 7, 8 -> new IllegalStateException(string2);
        };
    }

    private final class SchemesPanel
    extends SimpleSchemesPanel<FileTemplatesScheme>
    implements SchemesModel<FileTemplatesScheme> {
        private SchemesPanel() {
        }

        @NotNull
        protected AbstractSchemeActions<FileTemplatesScheme> createSchemeActions() {
            return new AbstractSchemeActions<FileTemplatesScheme>((AbstractSchemesPanel)this){

                protected void resetScheme(@NotNull FileTemplatesScheme scheme) {
                    if (scheme == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    throw new UnsupportedOperationException();
                }

                protected void duplicateScheme(@NotNull FileTemplatesScheme scheme, @NotNull String newName2) {
                    if (scheme == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (newName2 == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    throw new UnsupportedOperationException();
                }

                protected void onSchemeChanged(@Nullable FileTemplatesScheme scheme) {
                    if (scheme != null) {
                        AllFileTemplatesConfigurable.this.changeScheme(scheme);
                    }
                }

                protected void renameScheme(@NotNull FileTemplatesScheme scheme, @NotNull String newName2) {
                    if (scheme == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    if (newName2 == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    throw new UnsupportedOperationException();
                }

                @NotNull
                protected Class<FileTemplatesScheme> getSchemeType() {
                    return FileTemplatesScheme.class;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "scheme";
                            break;
                        }
                        case 2: 
                        case 4: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "newName";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/ide/fileTemplates/impl/AllFileTemplatesConfigurable$SchemesPanel$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "resetScheme";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "duplicateScheme";
                            break;
                        }
                        case 3: 
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[2] = "renameScheme";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }

        @NotNull
        public SchemesModel<FileTemplatesScheme> getModel() {
            SchemesPanel schemesPanel = this;
            if (schemesPanel == null) {
                SchemesPanel.$$$reportNull$$$0(0);
            }
            return schemesPanel;
        }

        protected boolean supportsProjectSchemes() {
            return false;
        }

        protected boolean highlightNonDefaultSchemes() {
            return false;
        }

        public boolean useBoldForNonRemovableSchemes() {
            return true;
        }

        public boolean canDuplicateScheme(@NotNull FileTemplatesScheme scheme) {
            if (scheme == null) {
                SchemesPanel.$$$reportNull$$$0(1);
            }
            return false;
        }

        public boolean canResetScheme(@NotNull FileTemplatesScheme scheme) {
            if (scheme == null) {
                SchemesPanel.$$$reportNull$$$0(2);
            }
            return false;
        }

        public boolean canDeleteScheme(@NotNull FileTemplatesScheme scheme) {
            if (scheme == null) {
                SchemesPanel.$$$reportNull$$$0(3);
            }
            return false;
        }

        public boolean isProjectScheme(@NotNull FileTemplatesScheme scheme) {
            if (scheme == null) {
                SchemesPanel.$$$reportNull$$$0(4);
            }
            return false;
        }

        public boolean canRenameScheme(@NotNull FileTemplatesScheme scheme) {
            if (scheme == null) {
                SchemesPanel.$$$reportNull$$$0(5);
            }
            return false;
        }

        public boolean containsScheme(@NotNull String name, boolean projectScheme) {
            if (name == null) {
                SchemesPanel.$$$reportNull$$$0(6);
            }
            return false;
        }

        public boolean differsFromDefault(@NotNull FileTemplatesScheme scheme) {
            if (scheme == null) {
                SchemesPanel.$$$reportNull$$$0(7);
            }
            return false;
        }

        public void removeScheme(@NotNull FileTemplatesScheme scheme) {
            if (scheme == null) {
                SchemesPanel.$$$reportNull$$$0(8);
            }
            throw new UnsupportedOperationException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5, 6, 7, 8 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/fileTemplates/impl/AllFileTemplatesConfigurable$SchemesPanel";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scheme";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModel";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/fileTemplates/impl/AllFileTemplatesConfigurable$SchemesPanel";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "canDuplicateScheme";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "canResetScheme";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "canDeleteScheme";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isProjectScheme";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "canRenameScheme";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "containsScheme";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "differsFromDefault";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "removeScheme";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string2);
                case 1, 2, 3, 4, 5, 6, 7, 8 -> new IllegalArgumentException(string2);
            };
        }
    }

    static final class Provider
    extends ConfigurableProvider {
        private final Project myProject;

        Provider(@NotNull Project project2) {
            if (project2 == null) {
                Provider.$$$reportNull$$$0(0);
            }
            this.myProject = project2;
        }

        @NotNull
        public Configurable createConfigurable() {
            return new AllFileTemplatesConfigurable(this.myProject);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/fileTemplates/impl/AllFileTemplatesConfigurable$Provider", "<init>"));
        }
    }
}

