/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.DynamicBundle;
import com.intellij.ide.fileTemplates.impl.FileTemplateBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.reference.SoftReference;
import com.intellij.util.ResourceUtil;
import java.io.IOException;
import java.lang.ref.Reference;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import java.util.function.Supplier;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B)\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\bBC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n\u0012\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u0017\u001a\u00020\u0003J\b\u0010\u0018\u001a\u00020\u0006H\u0007J\u0006\u0010\u0019\u001a\u00020\u0003J\b\u0010\u001a\u001a\u00020\u0003H\u0016R\u001c\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0014\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0012R\u0018\u0010\u0016\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ide/fileTemplates/impl/DefaultTemplate;", "", "name", "", "extension", "templateUrl", "Ljava/net/URL;", "descriptionUrl", "(Ljava/lang/String;Ljava/lang/String;Ljava/net/URL;Ljava/net/URL;)V", "textSupplier", "Ljava/util/function/Supplier;", "descriptionLoader", "Ljava/util/function/Function;", "descriptionPath", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/function/Supplier;Ljava/util/function/Function;Ljava/lang/String;)V", "descriptionText", "Ljava/lang/ref/Reference;", "getExtension", "()Ljava/lang/String;", "getName", "qualifiedName", "getQualifiedName", "text", "getDescriptionText", "getTemplateURL", "getText", "toString", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nDefaultTemplate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultTemplate.kt\ncom/intellij/ide/fileTemplates/impl/DefaultTemplate\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,104:1\n10#2:105\n10#2:106\n10#2:107\n*S KotlinDebug\n*F\n+ 1 DefaultTemplate.kt\ncom/intellij/ide/fileTemplates/impl/DefaultTemplate\n*L\n82#1:105\n34#1:106\n42#1:107\n*E\n"})
public final class DefaultTemplate {
    @NotNull
    private final String name;
    @NotNull
    private final String extension;
    @NotNull
    private final Supplier<String> textSupplier;
    @Nullable
    private final Function<String, String> descriptionLoader;
    @Nullable
    private final String descriptionPath;
    @Nullable
    private Reference<String> text;
    @Nullable
    private Reference<String> descriptionText;

    public DefaultTemplate(@NotNull String name, @NotNull String extension2, @NotNull Supplier<String> textSupplier, @Nullable Function<String, String> descriptionLoader, @Nullable String descriptionPath) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)extension2, (String)"extension");
        Intrinsics.checkNotNullParameter(textSupplier, (String)"textSupplier");
        this.name = name;
        this.extension = extension2;
        this.textSupplier = textSupplier;
        this.descriptionLoader = descriptionLoader;
        this.descriptionPath = descriptionPath;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getExtension() {
        return this.extension;
    }

    @Deprecated(message="Use {@link #DefaultTemplate(String, String, Supplier, Function, String)}")
    public DefaultTemplate(@NotNull String name, @NotNull String extension2, @NotNull URL templateUrl, @Nullable URL descriptionUrl) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)extension2, (String)"extension");
        Intrinsics.checkNotNullParameter((Object)templateUrl, (String)"templateUrl");
        URL uRL = descriptionUrl;
        this(name, extension2, () -> DefaultTemplate._init_$lambda$0(templateUrl), (Function<String, String>)(uRL == null ? null : arg_0 -> DefaultTemplate._init_$lambda$1(uRL, arg_0)), null);
    }

    @NotNull
    public final String getQualifiedName() {
        String string2 = FileTemplateBase.getQualifiedName(this.name, this.extension);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getQualifiedName(name, this.extension)");
        return string2;
    }

    @NotNull
    public final String getText() {
        String text2 = SoftReference.dereference(this.text);
        if (text2 == null) {
            text2 = StringUtil.convertLineSeparators(this.textSupplier.get());
            this.text = new java.lang.ref.SoftReference<String>(text2);
        }
        return text2;
    }

    @NotNull
    public final String getDescriptionText() {
        if (this.descriptionLoader == null) {
            return "";
        }
        String text2 = SoftReference.dereference(this.descriptionText);
        if (text2 != null) {
            return text2;
        }
        try {
            ClassLoader langBundleLoader;
            Object object = DynamicBundle.findLanguageBundle();
            ClassLoader classLoader = object != null && (object = ((DynamicBundle.LanguageBundleEP)object).pluginDescriptor) != null ? object.getPluginClassLoader() : (langBundleLoader = null);
            if (langBundleLoader != null && this.descriptionPath != null) {
                byte[] byArray = ResourceUtil.getResourceAsBytes("fileTemplates/" + this.descriptionPath, langBundleLoader);
                if (byArray != null) {
                    byte[] byArray2 = byArray;
                    Charset charset = StandardCharsets.UTF_8;
                    Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                    Charset charset2 = charset;
                    v3 = new String(byArray2, charset2);
                } else {
                    v3 = text2 = null;
                }
            }
            if (text2 == null) {
                String string2 = this.descriptionPath;
                if (string2 == null) {
                    string2 = "";
                }
                text2 = Strings.convertLineSeparators(this.descriptionLoader.apply(string2));
            }
        }
        catch (IOException e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(DefaultTemplate.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
            logger.error(e);
            text2 = "";
        }
        this.descriptionText = new java.lang.ref.SoftReference<String>(text2);
        String string3 = text2;
        Intrinsics.checkNotNull((Object)string3);
        return string3;
    }

    @Deprecated(message="Do not use.")
    @NotNull
    public final URL getTemplateURL() {
        try {
            return new URL("https://not.relevant");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public String toString() {
        return this.textSupplier.toString();
    }

    private static final String _init_$lambda$0(URL $templateUrl) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$templateUrl, (String)"$templateUrl");
        try {
            string2 = ResourceUtil.loadText($templateUrl.openStream());
        }
        catch (IOException e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(DefaultTemplate.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
            logger.error(e);
            string2 = "";
        }
        return string2;
    }

    private static final String _init_$lambda$1(URL $descriptionUrl, String it) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        try {
            string2 = ResourceUtil.loadText($descriptionUrl.openStream());
        }
        catch (IOException e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(DefaultTemplate.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
            logger.error(e);
            string2 = "";
        }
        return string2;
    }
}

