/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.application.options.CodeStyle;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.impl.BundledFileTemplate;
import com.intellij.ide.fileTemplates.impl.CustomFileTemplate;
import com.intellij.ide.fileTemplates.impl.DefaultTemplate;
import com.intellij.ide.fileTemplates.impl.FileTemplateBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.containers.MultiMap;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class FTManager {
    private static final Logger LOG = Logger.getInstance(FTManager.class);
    private static final String DEFAULT_TEMPLATE_EXTENSION = "ft";
    static final String TEMPLATE_EXTENSION_SUFFIX = ".ft";
    private static final String ENCODED_NAME_EXT_DELIMITER = "\u0f0fext\u0f0f.";
    private final String name;
    private final boolean isInternal;
    private final Path templateDir;
    @Nullable
    private final FTManager original;
    private final Map<String, FileTemplateBase> templates;
    private volatile List<FileTemplateBase> sortedTemplates;
    private final List<DefaultTemplate> defaultTemplates;

    FTManager(@NotNull @NonNls String name, @NotNull Path defaultTemplatesDirName, List<DefaultTemplate> defaultTemplates, boolean isInternal) {
        if (name == null) {
            FTManager.$$$reportNull$$$0(0);
        }
        if (defaultTemplatesDirName == null) {
            FTManager.$$$reportNull$$$0(1);
        }
        this.name = name;
        this.isInternal = isInternal;
        this.templateDir = defaultTemplatesDirName;
        this.original = null;
        this.defaultTemplates = defaultTemplates;
        this.templates = new HashMap<String, FileTemplateBase>(defaultTemplates.size());
        for (DefaultTemplate template : defaultTemplates) {
            BundledFileTemplate bundled = new BundledFileTemplate(template, this.isInternal);
            String qName = bundled.getQualifiedName();
            FileTemplateBase previous = this.templates.put(qName, bundled);
            if (previous == null) continue;
            LOG.error("Duplicate bundled template " + qName + " [" + template + ", " + previous + "]");
        }
    }

    FTManager(@NotNull FTManager original) {
        if (original == null) {
            FTManager.$$$reportNull$$$0(2);
        }
        this.original = original;
        this.name = original.getName();
        this.templateDir = original.templateDir;
        this.isInternal = original.isInternal;
        this.templates = new HashMap<String, FileTemplateBase>(original.templates);
        this.defaultTemplates = List.copyOf(original.defaultTemplates);
    }

    @TestOnly
    public FTManager(@NotNull @NonNls String name, @NotNull Path defaultTemplatesDirName) {
        if (name == null) {
            FTManager.$$$reportNull$$$0(3);
        }
        if (defaultTemplatesDirName == null) {
            FTManager.$$$reportNull$$$0(4);
        }
        this(name, defaultTemplatesDirName, Collections.emptyList(), false);
    }

    @NotNull
    public String getName() {
        String string2 = this.name;
        if (string2 == null) {
            FTManager.$$$reportNull$$$0(5);
        }
        return string2;
    }

    @NotNull
    Collection<FileTemplateBase> getAllTemplates(boolean includeDisabled) {
        List<FileTemplateBase> sorted = this.sortedTemplates;
        if (sorted == null) {
            sorted = new ArrayList<FileTemplateBase>(this.getTemplates().values());
            sorted.sort((t1, t2) -> t1.getName().compareToIgnoreCase(t2.getName()));
            this.sortedTemplates = sorted;
        }
        if (includeDisabled) {
            Collection<FileTemplateBase> collection = Collections.unmodifiableCollection(sorted);
            if (collection == null) {
                FTManager.$$$reportNull$$$0(6);
            }
            return collection;
        }
        ArrayList<FileTemplateBase> list2 = new ArrayList<FileTemplateBase>(sorted.size());
        for (FileTemplateBase template : sorted) {
            if (template instanceof BundledFileTemplate && !((BundledFileTemplate)template).isEnabled()) continue;
            list2.add(template);
        }
        ArrayList<FileTemplateBase> arrayList = list2;
        if (arrayList == null) {
            FTManager.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @Nullable
    FileTemplateBase getTemplate(@NotNull String templateQname) {
        if (templateQname == null) {
            FTManager.$$$reportNull$$$0(8);
        }
        return this.getTemplates().get(templateQname);
    }

    @Nullable
    public FileTemplateBase findTemplateByName(@NotNull String templateName) {
        FileTemplateBase template;
        if (templateName == null) {
            FTManager.$$$reportNull$$$0(9);
        }
        if ((template = this.getTemplates().get(templateName)) != null) {
            boolean isEnabled;
            boolean bl = isEnabled = !(template instanceof BundledFileTemplate) || ((BundledFileTemplate)template).isEnabled();
            if (isEnabled) {
                return template;
            }
        }
        for (FileTemplateBase t : this.getAllTemplates(false)) {
            String remainder;
            String qName = t.getQualifiedName();
            if (!qName.startsWith(templateName) || qName.length() <= templateName.length() || !(remainder = qName.substring(templateName.length())).startsWith(ENCODED_NAME_EXT_DELIMITER) && remainder.charAt(0) != '.') continue;
            return t;
        }
        return null;
    }

    @NotNull
    public FileTemplateBase addTemplate(@NotNull String name, @NotNull String extension2) {
        String qName;
        FileTemplateBase template;
        if (name == null) {
            FTManager.$$$reportNull$$$0(10);
        }
        if (extension2 == null) {
            FTManager.$$$reportNull$$$0(11);
        }
        if ((template = this.getTemplate(qName = FileTemplateBase.getQualifiedName(name, extension2))) == null) {
            template = new CustomFileTemplate(name, extension2);
            this.getTemplates().put(qName, template);
            this.sortedTemplates = null;
        } else if (template instanceof BundledFileTemplate && !((BundledFileTemplate)template).isEnabled()) {
            ((BundledFileTemplate)template).setEnabled(true);
        }
        FileTemplateBase fileTemplateBase = template;
        if (fileTemplateBase == null) {
            FTManager.$$$reportNull$$$0(12);
        }
        return fileTemplateBase;
    }

    public void removeTemplate(@NotNull String qName) {
        FileTemplateBase template;
        if (qName == null) {
            FTManager.$$$reportNull$$$0(13);
        }
        if ((template = this.getTemplates().get(qName)) instanceof CustomFileTemplate) {
            this.getTemplates().remove(qName);
            this.sortedTemplates = null;
        } else if (template instanceof BundledFileTemplate) {
            ((BundledFileTemplate)template).setEnabled(false);
        }
    }

    void updateTemplates(@NotNull Collection<? extends FileTemplate> newTemplates) {
        if (newTemplates == null) {
            FTManager.$$$reportNull$$$0(14);
        }
        HashSet<String> toDisable = new HashSet<String>();
        for (DefaultTemplate defaultTemplate : this.defaultTemplates) {
            toDisable.add(defaultTemplate.getQualifiedName());
        }
        for (FileTemplate fileTemplate : newTemplates) {
            toDisable.remove(((FileTemplateBase)fileTemplate).getQualifiedName());
        }
        this.restoreDefaults(toDisable);
        MultiMap<String, FileTemplateBase> children2 = new MultiMap<String, FileTemplateBase>();
        for (FileTemplate fileTemplate : newTemplates) {
            FileTemplateBase _template = this.addTemplate(fileTemplate.getName(), fileTemplate.getExtension());
            _template.setText(fileTemplate.getText());
            _template.setFileName(fileTemplate.getFileName());
            _template.setReformatCode(fileTemplate.isReformatCode());
            _template.setLiveTemplateEnabled(fileTemplate.isLiveTemplateEnabled());
            if (!FileTemplateBase.isChild(_template)) continue;
            children2.putValue(FTManager.getParentName(_template), _template);
        }
        for (String string2 : children2.keySet()) {
            FileTemplateBase template = this.getTemplate(string2);
            if (template == null) continue;
            template.setChildren(children2.get(string2).toArray(FileTemplate.EMPTY_ARRAY));
        }
        this.saveTemplates(true);
    }

    private void restoreDefaults(@NotNull Set<String> toDisable) {
        if (toDisable == null) {
            FTManager.$$$reportNull$$$0(15);
        }
        Map<String, FileTemplateBase> templates = this.getTemplates();
        templates.clear();
        this.sortedTemplates = null;
        for (DefaultTemplate template : this.defaultTemplates) {
            BundledFileTemplate bundled = new BundledFileTemplate(template, this.isInternal);
            String qName = bundled.getQualifiedName();
            FileTemplateBase previous = templates.put(qName, bundled);
            if (previous != null) {
                LOG.error("Duplicate bundled template " + qName + " [" + template + ", " + previous + "]");
            }
            if (!toDisable.contains(bundled.getQualifiedName())) continue;
            bundled.setEnabled(false);
        }
    }

    public void loadCustomizedContent() {
        ArrayList<Path> templateWithDefaultExtension = new ArrayList<Path>();
        HashSet<String> processedNames = new HashSet<String>();
        ArrayList<FileTemplateBase> children2 = new ArrayList<FileTemplateBase>();
        try (DirectoryStream<Path> stream2 = Files.newDirectoryStream(this.templateDir, file2 -> !Files.isDirectory(file2, new LinkOption[0]) && !Files.isHidden(file2));){
            FileTypeManager fileTypeManager = FileTypeManager.getInstance();
            for (Path file3 : stream2) {
                String fileName = file3.getFileName().toString();
                if (fileTypeManager.isFileIgnored(fileName)) continue;
                if (fileName.endsWith(TEMPLATE_EXTENSION_SUFFIX)) {
                    templateWithDefaultExtension.add(file3);
                    continue;
                }
                processedNames.add(fileName);
                FileTemplateBase template = this.addTemplateFromFile(fileName, file3);
                if (!fileName.contains(".child.")) continue;
                children2.add(template);
            }
        }
        catch (NoSuchFileException stream2) {
        }
        catch (IOException e) {
            LOG.error(e);
            return;
        }
        for (FileTemplateBase child : children2) {
            String qname = FTManager.getParentName(child);
            FileTemplateBase parent2 = this.getTemplate(qname);
            if (parent2 == null) continue;
            parent2.addChild(child);
        }
        for (Path file4 : templateWithDefaultExtension) {
            String name = file4.getFileName().toString();
            if (!processedNames.contains(name = name.substring(0, name.length() - TEMPLATE_EXTENSION_SUFFIX.length()))) {
                this.addTemplateFromFile(name, file4);
            }
            try {
                Files.delete(file4);
            }
            catch (IOException e) {
                LOG.error(e);
            }
        }
    }

    @NotNull
    private static String getParentName(FileTemplateBase child) {
        String name = child.getQualifiedName();
        String string2 = name.substring(0, name.indexOf(".child."));
        if (string2 == null) {
            FTManager.$$$reportNull$$$0(16);
        }
        return string2;
    }

    private FileTemplateBase addTemplateFromFile(@NotNull String fileName, @NotNull Path file2) {
        if (fileName == null) {
            FTManager.$$$reportNull$$$0(17);
        }
        if (file2 == null) {
            FTManager.$$$reportNull$$$0(18);
        }
        Pair<String, String> nameExt = FTManager.decodeFileName(fileName);
        String extension2 = (String)nameExt.second;
        String templateQName = (String)nameExt.first;
        if (templateQName.isEmpty()) {
            return null;
        }
        try {
            FileTemplateBase template = this.addTemplate(templateQName, extension2);
            template.setText(Files.readString(file2));
            return template;
        }
        catch (IOException e) {
            LOG.error(e);
            return null;
        }
    }

    public void saveTemplates() {
        this.saveTemplates(false);
    }

    private void saveTemplates(boolean removeDeleted) {
        HashSet<String> allNames = new HashSet<String>();
        HashMap<String, Path> templatesOnDisk = new HashMap<String, Path>();
        try (DirectoryStream<Path> stream22 = Files.newDirectoryStream(this.templateDir, file2 -> !Files.isDirectory(file2, new LinkOption[0]) && !Files.isHidden(file2));){
            for (Path file3 : stream22) {
                String string2 = file3.getFileName().toString();
                templatesOnDisk.put(string2, file3);
                allNames.add(string2);
            }
        }
        catch (NoSuchFileException stream22) {
        }
        catch (IOException e) {
            LOG.error(e);
        }
        HashMap<String, FileTemplateBase> templatesToSave = new HashMap<String, FileTemplateBase>();
        for (FileTemplateBase template : this.getAllTemplates(true)) {
            FTManager.processTemplate(allNames, templatesToSave, template);
            for (FileTemplate child : template.getChildren()) {
                FTManager.processTemplate(allNames, templatesToSave, (FileTemplateBase)child);
            }
        }
        if (allNames.isEmpty()) {
            return;
        }
        try {
            Files.createDirectories(this.templateDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOG.info("Cannot create directory: " + this.templateDir);
        }
        String lineSeparator = CodeStyle.getDefaultSettings().getLineSeparator();
        for (String string3 : allNames) {
            Path customizedTemplateFile = (Path)templatesOnDisk.get(string3);
            FileTemplateBase templateToSave = (FileTemplateBase)templatesToSave.get(string3);
            if (customizedTemplateFile == null) {
                try {
                    FTManager.saveTemplate(this.templateDir, templateToSave, lineSeparator);
                }
                catch (IOException e) {
                    LOG.error("Unable to save template " + string3, e);
                }
                continue;
            }
            if (templateToSave == null) {
                if (!removeDeleted) continue;
                try {
                    Files.delete(customizedTemplateFile);
                }
                catch (IOException e) {
                    LOG.error(e);
                }
                continue;
            }
            try {
                String templateText;
                String diskText = StringUtilRt.convertLineSeparators(Files.readString(customizedTemplateFile));
                if (diskText.equals(templateText = templateToSave.getText())) continue;
                FTManager.saveTemplate(this.templateDir, templateToSave, lineSeparator);
            }
            catch (IOException e) {
                LOG.error("Unable to save template " + string3, e);
            }
        }
    }

    private static void processTemplate(Set<? super String> allNames, Map<String, FileTemplateBase> templatesToSave, FileTemplateBase template) {
        if (template instanceof BundledFileTemplate && !((BundledFileTemplate)template).isTextModified()) {
            return;
        }
        String name = template.getQualifiedName();
        templatesToSave.put(name, template);
        allNames.add(name);
    }

    private static void saveTemplate(@NotNull Path parentDir, @NotNull FileTemplate template, @NotNull String lineSeparator) throws IOException {
        if (parentDir == null) {
            FTManager.$$$reportNull$$$0(19);
        }
        if (template == null) {
            FTManager.$$$reportNull$$$0(20);
        }
        if (lineSeparator == null) {
            FTManager.$$$reportNull$$$0(21);
        }
        Path templateFile = parentDir.resolve(FTManager.encodeFileName(template.getName(), template.getExtension()));
        try (OutputStream fileOutputStream = FTManager.startWriteOrCreate(templateFile);
             OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream, StandardCharsets.UTF_8);){
            String content2 = template.getText();
            if (!lineSeparator.equals("\n")) {
                content2 = StringUtilRt.convertLineSeparators(content2, lineSeparator);
            }
            outputStreamWriter.write(content2);
        }
    }

    @NotNull
    private static OutputStream startWriteOrCreate(@NotNull Path templateFile) throws IOException {
        OutputStream outputStream;
        if (templateFile == null) {
            FTManager.$$$reportNull$$$0(22);
        }
        try {
            outputStream = Files.newOutputStream(templateFile, new OpenOption[0]);
        }
        catch (NoSuchFileException e) {
            NioFiles.deleteRecursively(templateFile);
            OutputStream outputStream2 = Files.newOutputStream(templateFile, new OpenOption[0]);
            if (outputStream2 == null) {
                FTManager.$$$reportNull$$$0(24);
            }
            return outputStream2;
        }
        if (outputStream == null) {
            FTManager.$$$reportNull$$$0(23);
        }
        return outputStream;
    }

    @NotNull
    @TestOnly
    Path getConfigRoot() {
        Path path2 = this.templateDir;
        if (path2 == null) {
            FTManager.$$$reportNull$$$0(25);
        }
        return path2;
    }

    public String toString() {
        return this.name + " file template manager";
    }

    @NotNull
    public static String encodeFileName(@NotNull String templateName, @NotNull String extension2) {
        if (templateName == null) {
            FTManager.$$$reportNull$$$0(26);
        }
        if (extension2 == null) {
            FTManager.$$$reportNull$$$0(27);
        }
        String nameExtDelimiter = extension2.contains(".") ? ENCODED_NAME_EXT_DELIMITER : ".";
        String string2 = templateName + nameExtDelimiter + extension2;
        if (string2 == null) {
            FTManager.$$$reportNull$$$0(28);
        }
        return string2;
    }

    @NotNull
    private static Pair<String, String> decodeFileName(@NotNull String fileName) {
        if (fileName == null) {
            FTManager.$$$reportNull$$$0(29);
        }
        String name = fileName;
        String ext = "";
        String nameExtDelimiter = fileName.contains(ENCODED_NAME_EXT_DELIMITER) ? ENCODED_NAME_EXT_DELIMITER : ".";
        int extIndex = fileName.lastIndexOf(nameExtDelimiter);
        if (extIndex >= 0) {
            name = fileName.substring(0, extIndex);
            ext = fileName.substring(extIndex + nameExtDelimiter.length());
        }
        return new Pair<String, String>(name, ext);
    }

    @NotNull
    public Map<String, FileTemplateBase> getTemplates() {
        Map<String, FileTemplateBase> map2 = this.original == null ? this.templates : this.original.templates;
        if (map2 == null) {
            FTManager.$$$reportNull$$$0(30);
        }
        return map2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 12, 16, 23, 24, 25, 28, 30 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultTemplatesDirName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 16: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/fileTemplates/impl/FTManager";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateQname";
                break;
            }
            case 9: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateName";
                break;
            }
            case 11: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTemplates";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toDisable";
                break;
            }
            case 17: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDir";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineSeparator";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/fileTemplates/impl/FTManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllTemplates";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "addTemplate";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentName";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "startWriteOrCreate";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigRoot";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "encodeFileName";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 16: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 30: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTemplate";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findTemplateByName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addTemplate";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "removeTemplate";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updateTemplates";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "restoreDefaults";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addTemplateFromFile";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "saveTemplate";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "startWriteOrCreate";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "encodeFileName";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "decodeFileName";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 5, 6, 7, 12, 16, 23, 24, 25, 28, 30 -> new IllegalStateException(string2);
        };
    }
}

