/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateParseException;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.fileTemplates.impl.FTManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.OrderedSet;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import org.apache.velocity.runtime.parser.ParseException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileTemplateBase
implements FileTemplate {
    static final boolean DEFAULT_REFORMAT_CODE_VALUE = true;
    static final boolean DEFAULT_ENABLED_VALUE = true;
    static final String TEMPLATE_CHILDREN_SUFFIX = ".child.";
    @Nullable
    private String myText;
    private boolean myShouldReformatCode = true;
    private boolean myLiveTemplateEnabled;
    private boolean myLiveTemplateEnabledChanged;
    private String myFileName = "";
    private FileTemplate[] myChildren = EMPTY_ARRAY;

    public final boolean isReformatCode() {
        return this.myShouldReformatCode;
    }

    public final void setReformatCode(boolean reformat) {
        this.myShouldReformatCode = reformat;
    }

    @NotNull
    public final String getQualifiedName() {
        return FileTemplateBase.getQualifiedName(this.getName(), this.getExtension());
    }

    @NotNull
    public static String getQualifiedName(@NonNls @NotNull String name, @NonNls @NotNull String extension2) {
        if (name == null) {
            FileTemplateBase.$$$reportNull$$$0(0);
        }
        if (extension2 == null) {
            FileTemplateBase.$$$reportNull$$$0(1);
        }
        String string2 = FTManager.encodeFileName(name, extension2);
        if (string2 == null) {
            FileTemplateBase.$$$reportNull$$$0(2);
        }
        return string2;
    }

    @NotNull
    public final String getText() {
        String text2 = this.myText;
        String string2 = text2 != null ? text2 : this.getDefaultText();
        if (string2 == null) {
            FileTemplateBase.$$$reportNull$$$0(3);
        }
        return string2;
    }

    public final void setText(@Nullable String text2) {
        String converted;
        this.myText = text2 == null ? null : ((converted = StringUtil.convertLineSeparators(text2)).equals(this.getDefaultText()) ? null : StringUtil.internEmptyString(converted));
    }

    @NotNull
    protected String getDefaultText() {
        return "";
    }

    @NotNull
    public final String getText(@NotNull Map attributes) throws IOException {
        if (attributes == null) {
            FileTemplateBase.$$$reportNull$$$0(4);
        }
        String string2 = FileTemplateUtil.mergeTemplate(attributes, this.getText(), false);
        if (string2 == null) {
            FileTemplateBase.$$$reportNull$$$0(5);
        }
        return string2;
    }

    @NotNull
    public final String getText(@NotNull Properties attributes) throws IOException {
        if (attributes == null) {
            FileTemplateBase.$$$reportNull$$$0(6);
        }
        String string2 = FileTemplateUtil.mergeTemplate(attributes, this.getText(), false);
        if (string2 == null) {
            FileTemplateBase.$$$reportNull$$$0(7);
        }
        return string2;
    }

    public final String @NotNull [] getUnsetAttributes(@NotNull Properties properties, @NotNull Project project2) throws FileTemplateParseException {
        String[] stringArray;
        if (properties == null) {
            FileTemplateBase.$$$reportNull$$$0(8);
        }
        if (project2 == null) {
            FileTemplateBase.$$$reportNull$$$0(9);
        }
        try {
            OrderedSet<String> attributes = new OrderedSet<String>((Collection<String>)Arrays.asList(FileTemplateUtil.calculateAttributes(this.getText(), properties, false, project2)));
            attributes.addAll(Arrays.asList(FileTemplateUtil.calculateAttributes(this.getFileName(), properties, false, project2)));
            stringArray = ArrayUtil.toStringArray(attributes);
        }
        catch (ParseException e) {
            throw new FileTemplateParseException((Throwable)e);
        }
        if (stringArray == null) {
            FileTemplateBase.$$$reportNull$$$0(10);
        }
        return stringArray;
    }

    @NotNull
    public FileTemplateBase clone() {
        FileTemplateBase fileTemplateBase;
        try {
            fileTemplateBase = (FileTemplateBase)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        if (fileTemplateBase == null) {
            FileTemplateBase.$$$reportNull$$$0(11);
        }
        return fileTemplateBase;
    }

    public boolean isTemplateOfType(@NotNull FileType fType) {
        if (fType == null) {
            FileTemplateBase.$$$reportNull$$$0(12);
        }
        return fType.equals(FileTypeManagerEx.getInstanceEx().getFileTypeByExtension(this.getExtension()));
    }

    public boolean isLiveTemplateEnabled() {
        return this.myLiveTemplateEnabled;
    }

    public void setLiveTemplateEnabled(boolean value) {
        this.myLiveTemplateEnabledChanged |= this.myLiveTemplateEnabled != value;
        this.myLiveTemplateEnabled = value;
    }

    public boolean isLiveTemplateEnabledChanged() {
        return this.myLiveTemplateEnabledChanged;
    }

    public boolean isLiveTemplateEnabledByDefault() {
        return false;
    }

    @NotNull
    public String getFileName() {
        String string2 = this.myFileName;
        if (string2 == null) {
            FileTemplateBase.$$$reportNull$$$0(13);
        }
        return string2;
    }

    public void setFileName(@NotNull String fileName) {
        if (fileName == null) {
            FileTemplateBase.$$$reportNull$$$0(14);
        }
        this.myFileName = fileName;
    }

    public FileTemplate @NotNull [] getChildren() {
        if (this.myChildren == null) {
            FileTemplateBase.$$$reportNull$$$0(15);
        }
        return this.myChildren;
    }

    public void setChildren(FileTemplate @NotNull [] children2) {
        if (children2 == null) {
            FileTemplateBase.$$$reportNull$$$0(16);
        }
        this.myChildren = children2;
    }

    public void addChild(FileTemplate child) {
        this.myChildren = ArrayUtil.append(this.getChildren(), child);
    }

    public String getChildName(int index2) {
        return this.getQualifiedName() + TEMPLATE_CHILDREN_SUFFIX + index2;
    }

    public void updateChildrenNames() {
        FileTemplate @NotNull [] children2 = this.getChildren();
        for (int i2 = 0; i2 < children2.length; ++i2) {
            children2[i2].setName(this.getChildName(i2));
        }
    }

    public static boolean isChild(@NotNull FileTemplate template) {
        if (template == null) {
            FileTemplateBase.$$$reportNull$$$0(17);
        }
        return template.getName().contains(TEMPLATE_CHILDREN_SUFFIX);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5, 7, 10, 11, 13, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/fileTemplates/impl/FileTemplateBase";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fType";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/fileTemplates/impl/FileTemplateBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnsetAttributes";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "clone";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedName";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 15: {
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getUnsetAttributes";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isTemplateOfType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setFileName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setChildren";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isChild";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3, 5, 7, 10, 11, 13, 15 -> new IllegalStateException(string2);
        };
    }
}

