/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.impl.FileTemplateBase;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.JBColor;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class FileTemplateTab {
    protected final List<FileTemplateBase> templates = new ArrayList<FileTemplateBase>();
    @NlsContexts.TabTitle
    private final String myTitle;
    static final Color MODIFIED_FOREGROUND = JBColor.BLUE;

    FileTemplateTab(@NlsContexts.TabTitle String title) {
        this.myTitle = title;
    }

    public abstract JComponent getComponent();

    @Nullable
    public abstract FileTemplate getSelectedTemplate();

    public abstract void selectTemplate(FileTemplate var1);

    public abstract void removeSelected();

    public abstract void onTemplateSelected();

    public void init(List<? extends FileTemplate> templates) {
        FileTemplate oldSelection = this.getSelectedTemplate();
        String oldSelectionName = oldSelection != null ? ((FileTemplateBase)oldSelection).getQualifiedName() : null;
        this.templates.clear();
        for (FileTemplate fileTemplate : templates) {
            if (FileTemplateBase.isChild(fileTemplate)) continue;
            FileTemplate copy2 = this.addCopy(fileTemplate);
            copy2.setChildren(ContainerUtil.map2Array(fileTemplate.getChildren(), FileTemplate.class, template -> this.addCopy((FileTemplate)template)));
        }
        this.initSelection((FileTemplate)ContainerUtil.find(this.templates, base -> base.getQualifiedName().equals(oldSelectionName)));
    }

    private FileTemplate addCopy(FileTemplate original) {
        FileTemplateBase copy2 = (FileTemplateBase)original.clone();
        this.templates.add(copy2);
        return copy2;
    }

    protected abstract void initSelection(FileTemplate var1);

    public abstract void fireDataChanged();

    @NotNull
    public List<FileTemplate> getTemplates() {
        List<FileTemplate> list2 = List.copyOf(this.templates);
        if (list2 == null) {
            FileTemplateTab.$$$reportNull$$$0(0);
        }
        return list2;
    }

    public abstract void addTemplate(FileTemplate var1);

    public abstract void insertTemplate(FileTemplate var1, int var2);

    @NlsContexts.TabTitle
    public String getTitle() {
        return this.myTitle;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FileTemplateTab", "getTemplates"));
    }
}

