/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.ide.fileTemplates.impl.DefaultTemplate;
import com.intellij.ide.fileTemplates.impl.FTManager;
import com.intellij.ide.fileTemplates.impl.FileTemplateLoadResult;
import com.intellij.ide.fileTemplates.impl.FileTemplatesLoader;
import com.intellij.ide.fileTemplates.impl.FileTemplatesLoaderKt;
import com.intellij.ide.fileTemplates.impl.LoadedConfiguration;
import com.intellij.ide.fileTemplates.impl.UrlUtil;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.project.ProjectKt;
import com.intellij.util.ResourceUtil;
import com.intellij.util.lang.UrlClassLoader;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000`\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001H\u0002\u001a0\u0010\t\u001a\u0004\u0018\u00010\u00012\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\u000eH\u0002\u001a\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002\u001a\u0016\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00010\u0016H\u0002\u001a&\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00010\u0016H\u0002\u001a&\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00072\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00010\u00162\u0006\u0010\u0019\u001a\u00020\u0014H\u0002\u001a\u0018\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001H\u0002\u001ax\u0010\u001d\u001a\u00020\u00182\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00010\u001f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00010\u00162\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010 2\u0006\u0010\u0019\u001a\u00020\u00142\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\"2'\u0010#\u001a#\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b(\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00050$H\u0082\b\u001a\u0010\u0010'\u001a\u00020(2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"DEFAULT_TEMPLATES_ROOT", "", "DESCRIPTION_EXTENSION_SUFFIX", "DESCRIPTION_FILE_EXTENSION", "createSupplierForUrlSource", "Ljava/util/function/Supplier;", "root", "Ljava/net/URL;", "path", "getDescriptionPath", "pathPrefix", "templateName", "templateExtension", "descriptionPaths", "", "loadConfiguration", "Lcom/intellij/ide/fileTemplates/impl/LoadedConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "loadDefaultTemplates", "Lcom/intellij/ide/fileTemplates/impl/FileTemplateLoadResult;", "prefixes", "", "loadDefaultsFromDirectory", "", "result", "loadDefaultsFromJar", "url", "loadTemplate", "processTemplates", "files", "Lkotlin/sequences/Sequence;", "", "descriptionLoader", "Ljava/util/function/Function;", "dataLoader", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "urlToPath", "Ljava/nio/file/Path;", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nFileTemplatesLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileTemplatesLoader.kt\ncom/intellij/ide/fileTemplates/impl/FileTemplatesLoaderKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,354:1\n249#1,2:360\n251#1,5:363\n257#1,16:369\n273#1,4:386\n249#1,2:393\n251#1,5:396\n257#1,16:402\n273#1,4:419\n1549#2:355\n1620#2,3:356\n288#2:362\n289#2:368\n288#2,2:390\n288#2:395\n289#2:401\n10#3:359\n10#3:423\n1#4:385\n1#4:392\n1#4:418\n*S KotlinDebug\n*F\n+ 1 FileTemplatesLoader.kt\ncom/intellij/ide/fileTemplates/impl/FileTemplatesLoaderKt\n*L\n234#1:360,2\n234#1:363,5\n234#1:369,16\n234#1:386,4\n301#1:393,2\n301#1:396,5\n301#1:402,16\n301#1:419,4\n160#1:355\n160#1:356,3\n234#1:362\n234#1:368\n250#1:390,2\n301#1:395\n301#1:401\n209#1:359\n351#1:423\n234#1:385\n301#1:418\n*E\n"})
public final class FileTemplatesLoaderKt {
    @NotNull
    private static final String DEFAULT_TEMPLATES_ROOT = "fileTemplates";
    @NotNull
    private static final String DESCRIPTION_FILE_EXTENSION = "html";
    @NotNull
    private static final String DESCRIPTION_EXTENSION_SUFFIX = ".html";

    private static final String getDescriptionPath(String pathPrefix, String templateName, String templateExtension, Set<String> descriptionPaths) {
        Object path2;
        Locale locale = Locale.getDefault();
        Object[] objectArray = new Object[]{templateName, templateExtension, locale.getLanguage(), locale.getCountry()};
        Object name = MessageFormat.format("{0}.{1}_{2}_{3}.html", objectArray);
        Object object = path2 = ((CharSequence)pathPrefix).length() == 0 ? name : pathPrefix + "/" + (String)name;
        if (descriptionPaths.contains(path2)) {
            return path2;
        }
        Object[] objectArray2 = new Object[]{templateName, templateExtension, locale.getLanguage()};
        name = MessageFormat.format("{0}.{1}_{2}.html", objectArray2);
        Object object2 = path2 = ((CharSequence)pathPrefix).length() == 0 ? name : pathPrefix + "/" + (String)name;
        if (descriptionPaths.contains(path2)) {
            return path2;
        }
        name = templateName + "." + templateExtension + DESCRIPTION_EXTENSION_SUFFIX;
        path2 = ((CharSequence)pathPrefix).length() == 0 ? name : pathPrefix + "/" + (String)name;
        return descriptionPaths.contains(path2) ? path2 : null;
    }

    /*
     * WARNING - void declaration
     */
    private static final LoadedConfiguration loadConfiguration(Project project2) {
        void $this$mapTo$iv$iv;
        Path configDir = project2 == null || project2.isDefault() ? PathManager.getConfigDir().resolve(DEFAULT_TEMPLATES_ROOT) : ProjectKt.getStateStore(project2).getProjectFilePath().getParent().resolve(DEFAULT_TEMPLATES_ROOT);
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)"Default", (Object)""), TuplesKt.to((Object)"Internal", (Object)"internal"), TuplesKt.to((Object)"Includes", (Object)"includes"), TuplesKt.to((Object)"Code", (Object)"code"), TuplesKt.to((Object)"J2EE", (Object)"j2ee")};
        List managerToDir = CollectionsKt.listOf((Object[])objectArray);
        Iterable $this$map$iv = managerToDir;
        boolean $i$f$map = false;
        Iterable iterable2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)it.getSecond());
        }
        FileTemplateLoadResult result2 = FileTemplatesLoaderKt.loadDefaultTemplates((List)destination$iv$iv);
        HashMap<String, FTManager> managers2 = new HashMap<String, FTManager>(managerToDir.size());
        for (Iterable iterable2 : managerToDir) {
            String name = (String)iterable2.component1();
            String pathPrefix = (String)iterable2.component2();
            Path path2 = configDir.resolve(pathPrefix);
            List list2 = result2.prefixToTemplates.get(pathPrefix);
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            FTManager manager = new FTManager(name, path2, list2, Intrinsics.areEqual((Object)name, (Object)"Internal"));
            manager.loadCustomizedContent();
            managers2.put(name, manager);
        }
        return new LoadedConfiguration((Map<String, FTManager>)managers2, result2.defaultTemplateDescription, result2.defaultIncludeDescription);
    }

    private static final FileTemplateLoadResult loadDefaultTemplates(List<String> prefixes) {
        FileTemplateLoadResult result2 = new FileTemplateLoadResult(new HashMap());
        HashSet<URL> processedUrls = new HashSet<URL>();
        Set<ClassLoader> processedLoaders = Collections.newSetFromMap(new IdentityHashMap());
        for (IdeaPluginDescriptorImpl plugin : PluginManagerCore.getPluginSet().enabledPlugins) {
            ClassLoader loader;
            Intrinsics.checkNotNullExpressionValue((Object)plugin.getClassLoader(), (String)"plugin.classLoader");
            if (loader instanceof PluginAwareClassLoader && ((PluginAwareClassLoader)((Object)loader)).getFiles().isEmpty() || !processedLoaders.add(loader)) continue;
            try {
                Enumeration<URL> resourceUrls;
                Enumeration<URL> enumeration = resourceUrls = loader instanceof UrlClassLoader ? ((UrlClassLoader)loader).getClassPath().getResources(DEFAULT_TEMPLATES_ROOT) : loader.getResources(DEFAULT_TEMPLATES_ROOT);
                while (resourceUrls.hasMoreElements()) {
                    URL url = resourceUrls.nextElement();
                    if (!processedUrls.add(url)) continue;
                    String protocol = url.getProtocol();
                    if (StringsKt.equals((String)"jar", (String)protocol, (boolean)true)) {
                        Intrinsics.checkNotNullExpressionValue((Object)url, (String)"url");
                        FileTemplatesLoaderKt.loadDefaultsFromJar(url, prefixes, result2);
                        continue;
                    }
                    if (!StringsKt.equals((String)"file", (String)protocol, (boolean)true)) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)url, (String)"url");
                    FileTemplatesLoaderKt.loadDefaultsFromDirectory(url, result2, prefixes);
                }
            }
            catch (IOException e) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(FileTemplatesLoader.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
                logger.error(e);
            }
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private static final void loadDefaultsFromJar(URL url, List<String> prefixes, FileTemplateLoadResult result2) {
        void files$iv;
        List<String> list2 = UrlUtil.getChildPathsFromJar(url);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getChildPathsFromJar(url)");
        List<String> children2 = list2;
        if (children2.isEmpty()) {
            return;
        }
        Set descriptionPaths = new HashSet();
        for (String path2 : children2) {
            if (Intrinsics.areEqual((Object)path2, (Object)"default.html")) {
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path");
                result2.defaultTemplateDescription = FileTemplatesLoaderKt.createSupplierForUrlSource(url, path2);
                continue;
            }
            if (Intrinsics.areEqual((Object)path2, (Object)"includes/default.html")) {
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path");
                result2.defaultIncludeDescription = FileTemplatesLoaderKt.createSupplierForUrlSource(url, path2);
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path");
            if (!StringsKt.endsWith$default((String)path2, (String)DESCRIPTION_EXTENSION_SUFFIX, (boolean)false, (int)2, null)) continue;
            descriptionPaths.add(path2);
        }
        Sequence sequence = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)children2), (Function1)loadDefaultsFromJar.1.INSTANCE);
        Function1 descriptionLoader$iv = arg_0 -> FileTemplatesLoaderKt.loadDefaultsFromJar$lambda$1(url, arg_0);
        boolean $i$f$processTemplates = false;
        for (String path$iv : files$iv) {
            Function1 function1;
            void it;
            String string2;
            String extension$iv;
            String filename$iv;
            String prefix$iv;
            Object v2;
            block8: {
                Iterable $this$firstOrNull$iv$iv = prefixes;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                    String it$iv = (String)element$iv$iv;
                    boolean bl3 = false;
                    boolean bl2 = ((CharSequence)it$iv).length() == 0 ? !StringsKt.contains$default((CharSequence)path$iv, (char)'/', (boolean)false, (int)2, null) : path$iv.length() > it$iv.length() && path$iv.charAt(it$iv.length()) == '/' && StringsKt.startsWith$default((String)path$iv, (String)it$iv, (boolean)false, (int)2, null) && StringsKt.indexOf$default((CharSequence)path$iv, (char)'/', (int)(it$iv.length() + 1), (boolean)false, (int)4, null) == -1;
                    if (!bl2) continue;
                    v2 = element$iv$iv;
                    break block8;
                }
                v2 = null;
            }
            if ((String)v2 == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)path$iv.substring(((CharSequence)prefix$iv).length() == 0 ? 0 : prefix$iv.length() + 1, path$iv.length() - 3), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            Intrinsics.checkNotNullExpressionValue((Object)FileUtilRt.getExtension(filename$iv), (String)"getExtension(filename)");
            if (((CharSequence)extension$iv).length() > 0) {
                String string3 = filename$iv.substring(0, filename$iv.length() - extension$iv.length() - 1);
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            } else {
                string2 = filename$iv;
            }
            String templateName$iv = string2;
            String descriptionPath$iv = FileTemplatesLoaderKt.getDescriptionPath(prefix$iv, templateName$iv, extension$iv, descriptionPaths);
            String string4 = path$iv;
            String string5 = extension$iv;
            String string6 = templateName$iv;
            boolean bl = false;
            Supplier<String> supplier2 = FileTemplatesLoaderKt.createSupplierForUrlSource(url, (String)it);
            Function1 bl3 = function1 = descriptionLoader$iv;
            Supplier<String> supplier3 = supplier2;
            String string7 = string5;
            String string8 = string6;
            boolean bl4 = false;
            boolean bl5 = descriptionPath$iv != null;
            String string9 = descriptionPath$iv;
            Function1 function12 = bl5 ? function1 : null;
            Supplier<String> supplier4 = supplier3;
            String string10 = string7;
            String string11 = string8;
            DefaultTemplate template$iv = new DefaultTemplate(string11, string10, supplier4, (Function<String, String>)function12, string9);
            function1 = processTemplates.1.INSTANCE;
            result2.prefixToTemplates.computeIfAbsent(prefix$iv, new Function(function1){
                private final /* synthetic */ Function1 function;
                {
                    Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                    this.function = function;
                }

                public final /* synthetic */ Object apply(Object p0) {
                    return this.function.invoke(p0);
                }
            }).add(template$iv);
        }
    }

    private static final void processTemplates(Sequence<String> files2, List<String> prefixes, Set<String> descriptionPaths, FileTemplateLoadResult result2, Function<String, String> descriptionLoader, Function1<? super String, ? extends Supplier<String>> dataLoader2) {
        boolean $i$f$processTemplates = false;
        for (String path2 : files2) {
            Function1 function1;
            String string2;
            String extension2;
            String filename;
            String prefix;
            Object v1;
            block4: {
                Iterable $this$firstOrNull$iv = prefixes;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    boolean bl2 = ((CharSequence)it).length() == 0 ? !StringsKt.contains$default((CharSequence)path2, (char)'/', (boolean)false, (int)2, null) : path2.length() > it.length() && path2.charAt(it.length()) == '/' && StringsKt.startsWith$default((String)path2, (String)it, (boolean)false, (int)2, null) && StringsKt.indexOf$default((CharSequence)path2, (char)'/', (int)(it.length() + 1), (boolean)false, (int)4, null) == -1;
                    if (!bl2) continue;
                    v1 = element$iv;
                    break block4;
                }
                v1 = null;
            }
            if ((String)v1 == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)path2.substring(((CharSequence)prefix).length() == 0 ? 0 : prefix.length() + 1, path2.length() - 3), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            Intrinsics.checkNotNullExpressionValue((Object)FileUtilRt.getExtension(filename), (String)"getExtension(filename)");
            if (((CharSequence)extension2).length() > 0) {
                String string3 = filename.substring(0, filename.length() - extension2.length() - 1);
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            } else {
                string2 = filename;
            }
            String templateName = string2;
            String descriptionPath = FileTemplatesLoaderKt.getDescriptionPath(prefix, templateName, extension2, descriptionPaths);
            Function1 bl = function1 = descriptionLoader;
            Supplier supplier2 = (Supplier)dataLoader2.invoke((Object)path2);
            String string4 = extension2;
            String string5 = templateName;
            boolean bl3 = false;
            boolean bl4 = descriptionPath != null;
            String string6 = descriptionPath;
            Function1 function12 = bl4 ? function1 : null;
            Supplier supplier3 = supplier2;
            String string7 = string4;
            String string8 = string5;
            DefaultTemplate template = new DefaultTemplate(string8, string7, supplier3, (Function<String, String>)function12, string6);
            function1 = processTemplates.1.INSTANCE;
            result2.prefixToTemplates.computeIfAbsent(prefix, new /* invalid duplicate definition of identical inner class */).add(template);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final void loadDefaultsFromDirectory(URL root, FileTemplateLoadResult result2, List<String> prefixes) {
        void files$iv;
        HashSet<String> descriptionPaths = new HashSet<String>();
        List templateFiles = new ArrayList();
        Path rootFile = FileTemplatesLoaderKt.urlToPath(root);
        AutoCloseable autoCloseable = Files.find(rootFile, Integer.MAX_VALUE, FileTemplatesLoaderKt::loadDefaultsFromDirectory$lambda$5, new FileVisitOption[0]);
        Throwable throwable = null;
        try {
            Stream it = (Stream)autoCloseable;
            boolean bl = false;
            it.forEach(arg_0 -> FileTemplatesLoaderKt.loadDefaultsFromDirectory$lambda$7$lambda$6((Function1)new Function1<Path, Unit>(rootFile, result2, descriptionPaths, (List<String>)templateFiles){
                final /* synthetic */ Path $rootFile;
                final /* synthetic */ FileTemplateLoadResult $result;
                final /* synthetic */ HashSet<String> $descriptionPaths;
                final /* synthetic */ List<String> $templateFiles;
                {
                    this.$rootFile = $rootFile;
                    this.$result = $result;
                    this.$descriptionPaths = $descriptionPaths;
                    this.$templateFiles = $templateFiles;
                    super(1);
                }

                public final void invoke(Path file2) {
                    String path2 = StringsKt.replace$default((String)((Object)this.$rootFile.relativize(file2)).toString(), (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
                    if (StringsKt.endsWith$default((String)path2, (String)"/default.html", (boolean)false, (int)2, null)) {
                        this.$result.defaultTemplateDescription = () -> loadDefaultsFromDirectory.2.1.invoke$lambda$0(file2);
                    } else if (StringsKt.endsWith$default((String)path2, (String)"/includes/default.html", (boolean)false, (int)2, null)) {
                        this.$result.defaultIncludeDescription = () -> loadDefaultsFromDirectory.2.1.invoke$lambda$1(file2);
                    } else if (StringsKt.endsWith$default((String)path2, (String)".html", (boolean)false, (int)2, null)) {
                        this.$descriptionPaths.add(path2);
                    } else if (StringsKt.endsWith$default((String)path2, (String)".ft", (boolean)false, (int)2, null)) {
                        this.$templateFiles.add(path2);
                    }
                }

                private static final String invoke$lambda$0(Path $file) {
                    return Files.readString($file);
                }

                private static final String invoke$lambda$1(Path $file) {
                    return Files.readString($file);
                }
            }, arg_0));
            it = Unit.INSTANCE;
        }
        catch (Throwable it) {
            throwable = it;
            throw it;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        autoCloseable = CollectionsKt.asSequence((Iterable)templateFiles);
        Function1 descriptionLoader$iv = arg_0 -> FileTemplatesLoaderKt.loadDefaultsFromDirectory$lambda$8(rootFile, arg_0);
        boolean $i$f$processTemplates = false;
        for (String path$iv : files$iv) {
            Function1 function1;
            void it;
            String string2;
            String extension$iv;
            String filename$iv;
            String prefix$iv;
            Object v1;
            block10: {
                Iterable $this$firstOrNull$iv$iv = prefixes;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                    String it$iv = (String)element$iv$iv;
                    boolean bl3 = false;
                    boolean bl2 = ((CharSequence)it$iv).length() == 0 ? !StringsKt.contains$default((CharSequence)path$iv, (char)'/', (boolean)false, (int)2, null) : path$iv.length() > it$iv.length() && path$iv.charAt(it$iv.length()) == '/' && StringsKt.startsWith$default((String)path$iv, (String)it$iv, (boolean)false, (int)2, null) && StringsKt.indexOf$default((CharSequence)path$iv, (char)'/', (int)(it$iv.length() + 1), (boolean)false, (int)4, null) == -1;
                    if (!bl2) continue;
                    v1 = element$iv$iv;
                    break block10;
                }
                v1 = null;
            }
            if ((String)v1 == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)path$iv.substring(((CharSequence)prefix$iv).length() == 0 ? 0 : prefix$iv.length() + 1, path$iv.length() - 3), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            Intrinsics.checkNotNullExpressionValue((Object)FileUtilRt.getExtension(filename$iv), (String)"getExtension(filename)");
            if (((CharSequence)extension$iv).length() > 0) {
                String string3 = filename$iv.substring(0, filename$iv.length() - extension$iv.length() - 1);
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            } else {
                string2 = filename$iv;
            }
            String templateName$iv = string2;
            String descriptionPath$iv = FileTemplatesLoaderKt.getDescriptionPath(prefix$iv, templateName$iv, extension$iv, (Set<String>)descriptionPaths);
            String string4 = path$iv;
            String string5 = extension$iv;
            String string6 = templateName$iv;
            boolean bl = false;
            Supplier<String> supplier2 = () -> FileTemplatesLoaderKt.loadDefaultsFromDirectory$lambda$10$lambda$9(rootFile, (String)it);
            Function1 bl3 = function1 = descriptionLoader$iv;
            Supplier<String> supplier3 = supplier2;
            String string7 = string5;
            String string8 = string6;
            boolean bl4 = false;
            boolean bl5 = descriptionPath$iv != null;
            String string9 = descriptionPath$iv;
            Function1 function12 = bl5 ? function1 : null;
            Supplier<String> supplier4 = supplier3;
            String string10 = string7;
            String string11 = string8;
            DefaultTemplate template$iv = new DefaultTemplate(string11, string10, supplier4, (Function<String, String>)function12, string9);
            function1 = processTemplates.1.INSTANCE;
            result2.prefixToTemplates.computeIfAbsent(prefix$iv, new /* invalid duplicate definition of identical inner class */).add(template$iv);
        }
    }

    private static final Path urlToPath(URL root) {
        String path2 = root.toURI().getPath();
        if (SystemInfoRt.isWindows) {
            String string2 = path2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"path");
            if (StringsKt.startsWith$default((String)string2, (String)"/", (boolean)false, (int)2, null)) {
                String string3 = path2;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"path");
                int position = StringsKt.indexOf$default((CharSequence)string3, (char)':', (int)0, (boolean)false, (int)6, null);
                if (position > 1) {
                    String string4 = path2;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"path");
                    String string5 = string4;
                    int n = position - 1;
                    String string6 = string5.substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String).substring(startIndex)");
                    path2 = string6;
                }
            }
        }
        Path path3 = Path.of(path2, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"of(path)");
        return path3;
    }

    private static final Supplier<String> createSupplierForUrlSource(URL root, String path2) {
        return new Supplier<String>(root, path2){
            final /* synthetic */ URL $root;
            final /* synthetic */ String $path;
            {
                this.$root = $root;
                this.$path = $path;
            }

            @NotNull
            public String get() {
                return FileTemplatesLoaderKt.access$loadTemplate(this.$root, this.$path);
            }

            @NotNull
            public String toString() {
                return "(root=" + this.$root + ", path=" + this.$path + ")";
            }
        };
    }

    private static final String loadTemplate(URL root, String path2) {
        String string2;
        try {
            char[] cArray = new char[]{'/'};
            String string3 = ResourceUtil.loadText(new URL(root, "fileTemplates/" + StringsKt.trimEnd((String)path2, (char[])cArray)).openStream());
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"{\n    ResourceUtil.loadT\u2026'/')}\").openStream())\n  }");
            string2 = string3;
        }
        catch (IOException e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(FileTemplatesLoader.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
            logger.error(e);
            string2 = "";
        }
        return string2;
    }

    private static final String loadDefaultsFromJar$lambda$1(URL $url, String it) {
        Intrinsics.checkNotNullParameter((Object)$url, (String)"$url");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return FileTemplatesLoaderKt.loadTemplate($url, it);
    }

    private static final boolean loadDefaultsFromDirectory$lambda$5(Path path2, BasicFileAttributes a) {
        return a.isRegularFile();
    }

    private static final void loadDefaultsFromDirectory$lambda$7$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final String loadDefaultsFromDirectory$lambda$8(Path $rootFile, String it) {
        Intrinsics.checkNotNullParameter((Object)$rootFile, (String)"$rootFile");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Files.readString($rootFile.resolve(it));
    }

    private static final String loadDefaultsFromDirectory$lambda$10$lambda$9(Path $rootFile, String $it) {
        Intrinsics.checkNotNullParameter((Object)$rootFile, (String)"$rootFile");
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        return Files.readString($rootFile.resolve($it));
    }

    public static final /* synthetic */ LoadedConfiguration access$loadConfiguration(Project project2) {
        return FileTemplatesLoaderKt.loadConfiguration(project2);
    }

    public static final /* synthetic */ String access$loadTemplate(URL root, String path2) {
        return FileTemplatesLoaderKt.loadTemplate(root, path2);
    }
}

