/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy;

import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.ExporterToTextFile;
import com.intellij.ide.actions.CloseTabToolbarAction;
import com.intellij.ide.hierarchy.ExporterToTextFileHierarchy;
import com.intellij.ide.hierarchy.HierarchyBrowser;
import com.intellij.ide.hierarchy.HierarchyBrowserManager;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyNodeRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CompositeDataProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.pom.Navigatable;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.content.Content;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HierarchyBrowserBase
extends SimpleToolWindowPanel
implements HierarchyBrowser,
Disposable,
DataProvider {
    protected final Project myProject;
    protected Content myContent;
    private final AutoScrollToSourceHandler myAutoScrollToSourceHandler;
    private volatile boolean myDisposed;

    protected HierarchyBrowserBase(@NotNull Project project2) {
        if (project2 == null) {
            HierarchyBrowserBase.$$$reportNull$$$0(0);
        }
        super(true, true);
        this.myProject = project2;
        this.myAutoScrollToSourceHandler = new AutoScrollToSourceHandler(){

            protected boolean isAutoScrollMode() {
                return HierarchyBrowserManager.getSettings((Project)HierarchyBrowserBase.this.myProject).IS_AUTOSCROLL_TO_SOURCE;
            }

            protected void setAutoScrollMode(boolean state) {
                HierarchyBrowserManager.getSettings((Project)HierarchyBrowserBase.this.myProject).IS_AUTOSCROLL_TO_SOURCE = state;
            }
        };
    }

    @Override
    public void setContent(@NotNull Content content2) {
        if (content2 == null) {
            HierarchyBrowserBase.$$$reportNull$$$0(1);
        }
        this.myContent = content2;
    }

    protected void buildUi(@NotNull JComponent toolbar, @NotNull JComponent content2) {
        if (toolbar == null) {
            HierarchyBrowserBase.$$$reportNull$$$0(2);
        }
        if (content2 == null) {
            HierarchyBrowserBase.$$$reportNull$$$0(3);
        }
        this.setToolbar(toolbar);
        this.setContent(content2);
    }

    @Override
    public void dispose() {
        this.myDisposed = true;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    @NotNull
    protected ActionToolbar createToolbar(@NotNull String place, @NotNull String helpID) {
        if (place == null) {
            HierarchyBrowserBase.$$$reportNull$$$0(4);
        }
        if (helpID == null) {
            HierarchyBrowserBase.$$$reportNull$$$0(5);
        }
        DefaultActionGroup actionGroup2 = new DefaultActionGroup();
        this.appendActions(actionGroup2, helpID);
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar(place, (ActionGroup)actionGroup2, true);
        actionToolbar.setTargetComponent((JComponent)((Object)this));
        ActionToolbar actionToolbar2 = actionToolbar;
        if (actionToolbar2 == null) {
            HierarchyBrowserBase.$$$reportNull$$$0(6);
        }
        return actionToolbar2;
    }

    protected void appendActions(@NotNull DefaultActionGroup actionGroup2, @Nullable String helpID) {
        if (actionGroup2 == null) {
            HierarchyBrowserBase.$$$reportNull$$$0(7);
        }
        actionGroup2.add((AnAction)this.myAutoScrollToSourceHandler.createToggleAction());
        ActionManager actionManager = ActionManager.getInstance();
        actionGroup2.add(actionManager.getAction("ExpandAll"));
        actionGroup2.add(actionManager.getAction("CollapseAll"));
        actionGroup2.add(actionManager.getAction("PinToolwindowTab"));
        actionGroup2.add(CommonActionsManager.getInstance().createExportToTextFileAction((ExporterToTextFile)new ExporterToTextFileHierarchy(this)));
        actionGroup2.add((AnAction)new CloseAction());
    }

    protected abstract JTree getCurrentTree();

    abstract StructureTreeModel getCurrentBuilder();

    @Nullable
    protected abstract PsiElement getElementFromDescriptor(@NotNull HierarchyNodeDescriptor var1);

    @Nullable
    protected final PsiElement getSelectedElement(@NotNull DataContext dataContext2) {
        Object element;
        if (dataContext2 == null) {
            HierarchyBrowserBase.$$$reportNull$$$0(8);
        }
        if (!((element = ArrayUtil.getFirstElement((Object[])dataContext2.getData(PlatformCoreDataKeys.SELECTED_ITEMS))) instanceof HierarchyNodeDescriptor)) {
            return null;
        }
        return this.getElementFromDescriptor((HierarchyNodeDescriptor)((Object)element));
    }

    @Nullable
    protected static HierarchyNodeDescriptor getDescriptor(@NotNull DefaultMutableTreeNode node2) {
        Object userObject;
        if (node2 == null) {
            HierarchyBrowserBase.$$$reportNull$$$0(9);
        }
        if ((userObject = node2.getUserObject()) instanceof HierarchyNodeDescriptor) {
            return (HierarchyNodeDescriptor)((Object)userObject);
        }
        return null;
    }

    public PsiElement @NotNull [] getAvailableElements() {
        JTree tree = this.getCurrentTree();
        if (tree == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                HierarchyBrowserBase.$$$reportNull$$$0(10);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        TreeModel model2 = tree.getModel();
        Object root = model2.getRoot();
        if (!(root instanceof DefaultMutableTreeNode)) {
            if (PsiElement.EMPTY_ARRAY == null) {
                HierarchyBrowserBase.$$$reportNull$$$0(11);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        DefaultMutableTreeNode node2 = (DefaultMutableTreeNode)root;
        HierarchyNodeDescriptor descriptor2 = HierarchyBrowserBase.getDescriptor(node2);
        HashSet result2 = new HashSet();
        if (descriptor2 != null) {
            this.collectElements(descriptor2, result2);
        }
        PsiElement[] psiElementArray = result2.toArray(PsiElement.EMPTY_ARRAY);
        if (psiElementArray == null) {
            HierarchyBrowserBase.$$$reportNull$$$0(12);
        }
        return psiElementArray;
    }

    private void collectElements(@NotNull HierarchyNodeDescriptor descriptor2, @NotNull Set<? super PsiElement> out) {
        Object[] children2;
        PsiElement element;
        if (descriptor2 == null) {
            HierarchyBrowserBase.$$$reportNull$$$0(13);
        }
        if (out == null) {
            HierarchyBrowserBase.$$$reportNull$$$0(14);
        }
        if ((element = this.getElementFromDescriptor(descriptor2)) != null) {
            out.add(element.getNavigationElement());
        }
        if ((children2 = descriptor2.getCachedChildren()) == null) {
            return;
        }
        for (Object child : children2) {
            if (!(child instanceof HierarchyNodeDescriptor)) continue;
            HierarchyNodeDescriptor childDescriptor = (HierarchyNodeDescriptor)((Object)child);
            this.collectElements(childDescriptor, out);
        }
    }

    public final HierarchyNodeDescriptor @NotNull [] getSelectedDescriptors() {
        JTree tree = this.getCurrentTree();
        if (tree == null) {
            if (HierarchyNodeDescriptor.EMPTY_ARRAY == null) {
                HierarchyBrowserBase.$$$reportNull$$$0(15);
            }
            return HierarchyNodeDescriptor.EMPTY_ARRAY;
        }
        TreePath[] paths2 = tree.getSelectionPaths();
        if (paths2 == null || paths2.length == 0) {
            if (HierarchyNodeDescriptor.EMPTY_ARRAY == null) {
                HierarchyBrowserBase.$$$reportNull$$$0(16);
            }
            return HierarchyNodeDescriptor.EMPTY_ARRAY;
        }
        ArrayList<HierarchyNodeDescriptor> list2 = new ArrayList<HierarchyNodeDescriptor>(paths2.length);
        for (TreePath path2 : paths2) {
            DefaultMutableTreeNode node2;
            HierarchyNodeDescriptor descriptor2;
            Object lastPathComponent = path2.getLastPathComponent();
            if (!(lastPathComponent instanceof DefaultMutableTreeNode) || (descriptor2 = HierarchyBrowserBase.getDescriptor(node2 = (DefaultMutableTreeNode)lastPathComponent)) == null) continue;
            list2.add(descriptor2);
        }
        HierarchyNodeDescriptor[] hierarchyNodeDescriptorArray = list2.toArray(HierarchyNodeDescriptor.EMPTY_ARRAY);
        if (hierarchyNodeDescriptorArray == null) {
            HierarchyBrowserBase.$$$reportNull$$$0(17);
        }
        return hierarchyNodeDescriptorArray;
    }

    protected PsiElement @NotNull [] getSelectedElements() {
        HierarchyNodeDescriptor[] descriptors = this.getSelectedDescriptors();
        ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
        for (HierarchyNodeDescriptor descriptor2 : descriptors) {
            PsiElement element = this.getElementFromDescriptor(descriptor2);
            if (element == null) continue;
            elements.add(element);
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(elements);
        if (psiElementArray == null) {
            HierarchyBrowserBase.$$$reportNull$$$0(18);
        }
        return psiElementArray;
    }

    private Navigatable getNavigatable(@NotNull HierarchyNodeDescriptor descriptor2) {
        if (descriptor2 == null) {
            HierarchyBrowserBase.$$$reportNull$$$0(19);
        }
        if (descriptor2 instanceof Navigatable && descriptor2.isValid()) {
            return (Navigatable)((Object)descriptor2);
        }
        PsiElement element = this.getElementFromDescriptor(descriptor2);
        if (element instanceof NavigatablePsiElement && element.isValid()) {
            return (NavigatablePsiElement)element;
        }
        return null;
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        JTree tree;
        if (dataId == null) {
            HierarchyBrowserBase.$$$reportNull$$$0(20);
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            return null;
        }
        if (PlatformDataKeys.TREE_EXPANDER.is(dataId) && (tree = this.getCurrentTree()) != null) {
            return new DefaultTreeExpander(tree);
        }
        if (PlatformCoreDataKeys.SELECTED_ITEMS.is(dataId)) {
            return this.getSelectedDescriptors();
        }
        if (PlatformCoreDataKeys.BGT_DATA_PROVIDER.is(dataId)) {
            DataProvider bgtProvider = (DataProvider)super.getData(PlatformCoreDataKeys.BGT_DATA_PROVIDER.getName());
            HierarchyNodeDescriptor[] descriptors = this.getSelectedDescriptors();
            return CompositeDataProvider.compose(slowId -> this.getSlowData(slowId, descriptors), (DataProvider)bgtProvider);
        }
        return super.getData(dataId);
    }

    @Nullable
    protected Object getSlowData(@NotNull String dataId, HierarchyNodeDescriptor @NotNull [] selection) {
        if (dataId == null) {
            HierarchyBrowserBase.$$$reportNull$$$0(21);
        }
        if (selection == null) {
            HierarchyBrowserBase.$$$reportNull$$$0(22);
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            PsiElement anElement = selection.length > 0 ? this.getElementFromDescriptor(selection[0]) : null;
            return anElement != null && anElement.isValid() ? anElement : null;
        }
        if (PlatformCoreDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
            return JBIterable.of(selection).filterMap(this::getElementFromDescriptor).toArray((PsiElement[])PsiElement.EMPTY_ARRAY);
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            HierarchyNodeDescriptor descriptor2;
            HierarchyNodeDescriptor hierarchyNodeDescriptor = descriptor2 = selection.length > 0 ? selection[0] : null;
            if (descriptor2 == null) {
                return null;
            }
            return this.getNavigatable(descriptor2);
        }
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            return JBIterable.of(selection).filterMap(this::getNavigatable).toArray((Navigatable[])Navigatable.EMPTY_NAVIGATABLE_ARRAY);
        }
        return null;
    }

    protected void configureTree(@NotNull Tree tree) {
        if (tree == null) {
            HierarchyBrowserBase.$$$reportNull$$$0(23);
        }
        tree.getSelectionModel().setSelectionMode(4);
        tree.setToggleClickCount(-1);
        tree.setCellRenderer((TreeCellRenderer)((Object)new HierarchyNodeRenderer()));
        new TreeSpeedSearch((JTree)tree);
        TreeUtil.installActions((JTree)tree);
        this.myAutoScrollToSourceHandler.install((JTree)tree);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 10, 11, 12, 15, 16, 17, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolbar";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpID";
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/hierarchy/HierarchyBrowserBase";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroup";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/hierarchy/HierarchyBrowserBase";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbar";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableElements";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedDescriptors";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setContent";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildUi";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createToolbar";
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "appendActions";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedElement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptor";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "collectElements";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getNavigatable";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getSlowData";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "configureTree";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 6, 10, 11, 12, 15, 16, 17, 18 -> new IllegalStateException(string2);
        };
    }

    private final class CloseAction
    extends CloseTabToolbarAction {
        private CloseAction() {
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                CloseAction.$$$reportNull$$$0(0);
            }
            Objects.requireNonNull(HierarchyBrowserBase.this.myContent.getManager()).removeContent(HierarchyBrowserBase.this.myContent, true);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CloseAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setVisible(HierarchyBrowserBase.this.myContent != null);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                CloseAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/hierarchy/HierarchyBrowserBase$CloseAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/hierarchy/HierarchyBrowserBase$CloseAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2 -> new IllegalStateException(string2);
            };
        }
    }
}

