/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.ide.OccurenceNavigatorSupport;
import com.intellij.ide.PsiCopyPasteManager;
import com.intellij.ide.dnd.DnDAction;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDSource;
import com.intellij.ide.dnd.TransferableWrapper;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.hierarchy.HierarchyBrowserBase;
import com.intellij.ide.hierarchy.HierarchyBrowserManager;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyProvider;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.ide.hierarchy.actions.BrowseHierarchyActionBase;
import com.intellij.ide.projectView.impl.ProjectViewTree;
import com.intellij.ide.util.scopeChooser.EditScopesDialog;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.TreeBuilderUtil;
import com.intellij.idea.ActionsBundle;
import com.intellij.lang.LangBundle;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.PlatformEditorBundle;
import com.intellij.openapi.fileEditor.PsiElementNavigatable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.pom.Navigatable;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.scope.ProjectProductionScope;
import com.intellij.psi.search.scope.TestsScope;
import com.intellij.psi.search.scope.packageSet.CustomScopesProviderEx;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.content.Content;
import com.intellij.ui.popup.HintUpdateSupply;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.usageView.UsageViewTypeLocation;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.SingleAlarm;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HierarchyBrowserBaseEx
extends HierarchyBrowserBase
implements OccurenceNavigator {
    private static final Logger LOG = Logger.getInstance(HierarchyBrowserBaseEx.class);
    public static final DataKey<HierarchyBrowserBaseEx> HIERARCHY_BROWSER = DataKey.create((String)"HIERARCHY_BROWSER");
    public static final String SCOPE_PROJECT = "Production";
    public static final String SCOPE_ALL = "All";
    public static final String SCOPE_CLASS = "This Class";
    public static final String SCOPE_MODULE = "This Module";
    public static final String SCOPE_TEST = "Test";
    public static final String HELP_ID = "reference.toolWindows.hierarchy";
    private final AtomicReference<Sheet> myCurrentSheet;
    private final Map<String, Supplier<@Nls String>> myI18nMap;
    private final Map<String, Sheet> myType2Sheet;
    private final RefreshAction myRefreshAction;
    private final SingleAlarm myCursorAlarm;
    private SmartPsiElementPointer<?> mySmartPsiElementPointer;
    private final CardLayout myCardLayout;
    private final JPanel myTreePanel;
    private boolean myCachedIsValidBase;

    public HierarchyBrowserBaseEx(@NotNull Project project2, @NotNull PsiElement element) {
        JPanel contentPanel;
        if (project2 == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(0);
        }
        if (element == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(1);
        }
        super(project2);
        this.myCurrentSheet = new AtomicReference();
        this.myType2Sheet = new HashMap<String, Sheet>();
        this.myRefreshAction = new RefreshAction();
        this.myCursorAlarm = new SingleAlarm(() -> this.setCursor(Cursor.getPredefinedCursor(3)), 100, (Disposable)this);
        this.setHierarchyBase(element);
        this.myCardLayout = new CardLayout();
        this.myTreePanel = new JPanel(this.myCardLayout);
        HashMap<@Nls K, V> type2treeMap = new HashMap();
        this.createTrees(type2treeMap);
        this.myI18nMap = this.getPresentableNameMap();
        HierarchyBrowserManager.State state = HierarchyBrowserManager.getSettings(project2);
        String scope = state.SCOPE == null ? SCOPE_ALL : state.SCOPE;
        for (Map.Entry entry : type2treeMap.entrySet()) {
            @Nls String type = (String)entry.getKey();
            JTree tree = (JTree)entry.getValue();
            OccurenceNavigatorSupport occurenceNavigatorSupport = new OccurenceNavigatorSupport(tree){

                @Nullable
                protected Navigatable createDescriptorForNode(@NotNull DefaultMutableTreeNode node2) {
                    PsiElement psiElement;
                    HierarchyNodeDescriptor descriptor2;
                    if (node2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((descriptor2 = HierarchyBrowserBase.getDescriptor(node2)) != null && (psiElement = HierarchyBrowserBaseEx.this.getOpenFileElementFromDescriptor(descriptor2)) != null && psiElement.isValid()) {
                        return new PsiElementNavigatable(psiElement);
                    }
                    return null;
                }

                @NotNull
                public String getNextOccurenceActionName() {
                    String string2 = HierarchyBrowserBaseEx.this.getNextOccurenceActionNameImpl();
                    if (string2 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return string2;
                }

                @NotNull
                public String getPreviousOccurenceActionName() {
                    String string2 = HierarchyBrowserBaseEx.this.getPrevOccurenceActionNameImpl();
                    if (string2 == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return string2;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1, 2 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "node";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/ide/hierarchy/HierarchyBrowserBaseEx$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/ide/hierarchy/HierarchyBrowserBaseEx$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getNextOccurenceActionName";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getPreviousOccurenceActionName";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "createDescriptorForNode";
                            break;
                        }
                        case 1: 
                        case 2: {
                            break;
                        }
                    }
                    String string2 = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string2);
                        case 1, 2 -> new IllegalStateException(string2);
                    };
                }
            };
            this.myType2Sheet.put(type, new Sheet(type, tree, scope, (OccurenceNavigator)occurenceNavigatorSupport));
            this.myTreePanel.add((Component)ScrollPaneFactory.createScrollPane((Component)tree), type);
        }
        JPanel legendPanel = this.createLegendPanel();
        if (legendPanel == null) {
            contentPanel = this.myTreePanel;
        } else {
            contentPanel = new JPanel(new BorderLayout());
            contentPanel.add((Component)this.myTreePanel, "Center");
            contentPanel.add((Component)legendPanel, "South");
        }
        this.buildUi(this.createToolbar(this.getActionPlace(), HELP_ID).getComponent(), contentPanel);
    }

    @Nullable
    protected PsiElement getOpenFileElementFromDescriptor(@NotNull HierarchyNodeDescriptor descriptor2) {
        if (descriptor2 == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(2);
        }
        return this.getElementFromDescriptor(descriptor2);
    }

    @Override
    @Nullable
    protected abstract PsiElement getElementFromDescriptor(@NotNull HierarchyNodeDescriptor var1);

    @NlsActions.ActionText
    @NotNull
    protected abstract String getPrevOccurenceActionNameImpl();

    @NlsActions.ActionText
    @NotNull
    protected abstract String getNextOccurenceActionNameImpl();

    protected abstract void createTrees(@NotNull Map<? super @Nls String, ? super JTree> var1);

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = this.getOccurrenceNavigator().getActionUpdateThread();
        if (actionUpdateThread == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(3);
        }
        return actionUpdateThread;
    }

    protected @NotNull Map<String, Supplier<@Nls String>> getPresentableNameMap() {
        HashMap<String, Supplier<String>> map2 = new HashMap<String, Supplier<String>>();
        map2.put(SCOPE_PROJECT, () -> ProjectProductionScope.INSTANCE.getPresentableName());
        map2.put(SCOPE_CLASS, () -> LangBundle.message("this.class.scope.name", new Object[0]));
        map2.put(SCOPE_MODULE, () -> LangBundle.message("this.module.scope.name", new Object[0]));
        map2.put(SCOPE_TEST, () -> TestsScope.INSTANCE.getPresentableName());
        map2.put(SCOPE_ALL, () -> CustomScopesProviderEx.getAllScope().getPresentableName());
        HashMap<String, Supplier<String>> hashMap = map2;
        if (hashMap == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(4);
        }
        return hashMap;
    }

    @Nullable
    protected abstract JPanel createLegendPanel();

    protected abstract boolean isApplicableElement(@NotNull PsiElement var1);

    protected boolean isApplicableElementForBaseOn(@NotNull PsiElement element) {
        if (element == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(5);
        }
        return this.isApplicableElement(element);
    }

    @Nullable
    protected abstract HierarchyTreeStructure createHierarchyTreeStructure(@NotNull String var1, @NotNull PsiElement var2);

    @Nullable
    protected abstract Comparator<NodeDescriptor<?>> getComparator();

    @NotNull
    protected abstract String getActionPlace();

    @Nullable
    protected Color getFileColorForNode(Object node2) {
        if (node2 instanceof HierarchyNodeDescriptor) {
            return ((HierarchyNodeDescriptor)((Object)node2)).getBackgroundColorCached();
        }
        return null;
    }

    @NotNull
    protected final JTree createTree(boolean dndAware) {
        Object tree;
        if (dndAware) {
            tree = new DnDAwareTree(){

                public void addNotify() {
                    super.addNotify();
                    HierarchyBrowserBaseEx.this.myRefreshAction.registerShortcutOn((JComponent)((Object)this));
                }

                public void removeNotify() {
                    super.removeNotify();
                    HierarchyBrowserBaseEx.this.myRefreshAction.unregisterCustomShortcutSet((JComponent)((Object)this));
                }

                public boolean isFileColorsEnabled() {
                    return ProjectViewTree.isFileColorsEnabledFor((JTree)((Object)this));
                }

                public Color getFileColorFor(Object object) {
                    return HierarchyBrowserBaseEx.this.getFileColorForNode(object);
                }
            };
            if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
                DnDManager.getInstance().registerSource(new DnDSource(){
                    final /* synthetic */ Tree val$tree;
                    {
                        this.val$tree = tree;
                    }

                    public boolean canStartDragging(DnDAction action2, @NotNull Point dragOrigin) {
                        if (dragOrigin == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        return HierarchyBrowserBaseEx.this.getSelectedElements().length > 0;
                    }

                    public DnDDragStartBean startDragging(DnDAction action2, @NotNull Point dragOrigin) {
                        if (dragOrigin == null) {
                            3.$$$reportNull$$$0(1);
                        }
                        return new DnDDragStartBean((Object)new TransferableWrapper(){

                            public TreeNode[] getTreeNodes() {
                                return (TreeNode[])val$tree.getSelectedNodes(TreeNode.class, null);
                            }

                            public PsiElement[] getPsiElements() {
                                return HierarchyBrowserBaseEx.this.getSelectedElements();
                            }

                            public List<File> asFileList() {
                                return PsiCopyPasteManager.asFileList(this.getPsiElements());
                            }
                        });
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        objectArray2[0] = "dragOrigin";
                        objectArray2[1] = "com/intellij/ide/hierarchy/HierarchyBrowserBaseEx$3";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "canStartDragging";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "startDragging";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                }, (JComponent)tree);
            }
        } else {
            tree = new Tree(){

                public void addNotify() {
                    super.addNotify();
                    HierarchyBrowserBaseEx.this.myRefreshAction.registerShortcutOn((JComponent)((Object)this));
                }

                public void removeNotify() {
                    super.removeNotify();
                    HierarchyBrowserBaseEx.this.myRefreshAction.unregisterCustomShortcutSet((JComponent)((Object)this));
                }

                public boolean isFileColorsEnabled() {
                    return ProjectViewTree.isFileColorsEnabledFor((JTree)((Object)this));
                }

                public Color getFileColorFor(Object object) {
                    return HierarchyBrowserBaseEx.this.getFileColorForNode(object);
                }
            };
        }
        HintUpdateSupply.installDataContextHintUpdateSupply((JComponent)tree);
        this.configureTree((Tree)tree);
        EditSourceOnDoubleClickHandler.install((JTree)tree);
        EditSourceOnEnterKeyHandler.install((JTree)tree);
        Object object = tree;
        if (object == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(6);
        }
        return object;
    }

    protected void setHierarchyBase(@NotNull PsiElement element) {
        if (element == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(7);
        }
        this.mySmartPsiElementPointer = SmartPointerManager.getInstance(this.myProject).createSmartPsiElementPointer(element);
    }

    protected PsiElement getHierarchyBase() {
        return this.mySmartPsiElementPointer.getElement();
    }

    private void restoreCursor() {
        this.myCursorAlarm.cancelAllRequests();
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void setWaitCursor() {
        this.myCursorAlarm.request();
    }

    public void changeView(@Nls @NotNull String typeName) {
        if (typeName == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(8);
        }
        this.changeView(typeName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeView(@Nls @NotNull String typeName, boolean requestFocus) {
        Supplier supplier2;
        String displayName;
        if (typeName == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(9);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Sheet sheet = this.myType2Sheet.get(typeName);
        this.myCurrentSheet.set(sheet);
        Object element = this.mySmartPsiElementPointer.getElement();
        if (element == null || !this.isApplicableElement((PsiElement)element)) {
            return;
        }
        if (this.myContent != null && (displayName = this.getContentDisplayName((String)(supplier2 = this.myI18nMap.computeIfAbsent(typeName, __ -> () -> typeName)).get(), (PsiElement)element)) != null) {
            this.myContent.setDisplayName(displayName);
        }
        this.myCardLayout.show(this.myTreePanel, typeName);
        if (sheet.myStructureTreeModel == null) {
            try {
                this.setWaitCursor();
                JTree tree = sheet.myTree;
                HierarchyTreeStructure structure = this.createHierarchyTreeStructure(typeName, (PsiElement)element);
                if (structure == null) {
                    return;
                }
                StructureTreeModel myModel = new StructureTreeModel((AbstractTreeStructure)structure, this.getComparator(), (Disposable)sheet);
                AsyncTreeModel atm = new AsyncTreeModel((TreeModel)myModel, (Disposable)sheet);
                tree.setModel((TreeModel)atm);
                sheet.myStructureTreeModel = myModel;
                sheet.myAsyncTreeModel = atm;
                this.selectLater(tree, structure.getBaseDescriptor());
                this.expandLater(tree, structure.getBaseDescriptor());
            }
            finally {
                this.restoreCursor();
            }
        }
        if (requestFocus) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.getCurrentTree(), true));
        }
    }

    private static boolean isAncestor(@NotNull Project project2, @NotNull HierarchyNodeDescriptor ancestor, @NotNull HierarchyNodeDescriptor child) {
        if (project2 == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(10);
        }
        if (ancestor == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(11);
        }
        if (child == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(12);
        }
        PsiElement ancestorElement = ancestor.getPsiElement();
        while (child != null) {
            PsiElement childElement = child.getPsiElement();
            if (PsiManager.getInstance(project2).areElementsEquivalent(ancestorElement, childElement)) {
                return true;
            }
            child = (HierarchyNodeDescriptor)child.getParentDescriptor();
        }
        return false;
    }

    private void selectLater(@NotNull JTree tree, @NotNull HierarchyNodeDescriptor descriptor2) {
        if (tree == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(13);
        }
        if (descriptor2 == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(14);
        }
        TreeUtil.promiseSelect((JTree)tree, (TreeVisitor)this.visitor(descriptor2));
    }

    private void selectLater(@NotNull JTree tree, @NotNull List<? extends HierarchyNodeDescriptor> descriptors) {
        if (tree == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(15);
        }
        if (descriptors == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(16);
        }
        TreeUtil.promiseSelect((JTree)tree, descriptors.stream().map(descriptor2 -> this.visitor((HierarchyNodeDescriptor)((Object)descriptor2))));
    }

    private void expandLater(@NotNull JTree tree, @NotNull HierarchyNodeDescriptor descriptor2) {
        if (tree == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(17);
        }
        if (descriptor2 == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(18);
        }
        TreeUtil.promiseExpand((JTree)tree, (TreeVisitor)this.visitor(descriptor2));
    }

    @NotNull
    private TreeVisitor visitor(@NotNull HierarchyNodeDescriptor descriptor2) {
        PsiElement element;
        if (descriptor2 == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(19);
        }
        if ((element = descriptor2.getPsiElement()) == null) {
            TreeVisitor treeVisitor = path2 -> TreeVisitor.Action.INTERRUPT;
            if (treeVisitor == null) {
                HierarchyBrowserBaseEx.$$$reportNull$$$0(20);
            }
            return treeVisitor;
        }
        PsiManager psiManager = element.getManager();
        TreeVisitor treeVisitor = path2 -> {
            Object component2 = path2.getLastPathComponent();
            DefaultMutableTreeNode node2 = (DefaultMutableTreeNode)component2;
            Object object = node2.getUserObject();
            HierarchyNodeDescriptor current = (HierarchyNodeDescriptor)((Object)((Object)object));
            PsiElement currentPsiElement = current.getPsiElement();
            if (psiManager.areElementsEquivalent(currentPsiElement, element)) {
                return TreeVisitor.Action.INTERRUPT;
            }
            return HierarchyBrowserBaseEx.isAncestor(this.myProject, current, descriptor2) ? TreeVisitor.Action.CONTINUE : TreeVisitor.Action.SKIP_CHILDREN;
        };
        if (treeVisitor == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(21);
        }
        return treeVisitor;
    }

    @Nullable
    @NlsContexts.TabTitle
    protected String getContentDisplayName(@Nls @NotNull String typeName, @NotNull PsiElement element) {
        if (typeName == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(22);
        }
        if (element == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(23);
        }
        if (element instanceof PsiNamedElement) {
            return MessageFormat.format(typeName, ((PsiNamedElement)element).getName());
        }
        return null;
    }

    @Override
    protected void appendActions(@NotNull DefaultActionGroup actionGroup2, @Nullable String helpID) {
        if (actionGroup2 == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(24);
        }
        this.prependActions(actionGroup2);
        actionGroup2.add((AnAction)this.myRefreshAction);
        super.appendActions(actionGroup2, helpID);
    }

    protected void prependActions(@NotNull DefaultActionGroup actionGroup2) {
        if (actionGroup2 == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(25);
        }
    }

    public boolean hasNextOccurence() {
        return this.getOccurrenceNavigator().hasNextOccurence();
    }

    @NotNull
    private OccurenceNavigator getOccurrenceNavigator() {
        Sheet sheet = this.myCurrentSheet.get();
        OccurenceNavigator navigator = sheet == null ? null : sheet.myOccurenceNavigator;
        OccurenceNavigator occurenceNavigator = navigator == null ? EMPTY : navigator;
        if (occurenceNavigator == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(26);
        }
        return occurenceNavigator;
    }

    public boolean hasPreviousOccurence() {
        return this.getOccurrenceNavigator().hasPreviousOccurence();
    }

    public OccurenceNavigator.OccurenceInfo goNextOccurence() {
        return this.getOccurrenceNavigator().goNextOccurence();
    }

    public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
        return this.getOccurrenceNavigator().goPreviousOccurence();
    }

    @NotNull
    public String getNextOccurenceActionName() {
        String string2 = this.getOccurrenceNavigator().getNextOccurenceActionName();
        if (string2 == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(27);
        }
        return string2;
    }

    @NotNull
    public String getPreviousOccurenceActionName() {
        String string2 = this.getOccurrenceNavigator().getPreviousOccurenceActionName();
        if (string2 == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(28);
        }
        return string2;
    }

    @NotNull
    public StructureTreeModel<?> getTreeModel(@NotNull String viewType) {
        if (viewType == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(29);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        StructureTreeModel<HierarchyTreeStructure> structureTreeModel = this.myType2Sheet.get((Object)viewType).myStructureTreeModel;
        if (structureTreeModel == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(30);
        }
        return structureTreeModel;
    }

    @Override
    public void setContent(@NotNull Content content2) {
        if (content2 == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(31);
        }
        super.setContent(content2);
        Disposer.register((Disposable)content2, this::disposeAllSheets);
    }

    StructureTreeModel<?> getCurrentBuilder() {
        String viewType = this.getCurrentViewType();
        if (viewType == null) {
            return null;
        }
        Sheet sheet = this.myType2Sheet.get(viewType);
        return sheet == null ? null : sheet.myStructureTreeModel;
    }

    final boolean isValidBase() {
        if (this.myProject.isDisposed()) {
            return false;
        }
        if (PsiDocumentManager.getInstance(this.myProject).getUncommittedDocuments().length > 0) {
            return this.myCachedIsValidBase;
        }
        Object element = this.mySmartPsiElementPointer.getElement();
        this.myCachedIsValidBase = element != null && this.isApplicableElement((PsiElement)element) && element.isValid();
        return this.myCachedIsValidBase;
    }

    @Override
    protected JTree getCurrentTree() {
        @Nls String currentViewType = this.getCurrentViewType();
        return currentViewType == null ? null : this.myType2Sheet.get((Object)currentViewType).myTree;
    }

    @Nls
    protected final String getCurrentViewType() {
        Sheet sheet = this.myCurrentSheet.get();
        return sheet == null ? null : sheet.myType;
    }

    @Override
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(32);
        }
        if (HIERARCHY_BROWSER.is(dataId)) {
            return this;
        }
        if (PlatformCoreDataKeys.HELP_ID.is(dataId)) {
            return HELP_ID;
        }
        return super.getData(dataId);
    }

    @Override
    public void dispose() {
        this.disposeAllSheets();
        super.dispose();
    }

    private void disposeAllSheets() {
        for (Sheet sheet : this.myType2Sheet.values()) {
            this.disposeSheet(sheet);
        }
    }

    private void disposeSheet(@NotNull Sheet sheet) {
        if (sheet == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(33);
        }
        Disposer.dispose(sheet);
        this.myType2Sheet.put(sheet.myType, new Sheet(sheet.myType, sheet.myTree, sheet.myScope, sheet.myOccurenceNavigator));
    }

    protected void doRefresh(boolean currentBuilderOnly) {
        Object element;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (currentBuilderOnly) {
            LOG.assertTrue(this.getCurrentViewType() != null);
        }
        if (!this.isValidBase() || this.isDisposed()) {
            return;
        }
        if (this.getCurrentBuilder() == null) {
            return;
        }
        @Nls String currentViewType = this.getCurrentViewType();
        ArrayList pathsToExpand = new ArrayList();
        ArrayList selectionPaths = new ArrayList();
        if (currentViewType != null) {
            Sheet sheet = this.myType2Sheet.get(currentViewType);
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)sheet.myAsyncTreeModel.getRoot();
            TreeBuilderUtil.storePaths((JTree)sheet.myTree, (DefaultMutableTreeNode)root, pathsToExpand, selectionPaths, (boolean)true);
        }
        if ((element = this.mySmartPsiElementPointer.getElement()) == null || !this.isApplicableElement((PsiElement)element)) {
            return;
        }
        if (currentBuilderOnly) {
            Sheet sheet = this.myType2Sheet.get(currentViewType);
            this.disposeSheet(sheet);
        } else {
            this.disposeAllSheets();
        }
        this.setHierarchyBase((PsiElement)element);
        this.validate();
        ApplicationManager.getApplication().invokeLater(() -> {
            this.changeView(currentViewType);
            for (Object p : pathsToExpand) {
                this.expandLater(this.getCurrentTree(), (HierarchyNodeDescriptor)((Object)((Object)p)));
            }
            this.selectLater(this.getCurrentTree(), selectionPaths);
        }, __ -> this.isDisposed());
    }

    protected String getCurrentScopeType() {
        String currentViewType = this.getCurrentViewType();
        return currentViewType == null ? null : this.myType2Sheet.get((Object)currentViewType).myScope;
    }

    private List<NamedScope> getValidScopes() {
        NamedScopesHolder[] holders;
        ArrayList<NamedScope> result2 = new ArrayList<NamedScope>();
        result2.add(ProjectProductionScope.INSTANCE);
        result2.add(TestsScope.INSTANCE);
        result2.add(CustomScopesProviderEx.getAllScope());
        result2.add(new NamedScope(SCOPE_CLASS, () -> LangBundle.message("this.class.scope.name", new Object[0]), AllIcons.Ide.LocalScope, null));
        result2.add(new NamedScope(SCOPE_MODULE, () -> LangBundle.message("this.module.scope.name", new Object[0]), AllIcons.Ide.LocalScope, null));
        for (NamedScopesHolder holder : holders = NamedScopesHolder.getAllNamedScopeHolders(this.myProject)) {
            NamedScope[] scopes = holder.getEditableScopes();
            Collections.addAll(result2, scopes);
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 6, 20, 21, 26, 27, 28, 30 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 14: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 20: 
            case 21: 
            case 26: 
            case 27: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/hierarchy/HierarchyBrowserBaseEx";
                break;
            }
            case 8: 
            case 9: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroup";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewType";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sheet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/hierarchy/HierarchyBrowserBaseEx";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableNameMap";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createTree";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "visitor";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getOccurrenceNavigator";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextOccurenceActionName";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreviousOccurenceActionName";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getOpenFileElementFromDescriptor";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 20: 
            case 21: 
            case 26: 
            case 27: 
            case 28: 
            case 30: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableElementForBaseOn";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setHierarchyBase";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "changeView";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isAncestor";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "selectLater";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "expandLater";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "visitor";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getContentDisplayName";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "appendActions";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "prependActions";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getTreeModel";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "setContent";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "disposeSheet";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 4, 6, 20, 21, 26, 27, 28, 30 -> new IllegalStateException(string2);
        };
    }

    private class RefreshAction
    extends com.intellij.ide.actions.RefreshAction {
        RefreshAction() {
            super(IdeBundle.messagePointer((String)"action.refresh", (Object[])new Object[0]), IdeBundle.messagePointer((String)"action.refresh", (Object[])new Object[0]), AllIcons.Actions.Refresh);
        }

        public final void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                RefreshAction.$$$reportNull$$$0(0);
            }
            HierarchyBrowserBaseEx.this.doRefresh(false);
        }

        public final void update(@NotNull AnActionEvent event) {
            if (event == null) {
                RefreshAction.$$$reportNull$$$0(1);
            }
            Presentation presentation2 = event.getPresentation();
            presentation2.setEnabled(HierarchyBrowserBaseEx.this.isValidBase());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/hierarchy/HierarchyBrowserBaseEx$RefreshAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class Sheet
    implements Disposable {
        private AsyncTreeModel myAsyncTreeModel;
        private StructureTreeModel<HierarchyTreeStructure> myStructureTreeModel;
        @Nls
        @NotNull
        private final String myType;
        private final JTree myTree;
        private String myScope;
        private final OccurenceNavigator myOccurenceNavigator;

        Sheet(@Nls @NotNull String type, @NotNull JTree tree, @NotNull String scope, @NotNull OccurenceNavigator occurenceNavigator) {
            if (type == null) {
                Sheet.$$$reportNull$$$0(0);
            }
            if (tree == null) {
                Sheet.$$$reportNull$$$0(1);
            }
            if (scope == null) {
                Sheet.$$$reportNull$$$0(2);
            }
            if (occurenceNavigator == null) {
                Sheet.$$$reportNull$$$0(3);
            }
            this.myType = type;
            this.myTree = tree;
            this.myScope = scope;
            this.myOccurenceNavigator = occurenceNavigator;
        }

        @Override
        public void dispose() {
            this.myAsyncTreeModel = null;
            this.myStructureTreeModel = null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tree";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "scope";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "occurenceNavigator";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ide/hierarchy/HierarchyBrowserBaseEx$Sheet";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public class ChangeScopeAction
    extends ComboBoxAction {
        public final void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ChangeScopeAction.$$$reportNull$$$0(0);
            }
            Presentation presentation2 = e.getPresentation();
            Project project2 = e.getProject();
            if (project2 == null) {
                return;
            }
            presentation2.setEnabled(this.isEnabled());
            String scopeType = HierarchyBrowserBaseEx.this.getCurrentScopeType();
            presentation2.setText(HierarchyBrowserBaseEx.this.myI18nMap.getOrDefault(scopeType, () -> scopeType));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                ChangeScopeAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        protected boolean isEnabled() {
            return true;
        }

        @NotNull
        protected final DefaultActionGroup createPopupActionGroup(@NotNull JComponent button2, @NotNull DataContext context2) {
            if (button2 == null) {
                ChangeScopeAction.$$$reportNull$$$0(2);
            }
            if (context2 == null) {
                ChangeScopeAction.$$$reportNull$$$0(3);
            }
            DefaultActionGroup group2 = new DefaultActionGroup();
            for (NamedScope namedScope : HierarchyBrowserBaseEx.this.getValidScopes()) {
                group2.add((AnAction)new MenuAction(namedScope));
            }
            group2.add((AnAction)new ConfigureScopesAction());
            DefaultActionGroup defaultActionGroup = group2;
            if (defaultActionGroup == null) {
                ChangeScopeAction.$$$reportNull$$$0(4);
            }
            return defaultActionGroup;
        }

        private void selectScope(@NotNull String scopeType) {
            if (scopeType == null) {
                ChangeScopeAction.$$$reportNull$$$0(5);
            }
            HierarchyBrowserBaseEx.this.myType2Sheet.get((Object)HierarchyBrowserBaseEx.this.getCurrentViewType()).myScope = scopeType;
            HierarchyBrowserManager.getSettings((Project)HierarchyBrowserBaseEx.this.myProject).SCOPE = scopeType;
            ApplicationManager.getApplication().invokeLater(() -> HierarchyBrowserBaseEx.this.doRefresh(true), __ -> HierarchyBrowserBaseEx.this.isDisposed());
        }

        @NotNull
        public final JComponent createCustomComponent(@NotNull Presentation presentation2, @NotNull String place) {
            if (presentation2 == null) {
                ChangeScopeAction.$$$reportNull$$$0(6);
            }
            if (place == null) {
                ChangeScopeAction.$$$reportNull$$$0(7);
            }
            JPanel panel2 = new JPanel(new GridBagLayout());
            panel2.add((Component)new JLabel(IdeBundle.message((String)"label.scope", (Object[])new Object[0])), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, JBUI.insetsLeft(5), 0, 0));
            panel2.add((Component)super.createCustomComponent(presentation2, place), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 1, JBInsets.emptyInsets(), 0, 0));
            if (ExperimentalUI.isNewUI()) {
                UIUtil.setBackgroundRecursively(panel2, JBUI.CurrentTheme.ToolWindow.background());
            }
            JPanel jPanel = panel2;
            if (jPanel == null) {
                ChangeScopeAction.$$$reportNull$$$0(8);
            }
            return jPanel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 4, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: 
                case 4: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/hierarchy/HierarchyBrowserBaseEx$ChangeScopeAction";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "button";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scopeType";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/hierarchy/HierarchyBrowserBaseEx$ChangeScopeAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPopupActionGroup";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createCustomComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: 
                case 4: 
                case 8: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createPopupActionGroup";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "selectScope";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "createCustomComponent";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1, 4, 8 -> new IllegalStateException(string2);
            };
        }

        private final class MenuAction
        extends AnAction {
            private final String myScopeType;

            MenuAction(NamedScope namedScope) {
                super(namedScope.getPresentableName());
                this.myScopeType = namedScope.getScopeId();
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    MenuAction.$$$reportNull$$$0(0);
                }
                ChangeScopeAction.this.selectScope(this.myScopeType);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/hierarchy/HierarchyBrowserBaseEx$ChangeScopeAction$MenuAction", "actionPerformed"));
            }
        }

        private final class ConfigureScopesAction
        extends AnAction {
            private ConfigureScopesAction() {
                super(ActionsBundle.messagePointer((String)"action.ConfigureScopesAction.text", (Object[])new Object[0]));
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    ConfigureScopesAction.$$$reportNull$$$0(0);
                }
                EditScopesDialog.showDialog(HierarchyBrowserBaseEx.this.myProject, null);
                if (HierarchyBrowserBaseEx.this.getValidScopes().stream().anyMatch(scope -> scope.getScopeId().equals(HierarchyBrowserBaseEx.this.getCurrentScopeType()))) {
                    ChangeScopeAction.this.selectScope(HierarchyBrowserBaseEx.SCOPE_ALL);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/hierarchy/HierarchyBrowserBaseEx$ChangeScopeAction$ConfigureScopesAction", "actionPerformed"));
            }
        }
    }

    protected static class BaseOnThisElementAction
    extends AnAction {
        private final LanguageExtension<HierarchyProvider> myProviderLanguageExtension;

        protected BaseOnThisElementAction(@NotNull Supplier<String> text2, @NotNull LanguageExtension<HierarchyProvider> providerLanguageExtension) {
            if (text2 == null) {
                BaseOnThisElementAction.$$$reportNull$$$0(0);
            }
            if (providerLanguageExtension == null) {
                BaseOnThisElementAction.$$$reportNull$$$0(1);
            }
            super(text2);
            this.myProviderLanguageExtension = providerLanguageExtension;
        }

        public final void actionPerformed(@NotNull AnActionEvent event) {
            HierarchyBrowserBaseEx browser;
            if (event == null) {
                BaseOnThisElementAction.$$$reportNull$$$0(2);
            }
            if ((browser = (HierarchyBrowserBaseEx)event.getData(HIERARCHY_BROWSER)) == null) {
                return;
            }
            PsiElement selectedElement = browser.getSelectedElement(event.getDataContext());
            if (selectedElement == null || !browser.isApplicableElementForBaseOn(selectedElement)) {
                return;
            }
            @Nls String currentViewType = browser.getCurrentViewType();
            Disposer.dispose(browser);
            HierarchyProvider provider2 = BrowseHierarchyActionBase.findProvider(this.myProviderLanguageExtension, selectedElement, selectedElement.getContainingFile(), event.getDataContext());
            if (provider2 != null) {
                HierarchyBrowserBaseEx newBrowser = (HierarchyBrowserBaseEx)BrowseHierarchyActionBase.createAndAddToPanel(selectedElement.getProject(), provider2, selectedElement);
                ApplicationManager.getApplication().invokeLater(() -> newBrowser.changeView(this.correctViewType(browser, currentViewType)), __ -> newBrowser.isDisposed());
            }
        }

        @Nls
        protected String correctViewType(@NotNull HierarchyBrowserBaseEx browser, @Nls String viewType) {
            if (browser == null) {
                BaseOnThisElementAction.$$$reportNull$$$0(3);
            }
            return viewType;
        }

        public final void update(@NotNull AnActionEvent event) {
            if (event == null) {
                BaseOnThisElementAction.$$$reportNull$$$0(4);
            }
            Presentation presentation2 = event.getPresentation();
            HierarchyBrowserBaseEx browser = (HierarchyBrowserBaseEx)event.getData(HIERARCHY_BROWSER);
            if (browser == null) {
                presentation2.setEnabledAndVisible(false);
                return;
            }
            presentation2.setVisible(true);
            PsiElement selectedElement = browser.getSelectedElement(event.getDataContext());
            if (selectedElement == null || !browser.isApplicableElementForBaseOn(selectedElement)) {
                presentation2.setEnabledAndVisible(false);
            } else {
                String typeName = ElementDescriptionUtil.getElementDescription(selectedElement, (ElementDescriptionLocation)UsageViewTypeLocation.INSTANCE);
                if (StringUtil.isNotEmpty(typeName)) {
                    presentation2.setText(IdeBundle.messagePointer((String)"action.base.on.this.0", (Object[])new Object[]{StringUtil.capitalize(typeName)}));
                }
                presentation2.setEnabled(this.isEnabled(browser, selectedElement));
            }
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                BaseOnThisElementAction.$$$reportNull$$$0(5);
            }
            return actionUpdateThread;
        }

        protected boolean isEnabled(@NotNull HierarchyBrowserBaseEx browser, @NotNull PsiElement element) {
            if (browser == null) {
                BaseOnThisElementAction.$$$reportNull$$$0(6);
            }
            if (element == null) {
                BaseOnThisElementAction.$$$reportNull$$$0(7);
            }
            return !element.equals(browser.mySmartPsiElementPointer.getElement()) && element.isValid();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "providerLanguageExtension";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "browser";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/hierarchy/HierarchyBrowserBaseEx$BaseOnThisElementAction";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/hierarchy/HierarchyBrowserBaseEx$BaseOnThisElementAction";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "correctViewType";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 5: {
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "isEnabled";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 5 -> new IllegalStateException(string2);
            };
        }
    }

    protected class AlphaSortAction
    extends ToggleAction {
        public AlphaSortAction() {
            super(PlatformEditorBundle.messagePointer((String)"action.sort.alphabetically", (Object[])new Object[0]), PlatformEditorBundle.messagePointer((String)"action.sort.alphabetically", (Object[])new Object[0]), AllIcons.ObjectBrowser.Sorted);
        }

        public final boolean isSelected(@NotNull AnActionEvent event) {
            if (event == null) {
                AlphaSortAction.$$$reportNull$$$0(0);
            }
            return HierarchyBrowserManager.getSettings((Project)HierarchyBrowserBaseEx.this.myProject).SORT_ALPHABETICALLY;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                AlphaSortAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public final void setSelected(@NotNull AnActionEvent event, boolean flag2) {
            if (event == null) {
                AlphaSortAction.$$$reportNull$$$0(2);
            }
            HierarchyBrowserManager.getSettings((Project)HierarchyBrowserBaseEx.this.myProject).SORT_ALPHABETICALLY = flag2;
            Comparator<NodeDescriptor<?>> comparator = HierarchyBrowserBaseEx.this.getComparator();
            HierarchyBrowserBaseEx.this.myType2Sheet.values().stream().map(s -> s.myStructureTreeModel).filter(m -> m != null).forEach(m -> m.setComparator(comparator));
        }

        public final void update(@NotNull AnActionEvent event) {
            if (event == null) {
                AlphaSortAction.$$$reportNull$$$0(3);
            }
            super.update(event);
            Presentation presentation2 = event.getPresentation();
            presentation2.setEnabled(HierarchyBrowserBaseEx.this.isValidBase());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/hierarchy/HierarchyBrowserBaseEx$AlphaSortAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/hierarchy/HierarchyBrowserBaseEx$AlphaSortAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1 -> new IllegalStateException(string2);
            };
        }
    }
}

