/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.impl.ProjectViewTree;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.SmartElementDescriptor;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.LayeredIcon;
import com.intellij.usageView.UsageTreeColors;
import java.awt.Color;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HierarchyNodeDescriptor
extends SmartElementDescriptor {
    public static final HierarchyNodeDescriptor[] EMPTY_ARRAY = new HierarchyNodeDescriptor[0];
    @NotNull
    protected CompositeAppearance myHighlightedText;
    private Object[] myCachedChildren;
    protected final boolean myIsBase;
    private Color myBackgroundColor;

    protected HierarchyNodeDescriptor(@NotNull Project project2, @Nullable NodeDescriptor parentDescriptor, @NotNull PsiElement element, boolean isBase) {
        if (project2 == null) {
            HierarchyNodeDescriptor.$$$reportNull$$$0(0);
        }
        if (element == null) {
            HierarchyNodeDescriptor.$$$reportNull$$$0(1);
        }
        super(project2, parentDescriptor, element);
        this.myHighlightedText = new CompositeAppearance();
        this.myName = "";
        this.myIsBase = isBase;
    }

    @Override
    public final Object getElement() {
        return this;
    }

    @Nullable
    public PsiFile getContainingFile() {
        PsiElement element = this.getPsiElement();
        return element != null ? element.getContainingFile() : null;
    }

    public boolean isValid() {
        return this.getPsiElement() != null;
    }

    public final Object[] getCachedChildren() {
        return this.myCachedChildren;
    }

    public final void setCachedChildren(Object[] cachedChildren) {
        this.myCachedChildren = cachedChildren;
    }

    @Nullable
    public final Color getBackgroundColorCached() {
        return this.myBackgroundColor;
    }

    @Override
    public boolean update() {
        boolean changed2 = super.update();
        this.myBackgroundColor = ProjectViewTree.getColorForElement(this.getContainingFile());
        return changed2;
    }

    @Override
    protected final boolean isMarkReadOnly() {
        return true;
    }

    @Override
    protected final boolean isMarkModified() {
        return true;
    }

    @NotNull
    public final CompositeAppearance getHighlightedText() {
        CompositeAppearance compositeAppearance = this.myHighlightedText;
        if (compositeAppearance == null) {
            HierarchyNodeDescriptor.$$$reportNull$$$0(2);
        }
        return compositeAppearance;
    }

    protected static TextAttributes getInvalidPrefixAttributes() {
        return UsageTreeColors.INVALID_ATTRIBUTES.toTextAttributes();
    }

    protected static TextAttributes getUsageCountPrefixAttributes() {
        return UsageTreeColors.NUMBER_OF_USAGES_ATTRIBUTES.toTextAttributes();
    }

    protected static TextAttributes getPackageNameAttributes() {
        return HierarchyNodeDescriptor.getUsageCountPrefixAttributes();
    }

    public boolean expandOnDoubleClick() {
        return false;
    }

    protected final boolean invalidElement() {
        String invalidPrefix = IdeBundle.message((String)"node.hierarchy.invalid", (Object[])new Object[0]);
        if (!this.myHighlightedText.getText().startsWith(invalidPrefix)) {
            this.myHighlightedText.getBeginning().addText(invalidPrefix, HierarchyNodeDescriptor.getInvalidPrefixAttributes());
        }
        return true;
    }

    protected final void installIcon(@Nullable Icon elementIcon, boolean changes) {
        if (changes && this.myIsBase) {
            this.setIcon(this.getBaseMarkerIcon(elementIcon));
        } else {
            this.setIcon(elementIcon);
        }
    }

    @NotNull
    protected Icon getBaseMarkerIcon(@Nullable Icon sourceIcon) {
        LayeredIcon icon2 = new LayeredIcon(2);
        icon2.setIcon(sourceIcon, 0);
        icon2.setIcon(AllIcons.General.Modified, 1, -AllIcons.General.Modified.getIconWidth(), 0);
        LayeredIcon layeredIcon = icon2;
        if (layeredIcon == null) {
            HierarchyNodeDescriptor.$$$reportNull$$$0(3);
        }
        return layeredIcon;
    }

    protected final void installIcon(@NotNull PsiElement element, boolean changes) {
        if (element == null) {
            HierarchyNodeDescriptor.$$$reportNull$$$0(4);
        }
        Icon icon2 = this.getIcon(element);
        this.installIcon(icon2, changes);
    }

    protected final void installIcon(boolean changes) {
        this.installIcon(this.getIcon(), changes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/hierarchy/HierarchyNodeDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/hierarchy/HierarchyNodeDescriptor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightedText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseMarkerIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "installIcon";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3 -> new IllegalStateException(string2);
        };
    }
}

