/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy;

import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.AbstractTreeUi;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.tree.LeafState;
import com.intellij.usageView.UsageViewLongNameLocation;
import com.intellij.usageView.UsageViewTypeLocation;
import com.intellij.util.ArrayUtilRt;
import org.jetbrains.annotations.NotNull;

public abstract class HierarchyTreeStructure
extends AbstractTreeStructure {
    protected HierarchyNodeDescriptor myBaseDescriptor;
    private HierarchyNodeDescriptor myRoot;
    @NotNull
    protected final Project myProject;

    protected HierarchyTreeStructure(@NotNull Project project2, HierarchyNodeDescriptor baseDescriptor) {
        if (project2 == null) {
            HierarchyTreeStructure.$$$reportNull$$$0(0);
        }
        this.myBaseDescriptor = baseDescriptor;
        this.myProject = project2;
        this.myRoot = baseDescriptor;
    }

    public final HierarchyNodeDescriptor getBaseDescriptor() {
        return this.myBaseDescriptor;
    }

    protected final void setBaseElement(@NotNull HierarchyNodeDescriptor baseElement) {
        if (baseElement == null) {
            HierarchyTreeStructure.$$$reportNull$$$0(1);
        }
        this.myBaseDescriptor = baseElement;
        this.myRoot = baseElement;
        while (this.myRoot.getParentDescriptor() != null) {
            this.myRoot = (HierarchyNodeDescriptor)this.myRoot.getParentDescriptor();
        }
    }

    @NotNull
    public final NodeDescriptor createDescriptor(@NotNull Object element, NodeDescriptor parentDescriptor) {
        if (element == null) {
            HierarchyTreeStructure.$$$reportNull$$$0(2);
        }
        if (element instanceof HierarchyNodeDescriptor) {
            HierarchyNodeDescriptor hierarchyNodeDescriptor = (HierarchyNodeDescriptor)((Object)element);
            if (hierarchyNodeDescriptor == null) {
                HierarchyTreeStructure.$$$reportNull$$$0(3);
            }
            return hierarchyNodeDescriptor;
        }
        if (element instanceof String) {
            return new TextInfoNodeDescriptor(parentDescriptor, (String)element, this.myProject);
        }
        throw new IllegalArgumentException("Unknown element type: " + element);
    }

    public final boolean isToBuildChildrenInBackground(@NotNull Object element) {
        if (element == null) {
            HierarchyTreeStructure.$$$reportNull$$$0(4);
        }
        if (element instanceof HierarchyNodeDescriptor) {
            HierarchyNodeDescriptor descriptor2 = (HierarchyNodeDescriptor)((Object)element);
            Object[] cachedChildren = descriptor2.getCachedChildren();
            return cachedChildren == null && descriptor2.isValid();
        }
        return false;
    }

    public final Object @NotNull [] getChildElements(@NotNull Object element) {
        if (element == null) {
            HierarchyTreeStructure.$$$reportNull$$$0(5);
        }
        if (element instanceof HierarchyNodeDescriptor) {
            HierarchyNodeDescriptor descriptor2 = (HierarchyNodeDescriptor)((Object)element);
            Object[] cachedChildren = descriptor2.getCachedChildren();
            if (cachedChildren == null) {
                if (descriptor2.isValid()) {
                    try {
                        cachedChildren = (Object[])AbstractTreeUi.calculateYieldingToWriteAction(() -> this.buildChildren(descriptor2));
                    }
                    catch (IndexNotReadyException e) {
                        if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                            HierarchyTreeStructure.$$$reportNull$$$0(6);
                        }
                        return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
                    }
                } else {
                    cachedChildren = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
                }
                descriptor2.setCachedChildren(cachedChildren);
            }
            if (cachedChildren == null) {
                HierarchyTreeStructure.$$$reportNull$$$0(7);
            }
            return cachedChildren;
        }
        if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
            HierarchyTreeStructure.$$$reportNull$$$0(8);
        }
        return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    public final Object getParentElement(@NotNull Object element) {
        if (element == null) {
            HierarchyTreeStructure.$$$reportNull$$$0(9);
        }
        if (element instanceof HierarchyNodeDescriptor) {
            return ((HierarchyNodeDescriptor)((Object)element)).getParentDescriptor();
        }
        return null;
    }

    public final void commit() {
        PsiDocumentManager.getInstance(this.myProject).commitAllDocuments();
    }

    public final boolean hasSomethingToCommit() {
        return PsiDocumentManager.getInstance(this.myProject).hasUncommitedDocuments();
    }

    @NotNull
    public ActionCallback asyncCommit() {
        ActionCallback actionCallback = HierarchyTreeStructure.asyncCommitDocuments((Project)this.myProject);
        if (actionCallback == null) {
            HierarchyTreeStructure.$$$reportNull$$$0(10);
        }
        return actionCallback;
    }

    protected abstract Object @NotNull [] buildChildren(@NotNull HierarchyNodeDescriptor var1);

    @NotNull
    public final Object getRootElement() {
        HierarchyNodeDescriptor hierarchyNodeDescriptor = this.myRoot;
        if (hierarchyNodeDescriptor == null) {
            HierarchyTreeStructure.$$$reportNull$$$0(11);
        }
        return hierarchyNodeDescriptor;
    }

    protected SearchScope getSearchScope(String scopeType, PsiElement thisClass) {
        SearchScope searchScope2 = GlobalSearchScope.allScope(this.myProject);
        if ("This Class".equals(scopeType)) {
            searchScope2 = new LocalSearchScope(thisClass);
        } else if ("This Module".equals(scopeType)) {
            Module module2 = ModuleUtilCore.findModuleForPsiElement(thisClass);
            searchScope2 = module2 == null ? new LocalSearchScope(thisClass) : module2.getModuleScope(true);
        } else if ("Production".equals(scopeType)) {
            searchScope2 = GlobalSearchScopesCore.projectProductionScope(this.myProject);
        } else if ("Test".equals(scopeType)) {
            searchScope2 = GlobalSearchScopesCore.projectTestScope(this.myProject);
        } else {
            NamedScope namedScope = NamedScopesHolder.getScope(this.myProject, scopeType);
            if (namedScope != null) {
                searchScope2 = GlobalSearchScopesCore.filterScope(this.myProject, namedScope);
            }
        }
        return searchScope2;
    }

    protected boolean isInScope(PsiElement baseClass, @NotNull PsiElement srcElement, String scopeType) {
        if (srcElement == null) {
            HierarchyTreeStructure.$$$reportNull$$$0(12);
        }
        if ("This Class".equals(scopeType)) {
            return PsiTreeUtil.isAncestor(baseClass, srcElement, true);
        }
        if ("This Module".equals(scopeType)) {
            Module module2 = ModuleUtilCore.findModuleForPsiElement(baseClass);
            VirtualFile virtualFile2 = srcElement.getContainingFile().getVirtualFile();
            return module2 != null && module2.getModuleScope().contains(virtualFile2);
        }
        if ("Production".equals(scopeType)) {
            VirtualFile virtualFile3 = srcElement.getContainingFile().getVirtualFile();
            return virtualFile3 == null || !TestSourcesFilter.isTestSources(virtualFile3, this.myProject);
        }
        if ("Test".equals(scopeType)) {
            VirtualFile virtualFile4 = srcElement.getContainingFile().getVirtualFile();
            return virtualFile4 == null || TestSourcesFilter.isTestSources(virtualFile4, this.myProject);
        }
        if ("All".equals(scopeType)) {
            return true;
        }
        NamedScope namedScope = NamedScopesHolder.getScope(this.myProject, scopeType);
        if (namedScope == null) {
            return false;
        }
        PackageSet namedScopePattern = namedScope.getValue();
        if (namedScopePattern == null) {
            return false;
        }
        PsiFile psiFile = srcElement.getContainingFile();
        if (psiFile == null) {
            return true;
        }
        NamedScopesHolder holder = NamedScopesHolder.getHolder(this.myProject, scopeType, NamedScopeManager.getInstance(this.myProject));
        return namedScopePattern.contains(psiFile, holder);
    }

    @NotNull
    public LeafState getLeafState(@NotNull Object element) {
        if (element == null) {
            HierarchyTreeStructure.$$$reportNull$$$0(13);
        }
        if (this.isAlwaysShowPlus()) {
            LeafState leafState = LeafState.NEVER;
            if (leafState == null) {
                HierarchyTreeStructure.$$$reportNull$$$0(14);
            }
            return leafState;
        }
        LeafState state = super.getLeafState(element);
        LeafState leafState = state != LeafState.DEFAULT ? state : LeafState.ASYNC;
        if (leafState == null) {
            HierarchyTreeStructure.$$$reportNull$$$0(15);
        }
        return leafState;
    }

    public boolean isAlwaysShowPlus() {
        return false;
    }

    @NotNull
    protected String formatBaseElementText() {
        HierarchyNodeDescriptor descriptor2 = this.getBaseDescriptor();
        if (descriptor2 == null) {
            String string2 = ((Object)((Object)this)).toString();
            if (string2 == null) {
                HierarchyTreeStructure.$$$reportNull$$$0(16);
            }
            return string2;
        }
        PsiElement element = descriptor2.getPsiElement();
        if (element == null) {
            String string3 = descriptor2.toString();
            if (string3 == null) {
                HierarchyTreeStructure.$$$reportNull$$$0(17);
            }
            return string3;
        }
        String string4 = ElementDescriptionUtil.getElementDescription(element, (ElementDescriptionLocation)UsageViewTypeLocation.INSTANCE) + " " + ElementDescriptionUtil.getElementDescription(element, (ElementDescriptionLocation)UsageViewLongNameLocation.INSTANCE);
        if (string4 == null) {
            HierarchyTreeStructure.$$$reportNull$$$0(18);
        }
        return string4;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 6, 7, 8, 10, 11, 14, 15, 16, 17, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseElement";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/hierarchy/HierarchyTreeStructure";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/hierarchy/HierarchyTreeStructure";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createDescriptor";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildElements";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "asyncCommit";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootElement";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeafState";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "formatBaseElementText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setBaseElement";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptor";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isToBuildChildrenInBackground";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getChildElements";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getParentElement";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isInScope";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getLeafState";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 6, 7, 8, 10, 11, 14, 15, 16, 17, 18 -> new IllegalStateException(string2);
        };
    }

    private static final class TextInfoNodeDescriptor
    extends NodeDescriptor {
        TextInfoNodeDescriptor(NodeDescriptor parentDescriptor, String text2, Project project2) {
            super(project2, parentDescriptor);
            this.myName = text2;
            this.myColor = JBColor.RED;
        }

        public Object getElement() {
            return this.myName;
        }

        public boolean update() {
            return true;
        }
    }
}

