/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.hierarchy.HierarchyBrowserBaseEx;
import com.intellij.ide.hierarchy.LanguageTypeHierarchy;
import com.intellij.ide.hierarchy.ViewClassHierarchyAction;
import com.intellij.ide.hierarchy.ViewSubtypesHierarchyAction;
import com.intellij.ide.hierarchy.ViewSupertypesHierarchyAction;
import com.intellij.ide.util.DeleteHandler;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.ui.PopupHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JTree;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public abstract class TypeHierarchyBrowserBase
extends HierarchyBrowserBaseEx {
    private boolean myIsInterface;
    private final MyDeleteProvider myDeleteElementProvider = new MyDeleteProvider();

    public TypeHierarchyBrowserBase(Project project2, PsiElement element) {
        super(project2, element);
    }

    protected abstract boolean isInterface(@NotNull PsiElement var1);

    protected void createTreeAndSetupCommonActions(@NotNull Map<? super @Nls String, ? super JTree> trees, @NotNull String groupId) {
        if (trees == null) {
            TypeHierarchyBrowserBase.$$$reportNull$$$0(0);
        }
        if (groupId == null) {
            TypeHierarchyBrowserBase.$$$reportNull$$$0(1);
        }
        BaseOnThisTypeAction baseOnThisTypeAction = this.createBaseOnThisAction();
        JTree tree1 = this.createTree(true);
        PopupHandler.installPopupMenu((JComponent)tree1, (String)groupId, (String)"TypeHierarchyViewPopup");
        baseOnThisTypeAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("TypeHierarchy").getShortcutSet(), tree1);
        trees.put(TypeHierarchyBrowserBase.getTypeHierarchyType(), tree1);
        JTree tree2 = this.createTree(true);
        PopupHandler.installPopupMenu((JComponent)tree2, (String)groupId, (String)"TypeHierarchyViewPopup");
        baseOnThisTypeAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("TypeHierarchy").getShortcutSet(), tree2);
        trees.put(TypeHierarchyBrowserBase.getSupertypesHierarchyType(), tree2);
        JTree tree3 = this.createTree(true);
        PopupHandler.installPopupMenu((JComponent)tree3, (String)groupId, (String)"TypeHierarchyViewPopup");
        baseOnThisTypeAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("TypeHierarchy").getShortcutSet(), tree3);
        trees.put(TypeHierarchyBrowserBase.getSubtypesHierarchyType(), tree3);
    }

    @NotNull
    protected BaseOnThisTypeAction createBaseOnThisAction() {
        return new BaseOnThisTypeAction();
    }

    protected abstract boolean canBeDeleted(PsiElement var1);

    protected abstract String getQualifiedName(PsiElement var1);

    @Override
    @NotNull
    protected Map<String, Supplier<String>> getPresentableNameMap() {
        HashMap<String, Supplier<String>> map2 = new HashMap<String, Supplier<String>>();
        map2.put(TypeHierarchyBrowserBase.getTypeHierarchyType(), TypeHierarchyBrowserBase::getTypeHierarchyType);
        map2.put(TypeHierarchyBrowserBase.getSubtypesHierarchyType(), TypeHierarchyBrowserBase::getSubtypesHierarchyType);
        map2.put(TypeHierarchyBrowserBase.getSupertypesHierarchyType(), TypeHierarchyBrowserBase::getSupertypesHierarchyType);
        HashMap<String, Supplier<String>> hashMap = map2;
        if (hashMap == null) {
            TypeHierarchyBrowserBase.$$$reportNull$$$0(2);
        }
        return hashMap;
    }

    public boolean isInterface() {
        return this.myIsInterface;
    }

    @Override
    protected void setHierarchyBase(@NotNull PsiElement element) {
        if (element == null) {
            TypeHierarchyBrowserBase.$$$reportNull$$$0(3);
        }
        super.setHierarchyBase(element);
        this.myIsInterface = this.isInterface(element);
    }

    @Override
    protected void prependActions(@NotNull DefaultActionGroup actionGroup2) {
        if (actionGroup2 == null) {
            TypeHierarchyBrowserBase.$$$reportNull$$$0(4);
        }
        actionGroup2.add((AnAction)new ViewClassHierarchyAction());
        actionGroup2.add((AnAction)new ViewSupertypesHierarchyAction());
        actionGroup2.add((AnAction)new ViewSubtypesHierarchyAction());
        actionGroup2.add((AnAction)new HierarchyBrowserBaseEx.AlphaSortAction());
    }

    @Override
    @NotNull
    protected String getActionPlace() {
        return "TypeHierarchyViewToolbar";
    }

    @Override
    public final Object getData(@NotNull String dataId) {
        if (dataId == null) {
            TypeHierarchyBrowserBase.$$$reportNull$$$0(5);
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            return this.myDeleteElementProvider;
        }
        return super.getData(dataId);
    }

    @Override
    @NotNull
    protected String getPrevOccurenceActionNameImpl() {
        String string2 = IdeBundle.message((String)"hierarchy.type.prev.occurence.name", (Object[])new Object[0]);
        if (string2 == null) {
            TypeHierarchyBrowserBase.$$$reportNull$$$0(6);
        }
        return string2;
    }

    @Override
    @NotNull
    protected String getNextOccurenceActionNameImpl() {
        String string2 = IdeBundle.message((String)"hierarchy.type.next.occurence.name", (Object[])new Object[0]);
        if (string2 == null) {
            TypeHierarchyBrowserBase.$$$reportNull$$$0(7);
        }
        return string2;
    }

    @Override
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            TypeHierarchyBrowserBase.$$$reportNull$$$0(8);
        }
        return actionUpdateThread;
    }

    @Nls
    @NotNull
    public static String getTypeHierarchyType() {
        String string2 = IdeBundle.message((String)"title.hierarchy.class", (Object[])new Object[0]);
        if (string2 == null) {
            TypeHierarchyBrowserBase.$$$reportNull$$$0(9);
        }
        return string2;
    }

    @Nls
    @NotNull
    public static String getSubtypesHierarchyType() {
        String string2 = IdeBundle.message((String)"title.hierarchy.subtypes", (Object[])new Object[0]);
        if (string2 == null) {
            TypeHierarchyBrowserBase.$$$reportNull$$$0(10);
        }
        return string2;
    }

    @Nls
    @NotNull
    public static String getSupertypesHierarchyType() {
        String string2 = IdeBundle.message((String)"title.hierarchy.supertypes", (Object[])new Object[0]);
        if (string2 == null) {
            TypeHierarchyBrowserBase.$$$reportNull$$$0(11);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6, 7, 8, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trees";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/hierarchy/TypeHierarchyBrowserBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroup";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/hierarchy/TypeHierarchyBrowserBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableNameMap";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrevOccurenceActionNameImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextOccurenceActionNameImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeHierarchyType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubtypesHierarchyType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupertypesHierarchyType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createTreeAndSetupCommonActions";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setHierarchyBase";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "prependActions";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 6, 7, 8, 9, 10, 11 -> new IllegalStateException(string2);
        };
    }

    private final class MyDeleteProvider
    implements DeleteProvider {
        private MyDeleteProvider() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deleteElement(@NotNull DataContext dataContext2) {
            PsiElement aClass;
            if (dataContext2 == null) {
                MyDeleteProvider.$$$reportNull$$$0(0);
            }
            if (!TypeHierarchyBrowserBase.this.canBeDeleted(aClass = TypeHierarchyBrowserBase.this.getSelectedElement(dataContext2))) {
                return;
            }
            LocalHistoryAction a = LocalHistory.getInstance().startAction(IdeBundle.message((String)"progress.deleting.class", (Object[])new Object[]{TypeHierarchyBrowserBase.this.getQualifiedName(aClass)}));
            try {
                PsiElement[] elements = new PsiElement[]{aClass};
                DeleteHandler.deletePsiElement(elements, TypeHierarchyBrowserBase.this.myProject);
            }
            finally {
                a.finish();
            }
        }

        public boolean canDeleteElement(@NotNull DataContext dataContext2) {
            PsiElement aClass;
            if (dataContext2 == null) {
                MyDeleteProvider.$$$reportNull$$$0(1);
            }
            if (!TypeHierarchyBrowserBase.this.canBeDeleted(aClass = TypeHierarchyBrowserBase.this.getSelectedElement(dataContext2))) {
                return false;
            }
            PsiElement[] elements = new PsiElement[]{aClass};
            return DeleteHandler.shouldEnableDeleteAction(elements);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                MyDeleteProvider.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/hierarchy/TypeHierarchyBrowserBase$MyDeleteProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/hierarchy/TypeHierarchyBrowserBase$MyDeleteProvider";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "deleteElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "canDeleteElement";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2 -> new IllegalStateException(string2);
            };
        }
    }

    protected static class BaseOnThisTypeAction
    extends HierarchyBrowserBaseEx.BaseOnThisElementAction {
        public BaseOnThisTypeAction() {
            super(IdeBundle.messagePointer((String)"action.base.on.this.class", (Object[])new Object[0]), LanguageTypeHierarchy.INSTANCE);
        }

        @Override
        @Nls
        protected String correctViewType(@NotNull HierarchyBrowserBaseEx browser, @Nls String viewType) {
            if (browser == null) {
                BaseOnThisTypeAction.$$$reportNull$$$0(0);
            }
            if (((TypeHierarchyBrowserBase)browser).myIsInterface && TypeHierarchyBrowserBase.getTypeHierarchyType().equals(viewType)) {
                return TypeHierarchyBrowserBase.getSubtypesHierarchyType();
            }
            return viewType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browser", "com/intellij/ide/hierarchy/TypeHierarchyBrowserBase$BaseOnThisTypeAction", "correctViewType"));
        }
    }
}

