/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl.dataRules;

import com.intellij.ide.impl.dataRules.GetDataRule;
import com.intellij.ide.impl.dataRules.VirtualFileArrayRule;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleRule
implements GetDataRule {
    public Object getData(@NotNull DataProvider dataProvider) {
        Object moduleContext;
        if (dataProvider == null) {
            ModuleRule.$$$reportNull$$$0(0);
        }
        if ((moduleContext = LangDataKeys.MODULE_CONTEXT.getData(dataProvider)) != null) {
            return moduleContext;
        }
        Project project2 = ModuleRule.extractProject(dataProvider);
        if (project2 == null) {
            return null;
        }
        VirtualFile[] files2 = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataProvider);
        if (files2 == null) {
            files2 = (VirtualFile[])new VirtualFileArrayRule().getData(dataProvider);
        }
        if (files2 == null) {
            return null;
        }
        Module singleModule = null;
        for (VirtualFile file2 : files2) {
            Module module2 = ModuleUtilCore.findModuleForFile(file2, project2);
            if (module2 == null) {
                return null;
            }
            if (singleModule == null) {
                singleModule = module2;
                continue;
            }
            if (module2 == singleModule) continue;
            return null;
        }
        return singleModule;
    }

    @Nullable
    private static Project extractProject(@NotNull DataProvider dataProvider) {
        PsiElement[] psiElements;
        Project project2;
        if (dataProvider == null) {
            ModuleRule.$$$reportNull$$$0(1);
        }
        if ((project2 = (Project)CommonDataKeys.PROJECT.getData(dataProvider)) != null) {
            return project2;
        }
        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataProvider);
        Project project3 = project2 = editor2 != null ? editor2.getProject() : null;
        if (project2 != null) {
            return project2;
        }
        PsiFile file2 = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataProvider);
        if (file2 != null && file2.isValid()) {
            return file2.getProject();
        }
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataProvider);
        if (element == null && (psiElements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataProvider)) != null && psiElements.length > 0) {
            element = psiElements[0];
        }
        if (element == null || !element.isValid()) {
            return null;
        }
        return element.getProject();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "dataProvider";
        objectArray2[1] = "com/intellij/ide/impl/dataRules/ModuleRule";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "extractProject";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

