/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navbar.actions;

import com.intellij.ide.navbar.actions.NavBarActionHandler;
import com.intellij.ide.navbar.vm.NavBarPopupVm;
import com.intellij.ide.navbar.vm.NavBarVm;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\b \u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\b\u0010\b\u001a\u00020\u0006H\u0016J\b\u0010\t\u001a\u00020\u0006H\u0016J\b\u0010\n\u001a\u00020\u0006H\u0016J\b\u0010\u000b\u001a\u00020\u0006H\u0016J\b\u0010\f\u001a\u00020\u0006H\u0016J\b\u0010\r\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ide/navbar/actions/NavBarActionHandlerImpl;", "Lcom/intellij/ide/navbar/actions/NavBarActionHandler;", "vm", "Lcom/intellij/ide/navbar/vm/NavBarVm;", "(Lcom/intellij/ide/navbar/vm/NavBarVm;)V", "enter", "", "escape", "moveEnd", "moveHome", "moveLeft", "moveRight", "moveUpDown", "navigate", "intellij.platform.lang.impl"})
public abstract class NavBarActionHandlerImpl
implements NavBarActionHandler {
    @NotNull
    private final NavBarVm vm;

    public NavBarActionHandlerImpl(@NotNull NavBarVm vm2) {
        Intrinsics.checkNotNullParameter((Object)vm2, (String)"vm");
        this.vm = vm2;
    }

    @Override
    public void moveHome() {
        this.vm.shiftSelectionTo(NavBarVm.SelectionShift.FIRST);
    }

    @Override
    public void moveLeft() {
        this.vm.shiftSelectionTo(NavBarVm.SelectionShift.PREV);
    }

    @Override
    public void moveRight() {
        this.vm.shiftSelectionTo(NavBarVm.SelectionShift.NEXT);
    }

    @Override
    public void moveEnd() {
        this.vm.shiftSelectionTo(NavBarVm.SelectionShift.LAST);
    }

    @Override
    public void moveUpDown() {
        this.vm.showPopup();
    }

    @Override
    public void escape() {
        throw new IllegalStateException("unsupported in v2".toString());
    }

    @Override
    public void enter() {
        Unit unit;
        NavBarPopupVm navBarPopupVm = this.vm.getPopup().getValue();
        if (navBarPopupVm != null) {
            navBarPopupVm.complete();
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            this.vm.showPopup();
        }
    }

    @Override
    public void navigate() {
        throw new IllegalStateException("unsupported in v2".toString());
    }
}

