/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navbar.impl;

import com.intellij.ide.navbar.NavBarItem;
import com.intellij.ide.navbar.NavBarItemProvider;
import com.intellij.ide.navbar.impl.DefaultNavBarItem;
import com.intellij.ide.navbar.impl.DefaultNavBarItemProvider;
import com.intellij.ide.navbar.impl.DefaultNavBarItemProviderKt;
import com.intellij.ide.navbar.impl.PsiNavBarItem;
import com.intellij.ide.navigationToolbar.NavBarModelExtension;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.BaseProjectDirectories;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\tH\u0017J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\f2\u0006\u0010\n\u001a\u00020\tH\u0017J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ide/navbar/impl/DefaultNavBarItemProvider;", "Lcom/intellij/ide/navbar/NavBarItemProvider;", "()V", "adjustedParent", "Lcom/intellij/psi/PsiElement;", "parent", "ownerExtension", "Lcom/intellij/ide/navigationToolbar/NavBarModelExtension;", "findParent", "Lcom/intellij/ide/navbar/NavBarItem;", "item", "iterateChildren", "", "originalParent", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nDefaultNavBarItemProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultNavBarItemProvider.kt\ncom/intellij/ide/navbar/impl/DefaultNavBarItemProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,183:1\n766#2:184\n857#2,2:185\n*S KotlinDebug\n*F\n+ 1 DefaultNavBarItemProvider.kt\ncom/intellij/ide/navbar/impl/DefaultNavBarItemProvider\n*L\n42#1:184\n42#1:185,2\n*E\n"})
public final class DefaultNavBarItemProvider
implements NavBarItemProvider {
    /*
     * WARNING - void declaration
     */
    @Override
    @RequiresReadLock
    @RequiresBackgroundThread
    @Nullable
    public NavBarItem findParent(@NotNull NavBarItem item) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (!(item instanceof PsiNavBarItem)) {
            return null;
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance(((PsiElement)((PsiNavBarItem)item).getData()).getProject()).getFileIndex();
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(item.data.project).fileIndex");
        ProjectFileIndex projectFileIndex2 = projectFileIndex;
        Project project2 = ((PsiElement)((PsiNavBarItem)item).getData()).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"item.data.project");
        Set defaultRoots = BaseProjectDirectories.Companion.getBaseDirectories(project2);
        Project project3 = ((PsiElement)((PsiNavBarItem)item).getData()).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"item.data.project");
        Iterable oldEpRoots = DefaultNavBarItemProviderKt.access$additionalRoots(project3);
        Iterable $this$filter$iv = SetsKt.plus((Set)defaultRoots, (Iterable)oldEpRoots);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (!(it.getParent() == null || !projectFileIndex2.isInContent(it.getParent()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List allRoots = (List)destination$iv$iv;
        if (CollectionsKt.contains((Iterable)allRoots, (Object)PsiUtilCore.getVirtualFile((PsiElement)((PsiNavBarItem)item).getData()))) {
            return null;
        }
        PsiElement parent2 = (PsiElement)DefaultNavBarItemProviderKt.fromOldExtensions((Function1)new Function1<NavBarModelExtension, PsiElement>(item){
            final /* synthetic */ NavBarItem $item;
            {
                this.$item = $item;
                super(1);
            }

            @Nullable
            public final PsiElement invoke(@NotNull NavBarModelExtension ext) {
                PsiElement psiElement;
                Intrinsics.checkNotNullParameter((Object)ext, (String)"ext");
                try {
                    psiElement = ext.getParent((PsiElement)((PsiNavBarItem)this.$item).getData());
                }
                catch (ProcessCanceledException pce) {
                    ProgressManager.checkCanceled();
                    psiElement = null;
                }
                return psiElement;
            }
        }, (Function1)new Function1<PsiElement, Boolean>(item){
            final /* synthetic */ NavBarItem $item;
            {
                this.$item = $item;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull PsiElement parent2) {
                Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
                return !Intrinsics.areEqual((Object)parent2, ((PsiNavBarItem)this.$item).getData());
            }
        });
        if (parent2 == null || !parent2.isValid()) {
            return null;
        }
        PsiFile containingFile = parent2.getContainingFile();
        if (containingFile != null && containingFile.getVirtualFile() == null) {
            return null;
        }
        PsiElement adjustedParent = this.adjustedParent(parent2, ((PsiNavBarItem)item).getOwnerExtension());
        if (adjustedParent != null) {
            return new PsiNavBarItem(adjustedParent, ((PsiNavBarItem)item).getOwnerExtension());
        }
        return null;
    }

    private final PsiElement originalParent(PsiElement parent2) {
        PsiElement originalElement = parent2.getOriginalElement();
        if (!(originalElement instanceof PsiCompiledElement) || parent2 instanceof PsiCompiledElement) {
            Intrinsics.checkNotNullExpressionValue((Object)originalElement, (String)"originalElement");
            DefaultNavBarItemProviderKt.ensurePsiFromExtensionIsValid(originalElement, "Original parent is invalid", parent2.getClass());
            return originalElement;
        }
        return parent2;
    }

    private final PsiElement adjustedParent(PsiElement parent2, NavBarModelExtension ownerExtension) {
        PsiElement adjustedByOwner;
        PsiElement originalParent = this.originalParent(parent2);
        NavBarModelExtension navBarModelExtension = ownerExtension;
        PsiElement psiElement = adjustedByOwner = navBarModelExtension != null ? navBarModelExtension.adjustElement(originalParent) : null;
        if (adjustedByOwner != null) {
            DefaultNavBarItemProviderKt.ensurePsiFromExtensionIsValid(adjustedByOwner, "Owner extension returned invalid psi after adjustment", ownerExtension.getClass());
            return adjustedByOwner;
        }
        return DefaultNavBarItemProviderKt.adjustWithAllExtensions(originalParent);
    }

    @Override
    @RequiresReadLock
    @RequiresBackgroundThread
    @NotNull
    public Iterable<NavBarItem> iterateChildren(@NotNull NavBarItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (!(item instanceof DefaultNavBarItem)) {
            return new Iterable<NavBarItem>(){

                @NotNull
                public Iterator<NavBarItem> iterator() {
                    boolean bl = false;
                    Iterator<NavBarItem> iterator2 = Collections.emptyIterator();
                    Intrinsics.checkNotNullExpressionValue(iterator2, (String)"emptyIterator()");
                    return iterator2;
                }
            };
        }
        return SequencesKt.asIterable((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)NavBarModelExtension.EP_NAME.getExtensionList()), (Function1)((Function1)new Function1<NavBarModelExtension, Sequence<? extends Pair<? extends Object, ? extends NavBarModelExtension>>>(item){
            final /* synthetic */ NavBarItem $item;
            {
                this.$item = $item;
                super(1);
            }

            @NotNull
            public final Sequence<Pair<Object, NavBarModelExtension>> invoke(NavBarModelExtension ext) {
                ArrayList<E> children2 = new ArrayList<E>();
                ext.processChildren(((DefaultNavBarItem)this.$item).getData(), null, arg_0 -> iterateChildren.2.invoke$lambda$0(children2, arg_0));
                return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)children2), (Function1)((Function1)new Function1<Object, Pair<? extends Object, ? extends NavBarModelExtension>>(ext){
                    final /* synthetic */ NavBarModelExtension $ext;
                    {
                        this.$ext = $ext;
                        super(1);
                    }

                    @NotNull
                    public final Pair<Object, NavBarModelExtension> invoke(@NotNull Object child) {
                        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
                        return new Pair(child, (Object)this.$ext);
                    }
                }));
            }

            private static final boolean invoke$lambda$0(ArrayList $children, Object it) {
                Intrinsics.checkNotNullParameter((Object)$children, (String)"$children");
                $children.add(it);
                return true;
            }
        })), (Function1)iterateChildren.3.INSTANCE));
    }
}

