/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navbar.impl;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.navigationToolbar.NavBarModelExtension;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u001a(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u000e\b\u0002\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000eH\u0000\u001a8\u0010\u000f\u001a\u0004\u0018\u0001H\u0010\"\u0004\b\u0000\u0010\u00102#\u0010\u0011\u001a\u001f\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0016\u0012\u0006\u0012\u0004\u0018\u0001H\u00100\u0012\u00a2\u0006\u0002\u0010\u0017\u001aL\u0010\u000f\u001a\u0004\u0018\u0001H\u0010\"\u0004\b\u0000\u0010\u00102#\u0010\u0011\u001a\u001f\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0016\u0012\u0006\u0012\u0004\u0018\u0001H\u00100\u00122\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u0002H\u0010\u0012\u0004\u0012\u00020\u00190\u0012\u00a2\u0006\u0002\u0010\u001a\u00a8\u0006\u001b"}, d2={"additionalRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "adjustWithAllExtensions", "Lcom/intellij/psi/PsiElement;", "element", "ensurePsiFromExtensionIsValid", "", "psi", "message", "", "clazz", "Ljava/lang/Class;", "fromOldExtensions", "T", "selector", "Lkotlin/Function1;", "Lcom/intellij/ide/navigationToolbar/NavBarModelExtension;", "Lkotlin/ParameterName;", "name", "ext", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "predicate", "", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "intellij.platform.lang.impl"})
public final class DefaultNavBarItemProviderKt {
    @Nullable
    public static final <T> T fromOldExtensions(@NotNull Function1<? super NavBarModelExtension, ? extends T> selector) {
        Intrinsics.checkNotNullParameter(selector, (String)"selector");
        for (NavBarModelExtension ext : NavBarModelExtension.EP_NAME.getExtensionList()) {
            Intrinsics.checkNotNullExpressionValue((Object)ext, (String)"ext");
            Object selected = selector.invoke((Object)ext);
            if (selected == null) continue;
            return (T)selected;
        }
        return null;
    }

    @Nullable
    public static final <T> T fromOldExtensions(@NotNull Function1<? super NavBarModelExtension, ? extends T> selector, @NotNull Function1<? super T, Boolean> predicate2) {
        Intrinsics.checkNotNullParameter(selector, (String)"selector");
        Intrinsics.checkNotNullParameter(predicate2, (String)"predicate");
        for (NavBarModelExtension ext : NavBarModelExtension.EP_NAME.getExtensionList()) {
            Intrinsics.checkNotNullExpressionValue((Object)ext, (String)"ext");
            Object selected = selector.invoke((Object)ext);
            if (selected == null || !((Boolean)predicate2.invoke(selected)).booleanValue()) continue;
            return (T)selected;
        }
        return null;
    }

    @Nullable
    public static final PsiElement adjustWithAllExtensions(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement result2 = element;
        for (NavBarModelExtension ext : CollectionsKt.asReversed(NavBarModelExtension.EP_NAME.getExtensionList())) {
            if (ext.adjustElement(result2) == null) {
                return null;
            }
            DefaultNavBarItemProviderKt.ensurePsiFromExtensionIsValid(result2, "Invalid psi returned from " + ext.getClass() + " while adjusting", ext.getClass());
        }
        return result2;
    }

    private static final Iterable<VirtualFile> additionalRoots(Project project2) {
        ArrayList<VirtualFile> resultRoots = new ArrayList<VirtualFile>();
        for (NavBarModelExtension ext : NavBarModelExtension.EP_NAME.getExtensionList()) {
            resultRoots.addAll(ext.additionalRoots(project2));
        }
        return resultRoots;
    }

    public static final void ensurePsiFromExtensionIsValid(@NotNull PsiElement psi, @NotNull String message, @Nullable Class<?> clazz) {
        Intrinsics.checkNotNullParameter((Object)psi, (String)"psi");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        try {
            PsiUtilCore.ensureValid(psi);
        }
        catch (Throwable t) {
            if (clazz != null) {
                PluginException pluginException = PluginException.createByClass(message, t, clazz);
                Intrinsics.checkNotNullExpressionValue((Object)pluginException, (String)"createByClass(message, t, clazz)");
                throw (Throwable)pluginException;
            }
            throw new IllegalStateException(message, t);
        }
    }

    public static /* synthetic */ void ensurePsiFromExtensionIsValid$default(PsiElement psiElement, String string2, Class clazz, int n, Object object) {
        if ((n & 4) != 0) {
            clazz = null;
        }
        DefaultNavBarItemProviderKt.ensurePsiFromExtensionIsValid(psiElement, string2, clazz);
    }

    public static final /* synthetic */ Iterable access$additionalRoots(Project project2) {
        return DefaultNavBarItemProviderKt.additionalRoots(project2);
    }
}

