/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navbar.impl;

import com.intellij.ide.navbar.NavBarItem;
import com.intellij.ide.navbar.NavBarItemProvider;
import com.intellij.ide.navbar.impl.ImplKt;
import com.intellij.ide.navbar.impl.ModuleNavBarItem;
import com.intellij.ide.navbar.impl.PsiNavBarItem;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007*\u00020\u0002H\u0000\u001a\u000e\u0010\b\u001a\u0004\u0018\u00010\u0002*\u00020\u0002H\u0002\u001a\f\u0010\t\u001a\u00020\n*\u00020\u0002H\u0000\u001a\u0012\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f*\u00020\u0002H\u0002\u001a\u0012\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007*\u00020\u0002H\u0000\u001a\u0012\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0007*\u00020\u0002H\u0000\"\u001e\u0010\u0000\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"nameComparator", "Ljava/util/Comparator;", "Lcom/intellij/ide/navbar/NavBarItem;", "Lkotlin/Comparator;", "siblingsComparator", "weightComparator", "children", "", "findParent", "isModuleContentRoot", "", "iterateAllChildren", "", "pathToItem", "psiDirectories", "Lcom/intellij/psi/PsiDirectory;", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nimpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 impl.kt\ncom/intellij/ide/navbar/impl/ImplKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,88:1\n1360#2:89\n1446#2,5:90\n11653#3,9:95\n13579#3:104\n13580#3:106\n11662#3:107\n1#4:105\n*S KotlinDebug\n*F\n+ 1 impl.kt\ncom/intellij/ide/navbar/impl/ImplKt\n*L\n40#1:89\n40#1:90,5\n78#1:95,9\n78#1:104\n78#1:106\n78#1:107\n78#1:105\n*E\n"})
public final class ImplKt {
    @NotNull
    private static final Comparator<NavBarItem> weightComparator = new Comparator(){

        public final int compare(T a, T b) {
            NavBarItem it = (NavBarItem)a;
            boolean bl = false;
            Comparable comparable = Integer.valueOf(-it.weight());
            it = (NavBarItem)b;
            Comparable comparable2 = comparable;
            bl = false;
            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(-it.weight()));
        }
    };
    @NotNull
    private static final Comparator<NavBarItem> nameComparator;
    @NotNull
    private static final Comparator<NavBarItem> siblingsComparator;

    @NotNull
    public static final List<NavBarItem> pathToItem(@NotNull NavBarItem $this$pathToItem) {
        Intrinsics.checkNotNullParameter((Object)$this$pathToItem, (String)"<this>");
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return CollectionsKt.asReversed((List)SequencesKt.toList((Sequence)SequencesKt.generateSequence((Object)$this$pathToItem, (Function1)pathToItem.1.INSTANCE)));
    }

    private static final NavBarItem findParent(NavBarItem $this$findParent) {
        for (NavBarItemProvider ext : NavBarItemProvider.EP_NAME.getExtensionList()) {
            NavBarItem parentCandidate;
            if (ext.findParent($this$findParent) == null || parentCandidate instanceof PsiNavBarItem && !((PsiElement)((PsiNavBarItem)parentCandidate).getData()).isValid()) continue;
            return parentCandidate;
        }
        return null;
    }

    @NotNull
    public static final List<NavBarItem> children(@NotNull NavBarItem $this$children) {
        Intrinsics.checkNotNullParameter((Object)$this$children, (String)"<this>");
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return CollectionsKt.sortedWith(ImplKt.iterateAllChildren($this$children), siblingsComparator);
    }

    /*
     * WARNING - void declaration
     */
    private static final Iterable<NavBarItem> iterateAllChildren(NavBarItem $this$iterateAllChildren) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = NavBarItemProvider.EP_NAME.getExtensionList();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            NavBarItemProvider ext = (NavBarItemProvider)element$iv$iv;
            boolean bl = false;
            Iterable<NavBarItem> list$iv$iv = ext.iterateChildren($this$iterateAllChildren);
            CollectionsKt.addAll((Collection)destination$iv$iv, list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final boolean isModuleContentRoot(@NotNull NavBarItem $this$isModuleContentRoot) {
        PsiElement psi;
        Intrinsics.checkNotNullParameter((Object)$this$isModuleContentRoot, (String)"<this>");
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if ($this$isModuleContentRoot instanceof PsiNavBarItem && (psi = (PsiElement)((PsiNavBarItem)$this$isModuleContentRoot).getData()) instanceof PsiDirectory) {
            VirtualFile virtualFile2 = ((PsiDirectory)psi).getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"psi.virtualFile");
            VirtualFile dir = virtualFile2;
            return dir.getParent() == null || ProjectRootsUtil.isModuleContentRoot(dir, ((PsiDirectory)psi).getProject());
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<PsiDirectory> psiDirectories(@NotNull NavBarItem $this$psiDirectories) {
        Intrinsics.checkNotNullParameter((Object)$this$psiDirectories, (String)"<this>");
        ApplicationManager.getApplication().assertReadAccessAllowed();
        NavBarItem navBarItem = $this$psiDirectories;
        if (navBarItem instanceof PsiNavBarItem) {
            PsiElement psi = (PsiElement)((PsiNavBarItem)$this$psiDirectories).getData();
            if (psi instanceof PsiDirectory) {
                return CollectionsKt.listOf((Object)psi);
            }
            if (psi instanceof PsiDirectoryContainer) {
                PsiDirectory[] psiDirectoryArray = ((PsiDirectoryContainer)psi).getDirectories();
                Intrinsics.checkNotNullExpressionValue((Object)psiDirectoryArray, (String)"psi.directories");
                PsiDirectory[] psiDirectoryArray2 = psiDirectoryArray;
                return CollectionsKt.listOf((Object[])Arrays.copyOf(psiDirectoryArray2, psiDirectoryArray2.length));
            }
            PsiFile file2 = psi.getContainingFile();
            if (file2 != null) {
                return CollectionsKt.listOf((Object)file2.getContainingDirectory());
            }
            return CollectionsKt.emptyList();
        }
        if (navBarItem instanceof ModuleNavBarItem) {
            void $this$mapNotNullTo$iv$iv;
            Module data2 = (Module)((ModuleNavBarItem)$this$psiDirectories).getData();
            PsiManager psiManager = PsiManager.getInstance(data2.getProject());
            Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(data.project)");
            PsiManager psiManager2 = psiManager;
            VirtualFile[] virtualFileArray = ModuleRootManager.getInstance(data2).getSourceRoots();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getInstance(data).sourceRoots");
            Object[] $this$mapNotNull$iv = virtualFileArray;
            boolean $i$f$mapNotNull = false;
            Object[] objectArray = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int j = 0; j < n; ++j) {
                PsiDirectory it$iv$iv;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[j];
                boolean bl = false;
                VirtualFile it = (VirtualFile)element$iv$iv;
                boolean bl2 = false;
                if (psiManager2.findDirectory(it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        return CollectionsKt.emptyList();
    }

    public static final /* synthetic */ NavBarItem access$findParent(NavBarItem $receiver) {
        return ImplKt.findParent($receiver);
    }

    static {
        Comparator<String> comparator = NaturalComparator.INSTANCE;
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"INSTANCE");
        Comparator<String> comparator2 = comparator;
        nameComparator = new Comparator(comparator2){
            final /* synthetic */ Comparator $comparator;
            {
                this.$comparator = $comparator;
            }

            public final int compare(T a, T b) {
                NavBarItem navBarItem = (NavBarItem)a;
                Comparator comparator = this.$comparator;
                boolean bl = false;
                NavBarItem it = (NavBarItem)b;
                String string2 = it.presentation().getText();
                bl = false;
                String string3 = it.presentation().getText();
                return comparator.compare(string2, string3);
            }
        };
        siblingsComparator = ComparisonsKt.then(weightComparator, nameComparator);
    }
}

