/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navbar.impl;

import com.intellij.ide.navbar.NavBarItem;
import com.intellij.ide.navbar.impl.DefaultNavBarItem;
import com.intellij.ide.navbar.impl.DefaultNavBarItemKt;
import com.intellij.ide.navbar.impl.DefaultNavBarItemProviderKt;
import com.intellij.ide.navigationToolbar.NavBarModelExtension;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.model.Pointer;
import com.intellij.navigation.NavigationRequest;
import com.intellij.navigation.NavigationService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.refactoring.suggested.UtilsKt;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\nH\u0016J\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ide/navbar/impl/PsiNavBarItem;", "Lcom/intellij/ide/navbar/impl/DefaultNavBarItem;", "Lcom/intellij/psi/PsiElement;", "data", "ownerExtension", "Lcom/intellij/ide/navigationToolbar/NavBarModelExtension;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/ide/navigationToolbar/NavBarModelExtension;)V", "getOwnerExtension", "()Lcom/intellij/ide/navigationToolbar/NavBarModelExtension;", "createPointer", "Lcom/intellij/model/Pointer;", "Lcom/intellij/ide/navbar/NavBarItem;", "getIcon", "Ljavax/swing/Icon;", "getTextAttributes", "Lcom/intellij/ui/SimpleTextAttributes;", "selected", "", "navigateOnClick", "navigationRequest", "Lcom/intellij/navigation/NavigationRequest;", "weight", "", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nDefaultNavBarItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultNavBarItem.kt\ncom/intellij/ide/navbar/impl/PsiNavBarItem\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,257:1\n1#2:258\n*E\n"})
public final class PsiNavBarItem
extends DefaultNavBarItem<PsiElement> {
    @Nullable
    private final NavBarModelExtension ownerExtension;

    public PsiNavBarItem(@NotNull PsiElement data2, @Nullable NavBarModelExtension ownerExtension) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        super(data2);
        this.ownerExtension = ownerExtension;
    }

    @Nullable
    public final NavBarModelExtension getOwnerExtension() {
        return this.ownerExtension;
    }

    @Override
    @NotNull
    public Pointer<? extends NavBarItem> createPointer() {
        PsiElement data2 = (PsiElement)this.getData();
        NavBarModelExtension ownerExtension = this.ownerExtension;
        Pointer<PsiNavBarItem> pointer = Pointer.delegatingPointer((Pointer)UtilsKt.createSmartPointer(data2), arg_0 -> PsiNavBarItem.createPointer$lambda$0((Function1)new Function1<PsiElement, PsiNavBarItem>(ownerExtension){
            final /* synthetic */ NavBarModelExtension $ownerExtension;
            {
                this.$ownerExtension = $ownerExtension;
                super(1);
            }

            public final PsiNavBarItem invoke(PsiElement psi) {
                Intrinsics.checkNotNullExpressionValue((Object)psi, (String)"psi");
                return new PsiNavBarItem(psi, this.$ownerExtension);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue(pointer, (String)"ownerExtension = ownerEx\u2026si, ownerExtension)\n    }");
        return pointer;
    }

    @Override
    @Nullable
    public NavigationRequest navigationRequest() {
        NavigationRequest navigationRequest2;
        Object object = this.getData();
        Navigatable navigatable = object instanceof Navigatable ? (Navigatable)object : null;
        if (navigatable != null) {
            object = navigatable;
            NavigationService navigationService = NavigationService.Companion.instance();
            Object p0 = object;
            boolean bl = false;
            navigationRequest2 = navigationService.rawNavigationRequest((Navigatable)p0);
        } else {
            navigationRequest2 = null;
        }
        return navigationRequest2;
    }

    @Override
    @Nullable
    public Icon getIcon() {
        Icon icon2;
        try {
            Icon icon3;
            Icon icon4 = ((PsiElement)this.getData()).getIcon(0);
            if (icon4 != null) {
                Icon it = icon4;
                boolean bl = false;
                int maxDimension = JBUI.scale(32);
                icon3 = IconUtil.cropIcon((Icon)it, (int)maxDimension, (int)maxDimension);
            } else {
                icon3 = null;
            }
            icon2 = icon3;
        }
        catch (IndexNotReadyException e) {
            icon2 = null;
        }
        return icon2;
    }

    @Override
    @NotNull
    public SimpleTextAttributes getTextAttributes(boolean selected) {
        PsiFile psiFile = ((PsiElement)this.getData()).getContainingFile();
        if (psiFile != null) {
            VirtualFile virtualFile2 = psiFile.getVirtualFile();
            if (virtualFile2 == null) {
                return new SimpleTextAttributes(null, null, DefaultNavBarItemKt.getNavBarErrorAttributes().getWaveColor(), 0);
            }
            VirtualFile virtualFile3 = virtualFile2;
            WolfTheProblemSolver problemSolver2 = WolfTheProblemSolver.getInstance(((PsiElement)this.getData()).getProject());
            int style = problemSolver2.isProblemFile(virtualFile3) ? DefaultNavBarItemKt.getNavBarErrorAttributes().getStyle() : 0;
            Color color = !selected ? FileStatusManager.getInstance((Project)((PsiElement)this.getData()).getProject()).getStatus(virtualFile3).getColor() : null;
            return new SimpleTextAttributes(null, color, DefaultNavBarItemKt.getNavBarErrorAttributes().getWaveColor(), style);
        }
        if (this.getData() instanceof PsiDirectory) {
            VirtualFile virtualFile4 = ((PsiDirectory)this.getData()).getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile4, (String)"data.virtualFile");
            VirtualFile vDir = virtualFile4;
            if (vDir.getParent() == null || ProjectRootsUtil.isModuleContentRoot(vDir, ((PsiDirectory)this.getData()).getProject())) {
                SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
                Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"REGULAR_BOLD_ATTRIBUTES");
                return simpleTextAttributes;
            }
        }
        if (DefaultNavBarItemKt.access$wolfHasProblemFilesBeneath((PsiElement)this.getData())) {
            SimpleTextAttributes simpleTextAttributes = DefaultNavBarItemKt.getNavBarErrorAttributes();
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"navBarErrorAttributes");
            return simpleTextAttributes;
        }
        SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
        Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"REGULAR_ATTRIBUTES");
        return simpleTextAttributes;
    }

    @Override
    public boolean navigateOnClick() {
        Boolean shouldExpandOnClick2 = (Boolean)DefaultNavBarItemProviderKt.fromOldExtensions((Function1)new Function1<NavBarModelExtension, Boolean>(this){
            final /* synthetic */ PsiNavBarItem this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final Boolean invoke(@NotNull NavBarModelExtension ext) {
                Intrinsics.checkNotNullParameter((Object)ext, (String)"ext");
                return ext.shouldExpandOnClick((PsiElement)this.this$0.getData());
            }
        });
        if (shouldExpandOnClick2 != null) {
            return shouldExpandOnClick2 == false;
        }
        return !(this.getData() instanceof PsiDirectory) && !(this.getData() instanceof PsiDirectoryContainer);
    }

    @Override
    public int weight() {
        PsiElement psiElement = (PsiElement)this.getData();
        return psiElement instanceof PsiDirectoryContainer ? 4 : (psiElement instanceof PsiDirectory ? 4 : (psiElement instanceof PsiFile ? 2 : (psiElement instanceof PsiNamedElement ? 3 : Integer.MAX_VALUE)));
    }

    private static final PsiNavBarItem createPointer$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (PsiNavBarItem)$tmp0.invoke(p0);
    }
}

