/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navbar.ui;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.ide.navbar.ui.NewNavBarPanel;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.HintHint;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.util.CoroutinesKt;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a \u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u0014\u0010\u000f\u001a\u00020\u0007*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0002\u001a\u0014\u0010\u0012\u001a\u00020\u0013*\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a$\u0010\u0014\u001a\u00020\u0001*\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a8\u0006\u0015"}, d2={"showEditorHint", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "hint", "Lcom/intellij/ui/LightweightHint;", "showNonEditorHint", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "wrapNavbarPanel", "Ljavax/swing/JPanel;", "panel", "Lcom/intellij/ide/navbar/ui/NewNavBarPanel;", "createHint", "Lkotlinx/coroutines/CoroutineScope;", "contents", "guessEvenBetterPopupLocation", "Lcom/intellij/ui/awt/RelativePoint;", "showHint", "intellij.platform.lang.impl"})
public final class FloatingModeHelperKt {
    public static final void showHint(@NotNull CoroutineScope $this$showHint, @NotNull DataContext dataContext2, @NotNull Project project2, @NotNull NewNavBarPanel panel2) {
        Intrinsics.checkNotNullParameter((Object)$this$showHint, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dataContext2, (String)"dataContext");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
        JPanel wrappedPanel = FloatingModeHelperKt.wrapNavbarPanel(panel2);
        LightweightHint hint = FloatingModeHelperKt.createHint($this$showHint, wrappedPanel);
        panel2.setOnSizeChange(() -> FloatingModeHelperKt.showHint$lambda$0(hint, wrappedPanel));
        CoroutinesKt.awaitCancellationAndInvoke($this$showHint, (Function0<Unit>)((Function0)new Function0<Unit>(hint){
            final /* synthetic */ LightweightHint $hint;
            {
                this.$hint = $hint;
                super(0);
            }

            public final void invoke() {
                this.$hint.hide();
            }
        }));
        Editor editor2 = (Editor)dataContext2.getData(CommonDataKeys.EDITOR);
        if (editor2 != null) {
            FloatingModeHelperKt.showEditorHint(editor2, project2, hint);
        } else {
            FloatingModeHelperKt.showNonEditorHint(dataContext2, project2, hint);
        }
    }

    private static final void showEditorHint(Editor editor2, Project project2, LightweightHint hint) {
        JComponent jComponent = editor2.getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"editor.contentComponent");
        JComponent hintContainer = jComponent;
        Point point = AbstractPopup.getCenterOf((Component)hintContainer, (JComponent)hint.getComponent());
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getCenterOf(hintContainer, hint.component)");
        Point center = point;
        center.y -= hintContainer.getVisibleRect().height / 4;
        RelativePoint relativePoint = RelativePoint.fromScreen(center);
        Intrinsics.checkNotNullExpressionValue((Object)relativePoint, (String)"fromScreen(center)");
        RelativePoint showPoint = FloatingModeHelperKt.guessEvenBetterPopupLocation(relativePoint, project2);
        Point absoluteShowPoint = showPoint.getPointOn(hintContainer).getPoint();
        HintHint hintInfo = new HintHint(editor2, absoluteShowPoint);
        HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor2, absoluteShowPoint, 1, 0, true, hintInfo);
    }

    private static final void showNonEditorHint(DataContext dataContext2, Project project2, LightweightHint hint) {
        Component component2 = (Component)dataContext2.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT);
        if (component2 == null) {
            return;
        }
        Component contextComponent = component2;
        RelativePoint relativePoint = JBPopupFactory.getInstance().guessBestPopupLocation(dataContext2);
        Intrinsics.checkNotNullExpressionValue((Object)relativePoint, (String)"getInstance()\n    .guess\u2026opupLocation(dataContext)");
        RelativePoint showPoint = FloatingModeHelperKt.guessEvenBetterPopupLocation(relativePoint, project2);
        Component component3 = showPoint.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)component3, (String)"showPoint.component");
        Component component4 = component3;
        if (component4 instanceof JComponent && component4.isShowing()) {
            HintHint hintInfo = new HintHint(showPoint.getComponent(), showPoint.getPoint());
            hint.show((JComponent)component4, showPoint.getPoint().x, showPoint.getPoint().y, contextComponent instanceof JComponent ? (JComponent)contextComponent : null, hintInfo);
        }
    }

    private static final JPanel wrapNavbarPanel(NewNavBarPanel panel2) {
        JPanel jPanel;
        JPanel $this$wrapNavbarPanel_u24lambda_u241 = jPanel = new JPanel(new BorderLayout());
        boolean bl = false;
        $this$wrapNavbarPanel_u24lambda_u241.add(panel2);
        $this$wrapNavbarPanel_u24lambda_u241.setOpaque(true);
        if (ExperimentalUI.isNewUI()) {
            $this$wrapNavbarPanel_u24lambda_u241.setBorder(new JBEmptyBorder(JBUI.CurrentTheme.StatusBar.Breadcrumbs.floatingBorderInsets()));
            $this$wrapNavbarPanel_u24lambda_u241.setBackground(JBUI.CurrentTheme.StatusBar.Breadcrumbs.FLOATING_BACKGROUND);
        } else {
            $this$wrapNavbarPanel_u24lambda_u241.setBackground(UIUtil.getListBackground());
        }
        return jPanel;
    }

    private static final LightweightHint createHint(CoroutineScope $this$createHint, JPanel contents) {
        return new LightweightHint(contents, $this$createHint){
            final /* synthetic */ CoroutineScope $this_createHint;
            {
                this.$this_createHint = $receiver;
                super((JComponent)$contents);
                this.setForceShowAsPopup(true);
                this.setFocusRequestor($contents);
            }

            protected void onPopupCancel() {
                CoroutineScopeKt.cancel(this.$this_createHint, null);
            }
        };
    }

    private static final RelativePoint guessEvenBetterPopupLocation(RelativePoint $this$guessEvenBetterPopupLocation, Project project2) {
        if ($this$guessEvenBetterPopupLocation.getComponent() instanceof JComponent && $this$guessEvenBetterPopupLocation.getComponent().isShowing()) {
            return $this$guessEvenBetterPopupLocation;
        }
        IdeFrame ideFrame = WindowManager.getInstance().getIdeFrame(project2);
        Intrinsics.checkNotNull((Object)ideFrame);
        JComponent ideFrame2 = ideFrame.getComponent();
        JRootPane rootPane = UIUtil.getRootPane(ideFrame2);
        JBPopupFactory jBPopupFactory = JBPopupFactory.getInstance();
        JRootPane jRootPane = rootPane;
        Intrinsics.checkNotNull((Object)jRootPane);
        RelativePoint relativePoint = jBPopupFactory.guessBestPopupLocation((JComponent)jRootPane);
        Intrinsics.checkNotNullExpressionValue((Object)relativePoint, (String)"getInstance().guessBestPopupLocation(rootPane!!)");
        return relativePoint;
    }

    private static final void showHint$lambda$0(LightweightHint $hint, JPanel $wrappedPanel) {
        Intrinsics.checkNotNullParameter((Object)$hint, (String)"$hint");
        Intrinsics.checkNotNullParameter((Object)$wrappedPanel, (String)"$wrappedPanel");
        $hint.setSize($wrappedPanel.getPreferredSize());
    }
}

