/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navbar.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.navbar.NavBarItemPresentation;
import com.intellij.ide.navbar.ui.NavBarContextMenuActionGroup;
import com.intellij.ide.navbar.ui.NavBarDialogFocusListener;
import com.intellij.ide.navbar.ui.NavBarItemComponent;
import com.intellij.ide.navbar.ui.NavBarItemComponentTabKeyListener;
import com.intellij.ide.navbar.ui.NewNavBarPanel;
import com.intellij.ide.navbar.ui.UiKt;
import com.intellij.ide.navbar.vm.NavBarItemVm;
import com.intellij.ide.navigationToolbar.ui.AbstractNavBarUI;
import com.intellij.ide.navigationToolbar.ui.ImageType;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.IconManager;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.scale.UserScaleContext;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Function;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineStart;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u0000 02\u00020\u0001:\u0004/012B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0006\u0010!\u001a\u00020\u001aJ\b\u0010\"\u001a\u00020#H\u0016J\n\u0010$\u001a\u0004\u0018\u00010%H\u0016J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020'H\u0016J\n\u0010)\u001a\u0004\u0018\u00010*H\u0002J\u0010\u0010+\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020\u000fH\u0016J\b\u0010-\u001a\u00020\u000fH\u0014J\u0006\u0010.\u001a\u00020\u001aR \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0010R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0010R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\u00070\u0015\u00a2\u0006\u0002\b\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/intellij/ide/navbar/ui/NavBarItemComponent;", "Lcom/intellij/ui/SimpleColoredComponent;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "vm", "Lcom/intellij/ide/navbar/vm/NavBarItemVm;", "panel", "Lcom/intellij/ide/navbar/ui/NewNavBarPanel;", "(Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/ide/navbar/vm/NavBarItemVm;Lcom/intellij/ide/navbar/ui/NewNavBarPanel;)V", "cache", "", "Lcom/intellij/ide/navigationToolbar/ui/ImageType;", "Lcom/intellij/ui/scale/ScaleContext$Cache;", "Ljava/awt/image/BufferedImage;", "isFloating", "", "()Z", "isFocused", "isHovered", "isSelected", "text", "", "Lorg/jetbrains/annotations/Nls;", "getText", "()Ljava/lang/String;", "doPaint", "", "g", "Ljava/awt/Graphics2D;", "effectiveIcon", "Ljavax/swing/Icon;", "presentation", "Lcom/intellij/ide/navbar/NavBarItemPresentation;", "focusItem", "getAccessibleContext", "Ljavax/accessibility/AccessibleContext;", "getFont", "Ljava/awt/Font;", "getMinimumSize", "Ljava/awt/Dimension;", "getPreferredSize", "highlightColor", "Ljava/awt/Color;", "setOpaque", "isOpaque", "shouldDrawBackground", "update", "AccessibleNavBarItem", "Companion", "ItemMouseListener", "ItemPopupHandler", "intellij.platform.lang.impl"})
public final class NavBarItemComponent
extends SimpleColoredComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NavBarItemVm vm;
    @NotNull
    private final NewNavBarPanel panel;
    private boolean isHovered;
    @NotNull
    private final Map<ImageType, ScaleContext.Cache<BufferedImage>> cache;
    @NotNull
    private static final Icon CHEVRON_ICON;
    @NotNull
    private static final Icon MODULE_ICON;

    public NavBarItemComponent(@NotNull CoroutineScope cs, @NotNull NavBarItemVm vm2, @NotNull NewNavBarPanel panel2) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        Intrinsics.checkNotNullParameter((Object)vm2, (String)"vm");
        Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
        this.vm = vm2;
        this.panel = panel2;
        this.setOpaque(false);
        this.setIpad(UiKt.navBarItemInsets());
        if (ExperimentalUI.isNewUI()) {
            this.setIconTextGap(JBUIScale.scale(4));
        }
        this.setMyBorder(null);
        this.setBorder(null);
        if (Companion.isItemComponentFocusable$intellij_platform_lang_impl()) {
            this.setFocusable(true);
            this.setFocusTraversalKeysEnabled(false);
            this.addKeyListener(new NavBarItemComponentTabKeyListener(this.panel));
            if (this.isFloating()) {
                this.addFocusListener(new NavBarDialogFocusListener(this.panel));
            }
        } else {
            this.setFocusable(false);
        }
        this.setFont(RelativeFont.NORMAL.fromResource("NavBar.fontSizeOffset", 0).derive(this.getFont()));
        BuildersKt.launch(cs, CoroutinesKt.getEDT(Dispatchers.INSTANCE), CoroutineStart.UNDISPATCHED, (Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ NavBarItemComponent this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.vm.getSelected().collect((FlowCollector<Boolean>)new FlowCollector(){

                            @Nullable
                            public final Object emit(boolean it, @NotNull Continuation<? super Unit> $completion) {
                                this$0.update();
                                return Unit.INSTANCE;
                            }
                        }, (Continuation<?>)((Continuation)this));
                        if (object3 != object2) throw new KotlinNothingValueException();
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        this.addMouseListener((MouseListener)((Object)new ItemPopupHandler()));
        this.addMouseListener(new ItemMouseListener());
        this.cache = new EnumMap(ImageType.class);
    }

    @NotNull
    public final String getText() {
        return this.vm.getPresentation().getText();
    }

    private final boolean isFloating() {
        return this.panel.isFloating();
    }

    private final boolean isSelected() {
        return this.vm.getSelected().getValue();
    }

    private final boolean isFocused() {
        return this.panel.isItemFocused();
    }

    @Nullable
    public Font getFont() {
        return UiKt.navBarItemFont();
    }

    public void setOpaque(boolean isOpaque) {
        super.setOpaque(false);
    }

    @NotNull
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @NotNull
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"super.getPreferredSize()");
        Dimension size = dimension;
        Dimension offsets2 = new Dimension();
        JBInsets.addTo(offsets2, UiKt.navBarItemPadding(this.isFloating()));
        boolean newUI = ExperimentalUI.isNewUI();
        offsets2.width = newUI ? offsets2.width + (this.vm.isFirst() ? 0 : CHEVRON_ICON.getIconWidth() + JBUI.CurrentTheme.StatusBar.Breadcrumbs.CHEVRON_INSET.get()) : offsets2.width + (AbstractNavBarUI.getDecorationOffset() + (this.vm.isFirst() ? AbstractNavBarUI.getFirstElementLeftOffset() : 0));
        return new Dimension(size.width + offsets2.width, size.height + offsets2.height);
    }

    public final void focusItem() {
        JComponent focusComponent = this.isFocusable() ? (JComponent)((Object)this) : (JComponent)this.panel;
        IdeFocusManager.getInstance((Project)this.panel.getProject()).requestFocus((Component)focusComponent, true);
    }

    public final void update() {
        Color color;
        this.clear();
        boolean selected = this.isSelected();
        boolean focused = this.isFocused();
        NavBarItemPresentation presentation2 = this.vm.getPresentation();
        SimpleTextAttributes attributes = presentation2.getTextAttributes();
        if (!ExperimentalUI.isNewUI()) {
            color = UiKt.navBarItemForeground(selected, focused, this.vm.isInactive());
            if (color == null) {
                color = attributes.getFgColor();
            }
        } else {
            color = this.isHovered ? JBUI.CurrentTheme.StatusBar.Breadcrumbs.HOVER_FOREGROUND : (selected ? (focused ? JBUI.CurrentTheme.StatusBar.Breadcrumbs.SELECTION_FOREGROUND : JBUI.CurrentTheme.StatusBar.Breadcrumbs.SELECTION_INACTIVE_FOREGROUND) : (this.isFloating() ? JBUI.CurrentTheme.StatusBar.Breadcrumbs.FLOATING_FOREGROUND : JBUI.CurrentTheme.StatusBar.Breadcrumbs.FOREGROUND));
        }
        Color fg = color;
        Color bg = UiKt.navBarItemBackground(selected, focused);
        Color waveColor = ExperimentalUI.isNewUI() ? null : attributes.getWaveColor();
        int style = ExperimentalUI.isNewUI() ? 0 : attributes.getStyle();
        this.setIcon(this.effectiveIcon(presentation2));
        this.setBackground(bg);
        this.append(presentation2.getText(), new SimpleTextAttributes(bg, fg, waveColor, style));
    }

    private final Icon effectiveIcon(NavBarItemPresentation presentation2) {
        return ExperimentalUI.isNewUI() && this.vm.isModuleContentRoot() ? MODULE_ICON : (Registry.is("navBar.show.icons") || this.vm.isLast() || presentation2.getHasContainingFile() ? presentation2.getIcon() : null);
    }

    protected boolean shouldDrawBackground() {
        return this.isSelected() && this.isFocused();
    }

    protected void doPaint(@NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        JBInsets jBInsets = JBInsets.create(UiKt.navBarItemPadding(this.isFloating()));
        Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"create(navBarItemPadding(isFloating))");
        JBInsets paddings = jBInsets;
        boolean isFirst = this.vm.isFirst();
        if (ExperimentalUI.isNewUI()) {
            Icon icon2;
            Color highlightColor;
            Rectangle rect2 = new Rectangle(this.getSize());
            JBInsets.removeFrom(rect2, (Insets)paddings);
            int offset2 = rect2.x;
            if (!isFirst) {
                CHEVRON_ICON.paintIcon((Component)((Object)this), g, offset2, rect2.y + (rect2.height - CHEVRON_ICON.getIconHeight()) / 2);
                int delta = CHEVRON_ICON.getIconWidth() + JBUI.CurrentTheme.StatusBar.Breadcrumbs.CHEVRON_INSET.get();
                offset2 += delta;
                rect2.width -= delta;
            }
            if ((highlightColor = this.highlightColor()) != null) {
                AbstractNavBarUI.paintHighlight(g, new Rectangle(offset2, rect2.y, rect2.width, rect2.height), highlightColor);
            }
            if ((icon2 = this.getIcon()) == null) {
                offset2 += this.getIpad().left;
            } else {
                icon2.paintIcon((Component)((Object)this), g, offset2 += this.getIpad().left, rect2.y + (rect2.height - icon2.getIconHeight()) / 2 + (Intrinsics.areEqual((Object)icon2, (Object)MODULE_ICON) ? JBUI.scale(1) : 0));
                offset2 += icon2.getIconWidth();
                offset2 += this.getIconTextGap();
            }
            this.doPaintText(g, offset2, false);
        } else {
            boolean toolbarVisible = UISettings.Companion.getInstance().getShowMainToolbar();
            boolean selected = this.isSelected() && this.isFocused();
            boolean nextSelected = this.vm.isNextSelected() && this.isFocused();
            ImageType imageType = ImageType.from(this.isFloating(), toolbarVisible, selected, nextSelected);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)imageType), (String)"from(isFloating, toolbar\u2026, selected, nextSelected)");
            ImageType type = imageType;
            ScaleContext.Cache cache2 = this.cache.computeIfAbsent(type, arg_0 -> NavBarItemComponent.doPaint$lambda$0((Function1)new Function1<ImageType, ScaleContext.Cache<BufferedImage>>(this, toolbarVisible, selected, nextSelected){
                final /* synthetic */ NavBarItemComponent this$0;
                final /* synthetic */ boolean $toolbarVisible;
                final /* synthetic */ boolean $selected;
                final /* synthetic */ boolean $nextSelected;
                {
                    this.this$0 = $receiver;
                    this.$toolbarVisible = $toolbarVisible;
                    this.$selected = $selected;
                    this.$nextSelected = $nextSelected;
                    super(1);
                }

                @NotNull
                public final ScaleContext.Cache<BufferedImage> invoke(@NotNull ImageType it) {
                    Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                    return new ScaleContext.Cache<BufferedImage>((Function<ScaleContext, BufferedImage>)((Function<Object, BufferedImage>)arg_0 -> doPaint.imageCache.1.invoke$lambda$0((Function1)new Function1<ScaleContext, BufferedImage>(this.this$0, this.$toolbarVisible, this.$selected, this.$nextSelected){
                        final /* synthetic */ NavBarItemComponent this$0;
                        final /* synthetic */ boolean $toolbarVisible;
                        final /* synthetic */ boolean $selected;
                        final /* synthetic */ boolean $nextSelected;
                        {
                            this.this$0 = $receiver;
                            this.$toolbarVisible = $toolbarVisible;
                            this.$selected = $selected;
                            this.$nextSelected = $nextSelected;
                            super(1);
                        }

                        public final BufferedImage invoke(@NotNull ScaleContext ctx) {
                            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                            return AbstractNavBarUI.drawToBuffer((Component)((Object)this.this$0), ctx, NavBarItemComponent.access$isFloating(this.this$0), this.$toolbarVisible, this.$selected, this.$nextSelected, NavBarItemComponent.access$getVm$p(this.this$0).isLast());
                        }
                    }, arg_0)));
                }

                private static final BufferedImage invoke$lambda$0(Function1 $tmp0, Object p0) {
                    Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                    return (BufferedImage)$tmp0.invoke(p0);
                }
            }, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)cache2, (String)"override fun doPaint(g: \u2026tOffset, false)\n    }\n  }");
            ScaleContext.Cache imageCache2 = cache2;
            BufferedImage bufferedImage = (BufferedImage)imageCache2.getOrProvide((UserScaleContext)ScaleContext.create(g));
            if (bufferedImage == null) {
                return;
            }
            BufferedImage image = bufferedImage;
            StartupUiUtil.drawImage((Graphics)g, (Image)image, 0, 0, null);
            int offset3 = isFirst ? AbstractNavBarUI.getFirstElementLeftOffset() : 0;
            int textOffset = paddings.width() + offset3;
            Icon icon3 = this.getIcon();
            if (icon3 != null) {
                int iconOffset = paddings.left + offset3;
                icon3.paintIcon((Component)((Object)this), g, iconOffset, (this.getHeight() - icon3.getIconHeight()) / 2);
                textOffset += icon3.getIconWidth();
            }
            this.doPaintText(g, textOffset, false);
        }
    }

    private final Color highlightColor() {
        return this.isHovered ? JBUI.CurrentTheme.StatusBar.Breadcrumbs.HOVER_BACKGROUND : (this.isSelected() ? (this.isFocused() ? JBUI.CurrentTheme.StatusBar.Breadcrumbs.SELECTION_BACKGROUND : JBUI.CurrentTheme.StatusBar.Breadcrumbs.SELECTION_INACTIVE_BACKGROUND) : null);
    }

    @NotNull
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = (AccessibleContext)((Object)new AccessibleNavBarItem());
        }
        AccessibleContext accessibleContext = this.accessibleContext;
        Intrinsics.checkNotNullExpressionValue((Object)accessibleContext, (String)"accessibleContext");
        return accessibleContext;
    }

    private static final ScaleContext.Cache doPaint$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ScaleContext.Cache)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ boolean access$isFloating(NavBarItemComponent $this) {
        return $this.isFloating();
    }

    static {
        Icon icon2 = AllIcons.General.ChevronRight;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"ChevronRight");
        CHEVRON_ICON = icon2;
        Icon icon3 = IconManager.getInstance().getIcon("expui/nodes/module8x8.svg", AllIcons.class);
        Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"getInstance().getIcon(\"e\u2026g\", AllIcons::class.java)");
        MODULE_ICON = icon3;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\r\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tR\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/ide/navbar/ui/NavBarItemComponent$Companion;", "", "()V", "CHEVRON_ICON", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "MODULE_ICON", "isItemComponentFocusable", "", "isItemComponentFocusable$intellij_platform_lang_impl", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isItemComponentFocusable$intellij_platform_lang_impl() {
            return ScreenReader.isActive();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/ide/navbar/ui/NavBarItemComponent$ItemPopupHandler;", "Lcom/intellij/ui/PopupHandler;", "(Lcom/intellij/ide/navbar/ui/NavBarItemComponent;)V", "invokePopup", "", "comp", "Ljava/awt/Component;", "x", "", "y", "intellij.platform.lang.impl"})
    private final class ItemPopupHandler
    extends PopupHandler {
        public void invokePopup(@Nullable Component comp, int x, int y) {
            NavBarItemComponent.this.focusItem();
            NavBarItemComponent.this.vm.select();
            ActionPopupMenu actionPopupMenu = ActionManager.getInstance().createActionPopupMenu("NavBar", (ActionGroup)new NavBarContextMenuActionGroup());
            NavBarItemComponent navBarItemComponent = NavBarItemComponent.this;
            ActionPopupMenu it = actionPopupMenu;
            boolean bl = false;
            it.setTargetComponent((JComponent)navBarItemComponent.panel);
            actionPopupMenu.getComponent().show(NavBarItemComponent.this.panel, NavBarItemComponent.this.getX() + x, NavBarItemComponent.this.getY() + y);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ide/navbar/ui/NavBarItemComponent$ItemMouseListener;", "Ljava/awt/event/MouseAdapter;", "(Lcom/intellij/ide/navbar/ui/NavBarItemComponent;)V", "click", "", "e", "Ljava/awt/event/MouseEvent;", "mouseEntered", "mouseExited", "mousePressed", "mouseReleased", "intellij.platform.lang.impl"})
    private final class ItemMouseListener
    extends MouseAdapter {
        @Override
        public void mousePressed(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (!SystemInfo.isWindows) {
                this.click(e);
            }
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (SystemInfo.isWindows) {
                this.click(e);
            }
        }

        private final void click(MouseEvent e) {
            if (e.isConsumed()) {
                return;
            }
            if (e.isPopupTrigger()) {
                return;
            }
            if (e.getClickCount() == 1) {
                NavBarItemComponent.this.focusItem();
                NavBarItemComponent.this.vm.select();
                NavBarItemComponent.this.vm.showPopup();
                e.consume();
            } else if (e.getClickCount() == 2 && e.getButton() == 1) {
                NavBarItemComponent.this.vm.activate();
                e.consume();
            }
        }

        @Override
        public void mouseEntered(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (e.isConsumed() || !ExperimentalUI.isNewUI()) {
                return;
            }
            NavBarItemComponent.this.isHovered = true;
            NavBarItemComponent.this.update();
            e.consume();
        }

        @Override
        public void mouseExited(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (e.isConsumed() || !ExperimentalUI.isNewUI()) {
                return;
            }
            NavBarItemComponent.this.isHovered = false;
            NavBarItemComponent.this.update();
            e.consume();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0003H\u0016J\b\u0010\n\u001a\u00020\bH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ide/navbar/ui/NavBarItemComponent$AccessibleNavBarItem;", "Lcom/intellij/ui/SimpleColoredComponent$AccessibleSimpleColoredComponent;", "Lcom/intellij/ui/SimpleColoredComponent;", "Ljavax/accessibility/AccessibleAction;", "(Lcom/intellij/ide/navbar/ui/NavBarItemComponent;)V", "doAccessibleAction", "", "i", "", "getAccessibleAction", "getAccessibleActionCount", "getAccessibleActionDescription", "", "getAccessibleRole", "Ljavax/accessibility/AccessibleRole;", "intellij.platform.lang.impl"})
    private final class AccessibleNavBarItem
    extends SimpleColoredComponent.AccessibleSimpleColoredComponent
    implements AccessibleAction {
        public AccessibleNavBarItem() {
            super((SimpleColoredComponent)NavBarItemComponent.this);
        }

        @NotNull
        public AccessibleRole getAccessibleRole() {
            AccessibleRole accessibleRole = AccessibleRole.PUSH_BUTTON;
            Intrinsics.checkNotNullExpressionValue((Object)accessibleRole, (String)"PUSH_BUTTON");
            return accessibleRole;
        }

        @NotNull
        public AccessibleAction getAccessibleAction() {
            return this;
        }

        @Override
        public int getAccessibleActionCount() {
            return 1;
        }

        @Override
        @Nullable
        public String getAccessibleActionDescription(int i2) {
            if (i2 == 0) {
                return UIManager.getString("AbstractButton.clickText");
            }
            return null;
        }

        @Override
        public boolean doAccessibleAction(int i2) {
            if (i2 == 0) {
                NavBarItemComponent.this.vm.select();
                return true;
            }
            return false;
        }
    }
}

