/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navbar.ui;

import com.intellij.ide.navbar.NavBarItemPresentation;
import com.intellij.ide.navbar.ui.UiKt;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ide/navbar/ui/NavBarPopupItemComponent;", "Lcom/intellij/ui/SimpleColoredComponent;", "presentation", "Lcom/intellij/ide/navbar/NavBarItemPresentation;", "selected", "", "floating", "(Lcom/intellij/ide/navbar/NavBarItemPresentation;ZZ)V", "getFont", "Ljava/awt/Font;", "getMinimumSize", "Ljava/awt/Dimension;", "setOpaque", "", "isOpaque", "intellij.platform.lang.impl"})
public final class NavBarPopupItemComponent
extends SimpleColoredComponent {
    public NavBarPopupItemComponent(@NotNull NavBarItemPresentation presentation2, boolean selected, boolean floating) {
        Color color;
        Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
        SimpleTextAttributes attributes = presentation2.getTextAttributes();
        Color bg = UiKt.navBarItemBackground(selected, true);
        if (ExperimentalUI.isNewUI()) {
            color = selected ? JBUI.CurrentTheme.StatusBar.Breadcrumbs.SELECTION_FOREGROUND : (floating ? JBUI.CurrentTheme.StatusBar.Breadcrumbs.FLOATING_FOREGROUND : JBUI.CurrentTheme.List.foreground(false, true));
        } else {
            color = UiKt.navBarItemForeground(selected, true, false);
            if (color == null) {
                color = attributes.getFgColor();
            }
        }
        Color fg = color;
        this.setOpaque(false);
        this.setIpad(UiKt.navBarPopupItemInsets());
        this.setIcon(presentation2.getIcon());
        this.setIconOpaque(false);
        this.setFocusBorderAroundIcon(true);
        if (ExperimentalUI.isNewUI()) {
            this.setIconTextGap(JBUIScale.scale(4));
        }
        this.setBackground(bg);
        this.setFont(RelativeFont.NORMAL.fromResource("NavBar.fontSizeOffset", 0).derive(this.getFont()));
        int style = ExperimentalUI.isNewUI() ? 0 : attributes.getStyle();
        Color waveColor = ExperimentalUI.isNewUI() ? null : attributes.getWaveColor();
        String string2 = presentation2.getPopupText();
        if (string2 == null) {
            string2 = presentation2.getText();
        }
        this.append(string2, new SimpleTextAttributes(bg, fg, waveColor, style));
    }

    @Nullable
    public Font getFont() {
        return UiKt.navBarItemFont();
    }

    public void setOpaque(boolean isOpaque) {
        super.setOpaque(false);
    }

    @NotNull
    public Dimension getMinimumSize() {
        Dimension dimension = this.getPreferredSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"preferredSize");
        return dimension;
    }
}

