/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navbar.ui;

import com.intellij.ide.ui.UISettings;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.Gray;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\u001a\"\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H\u0000\u001a\u0018\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0000\u001a\n\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0000\u001a\"\u0010\t\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H\u0000\u001a\b\u0010\n\u001a\u00020\u000bH\u0000\u001a\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0003H\u0000\u001a\b\u0010\u000e\u001a\u00020\u000bH\u0000\u001a\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003H\u0000\u00a8\u0006\u0012"}, d2={"defaultNavBarItemForeground", "Ljava/awt/Color;", "selected", "", "focused", "inactive", "navBarItemBackground", "navBarItemFont", "Ljava/awt/Font;", "navBarItemForeground", "navBarItemInsets", "Ljava/awt/Insets;", "navBarItemPadding", "floating", "navBarPopupItemInsets", "navBarPopupOffset", "", "firstItem", "intellij.platform.lang.impl"})
public final class UiKt {
    @NotNull
    public static final Color navBarItemBackground(boolean selected, boolean focused) {
        Color color;
        if (selected && focused) {
            Color color2 = UIUtil.getListSelectionBackground(true);
            color = color2;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"{\n    UIUtil.getListSelectionBackground(true)\n  }");
        } else {
            Color color3 = UIUtil.getListBackground();
            color = color3;
            Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"{\n    UIUtil.getListBackground()\n  }");
        }
        return color;
    }

    @Nullable
    public static final Color navBarItemForeground(boolean selected, boolean focused, boolean inactive) {
        return StartupUiUtil.isUnderDarcula() ? (inactive ? (Color)Gray._140 : UiKt.defaultNavBarItemForeground(selected, focused, false)) : UiKt.defaultNavBarItemForeground(selected, focused, inactive);
    }

    @Nullable
    public static final Color defaultNavBarItemForeground(boolean selected, boolean focused, boolean inactive) {
        return selected && focused ? NamedColorUtil.getListSelectionForeground(true) : (inactive ? NamedColorUtil.getInactiveTextColor() : null);
    }

    @Nullable
    public static final Font navBarItemFont() {
        if (!ExperimentalUI.isNewUI() && UISettings.Companion.getInstance().getUseSmallLabelsOnTabs()) {
            return RelativeFont.SMALL.derive(StartupUiUtil.getLabelFont());
        }
        return JBUI.CurrentTheme.StatusBar.font();
    }

    @NotNull
    public static final Insets navBarItemInsets() {
        Insets insets;
        if (ExperimentalUI.isNewUI()) {
            JBInsets jBInsets = JBUI.insets("StatusBar.Breadcrumbs.itemBackgroundInsets", ExperimentalUI.isNewUI() ? JBUI.insets(2, 4) : JBUI.insets(1));
            Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"{\n    JBUI.insets(\"Statu\u2026 else JBUI.insets(1))\n  }");
            insets = jBInsets;
        } else {
            JBInsets jBInsets = JBInsets.emptyInsets();
            Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"{\n    JBInsets.emptyInsets()\n  }");
            insets = jBInsets;
        }
        return insets;
    }

    @NotNull
    public static final Insets navBarPopupItemInsets() {
        JBInsets jBInsets = JBInsets.create(1, 2);
        Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"create(1, 2)");
        return jBInsets;
    }

    @NotNull
    public static final Insets navBarItemPadding(boolean floating) {
        if (!ExperimentalUI.isNewUI()) {
            JBInsets jBInsets = JBUI.insets(3);
            Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"insets(3)");
            return jBInsets;
        }
        if (floating) {
            JBInsets jBInsets = JBUI.insets("StatusBar.Breadcrumbs.floatingItemInsets", JBUI.insets(1));
            Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"insets(\"StatusBar.Breadc\u2026mInsets\", JBUI.insets(1))");
            return jBInsets;
        }
        JBInsets jBInsets = JBUI.CurrentTheme.StatusBar.Breadcrumbs.itemInsets();
        Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"itemInsets()");
        return jBInsets;
    }

    public static final int navBarPopupOffset(boolean firstItem) {
        return firstItem ? 0 : JBUIScale.scale(5);
    }
}

