/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar;

import com.intellij.ide.navbar.ide.NavBarIdeUtil;
import com.intellij.ide.navbar.ide.NavBarService;
import com.intellij.ide.navigationToolbar.NavBarContainer;
import com.intellij.ide.navigationToolbar.NavBarLeftSideExtension;
import com.intellij.ide.navigationToolbar.NavBarPanel;
import com.intellij.ide.navigationToolbar.NavBarRootPaneExtension;
import com.intellij.ide.navigationToolbar.ReusableNavBarPanel;
import com.intellij.ide.navigationToolbar.ui.NavBarUIManager;
import com.intellij.ide.ui.NavBarLocation;
import com.intellij.ide.ui.ToolbarSettings;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.ide.ui.customization.CustomisedActionGroup;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.StatusBarCentralWidgetProvider;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBScrollBar;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.hover.HoverListener;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.concurrent.CompletableFuture;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class MyNavBarWrapperPanel
extends NavBarRootPaneExtension.NavBarWrapperPanel
implements StatusBarCentralWidgetProvider {
    private final Project myProject;
    private JComponent myNavBarPanel;
    private JPanel myRunPanel;
    private Boolean myNavToolbarGroupExist;
    JComponent myNavigationBar;
    JScrollPane myScrollPane;

    MyNavBarWrapperPanel(Project project2) {
        super(new BorderLayout());
        this.myProject = project2;
        UISettings settings = UISettings.getInstance();
        if (!ExperimentalUI.isNewUI() || settings.getShowNavigationBar() && settings.getNavBarLocation() == NavBarLocation.TOP) {
            this.add((Component)this.getNavBarPanel(), "Center");
        } else {
            this.setVisible(false);
        }
        this.revalidate();
        this.uiSettingsChanged(settings);
    }

    @NotNull
    public JComponent createCentralStatusBarComponent() {
        JComponent jComponent = this.getNavBarPanel();
        if (jComponent == null) {
            MyNavBarWrapperPanel.$$$reportNull$$$0(0);
        }
        return jComponent;
    }

    private JComponent getNavBarPanel() {
        if (this.myNavBarPanel != null) {
            return this.myNavBarPanel;
        }
        if (NavBarIdeUtil.isNavbarV2Enabled()) {
            this.myNavigationBar = NavBarService.getInstance(this.myProject).createNavBarPanel();
        } else {
            this.myNavigationBar = new ReusableNavBarPanel(this.myProject, true);
            ((NavBarPanel)this.myNavigationBar).getModel().setFixedComponent(true);
        }
        this.putClientProperty("NavBarPanel", this.myNavigationBar);
        this.myScrollPane = ScrollPaneFactory.createScrollPane((Component)this.myNavigationBar);
        this.updateScrollBarFlippedState(null);
        this.myNavBarPanel = new NavBarContainer((LayoutManager)new BorderLayout(), this);
        this.myNavBarPanel.add((Component)this.myScrollPane, "Center");
        this.myNavBarPanel.setOpaque(!ExperimentalUI.isNewUI());
        this.myNavBarPanel.updateUI();
        if (ExperimentalUI.isNewNavbar()) {
            HoverListener hoverListener = new HoverListener(){

                public void mouseEntered(@NotNull Component component2, int x, int y) {
                    if (component2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    MyNavBarWrapperPanel.this.toggleScrollBar(true);
                }

                public void mouseMoved(@NotNull Component component2, int x, int y) {
                    if (component2 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                }

                public void mouseExited(@NotNull Component component2) {
                    if (component2 == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    MyNavBarWrapperPanel.this.toggleScrollBar(false);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "component";
                    objectArray2[1] = "com/intellij/ide/navigationToolbar/MyNavBarWrapperPanel$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "mouseEntered";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "mouseMoved";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "mouseExited";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            hoverListener.addTo(this.myNavBarPanel);
        }
        return this.myNavBarPanel;
    }

    public void uiSettingsChanged(@NotNull UISettings uiSettings) {
        Component c2;
        if (uiSettings == null) {
            MyNavBarWrapperPanel.$$$reportNull$$$0(1);
        }
        this.toggleRunPanel(MyNavBarWrapperPanel.isShowToolPanel(uiSettings));
        this.toggleNavPanel(uiSettings);
        if (NavBarIdeUtil.isNavbarV2Enabled()) {
            NavBarService.getInstance(this.myProject).uiSettingsChanged(uiSettings);
        }
        if (this.myNavigationBar == null) {
            return;
        }
        if (this.myNavigationBar instanceof NavBarPanel) {
            ((NavBarPanel)this.myNavigationBar).updateState(uiSettings.getShowNavigationBar());
        }
        boolean visible = NavBarIdeUtil.isNavbarShown(uiSettings);
        if (ExperimentalUI.isNewUI()) {
            this.myScrollPane.setVisible(visible);
        }
        this.myNavigationBar.revalidate();
        this.setVisible(visible);
        this.revalidate();
        this.repaint();
        if (this.getComponentCount() > 0 && (c2 = this.getComponent(0)) instanceof JComponent) {
            ((JComponent)c2).setOpaque(false);
        }
    }

    @Override
    public Insets getInsets() {
        return NavBarUIManager.getUI().getWrapperPanelInsets(super.getInsets());
    }

    private void updateScrollBarFlippedState(@Nullable NavBarLocation location2) {
        if (ExperimentalUI.isNewNavbar() && this.myScrollPane != null) {
            if (location2 == null) {
                location2 = UISettings.getInstance().getNavBarLocation();
            }
            JBScrollPane.Flip flipState = location2 == NavBarLocation.BOTTOM ? JBScrollPane.Flip.VERTICAL : JBScrollPane.Flip.NONE;
            this.myScrollPane.putClientProperty(JBScrollPane.Flip.class, flipState);
        }
    }

    private static boolean isShowToolPanel(@NotNull UISettings uiSettings) {
        if (uiSettings == null) {
            MyNavBarWrapperPanel.$$$reportNull$$$0(2);
        }
        if (!ExperimentalUI.isNewUI() && !uiSettings.getShowMainToolbar() && NavBarIdeUtil.isNavbarShown(uiSettings)) {
            ToolbarSettings toolbarSettings = ToolbarSettings.getInstance();
            return !toolbarSettings.isVisible() || !toolbarSettings.isAvailable();
        }
        return false;
    }

    private static void alignVertically(Container container) {
        if (container.getComponentCount() == 1) {
            Component c2 = container.getComponent(0);
            Insets insets = container.getInsets();
            Dimension d = c2.getPreferredSize();
            Rectangle r = container.getBounds();
            c2.setBounds(insets.left, (r.height - d.height - insets.top - insets.bottom) / 2 + insets.top, r.width - insets.left - insets.right, d.height);
        }
    }

    private static boolean isNeedGap(AnAction group2) {
        AnAction firstAction = MyNavBarWrapperPanel.getFirstAction(group2);
        return firstAction instanceof ComboBoxAction;
    }

    @Nullable
    private static AnAction getFirstAction(AnAction group2) {
        if (group2 instanceof DefaultActionGroup) {
            AnAction firstAction = null;
            for (AnAction action2 : ((DefaultActionGroup)group2).getChildActionsOrStubs()) {
                if (!(action2 instanceof DefaultActionGroup)) {
                    if (action2 instanceof Separator || action2 instanceof ActionGroup) continue;
                    firstAction = action2;
                    break;
                }
                firstAction = MyNavBarWrapperPanel.getFirstAction(action2);
                if (firstAction != null) break;
            }
            return firstAction;
        }
        if (group2 instanceof CustomisedActionGroup) {
            return ((CustomisedActionGroup)group2).getFirstAction();
        }
        return null;
    }

    private boolean runToolbarExists() {
        if (this.myNavToolbarGroupExist == null) {
            AnAction correctedAction = CustomActionsSchema.getInstance().getCorrectedAction("NavBarToolBar");
            this.myNavToolbarGroupExist = correctedAction instanceof DefaultActionGroup && ((DefaultActionGroup)correctedAction).getChildrenCount() > 0 || correctedAction instanceof CustomisedActionGroup && ((CustomisedActionGroup)correctedAction).getFirstAction() != null;
        }
        return this.myNavToolbarGroupExist;
    }

    private void toggleNavPanel(UISettings settings) {
        boolean show2;
        boolean bl = ExperimentalUI.isNewUI() ? settings.getShowNavigationBar() && settings.getNavBarLocation() == NavBarLocation.TOP : (show2 = NavBarIdeUtil.isNavbarShown(settings));
        if (show2 == this.isNavBarVisible()) {
            return;
        }
        if (show2) {
            ApplicationManager.getApplication().invokeLater(() -> {
                this.add((Component)this.getNavBarPanel(), "Center");
                this.myNavBarPanel.updateUI();
            });
        } else {
            Component c2 = ((BorderLayout)this.getLayout()).getLayoutComponent("Center");
            if (c2 != null) {
                this.remove(c2);
            }
        }
        this.updateScrollBarFlippedState(settings.getNavBarLocation());
        this.setVisible(show2);
    }

    private boolean isNavBarVisible() {
        return ((BorderLayout)this.getLayout()).getLayoutComponent("Center") == this.getNavBarPanel();
    }

    private void toggleRunPanel(boolean show2) {
        CompletableFuture.supplyAsync(() -> CustomActionsSchema.getInstance().getCorrectedAction("NavBarToolBar"), AppExecutorUtil.getAppExecutorService()).thenAcceptAsync(action2 -> {
            if (show2 && this.myRunPanel == null && this.runToolbarExists()) {
                if (this.myRunPanel != null) {
                    this.remove(this.myRunPanel);
                    this.myRunPanel = null;
                }
                ActionManager manager = ActionManager.getInstance();
                if (action2 instanceof ActionGroup) {
                    ActionToolbar actionToolbar = manager.createActionToolbar("NavBarToolbar", (ActionGroup)action2, true);
                    actionToolbar.setTargetComponent(null);
                    this.myRunPanel = new JPanel(new BorderLayout()){

                        @Override
                        public void doLayout() {
                            MyNavBarWrapperPanel.alignVertically(this);
                        }
                    };
                    this.myRunPanel.setOpaque(false);
                    this.myRunPanel.add((Component)actionToolbar.getComponent(), "Center");
                    boolean needGap = MyNavBarWrapperPanel.isNeedGap(action2);
                    this.myRunPanel.setBorder(JBUI.Borders.emptyLeft(needGap ? 5 : 1));
                    NavBarLeftSideExtension.EP_NAME.forEachExtensionSafe(extension2 -> extension2.process(this, this.myProject));
                    this.add((Component)this.myRunPanel, "East");
                }
            } else if (!show2 && this.myRunPanel != null) {
                this.remove(this.myRunPanel);
                this.myRunPanel = null;
            }
        }, command2 -> ApplicationManager.getApplication().invokeLater(command2, this.myProject.getDisposed()));
    }

    void toggleScrollBar(boolean isOn) {
        JScrollBar scrollBar = this.myScrollPane.getHorizontalScrollBar();
        if (scrollBar instanceof JBScrollBar) {
            ((JBScrollBar)scrollBar).toggle(isOn);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/navigationToolbar/MyNavBarWrapperPanel";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createCentralStatusBarComponent";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/navigationToolbar/MyNavBarWrapperPanel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "uiSettingsChanged";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isShowToolPanel";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2 -> new IllegalArgumentException(string2);
        };
    }
}

