/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar;

import com.intellij.ide.navbar.ide.NavBarIdeUtil;
import com.intellij.ide.navigationToolbar.MyNavBarWrapperPanel;
import com.intellij.ide.navigationToolbar.NavBarBorder;
import com.intellij.ide.navigationToolbar.NavBarPanel;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.wm.impl.status.InfoAndProgressPanel;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBThinOverlappingScrollBar;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

final class NavBarContainer
extends JPanel
implements InfoAndProgressPanel.ScrollableToSelected {
    private final MyNavBarWrapperPanel panel;

    NavBarContainer(@NotNull LayoutManager layout, @NotNull MyNavBarWrapperPanel panel2) {
        if (layout == null) {
            NavBarContainer.$$$reportNull$$$0(0);
        }
        if (panel2 == null) {
            NavBarContainer.$$$reportNull$$$0(1);
        }
        super(layout);
        this.panel = panel2;
        this.updateUI();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        JScrollPane navBar = this.panel.myScrollPane;
        Rectangle r = navBar.getBounds();
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.translate(r.x, r.y);
        g2d.dispose();
    }

    @Override
    public void doLayout() {
        Rectangle r = this.getBounds();
        Insets insets = this.getInsets();
        int x = insets.left;
        JScrollPane scrollPane = this.panel.myScrollPane;
        if (scrollPane == null || !scrollPane.isVisible()) {
            return;
        }
        int navBarHeight = ((Component)scrollPane).getPreferredSize().height;
        if (ExperimentalUI.isNewNavbar()) {
            navBarHeight = r.height;
        }
        scrollPane.setBounds(x, (r.height - navBarHeight) / 2, r.width - insets.left - insets.right, navBarHeight);
    }

    @Override
    public void updateUI() {
        Border border;
        if (this.panel == null) {
            return;
        }
        super.updateUI();
        JScrollPane scrollPane = this.panel.myScrollPane;
        if (scrollPane == null || this.panel.myNavigationBar == null) {
            return;
        }
        UISettings settings = UISettings.getInstance();
        Border border2 = border = !ExperimentalUI.isNewUI() || settings.getShowNavigationBar() ? new NavBarBorder() : JBUI.Borders.empty();
        if (ExperimentalUI.isNewNavbar()) {
            scrollPane.setHorizontalScrollBar((JScrollBar)new JBThinOverlappingScrollBar(0));
            if (scrollPane instanceof JBScrollPane) {
                ((JBScrollPane)scrollPane).setOverlappingScrollBar(true);
            }
            scrollPane.setHorizontalScrollBarPolicy(30);
            this.panel.toggleScrollBar(false);
        } else {
            scrollPane.setHorizontalScrollBar(null);
        }
        scrollPane.setVerticalScrollBarPolicy(21);
        scrollPane.setBorder(border);
        scrollPane.setOpaque(false);
        scrollPane.getViewport().setOpaque(false);
        scrollPane.setViewportBorder(null);
        if (ExperimentalUI.isNewUI()) {
            ClientProperty.put(scrollPane, JBScrollPane.FORCE_HORIZONTAL_SCROLL, Boolean.valueOf(true));
            boolean visible = NavBarIdeUtil.isNavbarShown(settings);
            scrollPane.setVisible(visible);
            if (this.panel.myNavigationBar instanceof NavBarPanel) {
                ((NavBarPanel)this.panel.myNavigationBar).updateState(visible);
            }
        }
        this.panel.myNavigationBar.setBorder(null);
    }

    public void updateAutoscrollLimit(InfoAndProgressPanel.AutoscrollLimit limit2) {
        JComponent navigationBar = this.panel.myNavigationBar;
        if (navigationBar instanceof NavBarPanel) {
            ((NavBarPanel)navigationBar).updateAutoscrollLimit(limit2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "layout";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "panel";
                break;
            }
        }
        objectArray[1] = "com/intellij/ide/navigationToolbar/NavBarContainer";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

