/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.ide.CopyPasteDelegator;
import com.intellij.ide.CopyPasteSupport;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeView;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDSupport;
import com.intellij.ide.dnd.TransferableWrapper;
import com.intellij.ide.impl.ProjectUtilKt;
import com.intellij.ide.navbar.actions.NavBarActionHandler;
import com.intellij.ide.navigationToolbar.MyNavBarWrapperPanel;
import com.intellij.ide.navigationToolbar.NavBarIdeView;
import com.intellij.ide.navigationToolbar.NavBarItem;
import com.intellij.ide.navigationToolbar.NavBarListener;
import com.intellij.ide.navigationToolbar.NavBarModel;
import com.intellij.ide.navigationToolbar.NavBarModelExtension;
import com.intellij.ide.navigationToolbar.NavBarPopup;
import com.intellij.ide.navigationToolbar.NavBarPresentation;
import com.intellij.ide.navigationToolbar.NavBarUpdateQueue;
import com.intellij.ide.navigationToolbar.ui.NavBarUI;
import com.intellij.ide.navigationToolbar.ui.NavBarUIManager;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.ide.ui.NavBarLocation;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.ide.util.DeleteHandler;
import com.intellij.internal.statistic.service.fus.collectors.UIEventLogger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.actions.ModuleDeleteProvider;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.status.InfoAndProgressPanel;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.Gray;
import com.intellij.ui.HintHint;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.ListenerUtil;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.PopupOwner;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.border.LineBorder;
import javax.swing.plaf.PanelUI;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class NavBarPanel
extends JPanel
implements DataProvider,
PopupOwner,
Disposable,
Queryable,
InfoAndProgressPanel.ScrollableToSelected,
NavBarActionHandler {
    private final NavBarModel myModel;
    private final NavBarPresentation myPresentation;
    protected final Project myProject;
    private final ArrayList<NavBarItem> myList;
    private final IdeView myIdeView;
    private FocusListener myNavBarItemFocusListener;
    private LightweightHint myHint;
    private NavBarPopup myNodePopup;
    private JComponent myHintContainer;
    private Component myContextComponent;
    private final NavBarUpdateQueue myUpdateQueue;
    private final Set<PsiFile> myForcedFileUpdateQueue;
    private NavBarItem myContextObject;
    private boolean myDisposed;
    private RelativePoint myLocationCache;
    private Selection mySelection;
    private InfoAndProgressPanel.AutoscrollLimit myAutoscrollLimit;

    public NavBarPanel(@NotNull Project project2, boolean docked) {
        if (project2 == null) {
            NavBarPanel.$$$reportNull$$$0(0);
        }
        super(new FlowLayout(0, 0, 0));
        this.myList = new ArrayList();
        this.myHint = null;
        this.myNodePopup = null;
        this.myForcedFileUpdateQueue = new HashSet<PsiFile>();
        this.myDisposed = false;
        this.mySelection = null;
        this.myAutoscrollLimit = InfoAndProgressPanel.AutoscrollLimit.UNLIMITED;
        this.myProject = project2;
        this.myModel = this.createModel();
        this.myIdeView = new NavBarIdeView(this);
        this.myPresentation = new NavBarPresentation(this.myProject);
        this.myUpdateQueue = new NavBarUpdateQueue(this);
        this.installPopupHandler(this, -1);
        this.setOpaque(false);
        if (!ExperimentalUI.isNewUI() && StartupUiUtil.isUnderDarcula() && !docked) {
            this.setBorder(new LineBorder(Gray._120, 1));
        }
        this.myUpdateQueue.queueModelUpdateFromFocus();
        this.myUpdateQueue.queueRebuildUi();
        this.putClientProperty(ActionUtil.ALLOW_ACTION_PERFORM_WHEN_HIDDEN, true);
        Disposer.register(project2, this);
        AccessibleContextUtil.setName((Component)this, IdeBundle.message((String)"navigation.bar", (Object[])new Object[0]));
    }

    protected boolean allowNavItemsFocus() {
        return ScreenReader.isActive();
    }

    public boolean isFocused() {
        if (this.allowNavItemsFocus()) {
            return UIUtil.isFocusAncestor(this);
        }
        return this.hasFocus();
    }

    public void addNavBarItemFocusListener(@Nullable FocusListener l) {
        if (l == null) {
            return;
        }
        this.myNavBarItemFocusListener = AWTEventMulticaster.add(this.myNavBarItemFocusListener, l);
    }

    public void removeNavBarItemFocusListener(@Nullable FocusListener l) {
        if (l == null) {
            return;
        }
        this.myNavBarItemFocusListener = AWTEventMulticaster.remove(this.myNavBarItemFocusListener, l);
    }

    protected void fireNavBarItemFocusGained(FocusEvent e) {
        FocusListener listener2 = this.myNavBarItemFocusListener;
        if (listener2 != null) {
            listener2.focusGained(e);
        }
    }

    protected void fireNavBarItemFocusLost(FocusEvent e) {
        FocusListener listener2 = this.myNavBarItemFocusListener;
        if (listener2 != null) {
            listener2.focusLost(e);
        }
    }

    protected NavBarModel createModel() {
        return new NavBarModel(this.myProject);
    }

    @Nullable
    public NavBarPopup getNodePopup() {
        return this.myNodePopup;
    }

    public boolean isNodePopupActive() {
        return this.myNodePopup != null && this.myNodePopup.isVisible();
    }

    public LightweightHint getHint() {
        return this.myHint;
    }

    public NavBarPresentation getPresentation() {
        return this.myPresentation;
    }

    public void setContextComponent(@Nullable Component contextComponent) {
        this.myContextComponent = contextComponent;
    }

    public NavBarItem getContextObject() {
        return this.myContextObject;
    }

    public List<NavBarItem> getItems() {
        return Collections.unmodifiableList(this.myList);
    }

    public void addItem(NavBarItem item) {
        this.myList.add(item);
    }

    public void clearItems() {
        NavBarItem[] toDispose = this.myList.toArray(new NavBarItem[0]);
        this.myList.clear();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            for (NavBarItem item : toDispose) {
                Disposer.dispose(item);
            }
        });
        this.getNavBarUI().clearItems();
    }

    @Override
    public void setUI(PanelUI ui) {
        this.getNavBarUI().clearItems();
        super.setUI(ui);
    }

    public NavBarUpdateQueue getUpdateQueue() {
        return this.myUpdateQueue;
    }

    @Override
    public boolean isNodePopupSpeedSearchActive() {
        return this.isNodePopupActive() && SpeedSearchSupply.getSupply(this.myNodePopup.getList()) != null;
    }

    @Override
    public void escape() {
        if (this.isNodePopupActive()) {
            this.cancelPopup();
        } else {
            this.myModel.setSelectedIndex(-1);
            this.hideHint();
            ToolWindowManager.getInstance((Project)this.myProject).activateEditorComponent();
        }
    }

    @Override
    public void enter() {
        int index2;
        Object selectedPopupObject = this.getSelectedPopupObject();
        if (selectedPopupObject != null) {
            this.navigateInsideBar(this.mySelection.barIndex, selectedPopupObject, false);
        }
        if ((index2 = this.myModel.getSelectedIndex()) != -1) {
            this.ctrlClick(index2);
        }
    }

    @Override
    public void moveHome() {
        this.shiftFocus(-this.myModel.getSelectedIndex());
    }

    @Override
    public void navigate() {
        Object selectedPopupObject = this.getSelectedPopupObject();
        if (selectedPopupObject != null) {
            this.navigateInsideBar(this.mySelection.barIndex, selectedPopupObject, true);
        } else {
            int index2 = this.myModel.getSelectedIndex();
            if (index2 != -1) {
                this.doubleClick(index2);
            }
        }
    }

    @Nullable
    private Object getSelectedPopupObject() {
        List<Object> popupObjects;
        if (!this.isNodePopupActive()) {
            return null;
        }
        List<Object> list2 = popupObjects = this.mySelection == null ? null : this.mySelection.nodePopupObjects;
        if (popupObjects != null && !popupObjects.isEmpty()) {
            return popupObjects.get(0);
        }
        return null;
    }

    @Override
    public void moveUpDown() {
        this.moveDown();
    }

    public void moveDown() {
        int index2 = this.myModel.getSelectedIndex();
        if (index2 != -1) {
            if (this.myModel.size() - 1 == index2) {
                this.shiftFocus(-1);
                this.ctrlClick(index2 - 1);
            } else {
                this.ctrlClick(index2);
            }
        }
    }

    @Override
    public void moveEnd() {
        this.shiftFocus(this.myModel.size() - 1 - this.myModel.getSelectedIndex());
    }

    public Project getProject() {
        return this.myProject;
    }

    public NavBarModel getModel() {
        return this.myModel;
    }

    @Override
    public void dispose() {
        this.cancelPopup();
        this.getNavBarUI().clearItems();
        this.myDisposed = true;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    boolean isSelectedInPopup(Object object) {
        return this.isNodePopupActive() && this.myNodePopup.getList().getSelectedValuesList().contains(object);
    }

    static Object expandDirsWithJustOneSubdir(Object target2) {
        if (target2 instanceof PsiElement && !((PsiElement)target2).isValid()) {
            return target2;
        }
        if (target2 instanceof PsiDirectory) {
            PsiDirectory directory = (PsiDirectory)target2;
            VirtualFile file2 = directory.getVirtualFile();
            while (true) {
                VirtualFile next2;
                VirtualFile[] children2;
                VirtualFile child = (children2 = file2.getChildren()).length == 1 ? children2[0] : null;
                VirtualFile virtualFile2 = next2 = child != null && child.isDirectory() && !child.is(VFileProperty.SYMLINK) ? child : null;
                if (next2 == null) {
                    return ObjectUtils.notNull(directory.getManager().findDirectory(file2), directory);
                }
                file2 = next2;
            }
        }
        return target2;
    }

    protected void updateItems() {
        MyNavBarWrapperPanel wrapperPanel;
        for (NavBarItem item : new ArrayList<NavBarItem>(this.myList)) {
            item.update();
        }
        if (UISettings.getInstance().getShowNavigationBar() && (wrapperPanel = ComponentUtil.getParentOfType(MyNavBarWrapperPanel.class, this)) != null) {
            wrapperPanel.revalidate();
            wrapperPanel.repaint();
        }
    }

    public void rebuildAndSelectLastDirectoryOrTail(boolean showPopup2) {
        this.rebuildAndSelectItem(list2 -> {
            int lastDirectory;
            if (UISettings.getInstance().getShowMembersInNavigationBar() && (lastDirectory = ContainerUtil.lastIndexOf(list2, item -> NavBarPanel.isExpandable(item.getObject()))) >= 0 && lastDirectory < list2.size() - 1) {
                return lastDirectory;
            }
            return list2.size() - 1;
        }, showPopup2);
    }

    public void rebuildAndSelectItem(Function<? super List<NavBarItem>, Integer> indexToSelectCallback, boolean showPopup2) {
        this.myUpdateQueue.queueModelUpdateFromFocus();
        this.myUpdateQueue.queueRebuildUi();
        this.myUpdateQueue.queueSelect(() -> {
            if (!this.myList.isEmpty()) {
                int index2 = (Integer)indexToSelectCallback.apply(this.myList);
                this.myModel.setSelectedIndex(index2);
                this.requestSelectedItemFocus();
                if (showPopup2) {
                    this.ctrlClick(index2);
                }
            }
        });
        this.myUpdateQueue.flush();
    }

    public void rebuildAndSelectTail(boolean requestFocus) {
        this.rebuildAndSelectItem(list2 -> list2.size() - 1, false);
    }

    public void requestSelectedItemFocus() {
        int index2 = this.myModel.getSelectedIndex();
        if (index2 >= 0 && index2 < this.myModel.size() && this.allowNavItemsFocus()) {
            IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)((Object)this.getItem(index2)), true);
        } else {
            IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)this, true);
        }
    }

    @Override
    public void moveLeft() {
        this.move(-1);
    }

    @Override
    public void moveRight() {
        this.move(1);
    }

    private void move(int direction) {
        boolean withPopup = this.isNodePopupActive();
        if (withPopup) {
            this.cancelPopup();
        }
        this.shiftFocus(direction);
        if (withPopup) {
            this.restorePopup();
        }
    }

    void shiftFocus(int direction) {
        int selectedIndex = this.myModel.getSelectedIndex();
        int index2 = this.myModel.getIndexByModel(selectedIndex + direction);
        this.myModel.setSelectedIndex(index2);
        if (this.allowNavItemsFocus()) {
            this.requestSelectedItemFocus();
        }
    }

    public void updateAutoscrollLimit(InfoAndProgressPanel.AutoscrollLimit limit2) {
        this.myAutoscrollLimit = limit2;
    }

    protected void scrollSelectionToVisible(boolean isOnSelectionChange) {
        if (!isOnSelectionChange && UISettings.getInstance().getNavBarLocation() == NavBarLocation.BOTTOM && this.myAutoscrollLimit == InfoAndProgressPanel.AutoscrollLimit.NOT_ALLOWED) {
            return;
        }
        int selectedIndex = this.myModel.getSelectedIndex();
        if (selectedIndex == -1 || selectedIndex >= this.myList.size()) {
            return;
        }
        this.scrollRectToVisible(this.myList.get(selectedIndex).getBounds());
        if (this.myAutoscrollLimit == InfoAndProgressPanel.AutoscrollLimit.ALLOW_ONCE) {
            this.myAutoscrollLimit = InfoAndProgressPanel.AutoscrollLimit.NOT_ALLOWED;
        }
    }

    @Nullable
    private NavBarItem getItem(int index2) {
        if (index2 != -1 && index2 < this.myList.size()) {
            return this.myList.get(index2);
        }
        return null;
    }

    public boolean isInFloatingMode() {
        return this.myHint != null && this.myHint.isVisible();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.myDisposed || !this.myList.isEmpty()) {
            return super.getPreferredSize();
        }
        NavBarItem item = new NavBarItem(this, null, 0, null);
        Dimension size = item.getPreferredSize();
        ProjectUtilKt.executeOnPooledThread((Project)this.myProject, () -> Disposer.dispose(item));
        return size;
    }

    public boolean isRebuildUiNeeded() {
        this.myModel.revalidate();
        if (this.myList.size() == this.myModel.size()) {
            int index2 = 0;
            for (NavBarItem eachLabel : this.myList) {
                Object eachElement = this.myModel.get(index2);
                if (eachLabel.getObject() == null || !eachLabel.getObject().equals(eachElement)) {
                    return true;
                }
                if (eachLabel.getObject() instanceof PsiFile && this.myForcedFileUpdateQueue.remove(eachLabel.getObject())) {
                    return true;
                }
                if (!StringUtil.equals(eachLabel.getText(), this.getPresentation().getPresentableText(eachElement, false))) {
                    return true;
                }
                if (!Objects.equals(eachLabel.getIcon(), this.getPresentation().getIcon(eachElement))) {
                    return true;
                }
                SimpleTextAttributes modelAttributes1 = this.myPresentation.getTextAttributes(eachElement, true);
                SimpleTextAttributes modelAttributes2 = this.myPresentation.getTextAttributes(eachElement, false);
                SimpleTextAttributes labelAttributes = eachLabel.getAttributes();
                if (!modelAttributes1.toTextAttributes().equals(labelAttributes.toTextAttributes()) && !modelAttributes2.toTextAttributes().equals(labelAttributes.toTextAttributes())) {
                    return true;
                }
                ++index2;
            }
            return false;
        }
        return true;
    }

    void installPopupHandler(final @NotNull JComponent component2, final int index2) {
        if (component2 == null) {
            NavBarPanel.$$$reportNull$$$0(1);
        }
        final NavBarPanel navBarPanel = this;
        component2.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                ActionGroup actionGroup2 = new ActionGroup(){

                    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
                        ActionGroup group2;
                        NavBarModelExtension modelExtension;
                        if (e == null) {
                            if (EMPTY_ARRAY == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return EMPTY_ARRAY;
                        }
                        String popupGroupId = null;
                        Iterator<NavBarModelExtension> iterator2 = NavBarModelExtension.EP_NAME.getExtensionList().iterator();
                        while (iterator2.hasNext() && (popupGroupId = (modelExtension = iterator2.next()).getPopupMenuGroup(NavBarPanel.this)) == null) {
                        }
                        if (popupGroupId == null) {
                            popupGroupId = "NavbarPopupMenu";
                        }
                        AnAction[] anActionArray = (group2 = (ActionGroup)CustomActionsSchema.getInstance().getCorrectedAction(popupGroupId)) == null ? EMPTY_ARRAY : group2.getChildren(e);
                        if (anActionArray == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return anActionArray;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/navigationToolbar/NavBarPanel$1$1", "getChildren"));
                    }
                };
                ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("NavBar", actionGroup2);
                popupMenu.setTargetComponent((JComponent)navBarPanel);
                JPopupMenu menu = popupMenu.getComponent();
                if (index2 != -1 && !navBarPanel.isNodePopupActive()) {
                    NavBarPanel.this.myModel.setSelectedIndex(index2);
                }
                menu.show(NavBarPanel.this.isNodePopupActive() ? NavBarPanel.this.myNodePopup.getComponent() : navBarPanel, component2.getX() + x, component2.getY() + y);
            }
        });
    }

    public void installActions(final int index2, NavBarItem component2) {
        this.installPopupHandler((JComponent)((Object)component2), index2);
        ListenerUtil.addMouseListener((Component)((Object)component2), (MouseListener)new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SystemInfo.isWindows) {
                    this.click(e);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (!SystemInfo.isWindows) {
                    this.click(e);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (e.isConsumed() || !ExperimentalUI.isNewUI()) {
                    return;
                }
                NavBarItem item = NavBarPanel.this.getItem(index2);
                if (item != null) {
                    item.setMouseHover(true);
                    NavBarPanel.this.repaint();
                }
                e.consume();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (e.isConsumed() || !ExperimentalUI.isNewUI()) {
                    return;
                }
                NavBarItem item = NavBarPanel.this.getItem(index2);
                if (item != null) {
                    item.setMouseHover(false);
                    NavBarPanel.this.repaint();
                }
                e.consume();
            }

            private void click(MouseEvent e) {
                if (e.isConsumed()) {
                    return;
                }
                if (e.isPopupTrigger()) {
                    return;
                }
                if (e.getClickCount() == 1) {
                    NavBarPanel.this.ctrlClick(index2);
                    e.consume();
                } else if (e.getClickCount() == 2 && e.getButton() == 1) {
                    NavBarPanel.this.requestSelectedItemFocus();
                    NavBarPanel.this.doubleClick(index2);
                    e.consume();
                }
            }
        });
        ListenerUtil.addKeyListener((Component)((Object)component2), (KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getModifiers() == 0 && e.getKeyCode() == 32) {
                    NavBarPanel.this.ctrlClick(index2);
                    NavBarPanel.this.myModel.setSelectedIndex(index2);
                    e.consume();
                }
            }
        });
    }

    private void installDnD(final int index2, NavBarItem component2) {
        DnDSupport.createBuilder((JComponent)((Object)component2)).setBeanProvider(dnDActionInfo -> new DnDDragStartBean((Object)new TransferableWrapper(){

            public List<File> asFileList() {
                Object o = NavBarPanel.this.myModel.get(index2);
                if (o instanceof PsiElement) {
                    VirtualFile vf;
                    VirtualFile virtualFile2 = vf = o instanceof PsiDirectory ? ((PsiDirectory)o).getVirtualFile() : ((PsiElement)o).getContainingFile().getVirtualFile();
                    if (vf != null) {
                        return Collections.singletonList(new File(vf.getPath()).getAbsoluteFile());
                    }
                }
                return Collections.emptyList();
            }

            public TreeNode[] getTreeNodes() {
                return null;
            }

            public PsiElement[] getPsiElements() {
                return null;
            }
        })).setDisposableParent((Disposable)component2).install();
    }

    private void doubleClick(int index2) {
        this.doubleClick(this.myModel.getElement(index2));
    }

    protected void doubleClick(Object object) {
        Object target2 = ObjectUtils.chooseNotNull(this.getNavigatable(object), object);
        if (target2 instanceof Navigatable) {
            Navigatable navigatable = (Navigatable)target2;
            if (navigatable.canNavigate()) {
                navigatable.navigate(true);
            }
        } else if (target2 instanceof Module) {
            ProjectView projectView = ProjectView.getInstance(this.myProject);
            AbstractProjectViewPane projectViewPane = projectView.getProjectViewPaneById(projectView.getCurrentViewId());
            if (projectViewPane != null) {
                projectViewPane.selectModule((Module)target2, true);
            }
        } else if (target2 instanceof Project) {
            return;
        }
        this.hideHint(true);
    }

    @Nullable
    private Navigatable getNavigatable(Object object) {
        return (Navigatable)NavBarPanel.getSlowData(CommonDataKeys.NAVIGATABLE.getName(), this.myProject, JBIterable.of(object));
    }

    private void ctrlClick(int index2) {
        Object object;
        List<Object> objects;
        if (this.isNodePopupActive()) {
            this.cancelPopup();
            if (this.myModel.getSelectedIndex() == index2) {
                return;
            }
        }
        if (!(objects = this.myModel.getChildren(object = this.myModel.getElement(index2))).isEmpty()) {
            Object[] siblings2 = new Object[objects.size()];
            for (int i2 = 0; i2 < objects.size(); ++i2) {
                siblings2[i2] = objects.get(i2);
            }
            NavBarItem item = this.getItem(index2);
            if (item != null) {
                int selectedIndex = index2 < this.myModel.size() - 1 ? objects.indexOf(this.myModel.getElement(index2 + 1)) : 0;
                this.myNodePopup = new NavBarPopup(this, index2, siblings2, index2, selectedIndex);
                this.myModel.setSelectedIndex(index2);
                this.myNodePopup.show(item);
                item.update();
            }
        }
    }

    @Nullable
    NavBarItem getItemWithObject(Object object) {
        for (NavBarItem item : this.myList) {
            if (item.getObject() != object) continue;
            return item;
        }
        return null;
    }

    protected void navigateInsideBar(int sourceItemIndex, Object object, boolean forceNavigate) {
        UIEventLogger.NavBarNavigate.log(this.myProject);
        boolean restorePopup = !forceNavigate && this.shouldRestorePopupOnSelect(object, sourceItemIndex);
        Object obj = NavBarPanel.expandDirsWithJustOneSubdir(object);
        this.myContextObject = null;
        this.myUpdateQueue.cancelAllUpdates();
        if (this.myNodePopup != null && this.myNodePopup.isVisible()) {
            this.myUpdateQueue.queueModelUpdateForObject(obj);
        }
        this.myUpdateQueue.queueRebuildUi();
        this.myUpdateQueue.queueAfterAll(() -> {
            int index2 = this.myModel.indexOf(obj);
            if (index2 >= 0) {
                this.myModel.setSelectedIndex(index2);
            }
            if (this.myModel.hasChildren(obj) && restorePopup) {
                this.restorePopup();
            } else {
                this.doubleClick(obj);
            }
        }, NavBarUpdateQueue.ID.NAVIGATE_INSIDE);
    }

    private boolean shouldRestorePopupOnSelect(Object obj, int sourceItemIndex) {
        if (sourceItemIndex < this.myModel.size() - 1 && this.myModel.get(sourceItemIndex + 1) == obj) {
            return true;
        }
        return NavBarPanel.isExpandable(obj);
    }

    public static boolean isExpandable(Object obj) {
        if (!(obj instanceof PsiElement)) {
            return true;
        }
        PsiElement psiElement = (PsiElement)obj;
        for (NavBarModelExtension modelExtension : NavBarModelExtension.EP_NAME.getExtensionList()) {
            Boolean expand = modelExtension.shouldExpandOnClick(psiElement);
            if (expand == null) continue;
            return expand;
        }
        return psiElement instanceof PsiDirectory || psiElement instanceof PsiDirectoryContainer;
    }

    void restorePopup() {
        this.cancelPopup();
        this.ctrlClick(this.myModel.getSelectedIndex());
    }

    void cancelPopup() {
        this.cancelPopup(false);
    }

    void cancelPopup(boolean ok2) {
        if (this.myNodePopup != null) {
            this.myNodePopup.hide(ok2);
            this.myNodePopup = null;
            if (this.allowNavItemsFocus()) {
                this.requestSelectedItemFocus();
            }
        }
    }

    void hideHint() {
        this.hideHint(false);
    }

    protected void hideHint(boolean ok2) {
        this.cancelPopup(ok2);
        if (this.myHint != null) {
            this.myHint.hide(ok2);
            this.myHint = null;
        }
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            NavBarPanel.$$$reportNull$$$0(2);
        }
        return this.getDataImpl(dataId, this, this::getSelection);
    }

    @NotNull
    JBIterable<?> getSelection() {
        Object selectedObject;
        Object barObject = null;
        List<Object> popupObjects = null;
        if (this.mySelection != null) {
            barObject = this.myModel.getRawElement(this.mySelection.barIndex);
            popupObjects = this.mySelection.nodePopupObjects;
        }
        if (barObject != null) {
            if (popupObjects == null) {
                JBIterable<Object> jBIterable = JBIterable.of(barObject).filterMap(this.myModel::unwrapRaw);
                if (jBIterable == null) {
                    NavBarPanel.$$$reportNull$$$0(3);
                }
                return jBIterable;
            }
            if (!popupObjects.isEmpty()) {
                JBIterable<Object> jBIterable = JBIterable.from(popupObjects).filterMap(this.myModel::unwrapRaw);
                if (jBIterable == null) {
                    NavBarPanel.$$$reportNull$$$0(4);
                }
                return jBIterable;
            }
        }
        if ((selectedObject = this.myModel.getRawSelectedObject()) == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                NavBarPanel.$$$reportNull$$$0(5);
            }
            return jBIterable;
        }
        JBIterable<Object> jBIterable = JBIterable.of(selectedObject).filterMap(this.myModel::unwrapRaw);
        if (jBIterable == null) {
            NavBarPanel.$$$reportNull$$$0(6);
        }
        return jBIterable;
    }

    void updatePopupSelection(List<Object> objects) {
        this.mySelection = new Selection(this.myModel.getSelectedIndex(), objects);
    }

    void updateSelection() {
        this.mySelection = new Selection(this.myModel.getSelectedIndex(), null);
    }

    @Nullable
    Object getDataImpl(@NotNull String dataId, @NotNull JComponent source, @NotNull Supplier<? extends JBIterable<?>> selection) {
        if (dataId == null) {
            NavBarPanel.$$$reportNull$$$0(7);
        }
        if (source == null) {
            NavBarPanel.$$$reportNull$$$0(8);
        }
        if (selection == null) {
            NavBarPanel.$$$reportNull$$$0(9);
        }
        if (PlatformCoreDataKeys.CONTEXT_COMPONENT.is(dataId)) {
            return this;
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return !this.myProject.isDisposed() ? this.myProject : null;
        }
        if (PlatformCoreDataKeys.BGT_DATA_PROVIDER.is(dataId)) {
            JBIterable<?> finalSelection = selection.get();
            return slowId -> NavBarPanel.getSlowData(slowId, this.myProject, finalSelection);
        }
        if (LangDataKeys.IDE_VIEW.is(dataId)) {
            return this.myIdeView;
        }
        for (NavBarModelExtension modelExtension : NavBarModelExtension.EP_NAME.getExtensionList()) {
            Object data2 = modelExtension.getData(dataId, o -> null);
            if (data2 == null) continue;
            return data2;
        }
        if (PlatformDataKeys.CUT_PROVIDER.is(dataId)) {
            return this.getCopyPasteDelegator(source).getCutProvider();
        }
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this.getCopyPasteDelegator(source).getCopyProvider();
        }
        if (PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
            return this.getCopyPasteDelegator(source).getPasteProvider();
        }
        return null;
    }

    @Nullable
    public static Object getSlowData(@NotNull String dataId, @NotNull Project project2, @NotNull JBIterable<?> selection) {
        if (dataId == null) {
            NavBarPanel.$$$reportNull$$$0(10);
        }
        if (project2 == null) {
            NavBarPanel.$$$reportNull$$$0(11);
        }
        if (selection == null) {
            NavBarPanel.$$$reportNull$$$0(12);
        }
        DataProvider provider2 = o -> NavBarPanel.getSlowDataImpl(o, project2, selection);
        for (NavBarModelExtension modelExtension : NavBarModelExtension.EP_NAME.getExtensionList()) {
            Object data2 = modelExtension.getData(dataId, provider2);
            if (data2 == null) continue;
            return data2;
        }
        return provider2.getData(dataId);
    }

    @Nullable
    private static Object getSlowDataImpl(@NotNull String dataId, @NotNull Project project2, @NotNull JBIterable<?> selection) {
        if (dataId == null) {
            NavBarPanel.$$$reportNull$$$0(13);
        }
        if (project2 == null) {
            NavBarPanel.$$$reportNull$$$0(14);
        }
        if (selection == null) {
            NavBarPanel.$$$reportNull$$$0(15);
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return !project2.isDisposed() ? project2 : null;
        }
        if (PlatformCoreDataKeys.MODULE.is(dataId)) {
            Module module2 = selection.filter(Module.class).first();
            if (module2 != null && !module2.isDisposed()) {
                return module2;
            }
            PsiElement element = selection.filter(PsiElement.class).first();
            if (element != null) {
                return ModuleUtilCore.findModuleForPsiElement(element);
            }
            return null;
        }
        if (LangDataKeys.MODULE_CONTEXT.is(dataId)) {
            VirtualFile dir;
            PsiDirectory directory = selection.filter(PsiDirectory.class).first();
            if (directory != null && ProjectRootsUtil.isModuleContentRoot(dir = directory.getVirtualFile(), project2)) {
                return ModuleUtilCore.findModuleForPsiElement(directory);
            }
            return null;
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            PsiElement element = selection.filter(PsiElement.class).first();
            return element != null && element.isValid() ? element : null;
        }
        if (PlatformCoreDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
            List<PsiElement> result2 = selection.filter(PsiElement.class).filter(e -> e != null && e.isValid()).toList();
            return result2.isEmpty() ? null : result2.toArray(PsiElement.EMPTY_ARRAY);
        }
        if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
            Set<VirtualFile> files2 = selection.filter(PsiElement.class).filter(e -> e != null && e.isValid()).filterMap(e -> PsiUtilCore.getVirtualFile(e)).toSet();
            return !files2.isEmpty() ? VfsUtilCore.toVirtualFileArray(files2) : null;
        }
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            List<Navigatable> elements = selection.filter(Navigatable.class).toList();
            return elements.isEmpty() ? null : elements.toArray(Navigatable.EMPTY_NAVIGATABLE_ARRAY);
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            return selection.filter(Module.class).isNotEmpty() ? ModuleDeleteProvider.getInstance() : new DeleteHandler.DefaultDeleteProvider();
        }
        return null;
    }

    @NotNull
    private CopyPasteSupport getCopyPasteDelegator(@NotNull JComponent source) {
        String key;
        Object result2;
        if (source == null) {
            NavBarPanel.$$$reportNull$$$0(16);
        }
        if (!((result2 = source.getClientProperty(key = "NavBarPanel.copyPasteDelegator")) instanceof CopyPasteSupport)) {
            result2 = new CopyPasteDelegator(this.myProject, source);
            source.putClientProperty(key, result2);
        }
        CopyPasteSupport copyPasteSupport = (CopyPasteSupport)result2;
        if (copyPasteSupport == null) {
            NavBarPanel.$$$reportNull$$$0(17);
        }
        return copyPasteSupport;
    }

    public Point getBestPopupPosition() {
        NavBarItem item;
        int index2 = this.myModel.getSelectedIndex();
        int modelSize = this.myModel.size();
        if (index2 == -1) {
            index2 = modelSize - 1;
        }
        if (index2 > -1 && index2 < modelSize && (item = this.getItem(index2)) != null) {
            return new Point(item.getX(), item.getY() + item.getHeight());
        }
        return null;
    }

    @Nullable
    public JComponent getPopupComponent() {
        return this.isNodePopupActive() ? this.myNodePopup.getList() : null;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (!this.isDisposed()) {
            Disposable disposable = NavBarListener.subscribeTo(this);
            Disposer.register(this, disposable);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.isDisposeOnRemove() && ScreenUtil.isStandardAddRemoveNotify(this)) {
            Disposer.dispose(this);
        }
    }

    protected boolean isDisposeOnRemove() {
        return true;
    }

    public void updateState(boolean show2) {
        if (show2) {
            this.myUpdateQueue.queueModelUpdateFromFocus();
            this.myUpdateQueue.queueRebuildUi();
        }
    }

    public void showHint(@Nullable Editor editor2, DataContext dataContext2) {
        this.myModel.updateModelAsync(dataContext2, () -> {
            if (this.myModel.isEmpty()) {
                return;
            }
            JPanel panel2 = new JPanel(new BorderLayout());
            panel2.add(this);
            panel2.setOpaque(true);
            if (ExperimentalUI.isNewUI()) {
                panel2.setBorder(new JBEmptyBorder(JBUI.CurrentTheme.StatusBar.Breadcrumbs.floatingBorderInsets()));
                panel2.setBackground(JBUI.CurrentTheme.StatusBar.Breadcrumbs.FLOATING_BACKGROUND);
            } else {
                panel2.setBackground(UIUtil.getListBackground());
            }
            this.myHint = new LightweightHint(panel2){

                public void hide() {
                    super.hide();
                    NavBarPanel.this.cancelPopup();
                    Disposer.dispose(NavBarPanel.this);
                }
            };
            this.myHint.setForceShowAsPopup(true);
            this.myHint.setFocusRequestor((JComponent)this);
            KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            this.myUpdateQueue.rebuildUi();
            if (editor2 == null) {
                this.myContextComponent = (Component)PlatformCoreDataKeys.CONTEXT_COMPONENT.getData(dataContext2);
                this.getHintContainerShowPoint().doWhenDone(relativePoint -> {
                    Component owner = focusManager.getFocusOwner();
                    Component cmp = relativePoint.getComponent();
                    if (cmp instanceof JComponent && cmp.isShowing()) {
                        this.myHint.show((JComponent)cmp, relativePoint.getPoint().x, relativePoint.getPoint().y, owner instanceof JComponent ? (JComponent)owner : null, new HintHint(relativePoint.getComponent(), relativePoint.getPoint()));
                    }
                });
            } else {
                this.myHintContainer = editor2.getContentComponent();
                this.getHintContainerShowPoint().doWhenDone(rp -> {
                    Point p = rp.getPointOn(this.myHintContainer).getPoint();
                    HintHint hintInfo = new HintHint(editor2, p);
                    HintManagerImpl.getInstanceImpl().showEditorHint(this.myHint, editor2, p, 1, 0, true, hintInfo);
                });
            }
            this.rebuildAndSelectLastDirectoryOrTail(true);
        });
    }

    AsyncResult<RelativePoint> getHintContainerShowPoint() {
        Component c2;
        AsyncResult result2 = new AsyncResult();
        if (this.myLocationCache == null) {
            if (this.myHintContainer != null) {
                Point p = AbstractPopup.getCenterOf((Component)this.myHintContainer, (JComponent)this);
                p.y -= this.myHintContainer.getVisibleRect().height / 4;
                this.myLocationCache = RelativePoint.fromScreen(p);
            } else {
                DataManager dataManager = DataManager.getInstance();
                if (this.myContextComponent != null) {
                    DataContext ctx = dataManager.getDataContext(this.myContextComponent);
                    this.myLocationCache = JBPopupFactory.getInstance().guessBestPopupLocation(ctx);
                } else {
                    dataManager.getDataContextFromFocus().doWhenDone(dataContext2 -> {
                        this.myContextComponent = (Component)PlatformCoreDataKeys.CONTEXT_COMPONENT.getData(dataContext2);
                        DataContext ctx = dataManager.getDataContext(this.myContextComponent);
                        this.myLocationCache = JBPopupFactory.getInstance().guessBestPopupLocation(ctx);
                    });
                }
            }
        }
        if (!((c2 = this.myLocationCache.getComponent()) instanceof JComponent) || !c2.isShowing()) {
            JComponent ideFrame = WindowManager.getInstance().getIdeFrame(this.getProject()).getComponent();
            JRootPane rootPane = UIUtil.getRootPane(ideFrame);
            this.myLocationCache = JBPopupFactory.getInstance().guessBestPopupLocation((JComponent)rootPane);
        }
        result2.setDone((Object)this.myLocationCache);
        return result2;
    }

    @Override
    public void putInfo(@NotNull Map<? super String, ? super String> info2) {
        if (info2 == null) {
            NavBarPanel.$$$reportNull$$$0(18);
        }
        StringBuilder result2 = new StringBuilder();
        for (int i2 = 0; i2 < this.myList.size(); ++i2) {
            NavBarItem each = this.myList.get(i2);
            if (each.isSelected()) {
                result2.append("[").append(each.getText()).append("]");
            } else {
                result2.append(each.getText());
            }
            if (i2 >= this.myList.size() - 1) continue;
            result2.append(">");
        }
        info2.put("navBar", result2.toString());
        if (this.isNodePopupActive()) {
            StringBuilder popupText2 = new StringBuilder();
            JBList<?> list2 = this.myNodePopup.getList();
            for (int i3 = 0; i3 < list2.getModel().getSize(); ++i3) {
                Object eachElement = list2.getModel().getElementAt(i3);
                String text2 = new NavBarItem(this, eachElement, this.myNodePopup, true).getText();
                int selectedIndex = list2.getSelectedIndex();
                if (selectedIndex != -1 && eachElement.equals(list2.getSelectedValue())) {
                    popupText2.append("[").append(text2).append("]");
                } else {
                    popupText2.append(text2);
                }
                if (i3 >= list2.getModel().getSize() - 1) continue;
                popupText2.append(">");
            }
            info2.put("navBarPopup", popupText2.toString());
        }
    }

    @NotNull
    public NavBarUI getNavBarUI() {
        NavBarUI navBarUI = NavBarUIManager.getUI();
        if (navBarUI == null) {
            NavBarPanel.$$$reportNull$$$0(19);
        }
        return navBarUI;
    }

    void queueFileUpdate(PsiFile psiFile) {
        this.myForcedFileUpdateQueue.add(psiFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 17, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 2: 
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/navigationToolbar/NavBarPanel";
                break;
            }
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 9: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/navigationToolbar/NavBarPanel";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelection";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getCopyPasteDelegator";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavBarUI";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "installPopupHandler";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 17: 
            case 19: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDataImpl";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSlowData";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSlowDataImpl";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getCopyPasteDelegator";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "putInfo";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 4, 5, 6, 17, 19 -> new IllegalStateException(string2);
        };
    }

    private record Selection(int barIndex, @Nullable List<Object> nodePopupObjects) {
    }
}

