/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar;

import com.intellij.ide.actions.OpenInRightSplitAction;
import com.intellij.ide.navigationToolbar.NavBarItem;
import com.intellij.ide.navigationToolbar.NavBarListWrapper;
import com.intellij.ide.navigationToolbar.NavBarPanel;
import com.intellij.ide.navigationToolbar.ui.NavBarUIManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.internal.statistic.service.fus.collectors.UIEventLogger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DependentTransientComponent;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.HintHint;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.HintUpdateSupply;
import com.intellij.ui.popup.list.SelectablePanel;
import com.intellij.ui.speedSearch.ListWithFilter;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;

@Deprecated
public class NavBarPopup
extends LightweightHint
implements Disposable {
    private static final String JBLIST_KEY = "OriginalList";
    private static final String DISPOSED_OBJECTS = "DISPOSED_OBJECTS";
    private final NavBarPanel myPanel;
    private final int myIndex;
    private final int myItemIndex;

    public NavBarPopup(NavBarPanel panel2, final int sourceItemIndex, Object[] siblings2, int itemIndex, final int selectedIndex) {
        super(NavBarPopup.createPopupContent(panel2, siblings2));
        this.myPanel = panel2;
        this.myIndex = selectedIndex;
        this.myItemIndex = itemIndex;
        this.setFocusRequestor(this.getComponent());
        this.setForceShowAsPopup(true);
        this.setCancelOnOtherWindowOpen(false);
        panel2.installPopupHandler((JComponent)this.getList(), selectedIndex);
        this.getList().addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SystemInfo.isWindows) {
                    this.click(e);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (!SystemInfo.isWindows) {
                    this.click(e);
                }
            }

            private void click(MouseEvent e) {
                if (e.isConsumed()) {
                    return;
                }
                NavBarPopup.this.myPanel.getModel().setSelectedIndex(selectedIndex);
                if (e.isPopupTrigger()) {
                    return;
                }
                int idx = NavBarPopup.this.getList().locationToIndex(e.getPoint());
                if (idx != -1) {
                    Object value = NavBarPopup.this.getList().getModel().getElementAt(idx);
                    NavBarPopup.this.myPanel.navigateInsideBar(sourceItemIndex, value, SystemInfo.isMac ? e.isMetaDown() : e.isControlDown());
                }
            }
        });
    }

    protected void onPopupCancel() {
        Object o;
        JComponent component2 = this.getComponent();
        if (component2 != null && (o = component2.getClientProperty(JBLIST_KEY)) instanceof JComponent) {
            HintUpdateSupply.hideHint((JComponent)((JComponent)o));
        }
        for (SelectablePanel selectablePanel : (List)this.getList().getClientProperty((Object)DISPOSED_OBJECTS)) {
            Disposer.dispose(NavBarPopup.unwrapItem(selectablePanel));
        }
        Disposer.dispose(this);
    }

    public void show(NavBarItem item) {
        this.show(item, true);
    }

    private void show(NavBarItem item, boolean checkRepaint) {
        Window window;
        UIEventLogger.NavBarShowPopup.log(this.myPanel.getProject());
        UISettings settings = UISettings.getInstance();
        int relativeY = ExperimentalUI.isNewUI() && settings.getShowNavigationBarInBottom() && settings.getShowStatusBar() ? -this.getComponent().getPreferredSize().height : item.getHeight();
        RelativePoint point = new RelativePoint((Component)((Object)item), new Point(0, relativeY));
        Point p = point.getPoint(this.myPanel);
        if ((p.x == 0 || p.y == 0) && checkRepaint) {
            SwingUtilities.invokeLater(() -> {
                this.myPanel.getUpdateQueue().rebuildUi();
                SwingUtilities.invokeLater(() -> {
                    NavBarItem updatedItem = this.myPanel.getItemWithObject(item.getObject());
                    if (updatedItem == null) {
                        updatedItem = item;
                    }
                    this.show(updatedItem, false);
                });
            });
        } else {
            int offset2 = NavBarUIManager.getUI().getPopupOffset(item);
            this.show(this.myPanel, p.x - offset2, p.y, this.myPanel, new HintHint((Component)this.myPanel, p));
            JBList<?> list2 = this.getList();
            AccessibleContextUtil.setName(list2, item.getText());
            if (0 <= this.myIndex && this.myIndex < list2.getItemsCount()) {
                ScrollingUtil.selectItem(list2, (int)this.myIndex);
            }
        }
        if (this.myPanel.isInFloatingMode() && (window = SwingUtilities.windowForComponent(this.getList())) != null) {
            window.addWindowFocusListener(new WindowFocusListener(){

                @Override
                public void windowGainedFocus(WindowEvent e) {
                }

                @Override
                public void windowLostFocus(WindowEvent e) {
                    Window w = e.getOppositeWindow();
                    if (w != null && DialogWrapper.findInstance((Component)w.getComponent(0)) != null) {
                        NavBarPopup.this.myPanel.hideHint();
                    }
                }
            });
        }
    }

    public int getItemIndex() {
        return this.myItemIndex;
    }

    @Override
    public void dispose() {
    }

    private static JComponent createPopupContent(final @NotNull NavBarPanel panel2, Object @NotNull [] siblings2) {
        if (panel2 == null) {
            NavBarPopup.$$$reportNull$$$0(0);
        }
        if (siblings2 == null) {
            NavBarPopup.$$$reportNull$$$0(1);
        }
        class MyList<E>
        extends JBList<E>
        implements DependentTransientComponent,
        Queryable {
            final /* synthetic */ NavBarPanel val$panel;

            MyList(NavBarPanel navBarPanel) {
                this.val$panel = navBarPanel;
            }

            @Override
            public void putInfo(@NotNull Map<? super String, ? super String> info2) {
                if (info2 == null) {
                    MyList.$$$reportNull$$$0(0);
                }
                this.val$panel.putInfo(info2);
            }

            @NotNull
            public Component getPermanentComponent() {
                NavBarPanel navBarPanel = this.val$panel;
                if (navBarPanel == null) {
                    MyList.$$$reportNull$$$0(1);
                }
                return navBarPanel;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "info";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/navigationToolbar/NavBarPopup$1MyList";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/navigationToolbar/NavBarPopup$1MyList";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPermanentComponent";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "putInfo";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string2);
                    case 1 -> new IllegalStateException(string2);
                };
            }
        }
        final MyList list2 = new MyList(panel2);
        list2.setModel(new CollectionListModel<Object>(siblings2));
        HintUpdateSupply.installSimpleHintUpdateSupply(list2);
        class MyListRenderer
        implements ListCellRenderer<Object> {
            final List<SelectablePanel> selectables = new ArrayList<SelectablePanel>();
            final /* synthetic */ NavBarPanel val$panel;

            MyListRenderer(NavBarPanel navBarPanel) {
                this.val$panel = navBarPanel;
            }

            @Override
            public Component getListCellRendererComponent(JList<?> list2, Object obj, int index2, boolean isSelected, boolean cellHasFocus) {
                if (this.val$panel.isDisposed()) {
                    return new SelectablePanel();
                }
                SelectablePanel selectable = null;
                for (SelectablePanel cachedSelectable : this.selectables) {
                    NavBarItem item = NavBarPopup.unwrapItem(cachedSelectable);
                    if (obj != item.getObject()) continue;
                    item.update();
                    selectable = cachedSelectable;
                }
                if (selectable == null) {
                    selectable = SelectablePanel.wrap((Component)((Object)new NavBarItem(this.val$panel, obj, null, true)));
                    if (ExperimentalUI.isNewUI()) {
                        selectable.setSelectionArc(JBUI.CurrentTheme.Popup.Selection.ARC.get());
                    }
                    this.selectables.add(selectable);
                }
                selectable.setBackground(null);
                selectable.setSelectionColor(isSelected ? UIUtil.getListSelectionBackground(cellHasFocus) : null);
                return selectable;
            }
        }
        MyListRenderer renderer = new MyListRenderer(panel2);
        list2.putClientProperty(DISPOSED_OBJECTS, renderer.selectables);
        list2.setCellRenderer(renderer);
        list2.setBorder(JBUI.Borders.empty(5));
        list2.setBackground(JBUI.CurrentTheme.Popup.BACKGROUND);
        list2.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                panel2.updatePopupSelection(list2.getSelectedValuesList());
            }
        });
        NavBarListWrapper navBarListWrapper = new NavBarListWrapper((JList)((Object)list2));
        ListWithFilter component2 = (ListWithFilter)ListWithFilter.wrap(list2, (JScrollPane)((Object)navBarListWrapper), o -> panel2.getPresentation().getPresentableText(o, false));
        navBarListWrapper.updateViewportPreferredSizeIfNeeded();
        component2.setAutoPackHeight(!UISettings.getInstance().getShowNavigationBarInBottom());
        component2.putClientProperty((Object)JBLIST_KEY, list2);
        OpenInRightSplitAction.Companion.overrideDoubleClickWithOneClick((JComponent)component2);
        return component2;
    }

    private static NavBarItem unwrapItem(SelectablePanel panel2) {
        return (NavBarItem)((Object)panel2.getComponent(0));
    }

    @NotNull
    public JBList<?> getList() {
        JBList jBList = (JBList)this.getComponent().getClientProperty(JBLIST_KEY);
        if (jBList == null) {
            NavBarPopup.$$$reportNull$$$0(2);
        }
        return jBList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "siblings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/navigationToolbar/NavBarPopup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/navigationToolbar/NavBarPopup";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createPopupContent";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2 -> new IllegalStateException(string2);
        };
    }
}

