/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.navigationToolbar.NavBarItem;
import com.intellij.ide.navigationToolbar.NavBarModel;
import com.intellij.ide.navigationToolbar.NavBarPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.LightweightHint;
import com.intellij.util.Alarm;
import com.intellij.util.SlowOperations;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class NavBarUpdateQueue
extends MergingUpdateQueue {
    private final AtomicBoolean myModelUpdating = new AtomicBoolean(Boolean.FALSE);
    private final Alarm myUserActivityAlarm = new Alarm((Disposable)((Object)this));
    private Runnable myRunWhenListRebuilt;
    private final Runnable myUserActivityAlarmRunnable = () -> this.processUserActivity();
    private final NavBarPanel myPanel;

    public NavBarUpdateQueue(NavBarPanel panel2) {
        super("NavBar", Registry.intValue("navBar.updateMergeTime"), true, (JComponent)panel2, (Disposable)panel2);
        this.myPanel = panel2;
        this.setTrackUiActivity(true);
        IdeEventQueue.getInstance().addActivityListener(() -> this.restartRebuild(), (Disposable)panel2);
    }

    private void requestModelUpdate(final @Nullable DataContext context2, final @Nullable Object object, boolean requeue) {
        if (this.myModelUpdating.getAndSet(true) && !requeue) {
            return;
        }
        this.cancelAllUpdates();
        this.queue(new AfterModelUpdate(ID.MODEL){

            @Override
            public void run() {
                if (context2 != null || object != null) {
                    NavBarUpdateQueue.this.requestModelUpdateFromContextOrObject(context2, object);
                } else {
                    DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(dataContext2 -> NavBarUpdateQueue.this.requestModelUpdateFromContextOrObject((DataContext)dataContext2, null));
                }
            }

            public void setRejected() {
                super.setRejected();
                NavBarUpdateQueue.this.myModelUpdating.set(false);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestModelUpdateFromContextOrObject(DataContext dataContext2, Object object) {
        try {
            NavBarModel model2 = this.myPanel.getModel();
            if (dataContext2 != null) {
                Project project2;
                Component parent2 = UIUtil.findUltimateParent((Component)PlatformCoreDataKeys.CONTEXT_COMPONENT.getData(dataContext2));
                if (parent2 == null) {
                    return;
                }
                Project project3 = project2 = parent2 instanceof IdeFrame ? ((IdeFrame)parent2).getProject() : null;
                if (this.myPanel.getProject() != project2 || this.myPanel.isNodePopupActive()) {
                    this.requestModelUpdate(null, this.myPanel.getContextObject(), true);
                    return;
                }
                Window window = SwingUtilities.getWindowAncestor(this.myPanel);
                if (window != null && !window.isFocused()) {
                    model2.updateModelAsync(DataManager.getInstance().getDataContext((Component)this.myPanel), null);
                } else {
                    model2.updateModelAsync(dataContext2, null);
                }
            } else {
                model2.updateModel(object);
            }
            this.queueRebuildUi();
        }
        finally {
            this.myModelUpdating.set(false);
        }
    }

    void restartRebuild() {
        this.myUserActivityAlarm.cancelAllRequests();
        if (!this.myUserActivityAlarm.isDisposed()) {
            this.myUserActivityAlarm.addRequest(this.myUserActivityAlarmRunnable, Registry.intValue("navBar.userActivityMergeTime"));
        }
    }

    private void processUserActivity() {
        if (this.myPanel == null || !this.myPanel.isShowing()) {
            return;
        }
        Project project2 = this.myPanel.getProject();
        IdeFocusManager.getInstance((Project)project2).doWhenFocusSettlesDown(() -> {
            Window wnd = SwingUtilities.windowForComponent(this.myPanel);
            if (wnd == null) {
                return;
            }
            Component focus = null;
            if (!wnd.isActive()) {
                IdeFrame frame = ComponentUtil.getParentOfType(IdeFrame.class, this.myPanel);
                if (frame != null) {
                    focus = IdeFocusManager.getInstance((Project)project2).getLastFocusedFor((Window)frame);
                }
            } else {
                Dialog dialog;
                Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
                if (window instanceof Dialog && (dialog = (Dialog)window).isModal() && !SwingUtilities.isDescendingFrom(this.myPanel, dialog)) {
                    return;
                }
            }
            if (focus != null && focus.isShowing()) {
                if (!this.myPanel.isFocused() && !this.myPanel.isNodePopupActive()) {
                    this.requestModelUpdate(DataManager.getInstance().getDataContext(focus), null, false);
                }
            } else if (wnd.isActive()) {
                if (this.myPanel.allowNavItemsFocus() && (this.myPanel.isFocused() || this.myPanel.isNodePopupActive())) {
                    return;
                }
                this.requestModelUpdate(null, this.myPanel.getContextObject(), false);
            }
        });
    }

    public void queueModelUpdate(DataContext context2) {
        this.requestModelUpdate(context2, null, false);
    }

    public void queueModelUpdateFromFocus() {
        this.queueModelUpdateFromFocus(false);
    }

    public void queueModelUpdateFromFocus(boolean requeue) {
        this.requestModelUpdate(null, this.myPanel.getContextObject(), requeue);
    }

    public void queueModelUpdateForObject(Object object) {
        this.requestModelUpdate(null, object, false);
    }

    public void queueRebuildUi() {
        this.queue(new AfterModelUpdate(ID.UI){

            @Override
            protected void after() {
                SlowOperations.allowSlowOperations(() -> NavBarUpdateQueue.this.rebuildUi());
            }
        });
        this.queueRevalidate(null);
    }

    public void rebuildUi() {
        if (!this.myPanel.isRebuildUiNeeded()) {
            return;
        }
        this.myPanel.clearItems();
        for (int index2 = 0; index2 < this.myPanel.getModel().size(); ++index2) {
            Object object = this.myPanel.getModel().get(index2);
            NavBarItem label2 = new NavBarItem(this.myPanel, object, index2, null);
            this.myPanel.installActions(index2, label2);
            this.myPanel.addItem(label2);
        }
        this.rebuildComponent();
        if (this.myRunWhenListRebuilt != null) {
            Runnable r = this.myRunWhenListRebuilt;
            this.myRunWhenListRebuilt = null;
            r.run();
        }
    }

    private void rebuildComponent() {
        this.myPanel.removeAll();
        for (NavBarItem item : this.myPanel.getItems()) {
            this.myPanel.add((Component)((Object)item));
        }
        this.myPanel.revalidate();
        this.myPanel.repaint();
        this.queueAfterAll(() -> this.myPanel.scrollSelectionToVisible(false), ID.SCROLL_TO_VISIBLE);
    }

    private void queueRevalidate(final @Nullable Runnable after2) {
        this.queue(new AfterModelUpdate(ID.REVALIDATE){

            @Override
            protected void after() {
                LightweightHint hint = NavBarUpdateQueue.this.myPanel.getHint();
                if (hint != null) {
                    NavBarUpdateQueue.this.myPanel.getHintContainerShowPoint().doWhenDone(relativePoint -> {
                        Dimension size = NavBarUpdateQueue.this.myPanel.getPreferredSize();
                        if (ExperimentalUI.isNewUI()) {
                            JBInsets.addTo(size, JBUI.CurrentTheme.StatusBar.Breadcrumbs.floatingBorderInsets());
                        }
                        hint.setSize(size);
                        hint.setLocation(relativePoint);
                        if (after2 != null) {
                            after2.run();
                        }
                    });
                } else if (after2 != null) {
                    after2.run();
                }
            }
        });
    }

    void queueSelect(final Runnable runnable) {
        this.queue(new AfterModelUpdate(ID.SELECT){

            @Override
            protected void after() {
                runnable.run();
            }
        });
    }

    void queueAfterAll(final Runnable runnable, ID id) {
        this.queue(new AfterModelUpdate(id){

            @Override
            protected void after() {
                if (runnable != null) {
                    runnable.run();
                }
            }
        });
    }

    public static enum ID {
        MODEL(0),
        UI(1),
        REVALIDATE(2),
        SELECT(3),
        SCROLL_TO_VISIBLE(4),
        SHOW_HINT(4),
        REQUEST_FOCUS(4),
        NAVIGATE_INSIDE(4);

        private final int myPriority;

        private ID(int priority) {
            this.myPriority = priority;
        }

        public int getPriority() {
            return this.myPriority;
        }
    }

    private abstract class AfterModelUpdate
    extends Update {
        private AfterModelUpdate(ID id) {
            super((Object)id.name(), id.getPriority());
        }

        public void run() {
            if (NavBarUpdateQueue.this.myModelUpdating.get()) {
                NavBarUpdateQueue.this.queue(this);
            } else {
                this.after();
            }
        }

        protected void after() {
        }
    }
}

