/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.impl.SelectInTargetPsiWrapper;
import com.intellij.ide.navbar.ui.StaticNavBarPanel;
import com.intellij.ide.navbar.vm.NavBarVm;
import com.intellij.ide.navigationToolbar.NavBarPanel;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ex.IdeFrameEx;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

final class SelectInNavBarTarget
extends SelectInTargetPsiWrapper
implements DumbAware {
    public static final String NAV_BAR_ID = "NavBar";

    SelectInNavBarTarget(@NotNull Project project2) {
        if (project2 == null) {
            SelectInNavBarTarget.$$$reportNull$$$0(0);
        }
        super(project2);
    }

    @NonNls
    public String getToolWindowId() {
        return NAV_BAR_ID;
    }

    @Override
    protected boolean canSelect(PsiFileSystemItem file2) {
        return UISettings.getInstance().getShowNavigationBar();
    }

    @Override
    protected void select(Object selector, VirtualFile virtualFile2, boolean requestFocus) {
        SelectInNavBarTarget.selectInNavBar(false);
    }

    @Override
    protected void select(PsiElement element, boolean requestFocus) {
        SelectInNavBarTarget.selectInNavBar(false);
    }

    public static void selectInNavBar(boolean showPopup2) {
        DataManager.getInstance().getDataContextFromFocus().doWhenDone(context2 -> {
            JComponent navBar;
            IdeFrame frame = (IdeFrame)IdeFrame.KEY.getData(context2);
            if (frame instanceof IdeFrameEx && (navBar = ((IdeFrameEx)frame).getNorthExtension(NAV_BAR_ID)) != null) {
                Object panel2 = navBar.getClientProperty("NavBarPanel");
                if (panel2 instanceof StaticNavBarPanel) {
                    StaticNavBarPanel navBarPanel = (StaticNavBarPanel)panel2;
                    NavBarVm vm2 = navBarPanel.getModel();
                    if (vm2 != null) {
                        vm2.selectTail();
                        if (showPopup2) {
                            vm2.showPopup();
                        }
                    }
                } else {
                    ((NavBarPanel)panel2).rebuildAndSelectLastDirectoryOrTail(showPopup2);
                }
            }
        });
    }

    public float getWeight() {
        return 8.0f;
    }

    public String getMinorViewId() {
        return null;
    }

    @Override
    public String toString() {
        return IdeBundle.message((String)"navigation.bar", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/navigationToolbar/SelectInNavBarTarget", "<init>"));
    }
}

