/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar.experimental;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.HelpTooltip;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.GotoClassPresentationUpdater;
import com.intellij.ide.actions.SearchEverywhereAction;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereManager;
import com.intellij.ide.navigationToolbar.experimental.SearchEverywhereNewToolbarAction;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionButtonComponent;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionResult;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.actionSystem.impl.ActionButtonWithText;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.WindowStateService;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.FontUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 %2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001%B\u0005\u00a2\u0006\u0002\u0010\u0004J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u0006H\u0002J\u0010\u0010$\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/ide/navigationToolbar/experimental/SearchEverywhereNewToolbarAction;", "Lcom/intellij/ide/actions/SearchEverywhereAction;", "Lcom/intellij/openapi/actionSystem/ex/AnActionListener;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "clearPosition", "", "firstOpened", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "margin", "", "seManager", "Lcom/intellij/ide/actions/searcheverywhere/SearchEverywhereManager;", "getSeManager", "()Lcom/intellij/ide/actions/searcheverywhere/SearchEverywhereManager;", "setSeManager", "(Lcom/intellij/ide/actions/searcheverywhere/SearchEverywhereManager;)V", "subscribedForDoubleShift", "afterActionPerformed", "", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "result", "Lcom/intellij/openapi/actionSystem/AnActionResult;", "beforeActionPerformed", "createCustomComponent", "Ljavax/swing/JComponent;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "", "showHotkey", "update", "Companion", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nSearchEverywhereNewToolbarAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchEverywhereNewToolbarAction.kt\ncom/intellij/ide/navigationToolbar/experimental/SearchEverywhereNewToolbarAction\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,245:1\n10#2:246\n1#3:247\n*S KotlinDebug\n*F\n+ 1 SearchEverywhereNewToolbarAction.kt\ncom/intellij/ide/navigationToolbar/experimental/SearchEverywhereNewToolbarAction\n*L\n52#1:246\n*E\n"})
public final class SearchEverywhereNewToolbarAction
extends SearchEverywhereAction
implements AnActionListener,
DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    private final int margin;
    private boolean subscribedForDoubleShift;
    private boolean firstOpened;
    private boolean clearPosition;
    @Nullable
    private SearchEverywhereManager seManager;
    @NotNull
    public static final String SHOW_HOT_KEY_TIP = "com.intellij.ide.navigationToolbar.experimental.showSearchEverywhereHotKeyTip";

    public SearchEverywhereNewToolbarAction() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SearchEverywhereNewToolbarAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        this.logger = logger;
        this.margin = JBUI.scale(4);
    }

    @Nullable
    public final SearchEverywhereManager getSeManager() {
        return this.seManager;
    }

    public final void setSeManager(@Nullable SearchEverywhereManager searchEverywhereManager) {
        this.seManager = searchEverywhereManager;
    }

    @Override
    public void update(@NotNull AnActionEvent event) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!Intrinsics.areEqual((Object)event.getPlace(), (Object)"MainToolbar")) {
            event.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Project project2 = event.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        if (this.seManager == null) {
            this.seManager = SearchEverywhereManager.getInstance(project3);
            Disposer.register(project3, () -> SearchEverywhereNewToolbarAction.update$lambda$0(this));
        }
        Presentation presentation2 = event.getPresentation();
        if (!this.showHotkey()) {
            string2 = ActionsBundle.message((String)"action.SearchEverywhereToolbar.text", (Object[])new Object[0]);
        } else {
            String shortcut = ActionsBundle.message((String)"action.SearchEverywhereToolbarHotKey.hotkey", (Object[])new Object[0]);
            Object[] objectArray = new Object[]{shortcut};
            string2 = ActionsBundle.message((String)"action.SearchEverywhereToolbarHotKey.text", (Object[])objectArray);
        }
        presentation2.setText(string2);
        event.getPresentation().setIcon(AllIcons.Actions.Search);
        if (!this.subscribedForDoubleShift) {
            MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect(project3);
            Topic topic = AnActionListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            messageBusConnection.subscribe(topic, this);
            this.subscribedForDoubleShift = true;
        }
    }

    @Override
    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation2, @NotNull String place) {
        Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Dimension dimension = new Dimension(0, ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE.height);
        return (JComponent)new ActionButtonWithText(this, presentation2, place, dimension){
            @NotNull
            private final PropertyChangeListener listener;
            final /* synthetic */ SearchEverywhereNewToolbarAction this$0;
            final /* synthetic */ Presentation $presentation;
            {
                this.this$0 = $receiver;
                this.$presentation = $presentation;
                super((AnAction)$receiver, $presentation, $place, $super_call_param$1);
                this.listener = arg_0 -> createCustomComponent.1.listener$lambda$0(this, arg_0);
                this.setHorizontalTextAlignment(2);
                this.setCursor(Cursor.getPredefinedCursor(2));
            }

            public void addNotify() {
                FocusManager.getCurrentManager().addPropertyChangeListener(this.listener);
                super.addNotify();
            }

            public void removeNotify() {
                FocusManager.getCurrentManager().removePropertyChangeListener(this.listener);
                super.removeNotify();
            }

            @NotNull
            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE.height);
            }

            protected void updateToolTipText() {
                String shortcutText = "Double" + (String)(SystemInfo.isMac ? FontUtil.thinSpace() + "\u21e7" : " Shift");
                String classesTabName = String.join((CharSequence)"/", (Iterable<? extends CharSequence>)GotoClassPresentationUpdater.getActionTitlePluralized());
                if (Registry.is("ide.helptooltip.enabled")) {
                    HelpTooltip.dispose((Component)((Component)((Object)this)));
                    if (this.$presentation.isEnabledAndVisible()) {
                        Object[] objectArray = new Object[]{classesTabName};
                        new HelpTooltip().setTitle(ActionsBundle.message((String)"action.SearchEverywhereToolbar.text", (Object[])new Object[0])).setShortcut(shortcutText).setDescription(IdeBundle.message((String)"search.everywhere.action.tooltip.description.text", (Object[])objectArray)).installOn((JComponent)((Object)this));
                    }
                } else {
                    String string2;
                    if (this.$presentation.isEnabledAndVisible()) {
                        Object[] objectArray = new Object[]{shortcutText, classesTabName};
                        string2 = IdeBundle.message((String)"search.everywhere.action.tooltip.text", (Object[])objectArray);
                    } else {
                        string2 = "";
                    }
                    this.setToolTipText(string2);
                }
            }

            protected void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                IdeFocusManager ideFocusManager = IdeFocusManager.findInstance();
                Intrinsics.checkNotNullExpressionValue((Object)ideFocusManager, (String)"findInstance()");
                IdeFocusManager focusManager = ideFocusManager;
                Component focusedComponent = focusManager.getFocusOwner();
                Window ideWindow = focusManager.getLastFocusedIdeWindow();
                DataContext dataContext2 = ideWindow == focusedComponent || focusedComponent == focusManager.getLastFocusedFor(ideWindow) ? DataManager.getInstance().getDataContext(focusedComponent) : DataManager.getInstance().getDataContext();
                Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"if (ideWindow === focuse\u2026getInstance().dataContext");
                DataContext dataContext3 = dataContext2;
                if (!SearchEverywhereNewToolbarAction.access$getFirstOpened$p(this.this$0)) {
                    super.actionPerformed(new AnActionEvent(e.getInputEvent(), dataContext3, "RunToolbarLeftSide", this.this$0.getTemplatePresentation(), ActionManager.getInstance(), 0));
                    SearchEverywhereNewToolbarAction.access$setFirstOpened$p(this.this$0, true);
                } else {
                    super.actionPerformed(new AnActionEvent(e.getInputEvent(), dataContext3, "keyboard shortcut", this.this$0.getTemplatePresentation(), ActionManager.getInstance(), 0));
                }
            }

            public int getPopState() {
                return 0;
            }

            public void paint(@Nullable Graphics g) {
                if (this.getPreferredSize().width < ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE.width) {
                    return;
                }
                this.setForeground(JBUI.CurrentTheme.TabbedPane.DISABLED_TEXT_COLOR);
                this.setBackground(JBUI.CurrentTheme.BigPopup.searchFieldBackground());
                super.paint(g);
            }

            protected int iconTextSpace() {
                return super.iconTextSpace() + SearchEverywhereNewToolbarAction.access$getMargin$p(this.this$0);
            }

            public void paintComponent(@NotNull Graphics g) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                UISettings.Companion.setupAntialiasing(g);
                FontMetrics fm = this.getFontMetrics(this.getFont());
                Rectangle viewRect = this.getButtonRect();
                Rectangle iconRect = new Rectangle();
                Rectangle textRect = new Rectangle();
                String text2 = SwingUtilities.layoutCompoundLabel((JComponent)((Object)this), fm, this.$presentation.getText(true), this.getIcon(), 0, this.horizontalTextAlignment(), 0, this.horizontalTextPosition(), viewRect, iconRect, textRect, this.iconTextSpace());
                if (this.this$0.getSeManager() != null) {
                    SearchEverywhereManager searchEverywhereManager = this.this$0.getSeManager();
                    Intrinsics.checkNotNull((Object)searchEverywhereManager);
                    if (searchEverywhereManager.isShown()) {
                        this.setCursor(Cursor.getPredefinedCursor(0));
                        this.setOpaque(false);
                        this.setBorder(null);
                        BasicGraphicsUtils.drawStringUnderlineCharAt(g, ActionsBundle.message((String)"action.SearchEverywhereToolbar.searching.text", (Object[])new Object[0]), this.getMnemonicCharIndex(text2), textRect.x, textRect.y + fm.getAscent());
                        return;
                    }
                }
                this.setCursor(Cursor.getPredefinedCursor(2));
                Icon icon2 = this.getIcon();
                JBInsets.removeFrom(viewRect, this.getInsets());
                JBInsets.removeFrom(viewRect, this.getMargins());
                iconRect.x = SearchEverywhereNewToolbarAction.access$getMargin$p(this.this$0);
                ActionButtonLook look = this.getButtonLook();
                look.paintBackground(g, (JComponent)((Object)this));
                look.paintIcon(g, (ActionButtonComponent)this, icon2, iconRect.x, iconRect.y);
                look.paintBorder(g, (JComponent)((Object)this));
                g.setColor(this.$presentation.isEnabled() ? this.getForeground() : this.getInactiveTextColor());
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, text2, this.getMnemonicCharIndex(text2), textRect.x, textRect.y + fm.getAscent());
            }

            private static final void listener$lambda$0(createCustomComponent.1 this$0, PropertyChangeEvent it) {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                this$0.repaint();
            }
        };
    }

    private final boolean showHotkey() {
        return PropertiesComponent.getInstance().getBoolean(SHOW_HOT_KEY_TIP, true) && !AdvancedSettings.Companion.getBoolean("ide.suppress.double.click.handler");
    }

    public void afterActionPerformed(@NotNull AnAction action2, @NotNull AnActionEvent event, @NotNull AnActionResult result2) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        if (action2 instanceof SearchEverywhereAction) {
            this.logger.trace("SearchEverywhereAction was called (afterAction works)");
            if (this.showHotkey()) {
                this.logger.trace("SearchEverywhereAction hot key flag is on");
                if (event.getInputEvent() instanceof KeyEvent) {
                    this.logger.trace("SearchEverywhereAction key event happened, switching the flag off");
                    PropertiesComponent.getInstance().setValue(SHOW_HOT_KEY_TIP, false, true);
                }
            }
        }
        if (action2 instanceof SearchEverywhereNewToolbarAction && Intrinsics.areEqual((Object)event.getPlace(), (Object)"MainToolbar")) {
            this.clearPosition = true;
        }
    }

    public void beforeActionPerformed(@NotNull AnAction action2, @NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (Intrinsics.areEqual(action2.getClass(), SearchEverywhereAction.class) && this.clearPosition) {
            Project project2 = event.getProject();
            if (project2 != null) {
                Project it = project2;
                boolean bl = false;
                WindowStateService.getInstance((Project)it).putLocation("search.everywhere.popup", null);
            }
            this.clearPosition = false;
        }
    }

    private static final void update$lambda$0(SearchEverywhereNewToolbarAction this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.seManager = null;
    }

    public static final /* synthetic */ boolean access$getFirstOpened$p(SearchEverywhereNewToolbarAction $this) {
        return $this.firstOpened;
    }

    public static final /* synthetic */ void access$setFirstOpened$p(SearchEverywhereNewToolbarAction $this, boolean bl) {
        $this.firstOpened = bl;
    }

    public static final /* synthetic */ int access$getMargin$p(SearchEverywhereNewToolbarAction $this) {
        return $this.margin;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/ide/navigationToolbar/experimental/SearchEverywhereNewToolbarAction$Companion;", "", "()V", "SHOW_HOT_KEY_TIP", "", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

