/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.navbar.ui.UiKt;
import com.intellij.ide.navigationToolbar.NavBarItem;
import com.intellij.ide.navigationToolbar.NavBarModel;
import com.intellij.ide.navigationToolbar.NavBarPanel;
import com.intellij.ide.navigationToolbar.NavBarPopup;
import com.intellij.ide.navigationToolbar.ui.ImageType;
import com.intellij.ide.navigationToolbar.ui.NavBarUI;
import com.intellij.ide.ui.UISettings;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MacUIUtil;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Path2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public abstract class AbstractNavBarUI
implements NavBarUI {
    private static final Map<NavBarItem, Map<ImageType, ScaleContext.Cache<BufferedImage>>> cache = new HashMap<NavBarItem, Map<ImageType, ScaleContext.Cache<BufferedImage>>>();

    @Override
    public Insets getElementIpad(boolean isPopupElement) {
        return isPopupElement ? UiKt.navBarPopupItemInsets() : UiKt.navBarItemInsets();
    }

    @Override
    @Deprecated(forRemoval=true)
    public JBInsets getElementPadding() {
        return ExperimentalUI.isNewUI() ? JBUI.CurrentTheme.StatusBar.Breadcrumbs.itemInsets() : JBUI.insets(3);
    }

    @Override
    public Insets getElementPadding(@NotNull NavBarItem item) {
        if (item == null) {
            AbstractNavBarUI.$$$reportNull$$$0(0);
        }
        return UiKt.navBarItemPadding(item.isInFloatingMode());
    }

    @Override
    public Font getElementFont(NavBarItem navBarItem) {
        return UiKt.navBarItemFont();
    }

    @Override
    public Color getBackground(boolean selected, boolean focused) {
        return UiKt.navBarItemBackground(selected, focused);
    }

    @Override
    @Nullable
    public Color getForeground(boolean selected, boolean focused, boolean inactive) {
        return UiKt.defaultNavBarItemForeground(selected, focused, inactive);
    }

    @Override
    public short getSelectionAlpha() {
        return 150;
    }

    @Override
    public void doPaintNavBarItem(Graphics2D g, NavBarItem item, NavBarPanel navbar) {
        JBInsets paddings = JBInsets.create(this.getElementPadding(item));
        if (ExperimentalUI.isNewUI()) {
            Icon icon2;
            Rectangle rect2 = new Rectangle(item.getSize());
            JBInsets.removeFrom(rect2, (Insets)paddings);
            int offset2 = rect2.x;
            if (!item.isFirstElement()) {
                NavBarItem.CHEVRON_ICON.paintIcon((Component)((Object)item), g, offset2, rect2.y + (rect2.height - NavBarItem.CHEVRON_ICON.getIconHeight()) / 2);
                int delta = NavBarItem.CHEVRON_ICON.getIconWidth() + JBUI.CurrentTheme.StatusBar.Breadcrumbs.CHEVRON_INSET.get();
                offset2 += delta;
                rect2.width -= delta;
            }
            AbstractNavBarUI.paintHighlight(g, navbar, item, new Rectangle(offset2, rect2.y, rect2.width, rect2.height));
            boolean paintIcon = false;
            if (item.needPaintIcon() && (icon2 = item.getIcon()) != null) {
                paintIcon = true;
                icon2.paintIcon((Component)((Object)item), g, offset2 += item.getIpad().left, rect2.y + (rect2.height - icon2.getIconHeight()) / 2 + item.getVerticalIconOffset());
                offset2 += icon2.getIconWidth();
            }
            item.doPaintText(g, offset2 += paintIcon ? item.getIconTextGap() : item.getIpad().left);
        } else {
            Icon icon3;
            boolean floating = navbar.isInFloatingMode();
            boolean toolbarVisible = UISettings.getInstance().getShowMainToolbar();
            boolean selected = item.isSelected() && item.isFocused();
            boolean nextSelected = item.isNextSelected() && navbar.isFocused();
            ImageType type = ImageType.from(floating, toolbarVisible, selected, nextSelected);
            Map cache2 = cache.computeIfAbsent(item, k -> new HashMap());
            ScaleContext.Cache imageCache2 = cache2.computeIfAbsent(type, k -> new ScaleContext.Cache<BufferedImage>(ctx -> AbstractNavBarUI.drawToBuffer((Component)((Object)item), ctx, floating, toolbarVisible, selected, nextSelected, item.isLastElement())));
            BufferedImage image = (BufferedImage)imageCache2.getOrProvide(ScaleContext.create(g));
            if (image == null) {
                return;
            }
            StartupUiUtil.drawImage((Graphics)g, (Image)image, 0, 0, null);
            int offset3 = item.isFirstElement() ? AbstractNavBarUI.getFirstElementLeftOffset() : 0;
            int textOffset = paddings.width() + offset3;
            if (item.needPaintIcon() && (icon3 = item.getIcon()) != null) {
                int iconOffset = paddings.left + offset3;
                icon3.paintIcon((Component)((Object)item), g, iconOffset, (item.getHeight() - icon3.getIconHeight()) / 2);
                textOffset += icon3.getIconWidth();
            }
            item.doPaintText(g, textOffset);
        }
    }

    private static void paintHighlight(Graphics2D g, NavBarPanel panel2, NavBarItem item, Rectangle rectangle) {
        Color color;
        NavBarModel model2 = panel2.getModel();
        NavBarPopup popup2 = panel2.getNodePopup();
        if (item.isMouseHover()) {
            color = JBUI.CurrentTheme.StatusBar.Breadcrumbs.HOVER_BACKGROUND;
        } else if (model2.getSelectedIndex() == item.getIndex() && item.isFocused()) {
            color = JBUI.CurrentTheme.StatusBar.Breadcrumbs.SELECTION_BACKGROUND;
        } else if (model2.getSelectedIndex() == item.getIndex() && popup2 != null && popup2.isVisible() && popup2.getItemIndex() == item.getIndex()) {
            color = JBUI.CurrentTheme.StatusBar.Breadcrumbs.SELECTION_INACTIVE_BACKGROUND;
        } else {
            return;
        }
        AbstractNavBarUI.paintHighlight(g, rectangle, color);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public static void paintHighlight(@NotNull Graphics2D g, @NotNull Rectangle rectangle, @NotNull Color color) {
        if (g == null) {
            AbstractNavBarUI.$$$reportNull$$$0(1);
        }
        if (rectangle == null) {
            AbstractNavBarUI.$$$reportNull$$$0(2);
        }
        if (color == null) {
            AbstractNavBarUI.$$$reportNull$$$0(3);
        }
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
            g2.setColor(color);
            float arc = JBUIScale.scale(4);
            RoundRectangle2D.Float shape = new RoundRectangle2D.Float(rectangle.x, rectangle.y, rectangle.width, rectangle.height, arc, arc);
            g2.fill(shape);
        }
        finally {
            g2.dispose();
        }
    }

    @ApiStatus.Internal
    public static BufferedImage drawToBuffer(@NotNull Component item, ScaleContext ctx, boolean floating, boolean toolbarVisible, boolean selected, boolean nextSelected, boolean isLastElement) {
        if (item == null) {
            AbstractNavBarUI.$$$reportNull$$$0(4);
        }
        int w = item.getWidth();
        int h = item.getHeight();
        int offset2 = w - AbstractNavBarUI.getDecorationOffset();
        int h2 = h / 2;
        BufferedImage result2 = ImageUtil.createImage(ctx, (double)w, (double)h, 2, PaintUtil.RoundingMode.FLOOR);
        Color defaultBg = StartupUiUtil.isUnderDarcula() ? Gray._100 : JBColor.WHITE;
        Color bg = floating ? defaultBg : null;
        Color selection = UIUtil.getListSelectionBackground(true);
        Graphics2D g2 = result2.createGraphics();
        g2.setStroke(new BasicStroke(1.0f, 0, 1));
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Path2D.Double shape = new Path2D.Double();
        shape.moveTo(0.0, 0.0);
        shape.lineTo(offset2, 0.0);
        shape.lineTo(w, h2);
        shape.lineTo(offset2, h);
        shape.lineTo(0.0, h);
        shape.closePath();
        Path2D.Double endShape = new Path2D.Double();
        endShape.moveTo(offset2, 0.0);
        endShape.lineTo(w, 0.0);
        endShape.lineTo(w, h);
        endShape.lineTo(offset2, h);
        endShape.lineTo(w, h2);
        endShape.closePath();
        if (bg != null && toolbarVisible) {
            g2.setPaint(bg);
            g2.fill(shape);
            g2.fill(endShape);
        }
        if (selected) {
            Path2D.Double focusShape = new Path2D.Double();
            if (toolbarVisible || floating) {
                focusShape.moveTo(offset2, 0.0);
            } else {
                focusShape.moveTo(0.0, 0.0);
                focusShape.lineTo(offset2, 0.0);
            }
            focusShape.lineTo(w - 1, h2);
            focusShape.lineTo(offset2, h - 1);
            if (!toolbarVisible && !floating) {
                focusShape.lineTo(0.0, h - 1);
            }
            g2.setColor(selection);
            if (floating && isLastElement) {
                g2.fillRect(0, 0, w, h);
            } else {
                g2.fill(shape);
            }
        }
        if (nextSelected) {
            g2.setColor(selection);
            g2.fill(endShape);
        }
        if (!(isLastElement || selected || nextSelected)) {
            Icon icon2 = AllIcons.Ide.NavBarSeparator;
            icon2.paintIcon(item, g2, w - icon2.getIconWidth() - JBUIScale.scale(1), h2 - icon2.getIconHeight() / 2);
        }
        g2.dispose();
        return result2;
    }

    @ApiStatus.Internal
    public static int getDecorationOffset() {
        return JBUIScale.scale(8);
    }

    @ApiStatus.Internal
    public static int getFirstElementLeftOffset() {
        return JBUIScale.scale(6);
    }

    @Override
    public Dimension getOffsets(NavBarItem item) {
        Dimension size = new Dimension();
        if (!item.isPopupElement()) {
            JBInsets.addTo(size, this.getElementPadding(item));
            if (!ExperimentalUI.isNewUI()) {
                size.width = size.width + (AbstractNavBarUI.getDecorationOffset() + (item.isFirstElement() ? AbstractNavBarUI.getFirstElementLeftOffset() : 0));
            }
        }
        return size;
    }

    @Override
    public Insets getWrapperPanelInsets(Insets insets) {
        JBInsets result2 = JBInsets.create(insets);
        if (AbstractNavBarUI.shouldPaintWrapperPanel()) {
            result2.top += JBUIScale.scale(1);
        }
        return result2;
    }

    private static boolean shouldPaintWrapperPanel() {
        return false;
    }

    protected Color getBackgroundColor() {
        return ColorUtil.darker(UIUtil.getPanelBackground(), 1);
    }

    @Override
    public void clearItems() {
        if (!ExperimentalUI.isNewUI()) {
            cache.clear();
        }
    }

    @Override
    public int getPopupOffset(@NotNull NavBarItem item) {
        if (item == null) {
            AbstractNavBarUI.$$$reportNull$$$0(5);
        }
        return UiKt.navBarPopupOffset(item.isFirstElement());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rectangle";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/navigationToolbar/ui/AbstractNavBarUI";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getElementPadding";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "paintHighlight";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "drawToBuffer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getPopupOffset";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

