/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.ClassLoaderConfiguratorKt;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.MainInfo;
import com.intellij.ide.plugins.PluginDependency;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginSet;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.ide.plugins.cl.ResolveScopeManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.util.SmartList;
import com.intellij.util.lang.ClassPath;
import com.intellij.util.lang.ResourceFile;
import com.intellij.util.lang.UrlClassLoader;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000eH\u0002J\u0006\u0010\u001a\u001a\u00020\u0018J#\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000e2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001dH\u0002\u00a2\u0006\u0002\u0010\u001eJ\u0018\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u0005H\u0002J\u0016\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u000eJ\u000e\u0010%\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u000eJ+\u0010&\u001a\u00020'2\u0006\u0010\u0019\u001a\u00020\u000e2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001d2\u0006\u0010)\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010*J\u0012\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010\u0019\u001a\u00020\u000eH\u0002J\u0018\u0010-\u001a\u00020\u00182\u0006\u0010.\u001a\u00020\u000e2\u0006\u0010/\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\"\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0015\u0010\u0016\u00a8\u00060"}, d2={"Lcom/intellij/ide/plugins/ClassLoaderConfigurator;", "", "pluginSet", "Lcom/intellij/ide/plugins/PluginSet;", "coreLoader", "Ljava/lang/ClassLoader;", "(Lcom/intellij/ide/plugins/PluginSet;Ljava/lang/ClassLoader;)V", "mainToClassPath", "Ljava/util/IdentityHashMap;", "Lcom/intellij/openapi/extensions/PluginId;", "Lcom/intellij/ide/plugins/MainInfo;", "pluginPackagePrefixUniqueGuard", "Ljava/util/HashMap;", "", "Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "getPluginSet", "()Lcom/intellij/ide/plugins/PluginSet;", "resourceFileFactory", "Ljava/util/function/Function;", "Ljava/nio/file/Path;", "Lcom/intellij/util/lang/ResourceFile;", "getResourceFileFactory$annotations", "()V", "checkPackagePrefixUniqueness", "", "module", "configure", "configureCorePluginModuleClassLoader", "deps", "", "(Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;[Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;)V", "configureDependenciesInOldFormat", "mainDependentClassLoader", "configureDependency", "", "mainDescriptor", "moduleDescriptor", "configureModule", "createPluginClassLoader", "Lcom/intellij/ide/plugins/cl/PluginClassLoader;", "dependencies", "mainInfo", "(Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;[Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;Lcom/intellij/ide/plugins/MainInfo;)Lcom/intellij/ide/plugins/cl/PluginClassLoader;", "getCoreUrlClassLoaderIfPossible", "Lcom/intellij/util/lang/UrlClassLoader;", "setPluginClassLoaderForModuleAndOldSubDescriptors", "rootDescriptor", "classLoader", "intellij.platform.core.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nClassLoaderConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassLoaderConfigurator.kt\ncom/intellij/ide/plugins/ClassLoaderConfigurator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,442:1\n1#2:443\n37#3,2:444\n12744#4,2:446\n*S KotlinDebug\n*F\n+ 1 ClassLoaderConfigurator.kt\ncom/intellij/ide/plugins/ClassLoaderConfigurator\n*L\n76#1:444,2\n124#1:446,2\n*E\n"})
public final class ClassLoaderConfigurator {
    @NotNull
    private final PluginSet pluginSet;
    @NotNull
    private final ClassLoader coreLoader;
    @NotNull
    private final HashMap<String, IdeaPluginDescriptorImpl> pluginPackagePrefixUniqueGuard;
    @Nullable
    private final Function<Path, ResourceFile> resourceFileFactory;
    @NotNull
    private final IdentityHashMap<PluginId, MainInfo> mainToClassPath;

    /*
     * WARNING - void declaration
     */
    public ClassLoaderConfigurator(@NotNull PluginSet pluginSet, @NotNull ClassLoader coreLoader) {
        Function function;
        ClassLoaderConfigurator classLoaderConfigurator;
        Intrinsics.checkNotNullParameter((Object)pluginSet, (String)"pluginSet");
        Intrinsics.checkNotNullParameter((Object)coreLoader, (String)"coreLoader");
        this.pluginSet = pluginSet;
        this.coreLoader = coreLoader;
        this.pluginPackagePrefixUniqueGuard = new HashMap();
        this.mainToClassPath = new IdentityHashMap();
        ClassLoaderConfigurator classLoaderConfigurator2 = this;
        try {
            classLoaderConfigurator = classLoaderConfigurator2;
            function = MethodHandles.lookup().findStatic(this.coreLoader.loadClass("com.intellij.util.lang.PathClassLoader"), "getResourceFileFactory", MethodType.methodType(Function.class)).invokeExact();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classLoaderConfigurator = classLoaderConfigurator2;
            function = null;
        }
        catch (Throwable ignore) {
            void e;
            classLoaderConfigurator = classLoaderConfigurator2;
            ClassLoaderConfiguratorKt.access$getLog().error((Throwable)e);
            function = null;
        }
        classLoaderConfigurator.resourceFileFactory = function;
    }

    public /* synthetic */ ClassLoaderConfigurator(PluginSet pluginSet, ClassLoader classLoader, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            ClassLoader classLoader2 = ClassLoaderConfigurator.class.getClassLoader();
            Intrinsics.checkNotNullExpressionValue((Object)classLoader2, (String)"ClassLoaderConfigurator::class.java.classLoader");
            classLoader = classLoader2;
        }
        this(pluginSet, classLoader);
    }

    @NotNull
    public final PluginSet getPluginSet() {
        return this.pluginSet;
    }

    private static /* synthetic */ void getResourceFileFactory$annotations() {
    }

    public final boolean configureDependency(@NotNull IdeaPluginDescriptorImpl mainDescriptor, @NotNull IdeaPluginDescriptorImpl moduleDescriptor) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)mainDescriptor, (String)"mainDescriptor");
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        boolean bl2 = bl = !Intrinsics.areEqual((Object)mainDescriptor, (Object)moduleDescriptor);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-ClassLoaderConfigurator$configureDependency$32 = false;
            String $i$a$-assert-ClassLoaderConfigurator$configureDependency$32 = mainDescriptor + " != " + moduleDescriptor;
            throw new AssertionError((Object)$i$a$-assert-ClassLoaderConfigurator$configureDependency$32);
        }
        PluginId pluginId = mainDescriptor.getPluginId();
        boolean $i$a$-assert-ClassLoaderConfigurator$configureDependency$32 = Intrinsics.areEqual((Object)pluginId, (Object)moduleDescriptor.getPluginId());
        if (_Assertions.ENABLED && !$i$a$-assert-ClassLoaderConfigurator$configureDependency$32) {
            boolean bl3 = false;
            String string2 = "pluginId '" + pluginId + "' != moduleDescriptor.pluginId '" + moduleDescriptor.getPluginId() + '\'';
            throw new AssertionError((Object)string2);
        }
        ClassLoader classLoader = mainDescriptor.getPluginClassLoader();
        Intrinsics.checkNotNull((Object)classLoader, (String)"null cannot be cast to non-null type com.intellij.ide.plugins.cl.PluginClassLoader");
        PluginClassLoader mainClassLoader = (PluginClassLoader)classLoader;
        this.mainToClassPath.put(pluginId, new MainInfo(mainClassLoader));
        return this.configureModule(moduleDescriptor);
    }

    public final void configure() {
        for (IdeaPluginDescriptorImpl module2 : this.pluginSet.getEnabledModules()) {
            this.configureModule(module2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean configureModule(@NotNull IdeaPluginDescriptorImpl module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        this.checkPackagePrefixUniqueness(module2);
        boolean isMain = module2.moduleName == null;
        Collection<IdeaPluginDescriptorImpl> $this$toTypedArray$iv = this.pluginSet.moduleGraph.getDependencies(module2);
        boolean $i$f$toTypedArray = false;
        Collection<IdeaPluginDescriptorImpl> thisCollection$iv = $this$toTypedArray$iv;
        IdeaPluginDescriptorImpl[] dependencies = thisCollection$iv.toArray(new IdeaPluginDescriptorImpl[0]);
        ClassLoaderConfiguratorKt.sortDependenciesInPlace(dependencies);
        if (isMain) {
            if (module2.useCoreClassLoader || Intrinsics.areEqual((Object)module2.getPluginId(), (Object)PluginManagerCore.CORE_ID)) {
                this.setPluginClassLoaderForModuleAndOldSubDescriptors(module2, this.coreLoader);
                return true;
            }
            List files2 = module2.jarFiles;
            if (files2 == null) {
                if (!module2.isUseIdeaClassLoader) {
                    ClassLoaderConfiguratorKt.access$getLog().error("jarFiles is not set for " + module2);
                }
                files2 = CollectionsKt.emptyList();
            }
            SmartList<String> libDirectories = new SmartList<String>();
            Path libDir = module2.path.resolve("lib");
            if (Files.exists(libDir, new LinkOption[0])) {
                libDirectories.add(((Object)libDir.toAbsolutePath()).toString());
            }
            boolean mimicJarUrlConnection = !module2.isBundled() && !Intrinsics.areEqual((Object)module2.getVendor(), (Object)"JetBrains");
            ClassPath pluginClassPath = new ClassPath(files2, ClassLoaderConfiguratorKt.access$getDEFAULT_CLASSLOADER_CONFIGURATION$p(), this.resourceFileFactory, mimicJarUrlConnection);
            MainInfo mainInfo = new MainInfo(pluginClassPath, files2, (List<String>)libDirectories);
            MainInfo existing = this.mainToClassPath.put(module2.getPluginId(), mainInfo);
            if (existing != null) {
                ClassLoaderConfiguratorKt.access$getLog().error(new PluginException("Main module with " + module2.getPluginId() + " is already added (existingClassPath=" + existing.files, module2.getPluginId()));
            }
            ClassLoader mainDependentClassLoader = module2.isUseIdeaClassLoader ? ClassLoaderConfiguratorKt.access$configureUsingIdeaClassloader(mainInfo.files, module2) : (ClassLoader)this.createPluginClassLoader(module2, dependencies, mainInfo);
            module2.setPluginClassLoader(mainDependentClassLoader);
            this.configureDependenciesInOldFormat(module2, mainDependentClassLoader);
            return true;
        } else {
            if (module2.packagePrefix == null) {
                throw new PluginException("Package is not specified (module=" + module2 + ')', module2.getPluginId());
            }
            boolean files2 = module2.pluginDependencies.isEmpty();
            if (_Assertions.ENABLED && !files2) {
                boolean $i$a$-assert-ClassLoaderConfigurator$configureModule$22 = false;
                String $i$a$-assert-ClassLoaderConfigurator$configureModule$22 = "Module " + module2 + " shouldn't have plugin dependencies: " + module2.pluginDependencies;
                throw new AssertionError((Object)$i$a$-assert-ClassLoaderConfigurator$configureModule$22);
            }
            IdeaPluginDescriptorImpl[] $this$any$iv = dependencies;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int j = 0; j < n; ++j) {
                IdeaPluginDescriptorImpl element$iv;
                IdeaPluginDescriptorImpl it = element$iv = $this$any$iv[j];
                boolean bl = false;
                if (it.getPluginClassLoader() == null) {
                    return false;
                }
                boolean bl2 = false;
                if (!bl2) continue;
                return false;
            }
            boolean bl = false;
            if (bl) {
                return false;
            }
            if (module2.useCoreClassLoader) {
                module2.setPluginClassLoader(this.coreLoader);
                return true;
            }
            MainInfo mainInfo = this.mainToClassPath.get(module2.getPluginId());
            if (mainInfo == null) {
                if (!Intrinsics.areEqual((Object)module2.getPluginId(), (Object)PluginManagerCore.CORE_ID)) throw new PluginException("Cannot find containing plugin " + module2.getPluginId() + " for module " + module2.moduleName + ' ', module2.getPluginId());
                this.configureCorePluginModuleClassLoader(module2, dependencies);
                return true;
            } else {
                module2.setPluginClassLoader(new PluginClassLoader(mainInfo.classPath, dependencies, module2, this.coreLoader, ClassLoaderConfiguratorKt.access$createModuleResolveScopeManager(), module2.packagePrefix, mainInfo.libDirectories));
            }
        }
        return true;
    }

    private final void configureDependenciesInOldFormat(IdeaPluginDescriptorImpl module2, ClassLoader mainDependentClassLoader) {
        for (PluginDependency dependency : module2.pluginDependencies) {
            IdeaPluginDescriptorImpl subDescriptor;
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl;
            if (dependency.subDescriptor == null) continue;
            if (this.pluginSet.findEnabledPlugin(dependency.getPluginId()) != null) {
                IdeaPluginDescriptorImpl ideaPluginDescriptorImpl2;
                IdeaPluginDescriptorImpl it = ideaPluginDescriptorImpl2;
                boolean bl = false;
                ideaPluginDescriptorImpl = it != module2 ? ideaPluginDescriptorImpl2 : null;
            } else {
                ideaPluginDescriptorImpl = null;
            }
            if (ideaPluginDescriptorImpl == null) continue;
            subDescriptor.setPluginClassLoader(mainDependentClassLoader);
            this.configureDependenciesInOldFormat(subDescriptor, mainDependentClassLoader);
        }
    }

    private final void configureCorePluginModuleClassLoader(IdeaPluginDescriptorImpl module2, IdeaPluginDescriptorImpl[] deps) {
        UrlClassLoader coreUrlClassLoader = this.getCoreUrlClassLoaderIfPossible(module2);
        if (coreUrlClassLoader == null) {
            this.setPluginClassLoaderForModuleAndOldSubDescriptors(module2, this.coreLoader);
            return;
        }
        ClassPath classPath = coreUrlClassLoader.getClassPath();
        Intrinsics.checkNotNullExpressionValue((Object)classPath, (String)"coreUrlClassLoader.classPath");
        module2.setPluginClassLoader(new PluginClassLoader(classPath, deps, module2, this.coreLoader, ClassLoaderConfiguratorKt.access$createModuleResolveScopeManager(), module2.packagePrefix, new ArrayList()));
    }

    private final UrlClassLoader getCoreUrlClassLoaderIfPossible(IdeaPluginDescriptorImpl module2) {
        UrlClassLoader coreUrlClassLoader;
        ClassLoader classLoader = this.coreLoader;
        UrlClassLoader urlClassLoader = coreUrlClassLoader = classLoader instanceof UrlClassLoader ? (UrlClassLoader)classLoader : null;
        if (coreUrlClassLoader == null) {
            if (!Boolean.getBoolean("idea.use.core.classloader.for.plugin.path")) {
                ClassLoaderConfiguratorKt.access$getLog().error("You must run JVM with -Djava.system.class.loader=com.intellij.util.lang.PathClassLoader");
            }
            this.setPluginClassLoaderForModuleAndOldSubDescriptors(module2, this.coreLoader);
            return null;
        }
        if (coreUrlClassLoader.resolveScopeManager == null) {
            IdeaPluginDescriptorImpl corePlugin = (IdeaPluginDescriptorImpl)CollectionsKt.first(this.pluginSet.enabledPlugins);
            boolean bl = Intrinsics.areEqual((Object)corePlugin.getPluginId(), (Object)PluginManagerCore.CORE_ID);
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            ResolveScopeManager resolveScopeManager = ClassLoaderConfiguratorKt.access$createPluginDependencyAndContentBasedScope(corePlugin, this.pluginSet);
            if (resolveScopeManager != null) {
                coreUrlClassLoader.resolveScopeManager = (arg_0, arg_1) -> ClassLoaderConfigurator.getCoreUrlClassLoaderIfPossible$lambda$5(resolveScopeManager, arg_0, arg_1);
            }
        }
        return coreUrlClassLoader;
    }

    private final void setPluginClassLoaderForModuleAndOldSubDescriptors(IdeaPluginDescriptorImpl rootDescriptor, ClassLoader classLoader) {
        rootDescriptor.setPluginClassLoader(classLoader);
        for (PluginDependency dependency : rootDescriptor.pluginDependencies) {
            IdeaPluginDescriptorImpl subDescriptor = dependency.subDescriptor;
            if (subDescriptor == null || !this.pluginSet.isPluginEnabled(dependency.getPluginId())) continue;
            this.setPluginClassLoaderForModuleAndOldSubDescriptors(subDescriptor, classLoader);
        }
    }

    private final void checkPackagePrefixUniqueness(IdeaPluginDescriptorImpl module2) {
        IdeaPluginDescriptorImpl old;
        String packagePrefix = module2.packagePrefix;
        if (packagePrefix != null && (old = this.pluginPackagePrefixUniqueGuard.putIfAbsent(packagePrefix, module2)) != null) {
            throw new PluginException("Package prefix " + packagePrefix + " is already used (second=" + module2 + ", first=" + old + ')', module2.getPluginId());
        }
    }

    private final PluginClassLoader createPluginClassLoader(IdeaPluginDescriptorImpl module2, IdeaPluginDescriptorImpl[] dependencies, MainInfo mainInfo) {
        ResolveScopeManager resolveScopeManager;
        block15: {
            block13: {
                ResolveScopeManager resolveScopeManager2;
                resolveScopeManager = null;
                if (module2.moduleName != null) break block13;
                switch (module2.getPluginId().getIdString()) {
                    case "com.intellij.diagram": {
                        resolveScopeManager2 = ClassLoaderConfiguratorKt.access$createScopeWithExtraPackage("com.intellij.diagram.");
                        break;
                    }
                    case "com.intellij.struts2": {
                        resolveScopeManager2 = ClassLoaderConfiguratorKt.access$createScopeWithExtraPackage("com.intellij.lang.ognl.");
                        break;
                    }
                    case "com.intellij.properties": {
                        resolveScopeManager2 = new ResolveScopeManager(){

                            @Nullable
                            public String isDefinitelyAlienClass(@NotNull String name, @NotNull String packagePrefix, boolean force) {
                                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                                Intrinsics.checkNotNullParameter((Object)packagePrefix, (String)"packagePrefix");
                                if (force) {
                                    return null;
                                }
                                if (!(StringsKt.startsWith$default((String)name, (String)packagePrefix, (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name, (String)"com.intellij.ultimate.PluginVerifier", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)name, (Object)"com.intellij.codeInspection.unused.ImplicitPropertyUsageProvider"))) {
                                    return "";
                                }
                                return null;
                            }
                        };
                        break;
                    }
                    default: {
                        resolveScopeManager2 = ClassLoaderConfiguratorKt.access$createPluginDependencyAndContentBasedScope(module2, this.pluginSet);
                    }
                }
                resolveScopeManager = resolveScopeManager2;
                break block15;
            }
            resolveScopeManager = module2.content.modules.isEmpty() ? ClassLoaderConfiguratorKt.access$createModuleResolveScopeManager() : ClassLoaderConfiguratorKt.access$createModuleContentBasedScope(module2);
        }
        return new PluginClassLoader(mainInfo.classPath, dependencies, module2, this.coreLoader, resolveScopeManager, module2.packagePrefix, mainInfo.libDirectories);
    }

    private static final String getCoreUrlClassLoaderIfPossible$lambda$5(ResolveScopeManager $resolveScopeManager, String name, Boolean force) {
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
        Intrinsics.checkNotNullExpressionValue((Object)force, (String)"force");
        return $resolveScopeManager.isDefinitelyAlienClass(name, "", force);
    }
}

