/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.EnabledOnDemandPluginsState;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImplKt;
import com.intellij.ide.plugins.PluginEnabler;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0016\u0010\b\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0004H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ide/plugins/DisabledPluginsState;", "Lcom/intellij/ide/plugins/PluginEnabler$Headless;", "()V", "disable", "", "descriptors", "", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "enable", "isDisabled", "pluginId", "Lcom/intellij/openapi/extensions/PluginId;", "isIgnoredDisabledPlugins", "setIgnoredDisabledPlugins", "", "ignoredDisabledPlugins", "Companion", "intellij.platform.core.impl"})
@ApiStatus.Internal
public final class DisabledPluginsState
implements PluginEnabler.Headless {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String DISABLED_PLUGINS_FILENAME = "disabled_plugins.txt";
    private static final boolean IGNORE_DISABLED_PLUGINS = Boolean.getBoolean("idea.ignore.disabled.plugins");
    @Nullable
    private static volatile Set<PluginId> disabledPlugins;
    @NotNull
    private static final CopyOnWriteArrayList<Runnable> ourDisabledPluginListeners;
    private static volatile boolean isDisabledStateIgnored;

    @Override
    public boolean isIgnoredDisabledPlugins() {
        return isDisabledStateIgnored;
    }

    @Override
    public void setIgnoredDisabledPlugins(boolean ignoredDisabledPlugins) {
        isDisabledStateIgnored = ignoredDisabledPlugins;
    }

    @Override
    public boolean isDisabled(@NotNull PluginId pluginId) {
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        return Companion.getDisabledIds().contains(pluginId);
    }

    @Override
    public boolean enable(@NotNull Collection<? extends IdeaPluginDescriptor> descriptors) {
        Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
        return Companion.setEnabledState(descriptors, true);
    }

    @Override
    public boolean disable(@NotNull Collection<? extends IdeaPluginDescriptor> descriptors) {
        Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
        return Companion.setEnabledState(descriptors, false);
    }

    @JvmStatic
    public static final void addDisablePluginListener(@NotNull Runnable listener2) {
        Companion.addDisablePluginListener(listener2);
    }

    @JvmStatic
    public static final void removeDisablePluginListener(@NotNull Runnable listener2) {
        Companion.removeDisablePluginListener(listener2);
    }

    @JvmStatic
    @NotNull
    public static final Set<PluginId> getRequiredPlugins() {
        return Companion.getRequiredPlugins();
    }

    @JvmStatic
    @NotNull
    public static final Set<PluginId> loadDisabledPlugins() {
        return Companion.loadDisabledPlugins();
    }

    @JvmStatic
    @NotNull
    public static final Set<PluginId> getDisabledIds() {
        return Companion.getDisabledIds();
    }

    @JvmStatic
    public static final boolean saveDisabledPluginsAndInvalidate(@NotNull Set<PluginId> pluginIds) {
        return Companion.saveDisabledPluginsAndInvalidate(pluginIds);
    }

    static {
        ourDisabledPluginListeners = new CopyOnWriteArrayList();
        isDisabledStateIgnored = IGNORE_DISABLED_PLUGINS;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0017H\u0007J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0007J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0007J\u0006\u0010\u001d\u001a\u00020\u0019J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0007J\u0010\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0017H\u0007J-\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\t2\u0016\u0010\"\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00040#\"\u0004\u0018\u00010\u0004H\u0007\u00a2\u0006\u0002\u0010$J\u0016\u0010 \u001a\u00020\u00072\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0007J\u001e\u0010%\u001a\u00020\u00072\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\u0006\u0010)\u001a\u00020\u0007H\u0001J\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010+\u001a\u00020\u0004H\u0002J\u001e\u0010,\u001a\u00020\u00072\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u001d\u001a\u00020\u0007H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\f\u0012\u0004\b\u0012\u0010\u0002\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/ide/plugins/DisabledPluginsState$Companion;", "", "()V", "DISABLED_PLUGINS_FILENAME", "", "Lorg/jetbrains/annotations/NonNls;", "IGNORE_DISABLED_PLUGINS", "", "defaultFilePath", "Ljava/nio/file/Path;", "getDefaultFilePath", "()Ljava/nio/file/Path;", "disabledPlugins", "", "Lcom/intellij/openapi/extensions/PluginId;", "isDisabledStateIgnored", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger$annotations", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "ourDisabledPluginListeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Ljava/lang/Runnable;", "addDisablePluginListener", "", "listener", "getDisabledIds", "getRequiredPlugins", "invalidate", "loadDisabledPlugins", "removeDisablePluginListener", "saveDisabledPluginsAndInvalidate", "configPath", "pluginIds", "", "(Ljava/nio/file/Path;[Ljava/lang/String;)V", "setEnabledState", "descriptors", "", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "enabled", "splitByComma", "key", "trySaveDisabledPlugins", "intellij.platform.core.impl"})
    @SourceDebugExtension(value={"SMAP\nDisabledPluginsState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DisabledPluginsState.kt\ncom/intellij/ide/plugins/DisabledPluginsState$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,177:1\n1#2:178\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Path getDefaultFilePath() {
            Path path2 = PathManager.getConfigDir().resolve(DisabledPluginsState.DISABLED_PLUGINS_FILENAME);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getConfigDir().resolve(DISABLED_PLUGINS_FILENAME)");
            return path2;
        }

        private final Logger getLogger() {
            Logger logger = Logger.getInstance("#com.intellij.ide.plugins.DisabledPluginsState");
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(\"#com.intell\u2026ns.DisabledPluginsState\")");
            return logger;
        }

        private static /* synthetic */ void getLogger$annotations() {
        }

        @JvmStatic
        public final void addDisablePluginListener(@NotNull Runnable listener2) {
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            ourDisabledPluginListeners.add(listener2);
        }

        @JvmStatic
        public final void removeDisablePluginListener(@NotNull Runnable listener2) {
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            ourDisabledPluginListeners.remove(listener2);
        }

        @JvmStatic
        @NotNull
        public final Set<PluginId> getRequiredPlugins() {
            return this.splitByComma("idea.required.plugins.id");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @NotNull
        public final Set<PluginId> loadDisabledPlugins() {
            Set<PluginId> suppressedPluginIds;
            Set<PluginId> pluginIdsFromFile;
            boolean updateFile;
            Set<PluginId> requiredPlugins;
            LinkedHashSet<PluginId> disabledPlugins;
            block8: {
                disabledPlugins = new LinkedHashSet<PluginId>();
                Path path2 = this.getDefaultFilePath();
                requiredPlugins = this.getRequiredPlugins();
                updateFile = false;
                Set<PluginId> set2 = PluginManagerCore.tryReadPluginIdsFromFile(path2, this.getLogger());
                Intrinsics.checkNotNullExpressionValue(set2, (String)"tryReadPluginIdsFromFile(path, logger)");
                pluginIdsFromFile = set2;
                suppressedPluginIds = this.splitByComma("idea.suppressed.plugins.id");
                if (!pluginIdsFromFile.isEmpty() || !suppressedPluginIds.isEmpty()) break block8;
                Set set3 = SetsKt.emptySet();
                return set3;
            }
            try {
                ApplicationInfoEx applicationInfoEx = ApplicationInfoImpl.getShadowInstance();
                Intrinsics.checkNotNullExpressionValue((Object)applicationInfoEx, (String)"getShadowInstance()");
                ApplicationInfoEx applicationInfo = applicationInfoEx;
                for (PluginId id : pluginIdsFromFile) {
                    if (!requiredPlugins.contains(id) && !applicationInfo.isEssentialPlugin(id)) {
                        disabledPlugins.add(id);
                        continue;
                    }
                    updateFile = true;
                }
                for (PluginId suppressedPluginId : suppressedPluginIds) {
                    if (applicationInfo.isEssentialPlugin(suppressedPluginId) || !disabledPlugins.add(suppressedPluginId)) continue;
                    updateFile = true;
                }
                Set set4 = disabledPlugins;
                return set4;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (updateFile) {
                    this.trySaveDisabledPlugins((Set<PluginId>)disabledPlugins, false);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @NotNull
        public final Set<PluginId> getDisabledIds() {
            Set set2 = disabledPlugins;
            if (set2 != null) {
                Set it = set2;
                boolean bl = false;
                return it;
            }
            if (isDisabledStateIgnored) {
                Set<PluginId> set3 = Collections.emptySet();
                Intrinsics.checkNotNullExpressionValue(set3, (String)"emptySet()");
                return set3;
            }
            Class<DisabledPluginsState> clazz = DisabledPluginsState.class;
            synchronized (clazz) {
                boolean bl = false;
                Set<PluginId> result2 = disabledPlugins;
                if (result2 == null) {
                    Set<PluginId> set4 = Collections.unmodifiableSet(Companion.loadDisabledPlugins());
                    Intrinsics.checkNotNull(set4);
                    result2 = set4;
                    disabledPlugins = result2;
                }
                Set<PluginId> set5 = result2;
                return set5;
            }
        }

        @JvmName(name="setEnabledState")
        public final boolean setEnabledState(@NotNull Collection<? extends IdeaPluginDescriptor> descriptors, boolean enabled) {
            boolean changed2;
            Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
            Set<PluginId> pluginIds = IdeaPluginDescriptorImplKt.toPluginIdSet((Iterable<? extends IdeaPluginDescriptor>)descriptors);
            Set disabled = CollectionsKt.toMutableSet((Iterable)this.getDisabledIds());
            boolean bl = changed2 = enabled ? disabled.removeAll((Collection)pluginIds) : disabled.addAll((Collection)pluginIds);
            if (changed2) {
                disabledPlugins = Collections.unmodifiableSet(disabled);
            }
            this.getLogger().info(IdeaPluginDescriptorImplKt.joinedPluginIds((Iterable<PluginId>)pluginIds, enabled ? "enable" : "disable"));
            return (changed2 && this.saveDisabledPluginsAndInvalidate(disabled)) | EnabledOnDemandPluginsState.Companion.setEnabledState(descriptors, enabled);
        }

        @JvmStatic
        public final boolean saveDisabledPluginsAndInvalidate(@NotNull Set<PluginId> pluginIds) {
            Intrinsics.checkNotNullParameter(pluginIds, (String)"pluginIds");
            return this.trySaveDisabledPlugins(pluginIds, true);
        }

        private final boolean trySaveDisabledPlugins(Set<PluginId> pluginIds, boolean invalidate2) {
            if (!PluginManagerCore.tryWritePluginIdsToFile(this.getDefaultFilePath(), pluginIds, this.getLogger(), new OpenOption[0])) {
                return false;
            }
            if (invalidate2) {
                this.invalidate();
            }
            for (Runnable listener2 : ourDisabledPluginListeners) {
                listener2.run();
            }
            return true;
        }

        @TestOnly
        public final void saveDisabledPluginsAndInvalidate(@NotNull Path configPath, String ... pluginIds) throws IOException {
            Intrinsics.checkNotNullParameter((Object)configPath, (String)"configPath");
            Intrinsics.checkNotNullParameter((Object)pluginIds, (String)"pluginIds");
            PluginManagerCore.writePluginIdsToFile(configPath.resolve(DisabledPluginsState.DISABLED_PLUGINS_FILENAME), ArraysKt.asList((Object[])pluginIds), new OpenOption[0]);
            this.invalidate();
        }

        public final void invalidate() {
            disabledPlugins = null;
        }

        private final Set<PluginId> splitByComma(String key) {
            Set<PluginId> set2;
            String property = System.getProperty(key, "");
            Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property");
            if (((CharSequence)property).length() == 0) {
                set2 = SetsKt.emptySet();
            } else {
                char[] cArray = new char[]{','};
                set2 = IdeaPluginDescriptorImplKt.toPluginIds(StringsKt.split$default((CharSequence)property, (char[])cArray, (boolean)false, (int)0, (int)6, null));
            }
            return set2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

