/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView;

import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.ide.util.treeView.AbstractTreeUpdater;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ObjectUtils;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;

public abstract class ProjectViewPsiTreeChangeListener
extends PsiTreeChangeAdapter {
    private final PsiModificationTracker myModificationTracker;
    private long myModificationCount;

    protected ProjectViewPsiTreeChangeListener(@NotNull Project project2) {
        if (project2 == null) {
            ProjectViewPsiTreeChangeListener.$$$reportNull$$$0(0);
        }
        this.myModificationTracker = PsiManager.getInstance(project2).getModificationTracker();
        this.myModificationCount = this.myModificationTracker.getModificationCount();
    }

    protected abstract AbstractTreeUpdater getUpdater();

    protected abstract boolean isFlattenPackages();

    protected abstract DefaultMutableTreeNode getRootNode();

    @Override
    public final void childRemoved(@NotNull PsiTreeChangeEvent event) {
        PsiElement child;
        if (event == null) {
            ProjectViewPsiTreeChangeListener.$$$reportNull$$$0(1);
        }
        if ((child = event.getOldChild()) instanceof PsiWhiteSpace) {
            return;
        }
        this.childrenChanged(event.getParent(), true);
    }

    @Override
    public final void childAdded(@NotNull PsiTreeChangeEvent event) {
        PsiElement child;
        if (event == null) {
            ProjectViewPsiTreeChangeListener.$$$reportNull$$$0(2);
        }
        if ((child = event.getNewChild()) instanceof PsiWhiteSpace) {
            return;
        }
        this.childrenChanged(event.getParent(), true);
    }

    @Override
    public final void childReplaced(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            ProjectViewPsiTreeChangeListener.$$$reportNull$$$0(3);
        }
        PsiElement oldChild = event.getOldChild();
        PsiElement newChild = event.getNewChild();
        if (oldChild instanceof PsiWhiteSpace && newChild instanceof PsiWhiteSpace) {
            return;
        }
        this.childrenChanged(event.getParent(), true);
    }

    @Override
    public final void childMoved(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            ProjectViewPsiTreeChangeListener.$$$reportNull$$$0(4);
        }
        this.childrenChanged(event.getOldParent(), false);
        this.childrenChanged(event.getNewParent(), true);
    }

    @Override
    public final void childrenChanged(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            ProjectViewPsiTreeChangeListener.$$$reportNull$$$0(5);
        }
        this.childrenChanged(event.getParent(), true);
    }

    protected void childrenChanged(PsiElement parent2, boolean stopProcessingForThisModificationCount) {
        if (parent2 instanceof PsiDirectory && this.isFlattenPackages()) {
            this.addSubtreeToUpdateByRoot();
            return;
        }
        long newModificationCount = this.myModificationTracker.getModificationCount();
        if (newModificationCount == this.myModificationCount) {
            return;
        }
        if (stopProcessingForThisModificationCount) {
            this.myModificationCount = newModificationCount;
        }
        while (parent2 != null) {
            if (parent2 instanceof PsiFile) {
                VirtualFile virtualFile2 = ((PsiFile)parent2).getVirtualFile();
                if (virtualFile2 != null && !FileTypeRegistry.getInstance().isFileOfType(virtualFile2, FileTypes.PLAIN_TEXT) && (parent2 = ((PsiFile)parent2).getContainingDirectory()) == null) {
                    break;
                }
            } else if (parent2 instanceof PsiDirectory && ScratchUtil.isScratch(((PsiDirectory)parent2).getVirtualFile())) {
                this.addSubtreeToUpdateByRoot();
                break;
            }
            if (this.addSubtreeToUpdateByElementFile(parent2) || parent2 instanceof PsiFile || parent2 instanceof PsiDirectory) break;
            parent2 = parent2.getParent();
        }
    }

    @Override
    public void propertyChanged(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            ProjectViewPsiTreeChangeListener.$$$reportNull$$$0(6);
        }
        String propertyName = event.getPropertyName();
        PsiElement element = event.getElement();
        switch (propertyName) {
            case "roots": 
            case "propFileTypes": 
            case "propUnloadedPsi": {
                this.addSubtreeToUpdateByRoot();
                break;
            }
            case "writable": {
                if (this.addSubtreeToUpdateByElementFile(element) || !(element instanceof PsiFile)) break;
                this.addSubtreeToUpdateByElementFile(((PsiFile)element).getContainingDirectory());
                break;
            }
            case "fileName": 
            case "directoryName": {
                if (element instanceof PsiDirectory && this.isFlattenPackages()) {
                    this.addSubtreeToUpdateByRoot();
                    return;
                }
                PsiElement parent2 = element.getParent();
                if (parent2 != null && this.addSubtreeToUpdateByElementFile(parent2)) break;
                this.addSubtreeToUpdateByElementFile(element);
            }
        }
    }

    protected void addSubtreeToUpdateByRoot() {
        AbstractTreeUpdater updater2 = this.getUpdater();
        DefaultMutableTreeNode root = this.getRootNode();
        if (updater2 != null && root != null) {
            updater2.addSubtreeToUpdate(root);
        }
    }

    protected boolean addSubtreeToUpdateByElement(@NotNull PsiElement element) {
        AbstractTreeUpdater updater2;
        if (element == null) {
            ProjectViewPsiTreeChangeListener.$$$reportNull$$$0(7);
        }
        return (updater2 = this.getUpdater()) != null && updater2.addSubtreeToUpdateByElement((Object)element);
    }

    private boolean addSubtreeToUpdateByElementFile(PsiElement element) {
        return element != null && this.addSubtreeToUpdateByElement(ObjectUtils.notNull(element.getContainingFile(), element));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/projectView/ProjectViewPsiTreeChangeListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "childRemoved";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "childAdded";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "childReplaced";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "childMoved";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "childrenChanged";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "propertyChanged";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "addSubtreeToUpdateByElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

