/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.actions;

import com.intellij.ide.actions.OpenModuleSettingsAction;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ConfigureUnloadedModulesDialog;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ide/projectView/actions/LoadUnloadModulesAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getSelectedUnloadedModuleName", "", "isEnabled", "", "update", "intellij.platform.lang.impl"})
public final class LoadUnloadModulesAction
extends DumbAwareAction {
    public LoadUnloadModulesAction() {
        super(ActionsBundle.actionText((String)"LoadUnloadModules"));
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(this.isEnabled(e));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private final boolean isEnabled(AnActionEvent e) {
        Project project2 = e.getProject();
        if (project2 == null) {
            return false;
        }
        Project project3 = project2;
        ModuleManager moduleManager = ModuleManager.Companion.getInstance(project3);
        if (moduleManager.getModules().length <= 1 && moduleManager.getUnloadedModuleDescriptions().isEmpty()) {
            return false;
        }
        VirtualFile file2 = (VirtualFile)e.getData(LangDataKeys.VIRTUAL_FILE);
        return !ActionPlaces.isPopupPlace((String)e.getPlace()) || OpenModuleSettingsAction.isModuleInContext((AnActionEvent)e) || file2 != null && ProjectRootsUtil.findUnloadedModuleByContentRoot(file2, project3) != null;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Object object = (Module)e.getData(LangDataKeys.MODULE_CONTEXT);
        if ((object == null || (object = object.getName()) == null) && (object = this.getSelectedUnloadedModuleName(e)) == null) {
            Module module2 = (Module)e.getData(PlatformCoreDataKeys.MODULE);
            object = module2 != null ? module2.getName() : null;
        }
        Object selectedModuleName = object;
        Project project2 = e.getProject();
        Intrinsics.checkNotNull((Object)project2);
        new ConfigureUnloadedModulesDialog(project2, (String)selectedModuleName).show();
    }

    private final String getSelectedUnloadedModuleName(AnActionEvent e) {
        Project project2 = e.getProject();
        if (project2 == null) {
            return null;
        }
        Project project3 = project2;
        VirtualFile virtualFile2 = (VirtualFile)e.getData(LangDataKeys.VIRTUAL_FILE);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile file2 = virtualFile2;
        return ProjectRootsUtil.findUnloadedModuleByFile(file2, project3);
    }
}

