/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.actions.MarkRootActionBase;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class MarkExcludeRootAction
extends MarkRootActionBase {
    public MarkExcludeRootAction() {
        super(null, null, AllIcons.Modules.ExcludeRoot);
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            MarkExcludeRootAction.$$$reportNull$$$0(0);
        }
        VirtualFile[] files2 = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (Registry.is("ide.hide.excluded.files")) {
            String message = files2.length == 1 ? FileUtil.toSystemDependentName(files2[0].getPath()) : LangBundle.message("dialog.message.selected.files", files2.length);
            int rc = Messages.showOkCancelDialog((Project)((Project)e.getData(CommonDataKeys.PROJECT)), (String)this.getPromptText(message), (String)LangBundle.message("dialog.title.mark.as.excluded", new Object[0]), (Icon)Messages.getQuestionIcon());
            if (rc != 0) {
                return;
            }
        }
        super.actionPerformed(e);
    }

    @NlsContexts.DialogMessage
    protected String getPromptText(@NlsContexts.DialogMessage String message) {
        return LangBundle.message("dialog.message.are.you.sure.you.would.like.to.exclude", message);
    }

    @Override
    protected void modifyRoots(@NotNull VirtualFile vFile, @NotNull ContentEntry entry) {
        if (vFile == null) {
            MarkExcludeRootAction.$$$reportNull$$$0(1);
        }
        if (entry == null) {
            MarkExcludeRootAction.$$$reportNull$$$0(2);
        }
        entry.addExcludeFolder(vFile);
    }

    @Override
    protected boolean isEnabled(@NotNull MarkRootActionBase.RootsSelection selection, @NotNull Module module2) {
        if (selection == null) {
            MarkExcludeRootAction.$$$reportNull$$$0(3);
        }
        if (module2 == null) {
            MarkExcludeRootAction.$$$reportNull$$$0(4);
        }
        ModuleFileIndex index2 = ModuleRootManager.getInstance(module2).getFileIndex();
        return selection.mySelectedDirectories.stream().allMatch(file2 -> index2.isInContent((VirtualFile)file2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/projectView/actions/MarkExcludeRootAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "modifyRoots";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

