/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.actions;

import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ExcludeFolder;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MarkRootActionBase
extends DumbAwareAction {
    public MarkRootActionBase() {
    }

    public MarkRootActionBase(@Nullable @NlsActions.ActionText String text2) {
        super(text2);
    }

    public MarkRootActionBase(@Nullable @NlsActions.ActionText String text2, @Nullable @NlsActions.ActionDescription String description, @Nullable Icon icon2) {
        super(text2, description, icon2);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile[] files2;
        Module module2;
        if (e == null) {
            MarkRootActionBase.$$$reportNull$$$0(0);
        }
        if ((module2 = MarkRootActionBase.getModule(e, files2 = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY))) == null) {
            return;
        }
        this.modifyRoots(e, module2, files2);
    }

    protected void modifyRoots(@NotNull AnActionEvent e, @NotNull Module module2, VirtualFile @NotNull [] files2) {
        if (e == null) {
            MarkRootActionBase.$$$reportNull$$$0(1);
        }
        if (module2 == null) {
            MarkRootActionBase.$$$reportNull$$$0(2);
        }
        if (files2 == null) {
            MarkRootActionBase.$$$reportNull$$$0(3);
        }
        this.modifyRoots(module2, files2);
    }

    protected void modifyRoots(@NotNull Module module2, VirtualFile @NotNull [] files2) {
        if (module2 == null) {
            MarkRootActionBase.$$$reportNull$$$0(4);
        }
        if (files2 == null) {
            MarkRootActionBase.$$$reportNull$$$0(5);
        }
        ModifiableRootModel model2 = ModuleRootManager.getInstance(module2).getModifiableModel();
        for (VirtualFile file2 : files2) {
            SourceFolder[] sourceFolders2;
            ContentEntry entry = MarkRootActionBase.findContentEntry(model2, file2);
            if (entry == null) continue;
            for (SourceFolder sourceFolder : sourceFolders2 = entry.getSourceFolders()) {
                if (!Comparing.equal(sourceFolder.getFile(), file2)) continue;
                entry.removeSourceFolder(sourceFolder);
                break;
            }
            this.modifyRoots(file2, entry);
        }
        MarkRootActionBase.commitModel(module2, model2);
    }

    static void commitModel(@NotNull Module module2, ModifiableRootModel model2) {
        if (module2 == null) {
            MarkRootActionBase.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().runWriteAction(model2::commit);
        SaveAndSyncHandler.getInstance().scheduleProjectSave(module2.getProject());
    }

    protected abstract void modifyRoots(VirtualFile var1, ContentEntry var2);

    @Nullable
    public static ContentEntry findContentEntry(@NotNull ModuleRootModel model2, @NotNull VirtualFile vFile) {
        ContentEntry[] contentEntries;
        if (model2 == null) {
            MarkRootActionBase.$$$reportNull$$$0(7);
        }
        if (vFile == null) {
            MarkRootActionBase.$$$reportNull$$$0(8);
        }
        for (ContentEntry contentEntry : contentEntries = model2.getContentEntries()) {
            VirtualFile contentEntryFile = contentEntry.getFile();
            if (contentEntryFile == null || !VfsUtilCore.isAncestor(contentEntryFile, vFile, false)) continue;
            return contentEntry;
        }
        return null;
    }

    @NotNull
    public final ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            MarkRootActionBase.$$$reportNull$$$0(9);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            MarkRootActionBase.$$$reportNull$$$0(10);
        }
        RootsSelection selection = MarkRootActionBase.getSelection(e);
        this.doUpdate(e, selection.myModule, selection);
    }

    protected void doUpdate(@NotNull AnActionEvent e, @Nullable Module module2, @NotNull RootsSelection selection) {
        if (e == null) {
            MarkRootActionBase.$$$reportNull$$$0(11);
        }
        if (selection == null) {
            MarkRootActionBase.$$$reportNull$$$0(12);
        }
        boolean enabled = module2 != null && (!selection.mySelectedRoots.isEmpty() || !selection.mySelectedDirectories.isEmpty()) && selection.mySelectedExcludeRoots.isEmpty() && this.isEnabled(selection, module2);
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    protected abstract boolean isEnabled(@NotNull RootsSelection var1, @NotNull Module var2);

    protected static RootsSelection getSelection(@NotNull AnActionEvent e) {
        VirtualFile[] files2;
        Module module2;
        if (e == null) {
            MarkRootActionBase.$$$reportNull$$$0(13);
        }
        if ((module2 = MarkRootActionBase.getModule(e, files2 = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY))) == null) {
            return RootsSelection.EMPTY;
        }
        RootsSelection selection = new RootsSelection(module2);
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance(module2.getProject()).getFileIndex();
        for (VirtualFile file2 : files2) {
            if (!file2.isDirectory()) {
                return RootsSelection.EMPTY;
            }
            ExcludeFolder excludeFolder = ProjectRootsUtil.findExcludeFolder(module2, file2);
            if (excludeFolder != null) {
                selection.mySelectedExcludeRoots.add(excludeFolder);
                continue;
            }
            SourceFolder folder = ProjectRootsUtil.getModuleSourceRoot(file2, module2.getProject());
            if (folder != null && folder.getContentEntry().getRootModel().getModule().equals(module2)) {
                selection.mySelectedRoots.add(folder);
                continue;
            }
            selection.mySelectedDirectories.add(file2);
            if (!fileIndex.isInSourceContent(file2)) continue;
            selection.myHaveSelectedFilesUnderSourceRoots = true;
        }
        return selection;
    }

    @Nullable
    static Module getModule(@NotNull AnActionEvent e, VirtualFile @Nullable [] files2) {
        if (e == null) {
            MarkRootActionBase.$$$reportNull$$$0(14);
        }
        if (files2 == null) {
            return null;
        }
        Module module2 = (Module)e.getData(PlatformCoreDataKeys.MODULE);
        if (module2 == null) {
            module2 = MarkRootActionBase.findParentModule(e.getProject(), files2);
        }
        return module2;
    }

    @Nullable
    private static Module findParentModule(@Nullable Project project2, VirtualFile @NotNull [] files2) {
        if (files2 == null) {
            MarkRootActionBase.$$$reportNull$$$0(15);
        }
        if (project2 == null) {
            return null;
        }
        Module result2 = null;
        ProjectFileIndex index2 = ProjectFileIndex.getInstance(project2);
        for (VirtualFile file2 : files2) {
            Module module2 = index2.getModuleForFile(file2, false);
            if (module2 == null) {
                return null;
            }
            if (result2 == null) {
                result2 = module2;
                continue;
            }
            if (result2.equals(module2)) continue;
            return null;
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 5: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/actions/MarkRootActionBase";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/actions/MarkRootActionBase";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "modifyRoots";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "commitModel";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findContentEntry";
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doUpdate";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSelection";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getModule";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findParentModule";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 9 -> new IllegalStateException(string2);
        };
    }

    public static class RootsSelection {
        public static final RootsSelection EMPTY = new RootsSelection(null);
        public final Module myModule;
        public List<SourceFolder> mySelectedRoots = new ArrayList<SourceFolder>();
        public List<ExcludeFolder> mySelectedExcludeRoots = new ArrayList<ExcludeFolder>();
        public List<VirtualFile> mySelectedDirectories = new ArrayList<VirtualFile>();
        public boolean myHaveSelectedFilesUnderSourceRoots;

        public RootsSelection(Module module2) {
            this.myModule = module2;
        }
    }
}

