/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.PsiCopyPasteManager;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.dnd.DnDAction;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDEventImpl;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDSource;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.ide.dnd.TransferableWrapper;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.projectView.BaseProjectTreeBuilder;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ProjectViewNodeDecorator;
import com.intellij.ide.projectView.RootsProvider;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.impl.AsyncProjectViewSupport;
import com.intellij.ide.projectView.impl.DetachLibraryDeleteProvider;
import com.intellij.ide.projectView.impl.GroupByTypeComparator;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.projectView.impl.ProjectViewDeleteElementProvider;
import com.intellij.ide.projectView.impl.ProjectViewDropTarget;
import com.intellij.ide.projectView.impl.ProjectViewFileVisitor;
import com.intellij.ide.projectView.impl.ProjectViewNodeVisitor;
import com.intellij.ide.projectView.impl.ProjectViewRenderer;
import com.intellij.ide.projectView.impl.ProjectViewUtilKt;
import com.intellij.ide.projectView.impl.nodes.AbstractModuleNode;
import com.intellij.ide.projectView.impl.nodes.AbstractProjectNode;
import com.intellij.ide.projectView.impl.nodes.LibraryGroupElement;
import com.intellij.ide.projectView.impl.nodes.ModuleGroupNode;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElement;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.AbstractTreeStructureBase;
import com.intellij.ide.util.treeView.AbstractTreeUi;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CompositeDataProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.ProjectExtensionPointName;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorTabPresentationUtil;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ui.configuration.actions.ModuleDeleteProvider;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.BusyObject;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.pom.Navigatable;
import com.intellij.problems.ProblemListener;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiAwareObject;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.move.MoveHandler;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.TreePathUtil;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.tree.project.ProjectFileNode;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.InvokerSupplier;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public abstract class AbstractProjectViewPane
implements DataProvider,
Disposable,
BusyObject {
    private static final Logger LOG = Logger.getInstance(AbstractProjectViewPane.class);
    public static final ProjectExtensionPointName<AbstractProjectViewPane> EP = new ProjectExtensionPointName("com.intellij.projectViewPane");
    @NotNull
    protected final Project myProject;
    protected DnDAwareTree myTree;
    protected AbstractTreeStructure myTreeStructure;
    private AbstractTreeBuilder myTreeBuilder;
    private TreeExpander myTreeExpander;
    private final Map<String, TreeState> myReadTreeState;
    private final AtomicBoolean myTreeStateRestored;
    private String mySubId;
    @NonNls
    private static final String ELEMENT_SUB_PANE = "subPane";
    @NonNls
    private static final String ATTRIBUTE_SUB_ID = "subId";
    private DnDTarget myDropTarget;
    private DnDSource myDragSource;
    private final DeleteProvider myDeletePSIElementProvider;

    private void queueUpdateByProblem() {
        if (Registry.is("projectView.showHierarchyErrors") && this.myTreeBuilder != null) {
            this.myTreeBuilder.queueUpdate();
        }
    }

    protected AbstractProjectViewPane(@NotNull Project project2) {
        if (project2 == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(0);
        }
        this.myReadTreeState = new HashMap<String, TreeState>();
        this.myTreeStateRestored = new AtomicBoolean();
        this.myDeletePSIElementProvider = new ProjectViewDeleteElementProvider(){

            @Override
            protected PsiElement @NotNull [] getSelectedPSIElements(@NotNull DataContext dataContext2) {
                Object[] objects;
                if (dataContext2 == null) {
                    6.$$$reportNull$$$0(0);
                }
                if ((objects = (Object[])dataContext2.getData(PlatformCoreDataKeys.SELECTED_ITEMS)) == null) {
                    if (PsiElement.EMPTY_ARRAY == null) {
                        6.$$$reportNull$$$0(1);
                    }
                    return PsiElement.EMPTY_ARRAY;
                }
                PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(ContainerUtil.flatMap(Arrays.asList(objects), o -> AbstractProjectViewPane.this.getElementsFromNode(o)));
                if (psiElementArray == null) {
                    6.$$$reportNull$$$0(2);
                }
                return psiElementArray;
            }

            @Override
            protected Boolean hideEmptyMiddlePackages(@NotNull DataContext dataContext2) {
                Project project2;
                if (dataContext2 == null) {
                    6.$$$reportNull$$$0(3);
                }
                return (project2 = (Project)dataContext2.getData(CommonDataKeys.PROJECT)) != null && ProjectView.getInstance(project2).isHideEmptyMiddlePackages(AbstractProjectViewPane.this.getId());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataContext";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/projectView/impl/AbstractProjectViewPane$6";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/projectView/impl/AbstractProjectViewPane$6";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSelectedPSIElements";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getSelectedPSIElements";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "hideEmptyMiddlePackages";
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string2);
                    case 1, 2 -> new IllegalStateException(string2);
                };
            }
        };
        this.myProject = project2;
        ProblemListener problemListener = new ProblemListener(){

            @Override
            public void problemsAppeared(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                AbstractProjectViewPane.this.queueUpdateByProblem();
            }

            @Override
            public void problemsChanged(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                AbstractProjectViewPane.this.queueUpdateByProblem();
            }

            @Override
            public void problemsDisappeared(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                AbstractProjectViewPane.this.queueUpdateByProblem();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "file";
                objectArray2[1] = "com/intellij/ide/projectView/impl/AbstractProjectViewPane$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "problemsAppeared";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "problemsChanged";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "problemsDisappeared";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        project2.getMessageBus().connect(this).subscribe(ProblemListener.TOPIC, problemListener);
        Disposer.register(project2, this);
        TreeStructureProvider.EP.addExtensionPointListener(project2, new ExtensionPointListener<TreeStructureProvider>(){

            @Override
            public void extensionAdded(@NotNull TreeStructureProvider extension2, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(1);
                }
                AbstractProjectViewPane.this.rebuildCompletely(false);
            }

            @Override
            public void extensionRemoved(@NotNull TreeStructureProvider extension2, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(3);
                }
                AbstractProjectViewPane.this.rebuildCompletely(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ide/projectView/impl/AbstractProjectViewPane$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, this);
        ProjectViewNodeDecorator.EP.addExtensionPointListener(project2, new ExtensionPointListener<ProjectViewNodeDecorator>(){

            @Override
            public void extensionAdded(@NotNull ProjectViewNodeDecorator extension2, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    3.$$$reportNull$$$0(1);
                }
                AbstractProjectViewPane.this.rebuildCompletely(false);
            }

            @Override
            public void extensionRemoved(@NotNull ProjectViewNodeDecorator extension2, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension2 == null) {
                    3.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    3.$$$reportNull$$$0(3);
                }
                AbstractProjectViewPane.this.rebuildCompletely(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ide/projectView/impl/AbstractProjectViewPane$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, this);
    }

    private void rebuildCompletely(boolean wait) {
        ActionCallback callback = this.updateFromRoot(true);
        if (wait) {
            callback.waitFor(5000L);
        }
        this.myReadTreeState.clear();
        JTree tree = this.getTree();
        if (tree != null) {
            tree.clearSelection();
            tree.setAnchorSelectionPath(null);
            tree.setLeadSelectionPath(null);
        }
    }

    @Deprecated(forRemoval=true)
    protected final void fireTreeChangeListener() {
    }

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Title)
    public abstract String getTitle();

    @NotNull
    public abstract Icon getIcon();

    @NotNull
    public abstract String getId();

    public boolean isDefaultPane(@NotNull Project project2) {
        if (project2 == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(1);
        }
        return false;
    }

    @Nullable
    public final String getSubId() {
        return this.mySubId;
    }

    public final void setSubId(@Nullable String subId) {
        if (Comparing.strEqual(this.mySubId, subId)) {
            return;
        }
        this.saveExpandedPaths();
        this.mySubId = subId;
        this.onSubIdChange();
    }

    protected void onSubIdChange() {
    }

    public boolean isInitiallyVisible() {
        return true;
    }

    public boolean supportsManualOrder() {
        return false;
    }

    @NotNull
    @NlsActions.ActionText
    protected String getManualOrderOptionText() {
        String string2 = IdeBundle.message((String)"action.manual.order", (Object[])new Object[0]);
        if (string2 == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(2);
        }
        return string2;
    }

    public String @NotNull [] getSubIds() {
        if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(3);
        }
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    @NotNull
    @NlsSafe
    public String getPresentableSubIdName(@NotNull @NonNls String subId) {
        if (subId == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(4);
        }
        throw new IllegalStateException("should not call");
    }

    @NotNull
    public Icon getPresentableSubIdIcon(@NotNull String subId) {
        if (subId == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(5);
        }
        Icon icon2 = this.getIcon();
        if (icon2 == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(6);
        }
        return icon2;
    }

    @NotNull
    public abstract JComponent createComponent();

    public JComponent getComponentToFocus() {
        return this.myTree;
    }

    public void expand(Object @Nullable [] path2, boolean requestFocus) {
        DefaultMutableTreeNode node2;
        if (this.getTreeBuilder() == null || path2 == null) {
            return;
        }
        AbstractTreeUi ui = this.getTreeBuilder().getUi();
        if (ui != null) {
            ui.buildNodeForPath(path2);
        }
        DefaultMutableTreeNode defaultMutableTreeNode = node2 = ui == null ? null : ui.getNodeForPath(path2);
        if (node2 == null) {
            return;
        }
        TreePath treePath = new TreePath(node2.getPath());
        this.myTree.expandPath(treePath);
        if (requestFocus) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myTree, true));
        }
        TreeUtil.selectPath((JTree)this.myTree, (TreePath)treePath);
    }

    @Override
    public void dispose() {
        if (this.myDropTarget != null) {
            DnDManager.getInstance().unregisterTarget(this.myDropTarget, (JComponent)this.myTree);
            this.myDropTarget = null;
        }
        if (this.myDragSource != null) {
            DnDManager.getInstance().unregisterSource(this.myDragSource, (JComponent)this.myTree);
            this.myDragSource = null;
        }
        this.setTreeBuilder(null);
        this.myTree = null;
        this.myTreeStructure = null;
    }

    @NotNull
    public abstract ActionCallback updateFromRoot(boolean var1);

    public void updateFrom(Object element, boolean forceResort, boolean updateStructure) {
        AsyncProjectViewSupport support;
        AbstractTreeBuilder builder2 = this.getTreeBuilder();
        if (builder2 != null) {
            builder2.queueUpdateFrom(element, forceResort, updateStructure);
        } else if (element instanceof PsiElement) {
            AsyncProjectViewSupport support2 = this.getAsyncSupport();
            if (support2 != null) {
                support2.updateByElement((PsiElement)element, updateStructure);
            }
        } else if (element instanceof TreePath && (support = this.getAsyncSupport()) != null) {
            support.update((TreePath)element, updateStructure);
        }
    }

    public abstract void select(Object var1, VirtualFile var2, boolean var3);

    public void selectModule(@NotNull Module module2, boolean requestFocus) {
        if (module2 == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(7);
        }
        this.doSelectModuleOrGroup(module2, requestFocus);
    }

    private void doSelectModuleOrGroup(@NotNull Object toSelect2, boolean requestFocus) {
        if (toSelect2 == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(8);
        }
        ToolWindowManager windowManager = ToolWindowManager.getInstance((Project)this.myProject);
        Runnable runnable = () -> {
            BaseProjectTreeBuilder builder2;
            ProjectView projectView;
            if (requestFocus && (projectView = ProjectView.getInstance(this.myProject)) != null) {
                projectView.changeView(this.getId(), this.getSubId());
            }
            if ((builder2 = (BaseProjectTreeBuilder)this.getTreeBuilder()) != null) {
                builder2.selectInWidth(toSelect2, requestFocus, node2 -> node2 instanceof AbstractModuleNode || node2 instanceof ModuleGroupNode || node2 instanceof AbstractProjectNode);
            }
        };
        if (requestFocus) {
            windowManager.getToolWindow("Project").activate(runnable);
        } else {
            runnable.run();
        }
    }

    public void selectModuleGroup(@NotNull ModuleGroup moduleGroup, boolean requestFocus) {
        if (moduleGroup == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(9);
        }
        this.doSelectModuleOrGroup(moduleGroup, requestFocus);
    }

    public TreePath @Nullable [] getSelectionPaths() {
        return this.myTree == null ? null : this.myTree.getSelectionPaths();
    }

    public void addToolbarActions(@NotNull DefaultActionGroup actionGroup2) {
        if (actionGroup2 == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(10);
        }
    }

    @RequiresEdt
    public final @Nullable Object @NotNull [] getSelectedUserObjects() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        TreePath[] paths2 = this.getSelectionPaths();
        Object[] objectArray = paths2 == null ? ArrayUtil.EMPTY_OBJECT_ARRAY : ArrayUtil.toObjectArray(ContainerUtil.map(paths2, TreeUtil::getLastUserObject));
        if (objectArray == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(11);
        }
        return objectArray;
    }

    @RequiresEdt
    @Nullable
    public final @Nullable Object @Nullable [] getSingleSelectedPathUserObjects() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        TreePath singlePath = this.getSelectedPath();
        return singlePath == null ? null : ArrayUtil.toObjectArray(ContainerUtil.map(singlePath.getPath(), TreeUtil::getUserObject));
    }

    @Deprecated(forRemoval=true)
    @NotNull
    protected <T extends NodeDescriptor<?>> List<T> getSelectedNodes(@NotNull Class<T> nodeClass) {
        TreePath[] paths2;
        if (nodeClass == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(12);
        }
        if ((paths2 = this.getSelectionPaths()) == null) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                AbstractProjectViewPane.$$$reportNull$$$0(13);
            }
            return list2;
        }
        ArrayList<NodeDescriptor> result2 = new ArrayList<NodeDescriptor>();
        for (TreePath path2 : paths2) {
            NodeDescriptor userObject = (NodeDescriptor)TreeUtil.getLastUserObject(nodeClass, (TreePath)path2);
            if (userObject == null) continue;
            result2.add(userObject);
        }
        ArrayList<NodeDescriptor> arrayList = result2;
        if (arrayList == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    public boolean isAutoScrollEnabledFor(@NotNull VirtualFile file2) {
        if (file2 == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(15);
        }
        return true;
    }

    public boolean isAutoScrollEnabledWithoutFocus() {
        return false;
    }

    public boolean isFileNestingEnabled() {
        return false;
    }

    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(16);
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        Object[] selectedUserObjects = this.getSelectedUserObjects();
        if (PlatformCoreDataKeys.SELECTED_ITEMS.is(dataId)) {
            return selectedUserObjects;
        }
        if (PlatformDataKeys.LAST_ACTIVE_FILE_EDITOR.is(dataId)) {
            return FileEditorManagerEx.getInstanceEx((Project)this.myProject).getSelectedEditor();
        }
        if (PlatformCoreDataKeys.BGT_DATA_PROVIDER.is(dataId)) {
            return this.slowProviders(selectedUserObjects);
        }
        Object treeStructureData = this.getFromTreeStructure(selectedUserObjects, dataId);
        if (treeStructureData != null) {
            return treeStructureData;
        }
        if (PlatformDataKeys.TREE_EXPANDER.is(dataId)) {
            return this.getTreeExpander();
        }
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            TreePath[] paths2 = this.getSelectionPaths();
            if (paths2 == null) {
                return null;
            }
            ArrayList<Navigatable> navigatables = new ArrayList<Navigatable>();
            for (TreePath path2 : paths2) {
                Object node2 = path2.getLastPathComponent();
                Object userObject = TreeUtil.getUserObject((Object)node2);
                if (userObject instanceof Navigatable) {
                    navigatables.add((Navigatable)userObject);
                    continue;
                }
                if (!(node2 instanceof Navigatable)) continue;
                navigatables.add((Navigatable)node2);
            }
            return navigatables.isEmpty() ? null : navigatables.toArray(Navigatable.EMPTY_NAVIGATABLE_ARRAY);
        }
        return null;
    }

    public abstract int getWeight();

    @NotNull
    public abstract SelectInTarget createSelectInTarget();

    @Nullable
    public final TreePath getSelectedPath() {
        return TreeUtil.getSelectedPathIfOne((JTree)this.myTree);
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public final NodeDescriptor getSelectedDescriptor() {
        return (NodeDescriptor)TreeUtil.getLastUserObject(NodeDescriptor.class, (TreePath)this.getSelectedPath());
    }

    @Deprecated(forRemoval=true)
    public final DefaultMutableTreeNode getSelectedNode() {
        TreePath path2 = this.getSelectedPath();
        return path2 == null ? null : ObjectUtils.tryCast(path2.getLastPathComponent(), DefaultMutableTreeNode.class);
    }

    @Deprecated(forRemoval=true)
    public final Object getSelectedElement() {
        Object[] elements = this.getSelectedElements();
        return elements.length == 1 ? elements[0] : null;
    }

    @Deprecated(forRemoval=true)
    public final PsiElement @NotNull [] getSelectedPSIElements() {
        TreePath[] paths2 = this.getSelectionPaths();
        if (paths2 == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                AbstractProjectViewPane.$$$reportNull$$$0(17);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        for (TreePath path2 : paths2) {
            result2.addAll(this.getElementsFromNode(path2.getLastPathComponent()));
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(result2);
        if (psiElementArray == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(18);
        }
        return psiElementArray;
    }

    @Nullable
    private DataProvider slowProviders(@Nullable Object @NotNull [] selectedUserObjects) {
        if (selectedUserObjects == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(19);
        }
        DataProvider structureProvider = (DataProvider)this.getFromTreeStructure(selectedUserObjects, PlatformCoreDataKeys.BGT_DATA_PROVIDER.getName());
        DataProvider selectionProvider = this.selectionProvider(selectedUserObjects);
        return structureProvider != null ? CompositeDataProvider.compose((DataProvider)structureProvider, (DataProvider)selectionProvider) : selectionProvider;
    }

    @RequiresEdt
    @Nullable
    private DataProvider selectionProvider(@Nullable Object @NotNull [] selectedUserObjects) {
        if (selectedUserObjects == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(20);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (selectedUserObjects.length == 0) {
            return null;
        }
        Object[] singleSelectedPathUserObjects = this.getSingleSelectedPathUserObjects();
        return dataId -> this.getSlowDataFromSelection(selectedUserObjects, singleSelectedPathUserObjects, dataId);
    }

    @RequiresReadLock(generateAssertion=false)
    @RequiresBackgroundThread(generateAssertion=false)
    @Nullable
    protected Object getSlowDataFromSelection(@Nullable Object @NotNull [] selectedUserObjects, @Nullable @Nullable Object @Nullable [] singleSelectedPathUserObjects, @NotNull String dataId) {
        if (dataId == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(21);
        }
        if (selectedUserObjects == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(22);
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            PsiElement[] elements = this.getPsiElements(selectedUserObjects);
            return elements.length == 1 ? elements[0] : null;
        }
        if (PlatformCoreDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
            PsiElement[] elements = this.getPsiElements(selectedUserObjects);
            return elements.length > 0 ? elements : null;
        }
        if (PlatformCoreDataKeys.PROJECT_CONTEXT.is(dataId)) {
            Object selected = AbstractProjectViewPane.getSingleNodeElement(selectedUserObjects);
            return selected instanceof Project ? selected : null;
        }
        if (LangDataKeys.MODULE_CONTEXT.is(dataId)) {
            Object selected = AbstractProjectViewPane.getSingleNodeElement(selectedUserObjects);
            return ProjectViewUtilKt.moduleContext(this.myProject, selected);
        }
        if (LangDataKeys.MODULE_CONTEXT_ARRAY.is(dataId)) {
            return this.getSelectedModules(selectedUserObjects);
        }
        if (ProjectView.UNLOADED_MODULES_CONTEXT_KEY.is(dataId)) {
            return Collections.unmodifiableList(this.getSelectedUnloadedModules(selectedUserObjects));
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            Module[] modules2 = this.getSelectedModules(selectedUserObjects);
            if (modules2 != null || !this.getSelectedUnloadedModules(selectedUserObjects).isEmpty()) {
                return ModuleDeleteProvider.getInstance();
            }
            LibraryOrderEntry orderEntry2 = ProjectViewUtilKt.getSelectedLibrary(singleSelectedPathUserObjects);
            if (orderEntry2 != null) {
                return new DetachLibraryDeleteProvider(this.myProject, orderEntry2);
            }
            return this.myDeletePSIElementProvider;
        }
        if (ModuleGroup.ARRAY_DATA_KEY.is(dataId)) {
            List<ModuleGroup> selectedElements = this.getSelectedValues(selectedUserObjects, ModuleGroup.class);
            return selectedElements.isEmpty() ? null : selectedElements.toArray(new ModuleGroup[0]);
        }
        if (LibraryGroupElement.ARRAY_DATA_KEY.is(dataId)) {
            List<LibraryGroupElement> selectedElements = this.getSelectedValues(selectedUserObjects, LibraryGroupElement.class);
            return selectedElements.isEmpty() ? null : selectedElements.toArray(new LibraryGroupElement[0]);
        }
        if (NamedLibraryElement.ARRAY_DATA_KEY.is(dataId)) {
            List<NamedLibraryElement> selectedElements = this.getSelectedValues(selectedUserObjects, NamedLibraryElement.class);
            return selectedElements.isEmpty() ? null : selectedElements.toArray(new NamedLibraryElement[0]);
        }
        return null;
    }

    @Nullable
    private Object getFromTreeStructure(@Nullable Object @NotNull [] selectedUserObjects, @NotNull String dataId) {
        if (dataId == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(23);
        }
        if (selectedUserObjects == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(24);
        }
        if (!(this.myTreeStructure instanceof AbstractTreeStructureBase)) {
            return null;
        }
        ArrayList<AbstractTreeNode> nodes2 = new ArrayList<AbstractTreeNode>(selectedUserObjects.length);
        for (Object userObject : selectedUserObjects) {
            if (!(userObject instanceof AbstractTreeNode)) continue;
            nodes2.add((AbstractTreeNode)userObject);
        }
        return ((AbstractTreeStructureBase)this.myTreeStructure).getDataFromProviders(nodes2, dataId);
    }

    @RequiresReadLock(generateAssertion=false)
    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    private @NotNull PsiElement @NotNull [] getPsiElements(@Nullable Object @NotNull [] selectedUserObjects) {
        if (selectedUserObjects == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(25);
        }
        ArrayList result2 = new ArrayList();
        for (Object userObject : selectedUserObjects) {
            ContainerUtil.addAllNotNull(result2, this.getElementsFromNode(userObject));
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(result2);
        if (psiElementArray == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(26);
        }
        return psiElementArray;
    }

    @Nullable
    private static Object getSingleNodeElement(@Nullable Object @NotNull [] selectedUserObjects) {
        if (selectedUserObjects == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(27);
        }
        if (selectedUserObjects.length != 1) {
            return null;
        }
        return ProjectViewUtilKt.getNodeElement(selectedUserObjects[0]);
    }

    private @NotNull Module @Nullable [] getSelectedModules(@Nullable Object @NotNull [] selectedUserObjects) {
        List<Module> result2;
        if (selectedUserObjects == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(28);
        }
        return (result2 = ProjectViewUtilKt.moduleContexts(this.myProject, this.getSelectedValues(selectedUserObjects))).isEmpty() ? null : result2.toArray(Module.EMPTY_ARRAY);
    }

    @NotNull
    private @NotNull List<@NotNull UnloadedModuleDescription> getSelectedUnloadedModules(@Nullable Object @NotNull [] selectedUserObjects) {
        if (selectedUserObjects == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(29);
        }
        List<UnloadedModuleDescription> list2 = ProjectViewUtilKt.unloadedModules(this.myProject, this.getSelectedValues(selectedUserObjects));
        if (list2 == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(30);
        }
        return list2;
    }

    @NotNull
    private <T> @NotNull List<@NotNull T> getSelectedValues(@Nullable Object @NotNull [] selectedUserObjects, @NotNull Class<T> aClass) {
        if (aClass == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(31);
        }
        if (selectedUserObjects == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(32);
        }
        List<T> list2 = ContainerUtil.filterIsInstance(this.getSelectedValues(selectedUserObjects), aClass);
        if (list2 == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(33);
        }
        return list2;
    }

    @NotNull
    public final @NotNull Object @NotNull [] getSelectedValues(@Nullable Object @NotNull [] selectedUserObjects) {
        if (selectedUserObjects == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(34);
        }
        ArrayList<@NotNull Object> result2 = new ArrayList<Object>(selectedUserObjects.length);
        for (Object userObject : selectedUserObjects) {
            Object valueFromNode = this.getValueFromNode(userObject);
            if (valueFromNode instanceof Object[]) {
                for (Object value : (Object[])valueFromNode) {
                    if (value == null) continue;
                    result2.add(value);
                }
                continue;
            }
            if (valueFromNode == null) continue;
            result2.add(valueFromNode);
        }
        Object[] objectArray = ArrayUtil.toObjectArray(result2);
        if (objectArray == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(35);
        }
        return objectArray;
    }

    @Nullable
    private PsiElement getFirstElementFromNode(@Nullable Object node2) {
        return ContainerUtil.getFirstItem(this.getElementsFromNode(node2));
    }

    @NotNull
    public List<PsiElement> getElementsFromNode(@Nullable Object node2) {
        Object value = this.getValueFromNode(node2);
        JBIterable<Object> it = value instanceof PsiElement || value instanceof VirtualFile || value instanceof PsiAwareObject ? JBIterable.of(value) : (value instanceof Object[] ? JBIterable.of((Object[])value) : (value instanceof Iterable ? JBIterable.from((Iterable)value) : JBIterable.of(TreeUtil.getUserObject((Object)node2))));
        List<PsiElement> list2 = it.flatten(o -> o instanceof RootsProvider ? ((RootsProvider)o).getRoots() : Collections.singleton(o)).map(o -> o instanceof VirtualFile ? PsiUtilCore.findFileSystemItem(this.myProject, (VirtualFile)o) : (o instanceof PsiAwareObject ? ((PsiAwareObject)o).findElement(this.myProject) : o)).filter(PsiElement.class).filter(PsiElement::isValid).toList();
        if (list2 == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(36);
        }
        return list2;
    }

    @Nullable
    protected Module getNodeModule(@Nullable Object element) {
        if (element instanceof PsiElement) {
            PsiElement psiElement = (PsiElement)element;
            return ModuleUtilCore.findModuleForPsiElement(psiElement);
        }
        return null;
    }

    @Deprecated(forRemoval=true)
    public final Object @NotNull [] getSelectedElements() {
        TreePath[] paths2 = this.getSelectionPaths();
        if (paths2 == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                AbstractProjectViewPane.$$$reportNull$$$0(37);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        ArrayList<Object> list2 = new ArrayList<Object>(paths2.length);
        for (TreePath path2 : paths2) {
            Object lastPathComponent = path2.getLastPathComponent();
            Object element = this.getValueFromNode(lastPathComponent);
            if (element instanceof Object[]) {
                Collections.addAll(list2, (Object[])element);
                continue;
            }
            if (element == null) continue;
            list2.add(element);
        }
        Object[] objectArray = ArrayUtil.toObjectArray(list2);
        if (objectArray == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(38);
        }
        return objectArray;
    }

    @Nullable
    public Object getValueFromNode(@Nullable Object node2) {
        return AbstractProjectViewPane.extractValueFromNode(node2);
    }

    @Nullable
    public static Object extractValueFromNode(@Nullable Object node2) {
        Object userObject = TreeUtil.getUserObject((Object)node2);
        Object element = null;
        if (userObject instanceof AbstractTreeNode) {
            AbstractTreeNode descriptor2 = (AbstractTreeNode)userObject;
            element = descriptor2.getValue();
        } else if (userObject instanceof NodeDescriptor) {
            NodeDescriptor descriptor3 = (NodeDescriptor)userObject;
            element = descriptor3.getElement();
            if (element instanceof AbstractTreeNode) {
                element = ((AbstractTreeNode)element).getValue();
            }
        } else if (userObject != null) {
            element = userObject;
        }
        return element;
    }

    @Deprecated(forRemoval=true)
    public final AbstractTreeBuilder getTreeBuilder() {
        return this.myTreeBuilder;
    }

    public AbstractTreeStructure getTreeStructure() {
        return this.myTreeStructure;
    }

    public void readExternal(@NotNull Element element) {
        if (element == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(39);
        }
        List<Element> subPanes = element.getChildren(ELEMENT_SUB_PANE);
        for (Element subPane : subPanes) {
            String subId = subPane.getAttributeValue(ATTRIBUTE_SUB_ID);
            TreeState treeState = TreeState.createFrom((Element)subPane);
            if (treeState.isEmpty()) continue;
            this.myReadTreeState.put(subId, treeState);
        }
    }

    public void writeExternal(Element element) {
        this.saveExpandedPaths();
        for (Map.Entry<String, TreeState> entry : this.myReadTreeState.entrySet()) {
            String subId = entry.getKey();
            TreeState treeState = entry.getValue();
            Element subPane = new Element(ELEMENT_SUB_PANE);
            if (subId != null) {
                subPane.setAttribute(ATTRIBUTE_SUB_ID, subId);
            }
            treeState.writeExternal(subPane);
            element.addContent(subPane);
        }
    }

    @NotNull
    protected TreeState createTreeState(@NotNull JTree tree) {
        if (tree == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(40);
        }
        TreeState treeState = TreeState.createOn((JTree)tree);
        if (treeState == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(41);
        }
        return treeState;
    }

    protected void saveExpandedPaths() {
        this.myTreeStateRestored.set(false);
        if (this.myTree != null) {
            TreeState treeState = this.createTreeState((JTree)this.myTree);
            if (!treeState.isEmpty()) {
                this.myReadTreeState.put(this.getSubId(), treeState);
            } else {
                this.myReadTreeState.remove(this.getSubId());
            }
        }
    }

    public final void restoreExpandedPaths() {
        if (this.myTree == null || this.myTreeStateRestored.getAndSet(true)) {
            return;
        }
        TreeState treeState = this.myReadTreeState.get(this.getSubId());
        if (treeState != null && !treeState.isEmpty()) {
            treeState.applyTo((JTree)this.myTree);
        } else if (this.myTree.isSelectionEmpty()) {
            TreeUtil.promiseSelectFirst((JTree)this.myTree);
        }
    }

    @NotNull
    private TreeExpander getTreeExpander() {
        TreeExpander expander = this.myTreeExpander;
        if (expander == null) {
            this.myTreeExpander = expander = this.createTreeExpander();
        }
        TreeExpander treeExpander = expander;
        if (treeExpander == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(42);
        }
        return treeExpander;
    }

    @NotNull
    protected TreeExpander createTreeExpander() {
        return new DefaultTreeExpander(this::getTree){

            private boolean isExpandAllAllowed() {
                JTree tree = AbstractProjectViewPane.this.getTree();
                TreeModel model2 = tree == null ? null : tree.getModel();
                return model2 == null || model2 instanceof AsyncTreeModel || model2 instanceof InvokerSupplier;
            }

            public boolean isExpandAllVisible() {
                return this.isExpandAllAllowed() && Registry.is("ide.project.view.expand.all.action.visible");
            }

            public boolean canExpand() {
                return this.isExpandAllAllowed() && super.canExpand();
            }

            protected void collapseAll(@NotNull JTree tree, boolean strict, int keepSelectionLevel) {
                if (tree == null) {
                    4.$$$reportNull$$$0(0);
                }
                super.collapseAll(tree, false, keepSelectionLevel);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/ide/projectView/impl/AbstractProjectViewPane$4", "collapseAll"));
            }
        };
    }

    @NotNull
    protected Comparator<NodeDescriptor<?>> createComparator() {
        return new GroupByTypeComparator(this.myProject, this.getId());
    }

    public void installComparator() {
        this.installComparator(this.createComparator());
    }

    public void installComparator(@NotNull Comparator<? super NodeDescriptor<?>> comparator) {
        if (comparator == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(43);
        }
    }

    public JTree getTree() {
        return this.myTree;
    }

    @Deprecated
    public PsiDirectory @NotNull [] getSelectedDirectories() {
        TreePath[] paths2 = this.getSelectionPaths();
        if (paths2 == null) {
            if (PsiDirectory.EMPTY_ARRAY == null) {
                AbstractProjectViewPane.$$$reportNull$$$0(44);
            }
            return PsiDirectory.EMPTY_ARRAY;
        }
        Object[] selectedUserObjects = ContainerUtil.map2Array(paths2, TreeUtil::getLastUserObject);
        if (selectedUserObjects.length == 0) {
            if (PsiDirectory.EMPTY_ARRAY == null) {
                AbstractProjectViewPane.$$$reportNull$$$0(45);
            }
            return PsiDirectory.EMPTY_ARRAY;
        }
        PsiDirectory[] psiDirectoryArray = this.getSelectedDirectories(selectedUserObjects);
        if (psiDirectoryArray == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(46);
        }
        return psiDirectoryArray;
    }

    @RequiresBackgroundThread(generateAssertion=false)
    protected PsiDirectory @NotNull [] getSelectedDirectories(Object @NotNull [] selectedUserObjects) {
        if (selectedUserObjects == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(47);
        }
        ArrayList<PsiDirectory> directories = new ArrayList<PsiDirectory>();
        for (Object obj : selectedUserObjects) {
            PsiDirectory directory;
            Object node2 = ObjectUtils.tryCast(obj, PsiDirectoryNode.class);
            if (node2 == null || (directory = (PsiDirectory)node2.getValue()) == null) continue;
            directories.add(directory);
            Object parentValue = node2.getParent().getValue();
            if (!(parentValue instanceof PsiDirectory) || !Registry.is("projectView.choose.directory.on.compacted.middle.packages")) continue;
            while ((directory = directory.getParentDirectory()) != null && !directory.equals(parentValue)) {
                directories.add(directory);
            }
        }
        if (!directories.isEmpty()) {
            PsiDirectory[] psiDirectoryArray = directories.toArray(PsiDirectory.EMPTY_ARRAY);
            if (psiDirectoryArray == null) {
                AbstractProjectViewPane.$$$reportNull$$$0(48);
            }
            return psiDirectoryArray;
        }
        ArrayList<PsiElement> elements = new ArrayList<PsiElement>(selectedUserObjects.length);
        for (Object node2 : selectedUserObjects) {
            elements.addAll(this.getElementsFromNode(node2));
        }
        if (elements.size() == 1) {
            PsiElement element = (PsiElement)elements.get(0);
            if (element instanceof PsiDirectory) {
                PsiDirectory[] psiDirectoryArray = new PsiDirectory[]{(PsiDirectory)element};
                if (psiDirectoryArray == null) {
                    AbstractProjectViewPane.$$$reportNull$$$0(49);
                }
                return psiDirectoryArray;
            }
            if (element instanceof PsiDirectoryContainer) {
                PsiDirectory[] psiDirectoryArray = ((PsiDirectoryContainer)element).getDirectories();
                if (psiDirectoryArray == null) {
                    AbstractProjectViewPane.$$$reportNull$$$0(50);
                }
                return psiDirectoryArray;
            }
            PsiFile containingFile = element.getContainingFile();
            if (containingFile != null) {
                PsiDirectory psiDirectory = containingFile.getContainingDirectory();
                if (psiDirectory != null) {
                    PsiDirectory[] psiDirectoryArray = new PsiDirectory[]{psiDirectory};
                    if (psiDirectoryArray == null) {
                        AbstractProjectViewPane.$$$reportNull$$$0(51);
                    }
                    return psiDirectoryArray;
                }
                VirtualFile file2 = containingFile.getVirtualFile();
                if (file2 instanceof VirtualFileWindow) {
                    VirtualFile delegate2 = ((VirtualFileWindow)((Object)file2)).getDelegate();
                    PsiFile delegatePsiFile = containingFile.getManager().findFile(delegate2);
                    if (delegatePsiFile != null && delegatePsiFile.getContainingDirectory() != null) {
                        PsiDirectory[] psiDirectoryArray = new PsiDirectory[]{delegatePsiFile.getContainingDirectory()};
                        if (psiDirectoryArray == null) {
                            AbstractProjectViewPane.$$$reportNull$$$0(52);
                        }
                        return psiDirectoryArray;
                    }
                }
                if (PsiDirectory.EMPTY_ARRAY == null) {
                    AbstractProjectViewPane.$$$reportNull$$$0(53);
                }
                return PsiDirectory.EMPTY_ARRAY;
            }
        } else if (selectedUserObjects.length == 1) {
            PsiDirectory[] psiDirectoryArray = this.getSelectedDirectoriesInAmbiguousCase(selectedUserObjects[0]);
            if (psiDirectoryArray == null) {
                AbstractProjectViewPane.$$$reportNull$$$0(54);
            }
            return psiDirectoryArray;
        }
        if (PsiDirectory.EMPTY_ARRAY == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(55);
        }
        return PsiDirectory.EMPTY_ARRAY;
    }

    protected PsiDirectory @NotNull [] getSelectedDirectoriesInAmbiguousCase(Object userObject) {
        PsiDirectory directory;
        VirtualFile file2;
        if (userObject instanceof AbstractModuleNode) {
            Module module2 = (Module)((AbstractModuleNode)((Object)userObject)).getValue();
            if (module2 != null && !module2.isDisposed()) {
                ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(module2);
                VirtualFile[] sourceRoots = moduleRootManager.getSourceRoots();
                ArrayList<PsiDirectory> dirs = new ArrayList<PsiDirectory>(sourceRoots.length);
                PsiManager psiManager = PsiManager.getInstance(this.myProject);
                for (VirtualFile sourceRoot : sourceRoots) {
                    PsiDirectory directory2 = psiManager.findDirectory(sourceRoot);
                    if (directory2 == null) continue;
                    dirs.add(directory2);
                }
                PsiDirectory[] psiDirectoryArray = dirs.toArray(PsiDirectory.EMPTY_ARRAY);
                if (psiDirectoryArray == null) {
                    AbstractProjectViewPane.$$$reportNull$$$0(56);
                }
                return psiDirectoryArray;
            }
        } else if (userObject instanceof ProjectViewNode && (file2 = ((ProjectViewNode)((Object)userObject)).getVirtualFile()) != null && file2.isValid() && file2.isDirectory() && (directory = PsiManager.getInstance(this.myProject).findDirectory(file2)) != null) {
            PsiDirectory[] psiDirectoryArray = new PsiDirectory[]{directory};
            if (psiDirectoryArray == null) {
                AbstractProjectViewPane.$$$reportNull$$$0(57);
            }
            return psiDirectoryArray;
        }
        if (PsiDirectory.EMPTY_ARRAY == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(58);
        }
        return PsiDirectory.EMPTY_ARRAY;
    }

    public static PsiElement @Nullable [] getTransferedPsiElements(@NotNull Transferable transferable) {
        if (transferable == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(59);
        }
        try {
            Object transferData = transferable.getTransferData(DnDEventImpl.ourDataFlavor);
            if (transferData instanceof TransferableWrapper) {
                return ((TransferableWrapper)transferData).getPsiElements();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static TreeNode @Nullable [] getTransferedTreeNodes(@NotNull Transferable transferable) {
        if (transferable == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(60);
        }
        try {
            Object transferData = transferable.getTransferData(DnDEventImpl.ourDataFlavor);
            if (transferData instanceof TransferableWrapper) {
                return ((TransferableWrapper)transferData).getTreeNodes();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void enableDnD() {
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            this.myDropTarget = new ProjectViewDropTarget((JTree)this.myTree, this.myProject){

                @Override
                @Nullable
                protected PsiElement getPsiElement(@NotNull TreePath path2) {
                    if (path2 == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    return AbstractProjectViewPane.this.getFirstElementFromNode(path2.getLastPathComponent());
                }

                @Override
                @Nullable
                protected Module getModule(@NotNull PsiElement element) {
                    if (element == null) {
                        5.$$$reportNull$$$0(1);
                    }
                    return AbstractProjectViewPane.this.getNodeModule(element);
                }

                public void cleanUpOnLeave() {
                    AbstractProjectViewPane.this.beforeDnDLeave();
                    super.cleanUpOnLeave();
                }

                @Override
                public boolean update(DnDEvent event) {
                    AbstractProjectViewPane.this.beforeDnDUpdate(event);
                    return super.update(event);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "path";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "element";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/ide/projectView/impl/AbstractProjectViewPane$5";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "getPsiElement";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "getModule";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            this.myDragSource = new MyDragSource();
            DnDManager dndManager = DnDManager.getInstance();
            dndManager.registerSource(this.myDragSource, (JComponent)this.myTree);
            dndManager.registerTarget(this.myDropTarget, (JComponent)this.myTree);
        }
    }

    protected void beforeDnDUpdate(DnDEvent event) {
    }

    protected void beforeDnDLeave() {
    }

    @Deprecated(forRemoval=true)
    public void setTreeBuilder(AbstractTreeBuilder treeBuilder) {
        if (treeBuilder != null) {
            Disposer.register(this, (Disposable)treeBuilder);
        }
        this.myTreeBuilder = treeBuilder;
    }

    @ApiStatus.Internal
    public boolean supportsAbbreviatePackageNames() {
        return true;
    }

    @ApiStatus.Internal
    public boolean supportsCompactDirectories() {
        return false;
    }

    @ApiStatus.Internal
    public boolean supportsFlattenModules() {
        return false;
    }

    @ApiStatus.Internal
    public boolean supportsFoldersAlwaysOnTop() {
        return true;
    }

    @ApiStatus.Internal
    public boolean supportsHideEmptyMiddlePackages() {
        return true;
    }

    @ApiStatus.Internal
    public boolean supportsShowExcludedFiles() {
        return false;
    }

    @ApiStatus.Internal
    public boolean supportsShowLibraryContents() {
        return false;
    }

    @ApiStatus.Internal
    public boolean supportsShowModules() {
        return false;
    }

    @ApiStatus.Internal
    public boolean supportsShowScratchesAndConsoles() {
        return false;
    }

    @ApiStatus.Internal
    public boolean supportsSortByType() {
        return true;
    }

    @NotNull
    private static Color getFileForegroundColor(@NotNull Project project2, @NotNull VirtualFile file2) {
        FileEditorManager manager;
        if (project2 == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(61);
        }
        if (file2 == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(62);
        }
        if ((manager = FileEditorManager.getInstance(project2)) instanceof FileEditorManagerImpl) {
            Color color = ((FileEditorManagerImpl)manager).getFileColor(file2);
            if (color == null) {
                AbstractProjectViewPane.$$$reportNull$$$0(63);
            }
            return color;
        }
        Color color = UIUtil.getLabelForeground();
        if (color == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(64);
        }
        return color;
    }

    private static boolean canDragElements(Object @NotNull [] elements, @NotNull DataContext dataContext2, int dragAction) {
        if (dataContext2 == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(65);
        }
        if (elements == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(66);
        }
        for (Object element : elements) {
            if (!(element instanceof Module)) continue;
            return true;
        }
        return dragAction == 2 && MoveHandler.canMove(dataContext2);
    }

    @NotNull
    public ActionCallback getReady(@NotNull Object requestor) {
        if (requestor == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(67);
        }
        if (this.myTreeBuilder == null) {
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                AbstractProjectViewPane.$$$reportNull$$$0(68);
            }
            return actionCallback;
        }
        if (this.myTreeBuilder.isDisposed()) {
            ActionCallback actionCallback = ActionCallback.REJECTED;
            if (actionCallback == null) {
                AbstractProjectViewPane.$$$reportNull$$$0(69);
            }
            return actionCallback;
        }
        ActionCallback actionCallback = this.myTreeBuilder.getUi().getReady(requestor);
        if (actionCallback == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(70);
        }
        return actionCallback;
    }

    @Deprecated(forRemoval=true)
    @TestOnly
    @NotNull
    public Promise<TreePath> promisePathToElement(@NotNull Object element) {
        AbstractTreeBuilder builder2;
        if (element == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(71);
        }
        if ((builder2 = this.getTreeBuilder()) != null) {
            DefaultMutableTreeNode node2 = builder2.getNodeForElement(element);
            if (node2 == null) {
                Promise promise = Promises.rejectedPromise();
                if (promise == null) {
                    AbstractProjectViewPane.$$$reportNull$$$0(72);
                }
                return promise;
            }
            Promise promise = Promises.resolvedPromise((Object)new TreePath(node2.getPath()));
            if (promise == null) {
                AbstractProjectViewPane.$$$reportNull$$$0(73);
            }
            return promise;
        }
        TreeVisitor visitor2 = AbstractProjectViewPane.createVisitor(element);
        if (visitor2 == null || this.myTree == null) {
            Promise promise = Promises.rejectedPromise();
            if (promise == null) {
                AbstractProjectViewPane.$$$reportNull$$$0(74);
            }
            return promise;
        }
        Promise promise = TreeUtil.promiseVisit((JTree)this.myTree, (TreeVisitor)visitor2);
        if (promise == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(75);
        }
        return promise;
    }

    @ApiStatus.Internal
    public boolean isVisibleAndSelected(Object element) {
        JTree tree = this.getTree();
        if (tree == null) {
            return false;
        }
        TreePath path2 = TreeUtil.getSelectedPathIfOne((JTree)tree);
        if (path2 == null) {
            return false;
        }
        Rectangle bounds = tree.getPathBounds(path2);
        if (bounds == null) {
            return false;
        }
        Rectangle visible = tree.getVisibleRect();
        if (bounds.y < visible.y || bounds.y > visible.y + visible.height - bounds.height) {
            return false;
        }
        AbstractTreeNode node2 = (AbstractTreeNode)TreeUtil.getLastUserObject(AbstractTreeNode.class, (TreePath)path2);
        return node2 != null && node2.canRepresent(element);
    }

    AsyncProjectViewSupport getAsyncSupport() {
        return null;
    }

    @NotNull
    static List<TreeVisitor> createVisitors(Object ... objects) {
        if (objects == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(76);
        }
        List list2 = StreamEx.of((Object[])objects).map(AbstractProjectViewPane::createVisitor).nonNull().toImmutableList();
        if (list2 == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(77);
        }
        return list2;
    }

    @Nullable
    public static TreeVisitor createVisitor(@NotNull Object object) {
        AbstractTreeNode node2;
        if (object == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(78);
        }
        if (object instanceof AbstractTreeNode) {
            node2 = (AbstractTreeNode)object;
            object = node2.getValue();
        }
        if (object instanceof ProjectFileNode) {
            node2 = (ProjectFileNode)object;
            object = node2.getVirtualFile();
        }
        if (object instanceof VirtualFile) {
            return AbstractProjectViewPane.createVisitor((VirtualFile)object);
        }
        if (object instanceof PsiElement) {
            return AbstractProjectViewPane.createVisitor((PsiElement)object);
        }
        LOG.warn("unsupported object: " + object);
        return null;
    }

    @NotNull
    public static TreeVisitor createVisitor(@NotNull VirtualFile file2) {
        if (file2 == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(79);
        }
        TreeVisitor treeVisitor = AbstractProjectViewPane.createVisitor(null, file2);
        if (treeVisitor == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(80);
        }
        return treeVisitor;
    }

    @Nullable
    public static TreeVisitor createVisitor(@NotNull PsiElement element) {
        if (element == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(81);
        }
        return AbstractProjectViewPane.createVisitor(element, null);
    }

    @Nullable
    public static TreeVisitor createVisitor(@Nullable PsiElement element, @Nullable VirtualFile file2) {
        return AbstractProjectViewPane.createVisitor(element, file2, null);
    }

    @Nullable
    static TreeVisitor createVisitor(@Nullable PsiElement element, @Nullable VirtualFile file2, @Nullable List<? super TreePath> collector2) {
        Predicate<TreePath> predicate2;
        Predicate<TreePath> predicate3 = predicate2 = collector2 == null ? null : path2 -> {
            collector2.add((TreePath)path2);
            return false;
        };
        if (element != null && element.isValid()) {
            return new ProjectViewNodeVisitor(element, file2, predicate2);
        }
        if (file2 != null) {
            return new ProjectViewFileVisitor(file2, predicate2);
        }
        LOG.warn((String)(element != null ? "element invalidated: " + element : "cannot create visitor without element and/or file"));
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 6, 11, 13, 14, 17, 18, 26, 30, 33, 35, 36, 37, 38, 41, 42, 44, 45, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 63, 64, 68, 69, 70, 72, 73, 74, 75, 77, 80 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 26: 
            case 30: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 63: 
            case 64: 
            case 68: 
            case 69: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/AbstractProjectViewPane";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = ATTRIBUTE_SUB_ID;
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toSelect";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleGroup";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroup";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeClass";
                break;
            }
            case 15: 
            case 62: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 16: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 34: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedUserObjects";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 39: 
            case 71: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 59: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transferable";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/AbstractProjectViewPane";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getManualOrderOptionText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubIds";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableSubIdIcon";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedUserObjects";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedNodes";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedPSIElements";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiElements";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedUnloadedModules";
                break;
            }
            case 33: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedValues";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsFromNode";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedElements";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "createTreeState";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeExpander";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedDirectories";
                break;
            }
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedDirectoriesInAmbiguousCase";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileForegroundColor";
                break;
            }
            case 68: 
            case 69: 
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "getReady";
                break;
            }
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "promisePathToElement";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitors";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isDefaultPane";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 26: 
            case 30: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 63: 
            case 64: 
            case 68: 
            case 69: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 80: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableSubIdName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableSubIdIcon";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "selectModule";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doSelectModuleOrGroup";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "selectModuleGroup";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addToolbarActions";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedNodes";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isAutoScrollEnabledFor";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "slowProviders";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "selectionProvider";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getSlowDataFromSelection";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getFromTreeStructure";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getPsiElements";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getSingleNodeElement";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedModules";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedUnloadedModules";
                break;
            }
            case 31: 
            case 32: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedValues";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "createTreeState";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "installComparator";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedDirectories";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getTransferedPsiElements";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getTransferedTreeNodes";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getFileForegroundColor";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "canDragElements";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getReady";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "promisePathToElement";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "createVisitors";
                break;
            }
            case 78: 
            case 79: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3, 6, 11, 13, 14, 17, 18, 26, 30, 33, 35, 36, 37, 38, 41, 42, 44, 45, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 63, 64, 68, 69, 70, 72, 73, 74, 75, 77, 80 -> new IllegalStateException(string2);
        };
    }

    private final class MyDragSource
    implements DnDSource {
        private MyDragSource() {
        }

        public boolean canStartDragging(DnDAction action2, @NotNull Point dragOrigin) {
            if (dragOrigin == null) {
                MyDragSource.$$$reportNull$$$0(0);
            }
            if ((action2.getActionId() & 3) == 0) {
                return false;
            }
            Object[] elements = AbstractProjectViewPane.this.getSelectedElements();
            PsiElement[] psiElements = AbstractProjectViewPane.this.getSelectedPSIElements();
            DataContext dataContext2 = DataManager.getInstance().getDataContext((Component)AbstractProjectViewPane.this.myTree);
            return psiElements.length > 0 || AbstractProjectViewPane.canDragElements(elements, dataContext2, action2.getActionId());
        }

        public DnDDragStartBean startDragging(DnDAction action2, @NotNull Point dragOrigin) {
            if (dragOrigin == null) {
                MyDragSource.$$$reportNull$$$0(1);
            }
            final PsiElement[] psiElements = AbstractProjectViewPane.this.getSelectedPSIElements();
            final TreePath[] paths2 = AbstractProjectViewPane.this.getSelectionPaths();
            return new DnDDragStartBean((Object)new TransferableWrapper(){

                public List<File> asFileList() {
                    return PsiCopyPasteManager.asFileList(psiElements);
                }

                public TreePath @Nullable [] getTreePaths() {
                    return paths2;
                }

                public TreeNode[] getTreeNodes() {
                    return TreePathUtil.toTreeNodes((TreePath[])this.getTreePaths());
                }

                public PsiElement[] getPsiElements() {
                    return psiElements;
                }
            });
        }

        @Nullable
        public Pair<Image, Point> createDraggedImage(DnDAction action2, Point dragOrigin, @NotNull DnDDragStartBean bean) {
            TreePath[] paths2;
            if (bean == null) {
                MyDragSource.$$$reportNull$$$0(2);
            }
            if ((paths2 = AbstractProjectViewPane.this.getSelectionPaths()) == null) {
                return null;
            }
            record LabelData(@Nls String text, Icon icon, @Nullable VirtualFile file) {
            }
            ArrayList<LabelData> toRender = new ArrayList<LabelData>();
            for (TreePath path2 : paths2) {
                Pair<Icon, @Nls String> iconAndText = this.getIconAndText(path2);
                toRender.add(new LabelData((String)iconAndText.second, (Icon)iconAndText.first, PsiCopyPasteManager.asVirtualFile(AbstractProjectViewPane.this.getFirstElementFromNode(path2.getLastPathComponent()))));
            }
            int count2 = 0;
            JPanel panel2 = new JPanel(new VerticalFlowLayout(0, 0));
            int maxItemsToShow = toRender.size() < 20 ? toRender.size() : 10;
            for (LabelData data2 : toRender) {
                DragImageLabel fileLabel = new DragImageLabel(data2.text(), data2.icon(), data2.file());
                panel2.add(fileLabel);
                if (++count2 <= maxItemsToShow) continue;
                panel2.add(new DragImageLabel(IdeBundle.message((String)"label.more.files", (Object[])new Object[]{paths2.length - maxItemsToShow}), EmptyIcon.ICON_16, null));
                break;
            }
            panel2.setSize(panel2.getPreferredSize());
            panel2.doLayout();
            BufferedImage image = ImageUtil.createImage(panel2.getWidth(), panel2.getHeight(), 2);
            Graphics2D g2 = (Graphics2D)image.getGraphics();
            panel2.paint(g2);
            g2.dispose();
            return new Pair<Image, Point>(image, new Point());
        }

        private @NotNull Pair<Icon, @Nls String> getIconAndText(TreePath path2) {
            Object object = TreeUtil.getLastUserObject((TreePath)path2);
            Component component2 = AbstractProjectViewPane.this.getTree().getCellRenderer().getTreeCellRendererComponent(AbstractProjectViewPane.this.getTree(), object, false, false, true, AbstractProjectViewPane.this.getTree().getRowForPath(path2), false);
            Icon[] icon2 = new Icon[1];
            String[] text2 = new String[1];
            if (component2 instanceof ProjectViewRenderer) {
                ProjectViewRenderer renderer = (ProjectViewRenderer)((Object)component2);
                icon2[0] = renderer.getIcon();
            }
            if (component2 instanceof SimpleColoredComponent) {
                SimpleColoredComponent colored = (SimpleColoredComponent)component2;
                text2[0] = colored.getCharSequence(true).toString();
            }
            return new Pair<Icon, String>(icon2[0], text2[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dragOrigin";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bean";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/projectView/impl/AbstractProjectViewPane$MyDragSource";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canStartDragging";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "startDragging";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createDraggedImage";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class DragImageLabel
    extends JLabel {
        private DragImageLabel(String text2, @Nullable Icon icon2, VirtualFile file2) {
            super(text2, icon2, 10);
            this.setFont(UIUtil.getTreeFont());
            this.setOpaque(true);
            if (file2 != null) {
                this.setBackground(EditorTabPresentationUtil.getEditorTabBackgroundColor((Project)AbstractProjectViewPane.this.myProject, (VirtualFile)file2));
                this.setForeground(AbstractProjectViewPane.getFileForegroundColor(AbstractProjectViewPane.this.myProject, file2));
            } else {
                this.setForeground(RenderingUtil.getForeground(AbstractProjectViewPane.this.getTree(), true));
                this.setBackground(RenderingUtil.getBackground(AbstractProjectViewPane.this.getTree(), true));
            }
            this.setBorder(new EmptyBorder(JBUI.CurrentTheme.EditorTabs.tabInsets()));
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            size.height = JBUI.scale(28);
            return size;
        }
    }
}

