/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.CopyPasteUtil;
import com.intellij.ide.bookmark.BookmarksListener;
import com.intellij.ide.bookmark.FileBookmarksListener;
import com.intellij.ide.projectView.ProjectViewPsiTreeChangeListener;
import com.intellij.ide.projectView.impl.AbstractProjectTreeStructure;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.ProjectViewFileVisitor;
import com.intellij.ide.projectView.impl.ProjectViewNodeVisitor;
import com.intellij.ide.projectView.impl.ProjectViewPaneSelectionHelper;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.AbstractTreeUpdater;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.ProblemListener;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.RestoreSelectionListener;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.tree.TreeCollector;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.tree.project.ProjectFileNode;
import com.intellij.ui.tree.project.ProjectFileNodeUpdater;
import com.intellij.util.SmartList;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class AsyncProjectViewSupport {
    private static final Logger LOG = Logger.getInstance(AsyncProjectViewSupport.class);
    private final ProjectFileNodeUpdater myNodeUpdater;
    private final StructureTreeModel myStructureTreeModel;
    private final AsyncTreeModel myAsyncTreeModel;

    public AsyncProjectViewSupport(@NotNull Disposable parent2, final @NotNull Project project2, final @NotNull AbstractTreeStructure structure, @NotNull Comparator<NodeDescriptor<?>> comparator) {
        if (parent2 == null) {
            AsyncProjectViewSupport.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            AsyncProjectViewSupport.$$$reportNull$$$0(1);
        }
        if (structure == null) {
            AsyncProjectViewSupport.$$$reportNull$$$0(2);
        }
        if (comparator == null) {
            AsyncProjectViewSupport.$$$reportNull$$$0(3);
        }
        this.myStructureTreeModel = new StructureTreeModel(structure, comparator, parent2);
        this.myAsyncTreeModel = new AsyncTreeModel((TreeModel)this.myStructureTreeModel, parent2);
        this.myNodeUpdater = new ProjectFileNodeUpdater(project2, this.myStructureTreeModel.getInvoker()){

            /*
             * WARNING - void declaration
             */
            protected void updateStructure(boolean fromRoot, @NotNull Set<? extends VirtualFile> updatedFiles) {
                if (updatedFiles == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (fromRoot) {
                    AsyncProjectViewSupport.this.updateAll(null);
                } else {
                    long time2 = System.currentTimeMillis();
                    LOG.debug("found ", updatedFiles.size(), " changed files");
                    TreeCollector collector2 = TreeCollector.VirtualFileRoots.create();
                    for (VirtualFile virtualFile2 : updatedFiles) {
                        void var7_6;
                        if (!virtualFile2.isDirectory()) {
                            VirtualFile virtualFile3 = virtualFile2.getParent();
                        }
                        if (var7_6 == null || ProjectFileNode.findArea((VirtualFile)var7_6, (Project)project2) == null) continue;
                        collector2.add((Object)var7_6);
                    }
                    List roots2 = collector2.get();
                    LOG.debug("found ", roots2.size(), " roots in ", System.currentTimeMillis() - time2, "ms");
                    AsyncProjectViewSupport.this.myStructureTreeModel.getInvoker().invoke(() -> roots2.forEach(root -> AsyncProjectViewSupport.this.updateByFile((VirtualFile)root, true)));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updatedFiles", "com/intellij/ide/projectView/impl/AsyncProjectViewSupport$1", "updateStructure"));
            }
        };
        MessageBusConnection connection = project2.getMessageBus().connect(parent2);
        connection.subscribe(BookmarksListener.TOPIC, new FileBookmarksListener(file2 -> this.updateByFile((VirtualFile)file2, !file2.isDirectory())));
        PsiManager.getInstance(project2).addPsiTreeChangeListener(new ProjectViewPsiTreeChangeListener(project2){

            @Override
            protected boolean isFlattenPackages() {
                return structure instanceof AbstractProjectTreeStructure && ((AbstractProjectTreeStructure)structure).isFlattenPackages();
            }

            @Override
            protected AbstractTreeUpdater getUpdater() {
                return null;
            }

            @Override
            protected DefaultMutableTreeNode getRootNode() {
                return null;
            }

            @Override
            protected void addSubtreeToUpdateByRoot() {
                AsyncProjectViewSupport.this.myNodeUpdater.updateFromRoot();
            }

            @Override
            protected boolean addSubtreeToUpdateByElement(@NotNull PsiElement element) {
                VirtualFile file2;
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((file2 = PsiUtilCore.getVirtualFile(element)) != null) {
                    AsyncProjectViewSupport.this.myNodeUpdater.updateFromFile(file2);
                } else {
                    AsyncProjectViewSupport.this.updateByElement(element, true);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/projectView/impl/AsyncProjectViewSupport$2", "addSubtreeToUpdateByElement"));
            }
        }, parent2);
        FileStatusManager.getInstance((Project)project2).addFileStatusListener(new FileStatusListener(){

            public void fileStatusesChanged() {
                AsyncProjectViewSupport.this.updateAllPresentations();
            }

            public void fileStatusChanged(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                AsyncProjectViewSupport.this.updateByFile(file2, false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/projectView/impl/AsyncProjectViewSupport$3", "fileStatusChanged"));
            }
        }, parent2);
        CopyPasteUtil.addDefaultListener(parent2, element -> this.updateByElement((PsiElement)element, false));
        project2.getMessageBus().connect(parent2).subscribe(ProblemListener.TOPIC, new ProblemListener(){

            @Override
            public void problemsAppeared(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                AsyncProjectViewSupport.this.updatePresentationsFromRootTo(file2);
            }

            @Override
            public void problemsDisappeared(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    4.$$$reportNull$$$0(1);
                }
                AsyncProjectViewSupport.this.updatePresentationsFromRootTo(file2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "file";
                objectArray2[1] = "com/intellij/ide/projectView/impl/AsyncProjectViewSupport$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "problemsAppeared";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "problemsDisappeared";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public AsyncTreeModel getTreeModel() {
        return this.myAsyncTreeModel;
    }

    public void setComparator(@NotNull Comparator<? super NodeDescriptor<?>> comparator) {
        if (comparator == null) {
            AsyncProjectViewSupport.$$$reportNull$$$0(4);
        }
        this.myStructureTreeModel.setComparator(comparator);
    }

    public ActionCallback select(JTree tree, Object object, VirtualFile file2) {
        if (object instanceof AbstractTreeNode) {
            AbstractTreeNode node2 = (AbstractTreeNode)object;
            object = node2.getValue();
            LOG.debug("select AbstractTreeNode");
        }
        PsiElement element = object instanceof PsiElement ? (PsiElement)object : null;
        LOG.debug("select object: ", object, " in file: ", file2);
        SmartList pathsToSelect = new SmartList();
        TreeVisitor visitor2 = AbstractProjectViewPane.createVisitor(element, file2, pathsToSelect);
        if (visitor2 == null) {
            return ActionCallback.DONE;
        }
        ActionCallback callback = new ActionCallback();
        this.myNodeUpdater.updateImmediately(() -> TreeState.expand((JTree)tree, promise -> {
            promise.onSuccess(o -> callback.setDone());
            this.acceptOnEDT(visitor2, () -> {
                if (AsyncProjectViewSupport.selectPaths(tree, pathsToSelect, visitor2) || element == null || file2 == null || Registry.is("async.project.view.support.extra.select.disabled")) {
                    promise.setResult(null);
                } else {
                    pathsToSelect.clear();
                    TreeVisitor fileVisitor = AbstractProjectViewPane.createVisitor(null, file2, pathsToSelect);
                    this.acceptOnEDT(fileVisitor, () -> {
                        AsyncProjectViewSupport.selectPaths(tree, pathsToSelect, fileVisitor);
                        promise.setResult(null);
                    });
                }
            });
        }));
        return callback;
    }

    private void acceptOnEDT(@NotNull TreeVisitor visitor2, @NotNull Runnable task2) {
        if (visitor2 == null) {
            AsyncProjectViewSupport.$$$reportNull$$$0(5);
        }
        if (task2 == null) {
            AsyncProjectViewSupport.$$$reportNull$$$0(6);
        }
        this.myAsyncTreeModel.accept(visitor2).onProcessed(path2 -> this.myAsyncTreeModel.onValidThread(task2));
    }

    private static boolean selectPaths(@NotNull JTree tree, @NotNull List<TreePath> paths2, @NotNull TreeVisitor visitor2) {
        if (tree == null) {
            AsyncProjectViewSupport.$$$reportNull$$$0(7);
        }
        if (paths2 == null) {
            AsyncProjectViewSupport.$$$reportNull$$$0(8);
        }
        if (visitor2 == null) {
            AsyncProjectViewSupport.$$$reportNull$$$0(9);
        }
        if (paths2.isEmpty()) {
            return false;
        }
        if (paths2.size() > 1) {
            if (visitor2 instanceof ProjectViewNodeVisitor) {
                ProjectViewNodeVisitor nodeVisitor = (ProjectViewNodeVisitor)visitor2;
                return AsyncProjectViewSupport.selectPaths(tree, new ProjectViewPaneSelectionHelper.SelectionDescriptor((PsiElement)nodeVisitor.getElement(), nodeVisitor.getFile(), paths2));
            }
            if (visitor2 instanceof ProjectViewFileVisitor) {
                ProjectViewFileVisitor fileVisitor = (ProjectViewFileVisitor)visitor2;
                return AsyncProjectViewSupport.selectPaths(tree, new ProjectViewPaneSelectionHelper.SelectionDescriptor(null, (VirtualFile)fileVisitor.getElement(), paths2));
            }
        }
        TreePath path2 = paths2.get(0);
        tree.expandPath(path2);
        TreeUtil.selectPaths((JTree)tree, (TreePath[])new TreePath[]{path2});
        return true;
    }

    private static boolean selectPaths(@NotNull JTree tree, @NotNull ProjectViewPaneSelectionHelper.SelectionDescriptor selectionDescriptor) {
        if (tree == null) {
            AsyncProjectViewSupport.$$$reportNull$$$0(10);
        }
        if (selectionDescriptor == null) {
            AsyncProjectViewSupport.$$$reportNull$$$0(11);
        }
        List<? extends TreePath> adjustedPaths = ProjectViewPaneSelectionHelper.getAdjustedPaths(selectionDescriptor);
        adjustedPaths.forEach(it -> tree.expandPath((TreePath)it));
        TreeUtil.selectPaths((JTree)tree, adjustedPaths);
        return true;
    }

    public void updateAll(Runnable onDone) {
        LOG.debug(new RuntimeException("reload a whole tree"));
        CompletableFuture future = this.myStructureTreeModel.invalidateAsync();
        if (onDone != null) {
            future.thenRun(() -> this.myAsyncTreeModel.onValidThread(onDone));
        }
    }

    public void update(@NotNull TreePath path2, boolean structure) {
        if (path2 == null) {
            AsyncProjectViewSupport.$$$reportNull$$$0(12);
        }
        this.myStructureTreeModel.invalidate(path2, structure);
    }

    public void update(@NotNull List<? extends TreePath> list2, boolean structure) {
        if (list2 == null) {
            AsyncProjectViewSupport.$$$reportNull$$$0(13);
        }
        for (TreePath treePath : list2) {
            this.update(treePath, structure);
        }
    }

    public void updateByFile(@NotNull VirtualFile file2, boolean structure) {
        if (file2 == null) {
            AsyncProjectViewSupport.$$$reportNull$$$0(14);
        }
        LOG.debug(structure ? "updateChildrenByFile: " : "updatePresentationByFile: ", file2);
        this.update(null, file2, structure);
    }

    public void updateByElement(@NotNull PsiElement element, boolean structure) {
        if (element == null) {
            AsyncProjectViewSupport.$$$reportNull$$$0(15);
        }
        LOG.debug(structure ? "updateChildrenByElement: " : "updatePresentationByElement: ", element);
        this.update(element, null, structure);
    }

    private void update(PsiElement element, VirtualFile file2, boolean structure) {
        SmartList list2 = new SmartList();
        TreeVisitor visitor2 = AbstractProjectViewPane.createVisitor(element, file2, list2);
        if (visitor2 != null) {
            this.acceptAndUpdate(visitor2, list2, structure);
        }
    }

    private void acceptAndUpdate(@NotNull TreeVisitor visitor2, List<? extends TreePath> list2, boolean structure) {
        if (visitor2 == null) {
            AsyncProjectViewSupport.$$$reportNull$$$0(16);
        }
        this.myAsyncTreeModel.accept(visitor2, false).onSuccess(path2 -> this.update(list2, structure));
    }

    private void updatePresentationsFromRootTo(@NotNull VirtualFile file2) {
        if (file2 == null) {
            AsyncProjectViewSupport.$$$reportNull$$$0(17);
        }
        while (!file2.isValid()) {
            if ((file2 = file2.getParent()) != null) continue;
            return;
        }
        SmartList structures = new SmartList();
        final SmartList presentations = new SmartList();
        this.myAsyncTreeModel.accept((TreeVisitor)new ProjectViewFileVisitor(file2, structures::add){

            @NotNull
            protected TreeVisitor.Action visit(@NotNull TreePath path2, @NotNull AbstractTreeNode node2, @NotNull VirtualFile element) {
                TreeVisitor.Action action2;
                if (path2 == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (node2 == null) {
                    5.$$$reportNull$$$0(1);
                }
                if (element == null) {
                    5.$$$reportNull$$$0(2);
                }
                if ((action2 = super.visit(path2, node2, (Object)element)) == TreeVisitor.Action.CONTINUE) {
                    presentations.add(path2);
                }
                TreeVisitor.Action action3 = action2;
                if (action3 == null) {
                    5.$$$reportNull$$$0(3);
                }
                return action3;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "path";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/projectView/impl/AsyncProjectViewSupport$5";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/projectView/impl/AsyncProjectViewSupport$5";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visit";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visit";
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string2);
                    case 3 -> new IllegalStateException(string2);
                };
            }
        }, false).onSuccess(path2 -> {
            this.update(presentations, false);
            this.update(structures, true);
        });
    }

    private void updateAllPresentations() {
        final SmartList list2 = new SmartList();
        this.acceptAndUpdate(new TreeVisitor(){

            @NotNull
            public TreeVisitor.Action visit(@NotNull TreePath path2) {
                if (path2 == null) {
                    6.$$$reportNull$$$0(0);
                }
                list2.add(path2);
                TreeVisitor.Action action2 = TreeVisitor.Action.CONTINUE;
                if (action2 == null) {
                    6.$$$reportNull$$$0(1);
                }
                return action2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "path";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/projectView/impl/AsyncProjectViewSupport$6";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/projectView/impl/AsyncProjectViewSupport$6";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visit";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visit";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string2);
                    case 1 -> new IllegalStateException(string2);
                };
            }
        }, list2, false);
    }

    void setModelTo(@NotNull JTree tree) {
        if (tree == null) {
            AsyncProjectViewSupport.$$$reportNull$$$0(18);
        }
        RestoreSelectionListener listener2 = new RestoreSelectionListener();
        tree.addTreeSelectionListener((TreeSelectionListener)listener2);
        tree.setModel((TreeModel)this.myAsyncTreeModel);
        Disposer.register((Disposable)this.myAsyncTreeModel, () -> {
            tree.setModel(null);
            tree.removeTreeSelectionListener((TreeSelectionListener)listener2);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structure";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 5: 
            case 9: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 7: 
            case 10: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionDescriptor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/projectView/impl/AsyncProjectViewSupport";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setComparator";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "acceptOnEDT";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "selectPaths";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "updateByFile";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "updateByElement";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "acceptAndUpdate";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "updatePresentationsFromRootTo";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "setModelTo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

