/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.dnd.DnDDropHandler;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDSupport;
import com.intellij.ide.dnd.DnDTargetChecker;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.ProjectAbstractTreeStructureBase;
import com.intellij.ide.projectView.impl.ProjectViewPane;
import com.intellij.ide.projectView.impl.ProjectViewTree;
import com.intellij.ide.projectView.impl.nodes.ProjectViewProjectNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AttachableProjectViewPane
extends ProjectViewPane {
    private final DropAreaDecorator myDecorator = new DropAreaDecorator();

    public AttachableProjectViewPane(Project project2) {
        super(project2);
    }

    @Override
    @NotNull
    public String getTitle() {
        String string2 = IdeBundle.message((String)"attachable.project.pane.name", (Object[])new Object[0]);
        if (string2 == null) {
            AttachableProjectViewPane.$$$reportNull$$$0(0);
        }
        return string2;
    }

    @Override
    @NotNull
    protected ProjectViewTree createTree(@NotNull DefaultTreeModel treeModel) {
        if (treeModel == null) {
            AttachableProjectViewPane.$$$reportNull$$$0(1);
        }
        ProjectViewTree tree = super.createTree(treeModel);
        tree.getEmptyText().setText(IdeBundle.message((String)"label.empty.text.attach.directories.with.right.click", (Object[])new Object[0]));
        ProjectViewTree projectViewTree = tree;
        if (projectViewTree == null) {
            AttachableProjectViewPane.$$$reportNull$$$0(2);
        }
        return projectViewTree;
    }

    @Override
    @NotNull
    public JComponent createComponent() {
        JComponent jComponent = this.myDecorator.wrap(super.createComponent());
        if (jComponent == null) {
            AttachableProjectViewPane.$$$reportNull$$$0(3);
        }
        return jComponent;
    }

    @Override
    protected void beforeDnDUpdate(DnDEvent event) {
        this.myDecorator.processDnD(event);
    }

    @Override
    protected void beforeDnDLeave() {
        this.myDecorator.processDnD(null);
    }

    @Override
    @NotNull
    protected ProjectAbstractTreeStructureBase createStructure() {
        return new ProjectViewPane.ProjectViewPaneTreeStructure(){

            @Override
            protected AbstractTreeNode<?> createRoot(@NotNull Project project2, @NotNull ViewSettings settings) {
                if (project2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (settings == null) {
                    1.$$$reportNull$$$0(1);
                }
                return new ProjectViewProjectNode(project2, settings){

                    @Override
                    @NotNull
                    public Collection<AbstractTreeNode<?>> getChildren() {
                        Project project2 = Objects.requireNonNull(this.getProject());
                        LinkedHashSet result2 = new LinkedHashSet();
                        PsiManager psiManager = PsiManager.getInstance(project2);
                        for (VirtualFile virtualFile2 : ProjectRootManager.getInstance(project2).getContentRoots()) {
                            PsiDirectory directory = psiManager.findDirectory(virtualFile2);
                            if (directory == null) continue;
                            result2.add(new PsiDirectoryNode(this.getProject(), directory, this.getSettings()){

                                @Override
                                protected boolean shouldShowModuleName() {
                                    return false;
                                }
                            });
                        }
                        LinkedHashSet linkedHashSet = result2;
                        if (linkedHashSet == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return linkedHashSet;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/AttachableProjectViewPane$1$1", "getChildren"));
                    }
                };
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "settings";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ide/projectView/impl/AttachableProjectViewPane$1";
                objectArray[2] = "createRoot";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    protected void processDroppedDirectories(@NotNull List<? extends VirtualFile> dirs) {
        if (dirs == null) {
            AttachableProjectViewPane.$$$reportNull$$$0(4);
        }
        if (dirs.isEmpty()) {
            return;
        }
        Module[] modules2 = ModuleManager.getInstance(this.myProject).getModules();
        if (modules2.length == 0) {
            return;
        }
        Module module2 = modules2[0];
        ModuleRootModificationUtil.updateModel(module2, model2 -> {
            for (VirtualFile file2 : dirs) {
                model2.addContentEntry(file2);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/AttachableProjectViewPane";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/AttachableProjectViewPane";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createTree";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createTree";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processDroppedDirectories";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 4 -> new IllegalArgumentException(string2);
        };
    }

    private class DropAreaDecorator
    extends JPanel
    implements DnDTargetChecker,
    DnDDropHandler {
        private JComponent myWrappee;
        private final JPanel myDropArea;
        private final JLabel myLabel;

        DropAreaDecorator() {
            super(new BorderLayout());
            this.myDropArea = new JPanel(new BorderLayout());
            this.myLabel = new JLabel(IdeBundle.message((String)"label.text.html.center.drop.here.to.attach.br.as.a.root.directory.center.html", (Object[])new Object[0]));
            this.myLabel.setHorizontalAlignment(0);
            this.myLabel.setForeground(new JBColor(ColorUtil.fromHex("8b98ad"), ColorUtil.fromHex("6c7073")));
            this.myLabel.setBorder(JBUI.Borders.empty(25));
            this.myDropArea.setBackground(new JBColor(ColorUtil.fromHex("edf4ff"), ColorUtil.fromHex("343638")));
            this.myDropArea.add((Component)this.myLabel, "Center");
        }

        @NotNull
        private List<VirtualFile> getDirectories(@NotNull DnDEvent event) {
            if (event == null) {
                DropAreaDecorator.$$$reportNull$$$0(0);
            }
            List<VirtualFile> list2 = ContainerUtil.filter(FileCopyPasteUtil.getVirtualFileListFromAttachedObject((Object)event.getAttachedObject()), file2 -> file2.isDirectory());
            if (list2 == null) {
                DropAreaDecorator.$$$reportNull$$$0(1);
            }
            return list2;
        }

        @NotNull
        private JComponent wrap(@NotNull JComponent wrappee) {
            if (wrappee == null) {
                DropAreaDecorator.$$$reportNull$$$0(2);
            }
            if (wrappee != this.myWrappee) {
                this.myWrappee = wrappee;
                this.init(wrappee);
            }
            DropAreaDecorator dropAreaDecorator = this;
            if (dropAreaDecorator == null) {
                DropAreaDecorator.$$$reportNull$$$0(3);
            }
            return dropAreaDecorator;
        }

        private void init(@NotNull JComponent wrappee) {
            if (wrappee == null) {
                DropAreaDecorator.$$$reportNull$$$0(4);
            }
            Runnable leaveCallback = () -> {
                if (!this.isOverComponent((JComponent)AttachableProjectViewPane.this.myTree) && !this.isOverComponent(this.myLabel)) {
                    this.hideDropArea();
                }
            };
            DnDSupport.createBuilder((JComponent)this.myDropArea).enableAsNativeTarget().setCleanUpOnLeaveCallback(leaveCallback).setDropEndedCallback(() -> this.hideDropArea()).setTargetChecker((DnDTargetChecker)this).setDropHandler((DnDDropHandler)this).setDisposableParent((Disposable)AttachableProjectViewPane.this).install();
            this.hideDropArea();
            this.removeAll();
            this.add((Component)this.myDropArea, "South");
            this.add((Component)wrappee, "Center");
        }

        private void hideDropArea() {
            this.myLabel.setVisible(false);
        }

        public void drop(@NotNull DnDEvent event) {
            if (event == null) {
                DropAreaDecorator.$$$reportNull$$$0(5);
            }
            this.hideDropArea();
            AttachableProjectViewPane.this.processDroppedDirectories(this.getDirectories(event));
        }

        public boolean update(@NotNull DnDEvent event) {
            if (event == null) {
                DropAreaDecorator.$$$reportNull$$$0(6);
            }
            if (!this.isDroppable(event)) {
                this.hideDropArea();
                return false;
            }
            event.setHighlighting((Component)this.myLabel, 1);
            event.setDropPossible(true);
            this.myDropArea.setVisible(true);
            return false;
        }

        private boolean isDroppable(@NotNull DnDEvent event) {
            if (event == null) {
                DropAreaDecorator.$$$reportNull$$$0(7);
            }
            return FileCopyPasteUtil.isFileListFlavorAvailable((DnDEvent)event);
        }

        private boolean isOverComponent(@Nullable JComponent component2) {
            if (component2 == null) {
                return false;
            }
            Point location2 = MouseInfo.getPointerInfo().getLocation();
            Point p = new Point(location2);
            SwingUtilities.convertPointFromScreen(p, component2);
            return component2.getVisibleRect().contains(p);
        }

        private void processDnD(DnDEvent event) {
            if (event != null) {
                this.myLabel.setVisible(this.isDroppable(event));
            } else if (!this.isOverComponent(this.myLabel)) {
                this.hideDropArea();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/projectView/impl/AttachableProjectViewPane$DropAreaDecorator";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wrappee";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/projectView/impl/AttachableProjectViewPane$DropAreaDecorator";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDirectories";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "wrap";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getDirectories";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "wrap";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "init";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "drop";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "isDroppable";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1, 3 -> new IllegalStateException(string2);
            };
        }
    }
}

