/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.IconProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.psi.PsiElement;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompoundIconProvider
extends IconProvider {
    private static final IconProvider INSTANCE = new CompoundIconProvider();
    private static final Logger LOG = Logger.getInstance(CompoundIconProvider.class);

    @Override
    @Nullable
    public Icon getIcon(@NotNull PsiElement element, int flags) {
        if (element == null) {
            CompoundIconProvider.$$$reportNull$$$0(0);
        }
        if (element.isValid()) {
            for (IconProvider provider2 : EXTENSION_POINT_NAME.getExtensionList()) {
                ProgressManager.checkCanceled();
                try {
                    Icon icon2 = provider2.getIcon(element, flags);
                    if (icon2 == null) continue;
                    LOG.debug("icon found in ", provider2);
                    return icon2;
                }
                catch (IndexNotReadyException exception) {
                    throw new ProcessCanceledException(exception);
                }
                catch (ProcessCanceledException exception) {
                    throw exception;
                }
                catch (Exception exception) {
                    LOG.warn("unexpected error in " + provider2, exception);
                }
            }
            return element.getIcon(flags);
        }
        return null;
    }

    @Nullable
    public static Icon findIcon(@Nullable PsiElement element, int flags) {
        return element == null ? null : INSTANCE.getIcon(element, flags);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/projectView/impl/CompoundIconProvider", "getIcon"));
    }
}

