/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ProjectViewNodeDecorator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompoundProjectViewNodeDecorator
implements ProjectViewNodeDecorator {
    private static final ProjectViewNodeDecorator EMPTY = new CompoundProjectViewNodeDecorator(null);
    private static final Key<ProjectViewNodeDecorator> KEY = Key.create("ProjectViewNodeDecorator");
    private static final Logger LOG = Logger.getInstance(CompoundProjectViewNodeDecorator.class);
    private final Project myProject;

    @NotNull
    public static ProjectViewNodeDecorator get(@Nullable Project project2) {
        if (project2 == null || project2.isDisposed() || project2.isDefault()) {
            ProjectViewNodeDecorator projectViewNodeDecorator = EMPTY;
            if (projectViewNodeDecorator == null) {
                CompoundProjectViewNodeDecorator.$$$reportNull$$$0(0);
            }
            return projectViewNodeDecorator;
        }
        ProjectViewNodeDecorator provider2 = project2.getUserData(KEY);
        if (provider2 != null) {
            ProjectViewNodeDecorator projectViewNodeDecorator = provider2;
            if (projectViewNodeDecorator == null) {
                CompoundProjectViewNodeDecorator.$$$reportNull$$$0(1);
            }
            return projectViewNodeDecorator;
        }
        provider2 = new CompoundProjectViewNodeDecorator(project2);
        project2.putUserData(KEY, provider2);
        ProjectViewNodeDecorator projectViewNodeDecorator = provider2;
        if (projectViewNodeDecorator == null) {
            CompoundProjectViewNodeDecorator.$$$reportNull$$$0(2);
        }
        return projectViewNodeDecorator;
    }

    private CompoundProjectViewNodeDecorator(@Nullable Project project2) {
        this.myProject = project2;
    }

    public void decorate(ProjectViewNode node2, PresentationData data2) {
        this.forEach(decorator -> decorator.decorate(node2, data2));
    }

    private void forEach(@NotNull Consumer<? super ProjectViewNodeDecorator> consumer2) {
        if (consumer2 == null) {
            CompoundProjectViewNodeDecorator.$$$reportNull$$$0(3);
        }
        if (this.myProject == null || this.myProject.isDisposed()) {
            return;
        }
        for (ProjectViewNodeDecorator decorator : EP.getExtensions(this.myProject)) {
            try {
                consumer2.accept(decorator);
            }
            catch (IndexNotReadyException exception) {
                throw new ProcessCanceledException(exception);
            }
            catch (ProcessCanceledException exception) {
                throw exception;
            }
            catch (Exception exception) {
                LOG.warn("unexpected error in " + decorator, exception);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/CompoundProjectViewNodeDecorator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/CompoundProjectViewNodeDecorator";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "forEach";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 3 -> new IllegalArgumentException(string2);
        };
    }
}

