/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.impl.ProjectViewFileNestingService;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.table.TableView;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ElementProducer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileNestingInProjectViewDialog
extends DialogWrapper {
    private static final Comparator<ProjectViewFileNestingService.NestingRule> RULE_COMPARATOR = Comparator.comparing(o -> o.getParentFileSuffix() + " " + o.getChildFileSuffix());
    private final JBCheckBox myUseNestingRulesCheckBox;
    private final JPanel myRulesPanel;
    private final TableView<CombinedNestingRule> myTable;
    private final Action myOkAction;

    public FileNestingInProjectViewDialog(@NotNull Project project2) {
        if (project2 == null) {
            FileNestingInProjectViewDialog.$$$reportNull$$$0(0);
        }
        super(project2);
        this.myOkAction = new DialogWrapper.OkAction(){

            public void actionPerformed(ActionEvent e) {
                FileNestingInProjectViewDialog.this.myTable.stopEditing();
                super.actionPerformed(e);
            }
        };
        this.setTitle(IdeBundle.message((String)"file.nesting.dialog.title", (Object[])new Object[0]));
        this.myUseNestingRulesCheckBox = new JBCheckBox(IdeBundle.message((String)"file.nesting.feature.enabled.checkbox", (Object[])new Object[0]));
        this.myUseNestingRulesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UIUtil.setEnabled(FileNestingInProjectViewDialog.this.myRulesPanel, FileNestingInProjectViewDialog.this.myUseNestingRulesCheckBox.isSelected(), true);
            }
        });
        this.myTable = FileNestingInProjectViewDialog.createTable();
        this.myRulesPanel = FileNestingInProjectViewDialog.createRulesPanel(this.myTable);
        this.init();
    }

    protected String getHelpId() {
        return "project.view.file.nesting.dialog";
    }

    protected JComponent createCenterPanel() {
        JPanel mainPanel = new JPanel(new BorderLayout(0, JBUIScale.scale(16)));
        mainPanel.setBorder(JBUI.Borders.emptyTop(8));
        mainPanel.add((Component)this.myUseNestingRulesCheckBox, "North");
        mainPanel.add((Component)this.myRulesPanel, "Center");
        return mainPanel;
    }

    private static JPanel createRulesPanel(@NotNull TableView<CombinedNestingRule> table) {
        if (table == null) {
            FileNestingInProjectViewDialog.$$$reportNull$$$0(1);
        }
        ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator(table, (ElementProducer)new ElementProducer<CombinedNestingRule>(){

            @Override
            public boolean canCreateElement() {
                return true;
            }

            @Override
            public CombinedNestingRule createElement() {
                return new CombinedNestingRule("", "");
            }
        }).disableUpDownActions();
        return UI.PanelFactory.panel((JComponent)toolbarDecorator.createPanel()).withLabel(IdeBundle.message((String)"file.nesting.table.title", (Object[])new Object[0])).moveLabelOnTop().resizeY(true).createPanel();
    }

    private static TableView<CombinedNestingRule> createTable() {
        String childColumn = LangBundle.message("child.file.suffix.column.name", new Object[0]);
        String parentColumn = LangBundle.message("parent.file.suffix.column.name", new Object[0]);
        ListTableModel model2 = new ListTableModel(new ColumnInfo[]{new ColumnInfo<CombinedNestingRule, String>(parentColumn){

            public int getWidth(JTable table) {
                return JBUIScale.scale(125);
            }

            public boolean isCellEditable(CombinedNestingRule rule) {
                return true;
            }

            public String valueOf(CombinedNestingRule rule) {
                return rule.parentSuffix;
            }

            public void setValue(CombinedNestingRule rule, String value) {
                rule.parentSuffix = value.trim();
            }
        }, new ColumnInfo<CombinedNestingRule, String>(childColumn){

            public boolean isCellEditable(CombinedNestingRule rule) {
                return true;
            }

            public String valueOf(CombinedNestingRule rule) {
                return rule.childSuffixes;
            }

            public void setValue(CombinedNestingRule rule, String value) {
                rule.childSuffixes = value;
            }
        }});
        TableView table = new TableView(model2);
        table.setRowHeight(new JTextField().getPreferredSize().height + table.getRowMargin());
        return table;
    }

    protected Action @NotNull [] createLeftSideActions() {
        Action[] actionArray = new Action[]{new DialogWrapper.DialogWrapperAction(IdeBundle.message((String)"file.nesting.reset.to.default.button", (Object[])new Object[0])){

            protected void doAction(ActionEvent e) {
                FileNestingInProjectViewDialog.this.resetTable(ProjectViewFileNestingService.loadDefaultNestingRules());
            }
        }};
        if (actionArray == null) {
            FileNestingInProjectViewDialog.$$$reportNull$$$0(2);
        }
        return actionArray;
    }

    @NotNull
    protected Action getOKAction() {
        Action action2 = this.myOkAction;
        if (action2 == null) {
            FileNestingInProjectViewDialog.$$$reportNull$$$0(3);
        }
        return action2;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        if (!this.myUseNestingRulesCheckBox.isSelected()) {
            return null;
        }
        List items2 = this.myTable.getListTableModel().getItems();
        for (int i2 = 0; i2 < items2.size(); ++i2) {
            CombinedNestingRule rule = (CombinedNestingRule)items2.get(i2);
            int row = i2 + 1;
            if (rule.parentSuffix.isEmpty()) {
                return new ValidationInfo(LangBundle.message("dialog.message.parent.file.suffix.must.be.empty.see.row", row), null);
            }
            if (rule.childSuffixes.isEmpty()) {
                return new ValidationInfo(LangBundle.message("dialog.message.child.file.suffix.must.be.empty.see.row", row), null);
            }
            for (String childSuffix : StringUtil.split(rule.childSuffixes, ";")) {
                if (!rule.parentSuffix.equals(childSuffix.trim())) continue;
                return new ValidationInfo(LangBundle.message("dialog.message.parent.child.file.suffixes.must.be.equal.see.row", rule.parentSuffix, row), null);
            }
        }
        return null;
    }

    public void reset(boolean useFileNestingRules) {
        this.myUseNestingRulesCheckBox.setSelected(useFileNestingRules);
        UIUtil.setEnabled(this.myRulesPanel, this.myUseNestingRulesCheckBox.isSelected(), true);
        this.resetTable(ProjectViewFileNestingService.getInstance().getRules());
    }

    private void resetTable(@NotNull List<? extends ProjectViewFileNestingService.NestingRule> rules) {
        if (rules == null) {
            FileNestingInProjectViewDialog.$$$reportNull$$$0(4);
        }
        TreeMap<String, CombinedNestingRule> result2 = new TreeMap<String, CombinedNestingRule>();
        for (ProjectViewFileNestingService.NestingRule rule : ContainerUtil.sorted(rules, RULE_COMPARATOR)) {
            CombinedNestingRule r = (CombinedNestingRule)result2.get(rule.getParentFileSuffix());
            if (r == null) {
                result2.put(rule.getParentFileSuffix(), new CombinedNestingRule(rule.getParentFileSuffix(), rule.getChildFileSuffix()));
                continue;
            }
            r.childSuffixes = r.childSuffixes + "; " + rule.getChildFileSuffix();
        }
        this.myTable.getListTableModel().setItems(new ArrayList(result2.values()));
    }

    public void apply(@NotNull Consumer<? super Boolean> useNestingRulesOptionConsumer) {
        if (useNestingRulesOptionConsumer == null) {
            FileNestingInProjectViewDialog.$$$reportNull$$$0(5);
        }
        useNestingRulesOptionConsumer.consume((Boolean)this.myUseNestingRulesCheckBox.isSelected());
        if (this.myUseNestingRulesCheckBox.isSelected()) {
            TreeSet<ProjectViewFileNestingService.NestingRule> result2 = new TreeSet<ProjectViewFileNestingService.NestingRule>(RULE_COMPARATOR);
            for (CombinedNestingRule rule : this.myTable.getListTableModel().getItems()) {
                for (String childSuffix : StringUtil.split(rule.childSuffixes, ";")) {
                    if (StringUtil.isEmptyOrSpaces(childSuffix)) continue;
                    result2.add(new ProjectViewFileNestingService.NestingRule(rule.parentSuffix, childSuffix.trim()));
                }
            }
            ProjectViewFileNestingService.getInstance().setRules(new ArrayList<ProjectViewFileNestingService.NestingRule>(result2));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/FileNestingInProjectViewDialog";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rules";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "useNestingRulesOptionConsumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/FileNestingInProjectViewDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createLeftSideActions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOKAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createRulesPanel";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resetTable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3 -> new IllegalStateException(string2);
        };
    }

    private static final class CombinedNestingRule {
        @NotNull
        String parentSuffix;
        @NotNull
        String childSuffixes;

        private CombinedNestingRule(@NotNull String parentSuffix, @NotNull String childSuffixes) {
            if (parentSuffix == null) {
                CombinedNestingRule.$$$reportNull$$$0(0);
            }
            if (childSuffixes == null) {
                CombinedNestingRule.$$$reportNull$$$0(1);
            }
            this.parentSuffix = parentSuffix;
            this.childSuffixes = childSuffixes;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parentSuffix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "childSuffixes";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ide/projectView/impl/FileNestingInProjectViewDialog$CombinedNestingRule";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

