/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import java.util.List;
import java.util.Map;

public final class ModuleGroupUtil {
    private ModuleGroupUtil() {
    }

    public static <T> T buildModuleGroupPath(ModuleGroup group2, T parentNode, Map<ModuleGroup, T> map2, Consumer<? super ParentChildRelation<T>> insertNode, Function<? super ModuleGroup, ? extends T> createNewNode) {
        List<String> groupPath = group2.getGroupPathList();
        for (int i2 = 0; i2 < groupPath.size(); ++i2) {
            ModuleGroup moduleGroup = new ModuleGroup(groupPath.subList(0, i2 + 1));
            T moduleGroupNode = map2.get(moduleGroup);
            if (moduleGroupNode == null) {
                moduleGroupNode = createNewNode.fun(moduleGroup);
                map2.put(moduleGroup, moduleGroupNode);
                insertNode.consume(new ParentChildRelation<T>(parentNode, moduleGroupNode));
            }
            parentNode = moduleGroupNode;
        }
        return parentNode;
    }

    public static <T> T updateModuleGroupPath(ModuleGroup group2, T parentNode, Function<? super ModuleGroup, ? extends T> needToCreateNode, Consumer<? super ParentChildRelation<T>> insertNode, Function<? super ModuleGroup, ? extends T> createNewNode) {
        List<String> groupPath = group2.getGroupPathList();
        for (int i2 = 0; i2 < groupPath.size(); ++i2) {
            ModuleGroup moduleGroup = new ModuleGroup(groupPath.subList(0, i2 + 1));
            T moduleGroupNode = needToCreateNode.fun(moduleGroup);
            if (moduleGroupNode == null) {
                moduleGroupNode = createNewNode.fun(moduleGroup);
                insertNode.consume(new ParentChildRelation<T>(parentNode, moduleGroupNode));
            }
            parentNode = moduleGroupNode;
        }
        return parentNode;
    }

    public static class ParentChildRelation<T> {
        private final T myParent;
        private final T myChild;

        ParentChildRelation(T parent2, T child) {
            this.myParent = parent2;
            this.myChild = child;
        }

        public T getParent() {
            return this.myParent;
        }

        public T getChild() {
            return this.myChild;
        }
    }
}

