/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ProjectViewSettings;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.FileNestingBuilder;
import com.intellij.ide.projectView.impl.ProjectViewFileNestingService;
import com.intellij.ide.projectView.impl.ProjectViewState;
import com.intellij.ide.projectView.impl.nodes.NestingTreeNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public final class NestingTreeStructureProvider
implements TreeStructureProvider,
DumbAware {
    private static final Logger LOG = Logger.getInstance(NestingTreeStructureProvider.class);

    @NotNull
    public Collection<AbstractTreeNode<?>> modify(@NotNull AbstractTreeNode<?> parent2, @NotNull Collection<AbstractTreeNode<?>> children2, ViewSettings settings) {
        VirtualFile virtualFile2;
        if (parent2 == null) {
            NestingTreeStructureProvider.$$$reportNull$$$0(0);
        }
        if (children2 == null) {
            NestingTreeStructureProvider.$$$reportNull$$$0(1);
        }
        if (!(settings instanceof ProjectViewSettings) || !((ProjectViewSettings)settings).isUseFileNestingRules()) {
            Collection<AbstractTreeNode<?>> collection = children2;
            if (collection == null) {
                NestingTreeStructureProvider.$$$reportNull$$$0(2);
            }
            return collection;
        }
        ProjectViewNode parentNode = parent2 instanceof ProjectViewNode ? (ProjectViewNode)parent2 : null;
        VirtualFile virtualFile3 = virtualFile2 = parentNode == null ? null : parentNode.getVirtualFile();
        if (virtualFile2 == null || !virtualFile2.isDirectory()) {
            Collection<AbstractTreeNode<?>> collection = children2;
            if (collection == null) {
                NestingTreeStructureProvider.$$$reportNull$$$0(3);
            }
            return collection;
        }
        ArrayList<PsiFileNode> childNodes = new ArrayList<PsiFileNode>();
        for (AbstractTreeNode<?> node2 : children2) {
            if (!(node2 instanceof PsiFileNode)) continue;
            childNodes.add((PsiFileNode)node2);
        }
        Function<PsiFileNode, String> fileNameFunc = psiFileNode -> {
            PsiFile file2 = (PsiFile)psiFileNode.getValue();
            if (file2 == null) {
                return null;
            }
            return file2.getName();
        };
        FileNestingBuilder fileNestingBuilder = FileNestingBuilder.getInstance();
        MultiMap<PsiFileNode, PsiFileNode> parentToChildren = fileNestingBuilder.mapParentToChildren(childNodes, fileNameFunc);
        if (parentToChildren.isEmpty()) {
            Collection<AbstractTreeNode<?>> collection = children2;
            if (collection == null) {
                NestingTreeStructureProvider.$$$reportNull$$$0(4);
            }
            return collection;
        }
        ArrayList newChildren = new ArrayList(children2.size() - parentToChildren.size());
        HashSet<PsiFileNode> childrenToMoveDown = new HashSet<PsiFileNode>(parentToChildren.values());
        for (AbstractTreeNode<?> node3 : children2) {
            if (!(node3 instanceof PsiFileNode)) {
                newChildren.add(node3);
                continue;
            }
            if (childrenToMoveDown.contains(node3)) continue;
            Collection<PsiFileNode> childrenOfThisFile = parentToChildren.get((PsiFileNode)node3);
            if (childrenOfThisFile.isEmpty()) {
                newChildren.add(node3);
                continue;
            }
            newChildren.add(new NestingTreeNode((PsiFileNode)node3, childrenOfThisFile));
        }
        ArrayList arrayList = newChildren;
        if (arrayList == null) {
            NestingTreeStructureProvider.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    public static Collection<ChildFileInfo> getFilesShownAsChildrenInProjectView(@NotNull Project project2, @NotNull VirtualFile parentFile) {
        if (project2 == null) {
            NestingTreeStructureProvider.$$$reportNull$$$0(6);
        }
        if (parentFile == null) {
            NestingTreeStructureProvider.$$$reportNull$$$0(7);
        }
        LOG.assertTrue(!parentFile.isDirectory());
        if (!ProjectViewState.getInstance(project2).getUseFileNestingRules()) {
            return Collections.emptyList();
        }
        Collection<ProjectViewFileNestingService.NestingRule> rules = FileNestingBuilder.getInstance().getNestingRules();
        if (rules.isEmpty()) {
            return Collections.emptyList();
        }
        Collection<ProjectViewFileNestingService.NestingRule> rulesWhereItCanBeParent = NestingTreeStructureProvider.filterRules(rules, parentFile.getName(), true);
        if (rulesWhereItCanBeParent.isEmpty()) {
            return Collections.emptyList();
        }
        Collection<ProjectViewFileNestingService.NestingRule> rulesWhereItCanBeChild = NestingTreeStructureProvider.filterRules(rules, parentFile.getName(), false);
        VirtualFile dir = parentFile.getParent();
        if (dir == null) {
            return Collections.emptyList();
        }
        VirtualFile[] children2 = dir.getChildren();
        if (children2.length <= 1) {
            return Collections.emptyList();
        }
        SmartList<ChildFileInfo> result2 = new SmartList<ChildFileInfo>();
        for (VirtualFile child : children2) {
            String baseName;
            Couple<Boolean> c2;
            String childName;
            if (child.isDirectory() || child.equals(parentFile)) continue;
            for (ProjectViewFileNestingService.NestingRule rule : rulesWhereItCanBeChild) {
                childName = child.getName();
                c2 = FileNestingBuilder.checkMatchingAsParentOrChild(rule, childName);
                boolean matchesParent = (Boolean)c2.first;
                if (!matchesParent) continue;
                baseName = childName.substring(0, childName.length() - rule.getParentFileSuffix().length());
                if (!parentFile.getName().equals(baseName + rule.getChildFileSuffix())) continue;
                return Collections.emptyList();
            }
            for (ProjectViewFileNestingService.NestingRule rule : rulesWhereItCanBeParent) {
                childName = child.getName();
                c2 = FileNestingBuilder.checkMatchingAsParentOrChild(rule, childName);
                boolean matchesChild = (Boolean)c2.second;
                if (!matchesChild) continue;
                baseName = childName.substring(0, childName.length() - rule.getChildFileSuffix().length());
                if (!parentFile.getName().equals(baseName + rule.getParentFileSuffix())) continue;
                result2.add(new ChildFileInfo(child, baseName));
            }
        }
        return result2;
    }

    @NotNull
    private static Collection<ProjectViewFileNestingService.NestingRule> filterRules(@NotNull Collection<? extends ProjectViewFileNestingService.NestingRule> rules, @NotNull String fileName, boolean parentNotChild) {
        if (rules == null) {
            NestingTreeStructureProvider.$$$reportNull$$$0(8);
        }
        if (fileName == null) {
            NestingTreeStructureProvider.$$$reportNull$$$0(9);
        }
        SmartList<ProjectViewFileNestingService.NestingRule> result2 = new SmartList<ProjectViewFileNestingService.NestingRule>();
        for (ProjectViewFileNestingService.NestingRule nestingRule : rules) {
            Couple<Boolean> c2 = FileNestingBuilder.checkMatchingAsParentOrChild(nestingRule, fileName);
            boolean matchesParent = (Boolean)c2.first;
            boolean matchesChild = (Boolean)c2.second;
            if (!matchesChild && !matchesParent) continue;
            if (matchesParent && parentNotChild) {
                result2.add(nestingRule);
            }
            if (!matchesChild || parentNotChild) continue;
            result2.add(nestingRule);
        }
        SmartList<ProjectViewFileNestingService.NestingRule> smartList = result2;
        if (smartList == null) {
            NestingTreeStructureProvider.$$$reportNull$$$0(10);
        }
        return smartList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/NestingTreeStructureProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rules";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/NestingTreeStructureProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "modify";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "filterRules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "modify";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFilesShownAsChildrenInProjectView";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "filterRules";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3, 4, 5, 10 -> new IllegalStateException(string2);
        };
    }

    public record ChildFileInfo(@NotNull VirtualFile file, @NotNull String namePartCommonWithParentFile) {
        @NotNull
        private final VirtualFile file;
        @NotNull
        private final String namePartCommonWithParentFile;

        public ChildFileInfo(@NotNull VirtualFile file2, @NotNull String namePartCommonWithParentFile) {
            if (file2 == null) {
                ChildFileInfo.$$$reportNull$$$0(0);
            }
            if (namePartCommonWithParentFile == null) {
                ChildFileInfo.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        public VirtualFile file() {
            VirtualFile virtualFile2 = this.file;
            if (virtualFile2 == null) {
                ChildFileInfo.$$$reportNull$$$0(2);
            }
            return virtualFile2;
        }

        @NotNull
        public String namePartCommonWithParentFile() {
            String string2 = this.namePartCommonWithParentFile;
            if (string2 == null) {
                ChildFileInfo.$$$reportNull$$$0(3);
            }
            return string2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namePartCommonWithParentFile";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/projectView/impl/NestingTreeStructureProvider$ChildFileInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/projectView/impl/NestingTreeStructureProvider$ChildFileInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "file";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "namePartCommonWithParentFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2, 3 -> new IllegalStateException(string2);
            };
        }
    }
}

