/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.util.DeleteHandler;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public abstract class ProjectViewDeleteElementProvider
implements DeleteProvider {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ProjectViewDeleteElementProvider.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public boolean canDeleteElement(@NotNull DataContext dataContext2) {
        Project project2;
        if (dataContext2 == null) {
            ProjectViewDeleteElementProvider.$$$reportNull$$$0(1);
        }
        if ((project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext2)) == null) {
            return false;
        }
        PsiElement[] elements = this.getElementsToDelete(project2, dataContext2);
        return DeleteHandler.shouldEnableDeleteAction(elements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteElement(@NotNull DataContext dataContext2) {
        Project project2;
        if (dataContext2 == null) {
            ProjectViewDeleteElementProvider.$$$reportNull$$$0(2);
        }
        if ((project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext2)) == null) {
            return;
        }
        ArrayList<PsiElement> validElements = new ArrayList<PsiElement>();
        for (PsiElement psiElement : this.getElementsToDelete(project2, dataContext2)) {
            if (psiElement == null || !psiElement.isValid()) continue;
            validElements.add(psiElement);
        }
        PsiElement[] elements = PsiUtilCore.toPsiElementArray(validElements);
        LocalHistoryAction a = LocalHistory.getInstance().startAction(IdeBundle.message((String)"progress.deleting", (Object[])new Object[0]));
        try {
            DeleteHandler.deletePsiElement(elements, project2);
        }
        finally {
            a.finish();
        }
    }

    protected abstract PsiElement @NotNull [] getSelectedPSIElements(@NotNull DataContext var1);

    protected abstract Boolean hideEmptyMiddlePackages(@NotNull DataContext var1);

    private PsiElement @NotNull [] getElementsToDelete(@NotNull Project project2, @NotNull DataContext dataContext2) {
        if (project2 == null) {
            ProjectViewDeleteElementProvider.$$$reportNull$$$0(3);
        }
        if (dataContext2 == null) {
            ProjectViewDeleteElementProvider.$$$reportNull$$$0(4);
        }
        PsiElement[] elements = this.getSelectedPSIElements(dataContext2);
        for (int idx = 0; idx < elements.length; ++idx) {
            PsiFile psiFile;
            VirtualFile vFile;
            VirtualFile virtualFile2;
            String path2;
            PsiElement element = elements[idx];
            if (!(element instanceof PsiDirectory)) continue;
            PsiDirectory directory = (PsiDirectory)element;
            ProjectViewDirectoryHelper directoryHelper = ProjectViewDirectoryHelper.getInstance(project2);
            if (this.hideEmptyMiddlePackages(dataContext2).booleanValue() && directory.getChildren().length == 0 && !directoryHelper.skipDirectory(directory)) {
                PsiElement[] children2;
                PsiDirectory parent2;
                while ((parent2 = directory.getParentDirectory()) != null && !directoryHelper.skipDirectory(parent2) && !PsiDirectoryFactory.getInstance(project2).getQualifiedName(parent2, false).isEmpty() && ((children2 = parent2.getChildren()).length == 0 || children2.length == 1 && children2[0] == directory)) {
                    directory = parent2;
                }
                elements[idx] = directory;
            }
            if (!(path2 = (virtualFile2 = directory.getVirtualFile()).getPath()).endsWith("!/") || (vFile = LocalFileSystem.getInstance().findFileByPath(path2.substring(0, path2.length() - "!/".length()))) == null || (psiFile = PsiManager.getInstance(project2).findFile(vFile)) == null) continue;
            elements[idx] = psiFile;
        }
        if (elements == null) {
            ProjectViewDeleteElementProvider.$$$reportNull$$$0(5);
        }
        return elements;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/ProjectViewDeleteElementProvider";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/ProjectViewDeleteElementProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsToDelete";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "canDeleteElement";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "deleteElement";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getElementsToDelete";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string2);
        };
    }
}

