/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.application.options.OptionId;
import com.intellij.application.options.OptionsApplicabilityFilter;
import com.intellij.ide.CopyPasteDelegator;
import com.intellij.ide.FileEditorProvider;
import com.intellij.ide.FileSelectInContext;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeView;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.SmartSelectInContext;
import com.intellij.ide.bookmark.BookmarksListener;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.impl.DataValidators;
import com.intellij.ide.impl.ProjectViewSelectInTarget;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.AbstractProjectViewPaneWithAsyncSupport;
import com.intellij.ide.projectView.impl.IdeViewForProjectViewPane;
import com.intellij.ide.projectView.impl.ProjectViewCurrentPaneProvider;
import com.intellij.ide.projectView.impl.ProjectViewListener;
import com.intellij.ide.projectView.impl.ProjectViewSharedSettings;
import com.intellij.ide.projectView.impl.ProjectViewState;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.scopeView.ScopeViewPane;
import com.intellij.ide.ui.SplitterProportionsDataImpl;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.idea.ActionsBundle;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.ClassEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CompositeDataProvider;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleOptionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.ex.EditorEventMulticasterEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.ui.SplitterProportionsData;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.BusyObject;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowContentUiType;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.AutoScrollFromSourceHandler;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.IdeUICustomization;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.switcher.QuickActionProvider;
import com.intellij.ui.tree.TreePathUtil;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ProjectView", storages={@Storage(value="$PRODUCT_WORKSPACE_FILE$")})
public class ProjectViewImpl
extends ProjectView
implements PersistentStateComponent<Element>,
QuickActionProvider,
BusyObject {
    private static final Logger LOG = Logger.getInstance(ProjectViewImpl.class);
    private static final Key<String> ID_KEY = Key.create("pane-id");
    private static final Key<String> SUB_ID_KEY = Key.create("pane-sub-id");
    private final CopyPasteDelegator myCopyPasteDelegator;
    private boolean isInitialized;
    private final AtomicBoolean myExtensionsLoaded;
    @NotNull
    private final Project myProject;
    private final ProjectViewState myCurrentState;
    private final Option myAbbreviatePackageNames;
    private final Option myAutoscrollFromSource;
    private final Option myAutoscrollToSource;
    private final Option myOpenInPreviewTab;
    private final Option myCompactDirectories;
    private final Option myFlattenModules;
    private final Option myFlattenPackages;
    private final Option myFoldersAlwaysOnTop;
    private final Option myShowScratchesAndConsoles;
    private final Option myHideEmptyMiddlePackages;
    private final Option myManualOrder;
    private final Option myShowExcludedFiles;
    private final Option myShowLibraryContents;
    private final Option myShowMembers;
    private final Option myShowModules;
    private final Option myShowVisibilityIcons;
    private final Option mySortByType;
    private String myCurrentViewId;
    private String myCurrentViewSubId;
    private final AutoScrollToSourceHandler myAutoScrollToSourceHandler;
    private final MyAutoScrollFromSourceHandler myAutoScrollFromSourceHandler;
    private volatile ThreeState myCurrentSelectionObsolete;
    private final AtomicBoolean myAutoScrollOnFocusEditor;
    private final IdeView myIdeView;
    private SimpleToolWindowPanel myPanel;
    private final Map<String, AbstractProjectViewPane> myId2Pane;
    private final Collection<AbstractProjectViewPane> myUninitializedPanes;
    private DefaultActionGroup myActionGroup;
    @Nullable
    private String mySavedPaneId;
    @Nullable
    private String mySavedPaneSubId;
    @NonNls
    private static final String ELEMENT_NAVIGATOR = "navigator";
    @NonNls
    private static final String ELEMENT_PANES = "panes";
    @NonNls
    private static final String ELEMENT_PANE = "pane";
    @NonNls
    private static final String ATTRIBUTE_CURRENT_VIEW = "currentView";
    @NonNls
    private static final String ATTRIBUTE_CURRENT_SUBVIEW = "currentSubView";
    private static final String ATTRIBUTE_ID = "id";
    private JPanel myViewContentPanel;
    private static final Comparator<AbstractProjectViewPane> PANE_WEIGHT_COMPARATOR = Comparator.comparingInt(AbstractProjectViewPane::getWeight);
    private final MyPanel myDataProvider;
    private final SplitterProportionsData splitterProportions;
    private final Map<String, Element> myUninitializedPaneState;
    private final Map<String, SelectInTarget> mySelectInTargets;
    private ContentManager myContentManager;

    public ProjectViewImpl(@NotNull Project project2) {
        if (project2 == null) {
            ProjectViewImpl.$$$reportNull$$$0(0);
        }
        this.myExtensionsLoaded = new AtomicBoolean(false);
        this.myAbbreviatePackageNames = new Option(){

            @Override
            public boolean isEnabled(@NotNull AbstractProjectViewPane pane) {
                if (pane == null) {
                    1.$$$reportNull$$$0(0);
                }
                return ProjectViewImpl.this.myFlattenPackages.isSelected() && ProjectViewImpl.this.myFlattenPackages.isEnabled(pane) && pane.supportsAbbreviatePackageNames();
            }

            public boolean isSelected() {
                return ProjectViewImpl.this.myCurrentState.getAbbreviatePackageNames();
            }

            public void setSelected(boolean selected) {
                if (ProjectViewImpl.this.myProject.isDisposed()) {
                    return;
                }
                boolean updated = selected != this.isSelected();
                ProjectViewImpl.this.myCurrentState.setAbbreviatePackageNames(selected);
                ProjectViewImpl.getDefaultState().setAbbreviatePackageNames(selected);
                ProjectViewImpl.getGlobalOptions().setAbbreviatePackages(selected);
                if (updated) {
                    ProjectViewImpl.this.updatePanes(false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ProjectViewImpl.ELEMENT_PANE, "com/intellij/ide/projectView/impl/ProjectViewImpl$1", "isEnabled"));
            }
        };
        this.myAutoscrollFromSource = new Option(){

            public boolean isSelected() {
                return ProjectViewImpl.this.myCurrentState.getAutoscrollFromSource();
            }

            public void setSelected(boolean selected) {
                if (ProjectViewImpl.this.myProject.isDisposed()) {
                    return;
                }
                ProjectViewImpl.this.myCurrentState.setAutoscrollFromSource(selected);
                ProjectViewImpl.getDefaultState().setAutoscrollFromSource(selected);
                ProjectViewImpl.getGlobalOptions().setAutoscrollFromSource(selected);
                if (selected && !ProjectViewImpl.this.myAutoScrollFromSourceHandler.isCurrentProjectViewPaneFocused()) {
                    ProjectViewImpl.this.myAutoScrollFromSourceHandler.scrollFromSource(false);
                }
            }
        };
        this.myAutoscrollToSource = new Option(){

            public boolean isSelected() {
                return ProjectViewImpl.this.myCurrentState.getAutoscrollToSource();
            }

            public void setSelected(boolean selected) {
                if (ProjectViewImpl.this.myProject.isDisposed()) {
                    return;
                }
                ProjectViewImpl.this.myCurrentState.setAutoscrollToSource(selected);
                ProjectViewImpl.getDefaultState().setAutoscrollToSource(selected);
                ProjectViewImpl.getGlobalOptions().setAutoscrollToSource(selected);
            }
        };
        this.myOpenInPreviewTab = new Option(){

            public boolean isSelected() {
                return UISettings.getInstance().getOpenInPreviewTabIfPossible();
            }

            public void setSelected(boolean selected) {
                UISettings.getInstance().setOpenInPreviewTabIfPossible(selected);
            }
        };
        this.myCompactDirectories = new Option(){

            @Override
            public boolean isEnabled(@NotNull AbstractProjectViewPane pane) {
                if (pane == null) {
                    5.$$$reportNull$$$0(0);
                }
                return pane.supportsCompactDirectories();
            }

            public boolean isSelected() {
                return ProjectViewImpl.this.myCurrentState.getCompactDirectories();
            }

            public void setSelected(boolean selected) {
                if (ProjectViewImpl.this.myProject.isDisposed()) {
                    return;
                }
                boolean updated = selected != this.isSelected();
                ProjectViewImpl.this.myCurrentState.setCompactDirectories(selected);
                ProjectViewImpl.getDefaultState().setCompactDirectories(selected);
                ProjectViewImpl.getGlobalOptions().setCompactDirectories(selected);
                if (updated) {
                    ProjectViewImpl.this.updatePanes(false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ProjectViewImpl.ELEMENT_PANE, "com/intellij/ide/projectView/impl/ProjectViewImpl$5", "isEnabled"));
            }
        };
        this.myFlattenModules = new Option(){

            @Override
            public boolean isEnabled(@NotNull AbstractProjectViewPane pane) {
                if (pane == null) {
                    6.$$$reportNull$$$0(0);
                }
                return pane.supportsFlattenModules();
            }

            public boolean isSelected() {
                return ProjectViewImpl.this.myCurrentState.getFlattenModules();
            }

            public void setSelected(boolean selected) {
                if (ProjectViewImpl.this.myProject.isDisposed()) {
                    return;
                }
                boolean updated = selected != this.isSelected();
                ProjectViewImpl.this.myCurrentState.setFlattenModules(selected);
                ProjectViewImpl.getDefaultState().setFlattenModules(selected);
                ProjectViewImpl.getGlobalOptions().setFlattenModules(selected);
                if (updated) {
                    ProjectViewImpl.this.updatePanes(false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ProjectViewImpl.ELEMENT_PANE, "com/intellij/ide/projectView/impl/ProjectViewImpl$6", "isEnabled"));
            }
        };
        this.myFlattenPackages = new Option(){

            @Override
            public boolean isEnabled(@NotNull AbstractProjectViewPane pane) {
                if (pane == null) {
                    7.$$$reportNull$$$0(0);
                }
                return ProjectViewDirectoryHelper.getInstance(ProjectViewImpl.this.myProject).supportsFlattenPackages();
            }

            public boolean isSelected() {
                return ProjectViewImpl.this.myCurrentState.getFlattenPackages();
            }

            public void setSelected(boolean selected) {
                if (ProjectViewImpl.this.myProject.isDisposed()) {
                    return;
                }
                boolean updated = selected != this.isSelected();
                ProjectViewImpl.this.myCurrentState.setFlattenPackages(selected);
                ProjectViewImpl.getDefaultState().setFlattenPackages(selected);
                ProjectViewImpl.getGlobalOptions().setFlattenPackages(selected);
                if (updated) {
                    ProjectViewImpl.this.updatePanes(false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ProjectViewImpl.ELEMENT_PANE, "com/intellij/ide/projectView/impl/ProjectViewImpl$7", "isEnabled"));
            }
        };
        this.myFoldersAlwaysOnTop = new Option(){

            @Override
            public boolean isEnabled(@NotNull AbstractProjectViewPane pane) {
                if (pane == null) {
                    8.$$$reportNull$$$0(0);
                }
                return pane.supportsFoldersAlwaysOnTop();
            }

            public boolean isSelected() {
                return ProjectViewImpl.this.myCurrentState.getFoldersAlwaysOnTop();
            }

            public void setSelected(boolean selected) {
                if (ProjectViewImpl.this.myProject.isDisposed()) {
                    return;
                }
                boolean updated = selected != this.isSelected();
                ProjectViewImpl.this.myCurrentState.setFoldersAlwaysOnTop(selected);
                ProjectViewImpl.getDefaultState().setFoldersAlwaysOnTop(selected);
                ProjectViewImpl.getGlobalOptions().setFoldersAlwaysOnTop(selected);
                if (updated) {
                    ProjectViewImpl.this.updatePanes(true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ProjectViewImpl.ELEMENT_PANE, "com/intellij/ide/projectView/impl/ProjectViewImpl$8", "isEnabled"));
            }
        };
        this.myShowScratchesAndConsoles = new Option(){

            @Override
            public boolean isEnabled(@NotNull AbstractProjectViewPane pane) {
                if (pane == null) {
                    9.$$$reportNull$$$0(0);
                }
                return pane.supportsShowScratchesAndConsoles();
            }

            public boolean isSelected() {
                return ProjectViewImpl.this.myCurrentState.getShowScratchesAndConsoles();
            }

            public void setSelected(boolean selected) {
                if (ProjectViewImpl.this.myProject.isDisposed()) {
                    return;
                }
                boolean updated = selected != this.isSelected();
                ProjectViewImpl.this.myCurrentState.setShowScratchesAndConsoles(selected);
                ProjectViewImpl.getDefaultState().setShowScratchesAndConsoles(selected);
                ProjectViewImpl.getGlobalOptions().setShowScratchesAndConsoles(selected);
                if (updated) {
                    ProjectViewImpl.this.updatePanes(true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ProjectViewImpl.ELEMENT_PANE, "com/intellij/ide/projectView/impl/ProjectViewImpl$9", "isEnabled"));
            }
        };
        this.myHideEmptyMiddlePackages = new Option(){

            @NotNull
            public String getName() {
                String string2 = ProjectViewImpl.this.myFlattenPackages.isSelected() ? IdeBundle.message((String)"action.hide.empty.middle.packages", (Object[])new Object[0]) : IdeBundle.message((String)"action.compact.empty.middle.packages", (Object[])new Object[0]);
                if (string2 == null) {
                    10.$$$reportNull$$$0(0);
                }
                return string2;
            }

            public String getDescription() {
                return ProjectViewImpl.this.myFlattenPackages.isSelected() ? IdeBundle.message((String)"action.show.hide.empty.middle.packages", (Object[])new Object[0]) : IdeBundle.message((String)"action.show.compact.empty.middle.packages", (Object[])new Object[0]);
            }

            @Override
            public boolean isEnabled(@NotNull AbstractProjectViewPane pane) {
                if (pane == null) {
                    10.$$$reportNull$$$0(1);
                }
                return pane.supportsHideEmptyMiddlePackages() && ProjectViewDirectoryHelper.getInstance(ProjectViewImpl.this.myProject).supportsHideEmptyMiddlePackages();
            }

            public boolean isSelected() {
                return ProjectViewImpl.this.myCurrentState.getHideEmptyMiddlePackages();
            }

            public void setSelected(boolean selected) {
                if (ProjectViewImpl.this.myProject.isDisposed()) {
                    return;
                }
                boolean updated = selected != this.isSelected();
                ProjectViewImpl.this.myCurrentState.setHideEmptyMiddlePackages(selected);
                ProjectViewImpl.getDefaultState().setHideEmptyMiddlePackages(selected);
                ProjectViewImpl.getGlobalOptions().setHideEmptyPackages(selected);
                if (updated) {
                    ProjectViewImpl.this.updatePanes(false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/projectView/impl/ProjectViewImpl$10";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = ProjectViewImpl.ELEMENT_PANE;
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/projectView/impl/ProjectViewImpl$10";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "isEnabled";
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string2);
                    case 1 -> new IllegalArgumentException(string2);
                };
            }
        };
        this.myManualOrder = new Option(){

            @NotNull
            public String getName() {
                AbstractProjectViewPane pane = ProjectViewImpl.this.getCurrentProjectViewPane();
                String string2 = pane != null ? pane.getManualOrderOptionText() : IdeBundle.message((String)"action.manual.order", (Object[])new Object[0]);
                if (string2 == null) {
                    11.$$$reportNull$$$0(0);
                }
                return string2;
            }

            @Override
            public boolean isEnabled(@NotNull AbstractProjectViewPane pane) {
                if (pane == null) {
                    11.$$$reportNull$$$0(1);
                }
                return pane.supportsManualOrder();
            }

            public boolean isSelected() {
                return ProjectViewImpl.this.myCurrentState.getManualOrder();
            }

            public void setSelected(boolean selected) {
                if (ProjectViewImpl.this.myProject.isDisposed()) {
                    return;
                }
                boolean updated = selected != this.isSelected();
                ProjectViewImpl.this.myCurrentState.setManualOrder(selected);
                ProjectViewImpl.getDefaultState().setManualOrder(selected);
                ProjectViewImpl.getGlobalOptions().setManualOrder(selected);
                if (updated) {
                    ProjectViewImpl.this.updatePanes(true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/projectView/impl/ProjectViewImpl$11";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = ProjectViewImpl.ELEMENT_PANE;
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/projectView/impl/ProjectViewImpl$11";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "isEnabled";
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string2);
                    case 1 -> new IllegalArgumentException(string2);
                };
            }
        };
        this.myShowExcludedFiles = new Option(){

            @Override
            public boolean isEnabled(@NotNull AbstractProjectViewPane pane) {
                if (pane == null) {
                    12.$$$reportNull$$$0(0);
                }
                return pane.supportsShowExcludedFiles();
            }

            public boolean isSelected() {
                return ProjectViewImpl.this.myCurrentState.getShowExcludedFiles();
            }

            public void setSelected(boolean selected) {
                if (ProjectViewImpl.this.myProject.isDisposed()) {
                    return;
                }
                boolean updated = selected != this.isSelected();
                ProjectViewImpl.this.myCurrentState.setShowExcludedFiles(selected);
                ProjectViewImpl.getDefaultState().setShowExcludedFiles(selected);
                ProjectViewImpl.getGlobalOptions().setShowExcludedFiles(selected);
                if (updated) {
                    ProjectViewImpl.this.updatePanes(false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ProjectViewImpl.ELEMENT_PANE, "com/intellij/ide/projectView/impl/ProjectViewImpl$12", "isEnabled"));
            }
        };
        this.myShowLibraryContents = new Option(){

            @Override
            public boolean isEnabled(@NotNull AbstractProjectViewPane pane) {
                if (pane == null) {
                    13.$$$reportNull$$$0(0);
                }
                return pane.supportsShowLibraryContents();
            }

            public boolean isSelected() {
                return ProjectViewImpl.this.myCurrentState.getShowLibraryContents();
            }

            public void setSelected(boolean selected) {
                if (ProjectViewImpl.this.myProject.isDisposed()) {
                    return;
                }
                boolean updated = selected != this.isSelected();
                ProjectViewImpl.this.myCurrentState.setShowLibraryContents(selected);
                ProjectViewImpl.getDefaultState().setShowLibraryContents(selected);
                ProjectViewImpl.getGlobalOptions().setShowLibraryContents(selected);
                if (updated) {
                    ProjectViewImpl.this.updatePanes(false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ProjectViewImpl.ELEMENT_PANE, "com/intellij/ide/projectView/impl/ProjectViewImpl$13", "isEnabled"));
            }
        };
        this.myShowMembers = new Option(){

            @Override
            public boolean isEnabled(@NotNull AbstractProjectViewPane pane) {
                if (pane == null) {
                    14.$$$reportNull$$$0(0);
                }
                return ProjectViewImpl.this.isShowMembersOptionSupported();
            }

            public boolean isSelected() {
                return ProjectViewImpl.this.myCurrentState.getShowMembers();
            }

            public void setSelected(boolean selected) {
                if (ProjectViewImpl.this.myProject.isDisposed()) {
                    return;
                }
                boolean updated = selected != this.isSelected();
                ProjectViewImpl.this.myCurrentState.setShowMembers(selected);
                ProjectViewImpl.getDefaultState().setShowMembers(selected);
                ProjectViewImpl.getGlobalOptions().setShowMembers(selected);
                if (updated) {
                    ProjectViewImpl.this.updatePanes(false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ProjectViewImpl.ELEMENT_PANE, "com/intellij/ide/projectView/impl/ProjectViewImpl$14", "isEnabled"));
            }
        };
        this.myShowModules = new Option(){

            @Override
            public boolean isEnabled(@NotNull AbstractProjectViewPane pane) {
                if (pane == null) {
                    15.$$$reportNull$$$0(0);
                }
                return pane.supportsShowModules();
            }

            public boolean isSelected() {
                return ProjectViewImpl.this.myCurrentState.getShowModules();
            }

            public void setSelected(boolean selected) {
                if (ProjectViewImpl.this.myProject.isDisposed()) {
                    return;
                }
                boolean updated = selected != this.isSelected();
                ProjectViewImpl.this.myCurrentState.setShowModules(selected);
                ProjectViewImpl.getDefaultState().setShowModules(selected);
                ProjectViewImpl.getGlobalOptions().setShowModules(selected);
                if (updated) {
                    ProjectViewImpl.this.updatePanes(false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ProjectViewImpl.ELEMENT_PANE, "com/intellij/ide/projectView/impl/ProjectViewImpl$15", "isEnabled"));
            }
        };
        this.myShowVisibilityIcons = new Option(){

            @Override
            public boolean isEnabled(@NotNull AbstractProjectViewPane pane) {
                if (pane == null) {
                    16.$$$reportNull$$$0(0);
                }
                return OptionsApplicabilityFilter.isApplicable(OptionId.PROJECT_VIEW_SHOW_VISIBILITY_ICONS);
            }

            public boolean isSelected() {
                return ProjectViewImpl.this.myCurrentState.getShowVisibilityIcons();
            }

            public void setSelected(boolean selected) {
                if (ProjectViewImpl.this.myProject.isDisposed()) {
                    return;
                }
                boolean updated = selected != this.isSelected();
                ProjectViewImpl.this.myCurrentState.setShowVisibilityIcons(selected);
                ProjectViewImpl.getDefaultState().setShowVisibilityIcons(selected);
                ProjectViewImpl.getGlobalOptions().setShowVisibilityIcons(selected);
                if (updated) {
                    ProjectViewImpl.this.updatePanes(false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ProjectViewImpl.ELEMENT_PANE, "com/intellij/ide/projectView/impl/ProjectViewImpl$16", "isEnabled"));
            }
        };
        this.mySortByType = new Option(){

            @Override
            public boolean isEnabled(@NotNull AbstractProjectViewPane pane) {
                if (pane == null) {
                    17.$$$reportNull$$$0(0);
                }
                return pane.supportsSortByType();
            }

            public boolean isSelected() {
                return ProjectViewImpl.this.myCurrentState.getSortByType();
            }

            public void setSelected(boolean selected) {
                if (ProjectViewImpl.this.myProject.isDisposed()) {
                    return;
                }
                boolean updated = selected != this.isSelected();
                ProjectViewImpl.this.myCurrentState.setSortByType(selected);
                ProjectViewImpl.getDefaultState().setSortByType(selected);
                ProjectViewImpl.getGlobalOptions().setSortByType(selected);
                if (updated) {
                    ProjectViewImpl.this.updatePanes(true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ProjectViewImpl.ELEMENT_PANE, "com/intellij/ide/projectView/impl/ProjectViewImpl$17", "isEnabled"));
            }
        };
        this.myCurrentSelectionObsolete = ThreeState.NO;
        this.myAutoScrollOnFocusEditor = new AtomicBoolean(true);
        this.myIdeView = new IdeViewForProjectViewPane(this::getCurrentProjectViewPane);
        this.myId2Pane = new LinkedHashMap<String, AbstractProjectViewPane>();
        this.myUninitializedPanes = new HashSet<AbstractProjectViewPane>();
        this.mySavedPaneId = null;
        this.splitterProportions = new SplitterProportionsDataImpl();
        this.myUninitializedPaneState = new HashMap<String, Element>();
        this.mySelectInTargets = new LinkedHashMap<String, SelectInTarget>();
        this.myProject = project2;
        this.myCurrentState = ProjectViewState.getInstance(project2);
        this.constructUi();
        this.myAutoScrollFromSourceHandler = new MyAutoScrollFromSourceHandler();
        this.myDataProvider = new MyPanel();
        this.myDataProvider.add((Component)this.myPanel, "Center");
        this.myCopyPasteDelegator = new CopyPasteDelegator(this.myProject, (JComponent)this.myPanel);
        this.myAutoScrollToSourceHandler = new AutoScrollToSourceHandler(){

            protected boolean isAutoScrollMode() {
                return ProjectViewImpl.this.myAutoscrollToSource.isSelected() || ProjectViewImpl.this.myOpenInPreviewTab.isSelected();
            }

            protected void setAutoScrollMode(boolean state) {
                ProjectViewImpl.this.myAutoscrollToSource.setSelected(state);
            }

            protected boolean isAutoScrollEnabledFor(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    18.$$$reportNull$$$0(0);
                }
                if (!super.isAutoScrollEnabledFor(file2)) {
                    return false;
                }
                AbstractProjectViewPane pane = ProjectViewImpl.this.getCurrentProjectViewPane();
                return pane == null || pane.isAutoScrollEnabledFor(file2);
            }

            protected String getActionName() {
                return ActionsBundle.message((String)"action.ProjectView.AutoscrollToSource.text", (Object[])new Object[0]);
            }

            protected String getActionDescription() {
                return ActionsBundle.message((String)"action.ProjectView.AutoscrollToSource.description", (Object[])new Object[0]);
            }

            protected boolean needToCheckFocus() {
                AbstractProjectViewPane currentProjectViewPane = ProjectViewImpl.this.getCurrentProjectViewPane();
                return currentProjectViewPane == null || !currentProjectViewPane.isAutoScrollEnabledWithoutFocus();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/projectView/impl/ProjectViewImpl$18", "isAutoScrollEnabledFor"));
            }
        };
        project2.getMessageBus().connect().subscribe(ToolWindowManagerListener.TOPIC, new ToolWindowManagerListener(){

            public void toolWindowShown(@NotNull ToolWindow toolWindow) {
                if (toolWindow == null) {
                    19.$$$reportNull$$$0(0);
                }
                if ("Project".equals(toolWindow.getId())) {
                    SimpleSelectInContext context2;
                    ProjectViewImpl.this.myCurrentSelectionObsolete = ThreeState.NO;
                    AbstractProjectViewPane currentProjectViewPane = ProjectViewImpl.this.getCurrentProjectViewPane();
                    if (currentProjectViewPane != null && ProjectViewImpl.this.isAutoscrollFromSource(currentProjectViewPane.getId()) && (context2 = ProjectViewImpl.this.myAutoScrollFromSourceHandler.findSelectInContext()) != null) {
                        ProjectViewImpl.this.myCurrentSelectionObsolete = ThreeState.UNSURE;
                        context2.selectInCurrentTarget(false);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/intellij/ide/projectView/impl/ProjectViewImpl$19", "toolWindowShown"));
            }
        });
        AbstractProjectViewPane.EP.addExtensionPointListener(project2, new ExtensionPointListener<AbstractProjectViewPane>(){

            @Override
            public void extensionAdded(@NotNull AbstractProjectViewPane extension2, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension2 == null) {
                    20.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    20.$$$reportNull$$$0(1);
                }
                ProjectViewImpl.this.reloadPanes();
            }

            @Override
            public void extensionRemoved(@NotNull AbstractProjectViewPane extension2, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension2 == null) {
                    20.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    20.$$$reportNull$$$0(3);
                }
                if (ProjectViewImpl.this.myId2Pane.containsKey(extension2.getId()) || ProjectViewImpl.this.myUninitializedPanes.contains(extension2)) {
                    ProjectViewImpl.this.reloadPanes();
                } else {
                    Disposer.dispose(extension2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ide/projectView/impl/ProjectViewImpl$20";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, project2);
    }

    private void constructUi() {
        this.myViewContentPanel = new JPanel();
        this.myViewContentPanel.putClientProperty(FileEditorManagerImpl.OPEN_IN_PREVIEW_TAB, true);
        this.myPanel = new SimpleToolWindowPanel(true).setProvideQuickActions(false);
        this.myPanel.setContent((JComponent)this.myViewContentPanel);
    }

    @NotNull
    public String getName() {
        String string2 = IdeUICustomization.getInstance().getProjectViewTitle(this.myProject);
        if (string2 == null) {
            ProjectViewImpl.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @NotNull
    public List<AnAction> getActions(boolean originalProvider) {
        DefaultActionGroup views = DefaultActionGroup.createPopupGroup(() -> LangBundle.message("action.change.view.text", new Object[0]));
        ChangeViewAction lastHeader = null;
        for (int i2 = 0; i2 < this.myContentManager.getContentCount(); ++i2) {
            Content each = this.myContentManager.getContent(i2);
            if (each == null) continue;
            String id = (String)each.getUserData(ID_KEY);
            String subId = (String)each.getUserData(SUB_ID_KEY);
            ChangeViewAction newHeader = new ChangeViewAction(id, subId);
            if (lastHeader != null) {
                boolean newHasKids;
                boolean lastHasKids = lastHeader.mySubId != null;
                boolean bl = newHasKids = newHeader.mySubId != null;
                if (lastHasKids != newHasKids || lastHasKids && !Strings.areSameInstance(lastHeader.myId, newHeader.myId)) {
                    views.add((AnAction)Separator.getInstance());
                }
            }
            views.add((AnAction)newHeader);
            lastHeader = newHeader;
        }
        ArrayList<AnAction> result2 = new ArrayList<AnAction>();
        result2.add((AnAction)views);
        result2.add((AnAction)Separator.getInstance());
        if (this.myActionGroup != null) {
            ArrayList<AnAction> secondary = new ArrayList<AnAction>();
            for (AnAction each : this.myActionGroup.getChildren(null)) {
                if (this.myActionGroup.isPrimary(each)) {
                    result2.add(each);
                    continue;
                }
                secondary.add(each);
            }
            result2.add((AnAction)Separator.getInstance());
            result2.addAll(secondary);
        }
        ArrayList<AnAction> arrayList = result2;
        if (arrayList == null) {
            ProjectViewImpl.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static ProjectViewState getDefaultState() {
        return ProjectViewState.getDefaultInstance();
    }

    @Override
    public synchronized void addProjectPane(@NotNull AbstractProjectViewPane pane) {
        if (pane == null) {
            ProjectViewImpl.$$$reportNull$$$0(3);
        }
        this.myUninitializedPanes.add(pane);
        SelectInTarget selectInTarget = pane.createSelectInTarget();
        String id = selectInTarget.getMinorViewId();
        if (pane.getId().equals(id)) {
            this.mySelectInTargets.put(id, selectInTarget);
        } else {
            try {
                LOG.error("Unexpected SelectInTarget: " + selectInTarget.getClass() + "\n  created by project pane:" + pane.getClass());
            }
            catch (AssertionError assertionError) {
                // empty catch block
            }
        }
        if (this.isInitialized) {
            this.doAddUninitializedPanes();
        }
    }

    @Override
    public synchronized void removeProjectPane(@NotNull AbstractProjectViewPane pane) {
        if (pane == null) {
            ProjectViewImpl.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myUninitializedPanes.remove(pane);
        String idToRemove = pane.getId();
        if (!this.myId2Pane.containsKey(idToRemove)) {
            return;
        }
        for (int i2 = this.getContentManager().getContentCount() - 1; i2 >= 0; --i2) {
            String id;
            Content content2 = this.getContentManager().getContent(i2);
            String string2 = id = content2 != null ? (String)content2.getUserData(ID_KEY) : null;
            if (!idToRemove.equals(id)) continue;
            this.getContentManager().removeContent(content2, true);
        }
        this.myId2Pane.remove(idToRemove);
        this.mySelectInTargets.remove(idToRemove);
        this.viewSelectionChanged();
    }

    private synchronized void doAddUninitializedPanes() {
        for (AbstractProjectViewPane pane : this.myUninitializedPanes) {
            this.doAddPane(pane);
        }
        Content[] contents = this.getContentManager().getContents();
        for (int i2 = 1; i2 < contents.length; ++i2) {
            Content content2 = contents[i2];
            Content prev = contents[i2 - 1];
            if (StringUtil.equals((CharSequence)content2.getUserData(ID_KEY), (CharSequence)prev.getUserData(ID_KEY)) || prev.getUserData(SUB_ID_KEY) == null || content2.getSeparator() != null) continue;
            content2.setSeparator("");
        }
        String selectID = null;
        String selectSubID = null;
        String savedPaneId = this.mySavedPaneId;
        if (savedPaneId == null) {
            savedPaneId = this.getDefaultViewId();
            this.mySavedPaneSubId = null;
        }
        for (Content content3 : contents) {
            String id = (String)content3.getUserData(ID_KEY);
            String subId = (String)content3.getUserData(SUB_ID_KEY);
            if (id == null || !id.equals(savedPaneId) || !StringUtil.equals(subId, this.mySavedPaneSubId)) continue;
            selectID = id;
            selectSubID = subId;
            this.mySavedPaneId = null;
            this.mySavedPaneSubId = null;
            break;
        }
        if (selectID == null && contents.length > 0 && this.myCurrentViewId == null) {
            Content content4 = contents[0];
            selectID = (String)content4.getUserData(ID_KEY);
            selectSubID = (String)content4.getUserData(SUB_ID_KEY);
        }
        if (selectID != null) {
            this.changeView(selectID, selectSubID);
        }
        this.myUninitializedPanes.clear();
    }

    private void doAddPane(@NotNull AbstractProjectViewPane newPane) {
        String[] stringArray;
        int index2;
        if (newPane == null) {
            ProjectViewImpl.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ContentManager manager = this.getContentManager();
        for (index2 = 0; index2 < manager.getContentCount(); ++index2) {
            Content content2 = manager.getContent(index2);
            String id = (String)content2.getUserData(ID_KEY);
            AbstractProjectViewPane pane = this.myId2Pane.get(id);
            int comp = PANE_WEIGHT_COMPARATOR.compare(pane, newPane);
            LOG.assertTrue(comp != 0, "Project view pane " + newPane + " has the same weight as " + pane + ". Please make sure that you overload getWeight() and return a distinct weight value.");
            if (comp > 0) break;
        }
        String id = newPane.getId();
        this.myId2Pane.put(id, newPane);
        String[] subIds = newPane.getSubIds();
        if (subIds.length == 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = null;
        } else {
            stringArray = subIds;
        }
        subIds = stringArray;
        boolean first2 = true;
        for (String subId : subIds) {
            Icon icon2;
            String title = subId != null ? newPane.getPresentableSubIdName(subId) : newPane.getTitle();
            Content content3 = this.getContentManager().getFactory().createContent(this.getComponent(), title, false);
            content3.setTabName(title);
            content3.putUserData(ID_KEY, (Object)id);
            content3.putUserData(SUB_ID_KEY, (Object)subId);
            content3.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
            Icon icon3 = icon2 = subId != null ? newPane.getPresentableSubIdIcon(subId) : newPane.getIcon();
            if (!ExperimentalUI.isNewUI()) {
                content3.setIcon(icon2);
                content3.setPopupIcon(icon2);
            }
            content3.setPreferredFocusedComponent(() -> {
                AbstractProjectViewPane current = this.getCurrentProjectViewPane();
                return current != null ? current.getComponentToFocus() : null;
            });
            content3.setBusyObject((BusyObject)this);
            if (first2 && subId != null) {
                content3.setSeparator(newPane.getTitle());
            }
            manager.addContent(content3, index2++);
            first2 = false;
        }
    }

    private void showPane(@NotNull AbstractProjectViewPane newPane) {
        if (newPane == null) {
            ProjectViewImpl.$$$reportNull$$$0(6);
        }
        AbstractProjectViewPane currentPane = this.getCurrentProjectViewPane();
        PsiElement selectedPsiElement = null;
        if (currentPane != null) {
            PsiElement[] elements;
            if (currentPane != newPane) {
                currentPane.saveExpandedPaths();
            }
            if ((elements = currentPane.getSelectedPSIElements()).length > 0) {
                selectedPsiElement = elements[0];
            }
        }
        this.myViewContentPanel.removeAll();
        JComponent component2 = newPane.createComponent();
        UIUtil.removeScrollBorder(component2);
        this.myViewContentPanel.setLayout(new BorderLayout());
        this.myViewContentPanel.add((Component)component2, "Center");
        this.myCurrentViewId = newPane.getId();
        String newSubId = this.myCurrentViewSubId = newPane.getSubId();
        this.myViewContentPanel.revalidate();
        this.myViewContentPanel.repaint();
        this.createToolbarActions(newPane);
        if (newPane.myTree != null) {
            this.myAutoScrollToSourceHandler.install((JTree)newPane.myTree);
            this.myAutoScrollToSourceHandler.onMouseClicked((Component)newPane.myTree);
        }
        newPane.restoreExpandedPaths();
        if (selectedPsiElement != null && newSubId != null) {
            ProjectViewSelectInTarget target2;
            VirtualFile virtualFile2 = PsiUtilCore.getVirtualFile(selectedPsiElement);
            ProjectViewSelectInTarget projectViewSelectInTarget = target2 = virtualFile2 == null ? null : this.getProjectViewSelectInTarget(newPane);
            if (target2 != null && target2.isSubIdSelectable(newSubId, (SelectInContext)new FileSelectInContext(this.myProject, virtualFile2, null))) {
                newPane.select(selectedPsiElement, virtualFile2, true);
            }
        }
        this.myProject.getMessageBus().syncPublisher(ProjectViewListener.TOPIC).paneShown(newPane, currentPane);
        ProjectViewImpl.logProjectViewPaneChangedEvent(this.myProject, currentPane, newPane);
    }

    private static void logProjectViewPaneChangedEvent(@NotNull Project project2, @Nullable AbstractProjectViewPane currentPane, @NotNull AbstractProjectViewPane newPane) {
        NamedScope selectedScope;
        if (project2 == null) {
            ProjectViewImpl.$$$reportNull$$$0(7);
        }
        if (newPane == null) {
            ProjectViewImpl.$$$reportNull$$$0(8);
        }
        ArrayList<EventPair> events = new ArrayList<EventPair>(4);
        events.add(ProjectViewPaneChangesCollector.TO_PROJECT_VIEW.with(newPane.getClass()));
        NamedScope namedScope = selectedScope = newPane instanceof ScopeViewPane ? ((ScopeViewPane)newPane).getSelectedScope() : null;
        if (selectedScope != null) {
            events.add(ProjectViewPaneChangesCollector.TO_SCOPE.with(selectedScope.getClass()));
        }
        if (currentPane != null) {
            events.add(ProjectViewPaneChangesCollector.FROM_PROJECT_VIEW.with(currentPane.getClass()));
            NamedScope namedScope2 = selectedScope = currentPane instanceof ScopeViewPane ? ((ScopeViewPane)currentPane).getSelectedScope() : null;
            if (selectedScope != null) {
                events.add(ProjectViewPaneChangesCollector.FROM_SCOPE.with(selectedScope.getClass()));
            }
        }
        ProjectViewPaneChangesCollector.CHANGED.log(project2, events);
    }

    public synchronized void setupImpl(@NotNull ToolWindow toolWindow) {
        if (toolWindow == null) {
            ProjectViewImpl.$$$reportNull$$$0(9);
        }
        this.setupImpl(toolWindow, true);
    }

    public synchronized void setupImpl(@NotNull ToolWindow toolWindow, boolean loadPaneExtensions) {
        if (toolWindow == null) {
            ProjectViewImpl.$$$reportNull$$$0(10);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.isInitialized) {
            return;
        }
        this.myActionGroup = new DefaultActionGroup();
        this.myAutoScrollFromSourceHandler.install();
        this.myContentManager = toolWindow.getContentManager();
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            toolWindow.setDefaultContentUiType(ToolWindowContentUiType.COMBO);
            toolWindow.setAdditionalGearActions((ActionGroup)this.myActionGroup);
            toolWindow.getComponent().putClientProperty("HideIdLabel", "true");
        }
        GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)this.myPanel);
        SwingUtilities.invokeLater(() -> this.splitterProportions.restoreSplitterProportions((Component)this.myPanel));
        if (loadPaneExtensions) {
            this.ensurePanesLoaded();
        }
        this.isInitialized = true;
        this.doAddUninitializedPanes();
        this.getContentManager().addContentManagerListener(new ContentManagerListener(){

            public void selectionChanged(@NotNull ContentManagerEvent event) {
                if (event == null) {
                    21.$$$reportNull$$$0(0);
                }
                if (event.getOperation() == ContentManagerEvent.ContentOperation.add) {
                    ProjectViewImpl.this.viewSelectionChanged();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/projectView/impl/ProjectViewImpl$21", "selectionChanged"));
            }
        });
        this.viewSelectionChanged();
        this.setupToolwindowActions(toolWindow);
        EditorEventMulticaster multicaster = EditorFactory.getInstance().getEventMulticaster();
        if (multicaster instanceof EditorEventMulticasterEx) {
            EditorEventMulticasterEx ex = (EditorEventMulticasterEx)multicaster;
            ex.addFocusChangeListener(new FocusChangeListener(){

                public void focusLost(@NotNull Editor editor2, @NotNull FocusEvent event) {
                    if (editor2 == null) {
                        22.$$$reportNull$$$0(0);
                    }
                    if (event == null) {
                        22.$$$reportNull$$$0(1);
                    }
                    ProjectViewImpl.this.myAutoScrollFromSourceHandler.cancelAllRequests();
                    ProjectViewImpl.this.myAutoScrollOnFocusEditor.set(true);
                }

                public void focusGained(@NotNull Editor editor2, @NotNull FocusEvent event) {
                    if (editor2 == null) {
                        22.$$$reportNull$$$0(2);
                    }
                    if (event == null) {
                        22.$$$reportNull$$$0(3);
                    }
                    if (!Registry.is("ide.autoscroll.from.source.on.focus.gained")) {
                        return;
                    }
                    if (!ProjectViewImpl.this.myAutoScrollOnFocusEditor.getAndSet(true)) {
                        return;
                    }
                    if (ProjectViewImpl.this.isAutoscrollFromSource(ProjectViewImpl.this.getCurrentViewId())) {
                        ProjectViewImpl.this.myAutoScrollFromSourceHandler.addRequest(() -> {
                            if (ProjectViewImpl.this.isAutoscrollFromSource(ProjectViewImpl.this.getCurrentViewId())) {
                                JComponent component2 = editor2.getComponent();
                                for (FileEditor fileEditor : FileEditorManager.getInstance(ProjectViewImpl.this.myProject).getAllEditors()) {
                                    if (!SwingUtilities.isDescendingFrom(component2, fileEditor.getComponent())) continue;
                                    ProjectViewImpl.this.myAutoScrollFromSourceHandler.scrollFromSource(false);
                                    break;
                                }
                            }
                        });
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "editor";
                            break;
                        }
                        case 1: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "event";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/ide/projectView/impl/ProjectViewImpl$22";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "focusLost";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "focusGained";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, (Disposable)this.myProject);
        }
    }

    private void setupToolwindowActions(@NotNull ToolWindow toolWindow) {
        if (toolWindow == null) {
            ProjectViewImpl.$$$reportNull$$$0(11);
        }
        ArrayList titleActions = new ArrayList();
        this.createTitleActions(titleActions);
        if (!titleActions.isEmpty()) {
            toolWindow.setTitleActions(titleActions);
        }
        ArrayList tabActions = new ArrayList();
        this.createTabActions(tabActions);
        if (!tabActions.isEmpty()) {
            ((ToolWindowEx)toolWindow).setTabActions((AnAction[])tabActions.toArray(AnAction[]::new));
        }
    }

    private synchronized void reloadPanes() {
        if (this.myProject.isDisposed() || !this.myExtensionsLoaded.get()) {
            return;
        }
        Map<String, AbstractProjectViewPane> newPanes = this.loadPanes();
        IdentityHashMap<AbstractProjectViewPane, Boolean> oldPanes = new IdentityHashMap<AbstractProjectViewPane, Boolean>();
        this.myUninitializedPanes.forEach(pane -> oldPanes.put((AbstractProjectViewPane)pane, pane == newPanes.get(pane.getId())));
        this.myId2Pane.forEach((id, pane) -> oldPanes.put((AbstractProjectViewPane)pane, pane == newPanes.get(id)));
        oldPanes.forEach((pane, exists) -> {
            if (Boolean.FALSE.equals(exists)) {
                this.removeProjectPane((AbstractProjectViewPane)pane);
                Disposer.dispose(pane);
            }
        });
        for (AbstractProjectViewPane pane2 : newPanes.values()) {
            if (Boolean.TRUE.equals(oldPanes.get(pane2)) || !pane2.isInitiallyVisible()) continue;
            this.addProjectPane(pane2);
        }
    }

    private void ensurePanesLoaded() {
        if (this.myProject.isDisposed() || this.myExtensionsLoaded.getAndSet(true)) {
            return;
        }
        for (AbstractProjectViewPane pane : this.loadPanes().values()) {
            if (!pane.isInitiallyVisible()) continue;
            this.addProjectPane(pane);
        }
    }

    @NotNull
    private Map<String, AbstractProjectViewPane> loadPanes() {
        LinkedHashMap<String, AbstractProjectViewPane> map2 = new LinkedHashMap<String, AbstractProjectViewPane>();
        ArrayList<AbstractProjectViewPane> toSort = new ArrayList<AbstractProjectViewPane>(AbstractProjectViewPane.EP.getExtensions(this.myProject));
        toSort.sort(PANE_WEIGHT_COMPARATOR);
        for (AbstractProjectViewPane pane : toSort) {
            AbstractProjectViewPane added;
            if (pane != (added = map2.computeIfAbsent(pane.getId(), id -> pane))) {
                LOG.warn("ignore duplicated pane with id=" + pane.getId() + "\nold " + added.getClass() + "\nnew " + pane.getClass());
                continue;
            }
            Element element = this.myUninitializedPaneState.remove(pane.getId());
            if (element == null) continue;
            ProjectViewImpl.applyPaneState(pane, element);
        }
        LinkedHashMap<String, AbstractProjectViewPane> linkedHashMap = map2;
        if (linkedHashMap == null) {
            ProjectViewImpl.$$$reportNull$$$0(12);
        }
        return linkedHashMap;
    }

    private void viewSelectionChanged() {
        Content content2 = this.getContentManager().getSelectedContent();
        if (content2 == null) {
            return;
        }
        String id = (String)content2.getUserData(ID_KEY);
        String subId = (String)content2.getUserData(SUB_ID_KEY);
        if (Objects.equals(id, this.myCurrentViewId) && Objects.equals(subId, this.myCurrentViewSubId)) {
            return;
        }
        AbstractProjectViewPane newPane = this.getProjectViewPaneById(id);
        if (newPane == null) {
            return;
        }
        newPane.setSubId(subId);
        this.showPane(newPane);
        ProjectViewSelectInTarget target2 = this.getProjectViewSelectInTarget(newPane);
        if (target2 != null) {
            target2.setSubId(subId);
        }
        if (this.isAutoscrollFromSource(id)) {
            this.myAutoScrollFromSourceHandler.scrollFromSource(false);
        }
    }

    private void createToolbarActions(@NotNull AbstractProjectViewPane pane) {
        if (pane == null) {
            ProjectViewImpl.$$$reportNull$$$0(13);
        }
        if (this.myActionGroup == null) {
            return;
        }
        this.myActionGroup.removeAll();
        DefaultActionGroup group2 = (DefaultActionGroup)ActionManager.getInstance().getAction("ProjectView.ToolWindow.SecondaryActions");
        for (AnAction action2 : group2.getChildActionsOrStubs()) {
            this.myActionGroup.addAction(action2).setAsSecondary(true);
        }
        pane.addToolbarActions(this.myActionGroup);
    }

    protected void createTitleActions(@NotNull List<? super AnAction> titleActions) {
        AnAction action2;
        if (titleActions == null) {
            ProjectViewImpl.$$$reportNull$$$0(14);
        }
        if ((action2 = ActionManager.getInstance().getAction("ProjectViewToolbar")) != null) {
            titleActions.add((AnAction)action2);
        }
    }

    protected void createTabActions(@NotNull List<? super AnAction> tabActions) {
        AnAction action2;
        if (tabActions == null) {
            ProjectViewImpl.$$$reportNull$$$0(15);
        }
        if ((action2 = ActionManager.getInstance().getAction("ProjectViewTabToolbar")) != null) {
            tabActions.add((AnAction)action2);
        }
    }

    protected boolean isShowMembersOptionSupported() {
        return true;
    }

    @Override
    public AbstractProjectViewPane getProjectViewPaneById(String id) {
        AbstractProjectViewPane pane;
        if (!ApplicationManager.getApplication().isUnitTestMode() && ApplicationManager.getApplication().isDispatchThread()) {
            this.ensurePanesLoaded();
        }
        if ((pane = this.myId2Pane.get(id)) != null) {
            return pane;
        }
        for (AbstractProjectViewPane viewPane : this.myUninitializedPanes) {
            if (!viewPane.getId().equals(id)) continue;
            return viewPane;
        }
        return null;
    }

    @Override
    public AbstractProjectViewPane getCurrentProjectViewPane() {
        if (this.myProject.isDisposed()) {
            return null;
        }
        ProjectViewCurrentPaneProvider currentPaneProvider = ProjectViewCurrentPaneProvider.getInstance(this.myProject);
        String currentProjectViewPaneId = currentPaneProvider != null ? currentPaneProvider.getCurrentPaneId() : this.myCurrentViewId;
        return currentProjectViewPaneId != null ? this.getProjectViewPaneById(currentProjectViewPaneId) : null;
    }

    @Override
    public void refresh() {
        AbstractProjectViewPane currentProjectViewPane = this.getCurrentProjectViewPane();
        if (currentProjectViewPane != null) {
            currentProjectViewPane.updateFromRoot(false);
        }
    }

    private boolean isCurrentSelectionObsolete(boolean requestFocus) {
        if (this.myCurrentSelectionObsolete == ThreeState.YES) {
            this.myCurrentSelectionObsolete = ThreeState.NO;
            return true;
        }
        if (this.myCurrentSelectionObsolete == ThreeState.UNSURE) {
            this.myCurrentSelectionObsolete = requestFocus ? ThreeState.YES : ThreeState.NO;
        }
        return false;
    }

    @Override
    public void select(Object element, VirtualFile file2, boolean requestFocus) {
        if (this.isCurrentSelectionObsolete(requestFocus)) {
            return;
        }
        AbstractProjectViewPane viewPane = this.getCurrentProjectViewPane();
        if (viewPane != null) {
            this.myAutoScrollOnFocusEditor.set(!requestFocus);
            viewPane.select(element, file2, requestFocus);
        }
    }

    @Override
    @NotNull
    public ActionCallback selectCB(Object element, VirtualFile file2, boolean requestFocus) {
        if (this.isCurrentSelectionObsolete(requestFocus)) {
            ActionCallback actionCallback = ActionCallback.REJECTED;
            if (actionCallback == null) {
                ProjectViewImpl.$$$reportNull$$$0(16);
            }
            return actionCallback;
        }
        AbstractProjectViewPane viewPane = this.getCurrentProjectViewPane();
        if (viewPane instanceof AbstractProjectViewPaneWithAsyncSupport) {
            this.myAutoScrollOnFocusEditor.set(!requestFocus);
            ActionCallback actionCallback = ((AbstractProjectViewPaneWithAsyncSupport)viewPane).selectCB(element, file2, requestFocus);
            if (actionCallback == null) {
                ProjectViewImpl.$$$reportNull$$$0(17);
            }
            return actionCallback;
        }
        this.select(element, file2, requestFocus);
        ActionCallback actionCallback = ActionCallback.DONE;
        if (actionCallback == null) {
            ProjectViewImpl.$$$reportNull$$$0(18);
        }
        return actionCallback;
    }

    public JComponent getComponent() {
        return this.myDataProvider;
    }

    @Override
    public String getCurrentViewId() {
        return this.myCurrentViewId;
    }

    private SelectInTarget getCurrentSelectInTarget() {
        return this.getSelectInTarget(this.getCurrentViewId());
    }

    private SelectInTarget getSelectInTarget(String id) {
        return this.mySelectInTargets.get(id);
    }

    private ProjectViewSelectInTarget getProjectViewSelectInTarget(AbstractProjectViewPane pane) {
        SelectInTarget target2 = this.getSelectInTarget(pane.getId());
        return target2 instanceof ProjectViewSelectInTarget ? (ProjectViewSelectInTarget)target2 : null;
    }

    @Override
    public PsiElement getParentOfCurrentSelection() {
        AbstractProjectViewPane viewPane = this.getCurrentProjectViewPane();
        if (viewPane == null) {
            return null;
        }
        TreePath path2 = viewPane.getSelectedPath();
        if (path2 == null) {
            return null;
        }
        if ((path2 = path2.getParentPath()) == null) {
            return null;
        }
        ProjectViewNode descriptor2 = (ProjectViewNode)((Object)TreeUtil.getLastUserObject(ProjectViewNode.class, (TreePath)path2));
        if (descriptor2 != null) {
            Object element = descriptor2.getValue();
            if (element instanceof PsiElement) {
                PsiElement psiElement = (PsiElement)element;
                if (!psiElement.isValid()) {
                    return null;
                }
                return psiElement;
            }
            return null;
        }
        return null;
    }

    public ContentManager getContentManager() {
        if (this.myContentManager == null) {
            ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Project").getContentManager();
        }
        return this.myContentManager;
    }

    @Override
    public void changeView() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void changeView(@NotNull String viewId) {
        if (viewId == null) {
            ProjectViewImpl.$$$reportNull$$$0(19);
        }
        this.changeView(viewId, null);
    }

    @Override
    public void changeView(@NotNull String viewId, @Nullable String subId) {
        if (viewId == null) {
            ProjectViewImpl.$$$reportNull$$$0(20);
        }
        this.changeViewCB(viewId, subId);
    }

    @Override
    @NotNull
    public ActionCallback changeViewCB(@NotNull String viewId, @Nullable String subId) {
        boolean hasSubViews;
        AbstractProjectViewPane pane;
        if (viewId == null) {
            ProjectViewImpl.$$$reportNull$$$0(21);
        }
        LOG.assertTrue((pane = this.getProjectViewPaneById(viewId)) != null, "Project view pane not found: " + viewId + "; subId:" + subId + "; project: " + this.myProject);
        boolean bl = hasSubViews = pane.getSubIds().length > 0;
        if (hasSubViews) {
            if (subId == null) {
                subId = pane.getSubId();
            }
        } else if (subId != null) {
            LOG.error("View doesn't have subviews: " + viewId + "; subId:" + subId + "; project: " + this.myProject);
        }
        if (viewId.equals(this.myCurrentViewId) && Objects.equals(subId, this.myCurrentViewSubId)) {
            ActionCallback actionCallback = ActionCallback.REJECTED;
            if (actionCallback == null) {
                ProjectViewImpl.$$$reportNull$$$0(22);
            }
            return actionCallback;
        }
        for (Content content2 : this.getContentManager().getContents()) {
            if (!viewId.equals(content2.getUserData(ID_KEY)) || subId != null && !subId.equals(content2.getUserData(SUB_ID_KEY))) continue;
            ActionCallback actionCallback = this.getContentManager().setSelectedContentCB(content2);
            if (actionCallback == null) {
                ProjectViewImpl.$$$reportNull$$$0(23);
            }
            return actionCallback;
        }
        ActionCallback actionCallback = ActionCallback.REJECTED;
        if (actionCallback == null) {
            ProjectViewImpl.$$$reportNull$$$0(24);
        }
        return actionCallback;
    }

    @Override
    public void selectPsiElement(@NotNull PsiElement element, boolean requestFocus) {
        if (element == null) {
            ProjectViewImpl.$$$reportNull$$$0(25);
        }
        VirtualFile virtualFile2 = PsiUtilCore.getVirtualFile(element);
        this.select(element, virtualFile2, requestFocus);
    }

    @Override
    public void loadState(@NotNull Element parentNode) {
        Element panesElement;
        Element navigatorElement;
        if (parentNode == null) {
            ProjectViewImpl.$$$reportNull$$$0(26);
        }
        if ((navigatorElement = parentNode.getChild(ELEMENT_NAVIGATOR)) != null) {
            this.mySavedPaneId = navigatorElement.getAttributeValue(ATTRIBUTE_CURRENT_VIEW);
            this.mySavedPaneSubId = this.mySavedPaneId == null ? null : navigatorElement.getAttributeValue(ATTRIBUTE_CURRENT_SUBVIEW);
            try {
                this.splitterProportions.readExternal(navigatorElement);
            }
            catch (InvalidDataException invalidDataException) {
                // empty catch block
            }
        }
        if ((panesElement = parentNode.getChild(ELEMENT_PANES)) != null) {
            this.readPaneState(panesElement);
        }
    }

    @Override
    @NotNull
    public String getDefaultViewId() {
        if ("AndroidStudio".equals(PlatformUtils.getPlatformPrefix()) && !Boolean.getBoolean("studio.projectview")) {
            return "AndroidView";
        }
        for (AbstractProjectViewPane extension2 : AbstractProjectViewPane.EP.getExtensions(this.myProject)) {
            if (!extension2.isDefaultPane(this.myProject)) continue;
            String string2 = extension2.getId();
            if (string2 == null) {
                ProjectViewImpl.$$$reportNull$$$0(27);
            }
            return string2;
        }
        return "ProjectPane";
    }

    private void readPaneState(@NotNull Element panesElement) {
        if (panesElement == null) {
            ProjectViewImpl.$$$reportNull$$$0(28);
        }
        List<Element> paneElements = panesElement.getChildren(ELEMENT_PANE);
        for (Element paneElement : paneElements) {
            String paneId = paneElement.getAttributeValue(ATTRIBUTE_ID);
            if (StringUtil.isEmptyOrSpaces(paneId)) continue;
            AbstractProjectViewPane pane = this.myId2Pane.get(paneId);
            if (pane != null) {
                ProjectViewImpl.applyPaneState(pane, paneElement);
                continue;
            }
            this.myUninitializedPaneState.put(paneId, paneElement);
        }
    }

    private static void applyPaneState(@NotNull AbstractProjectViewPane pane, @NotNull Element element) {
        if (pane == null) {
            ProjectViewImpl.$$$reportNull$$$0(29);
        }
        if (element == null) {
            ProjectViewImpl.$$$reportNull$$$0(30);
        }
        try {
            pane.readExternal(element);
        }
        catch (InvalidDataException invalidDataException) {
            // empty catch block
        }
    }

    @Override
    public Element getState() {
        Element parentNode = new Element("projectView");
        Element navigatorElement = new Element(ELEMENT_NAVIGATOR);
        AbstractProjectViewPane currentPane = this.getCurrentProjectViewPane();
        if (currentPane != null) {
            String subId = currentPane.getSubId();
            navigatorElement.setAttribute(ATTRIBUTE_CURRENT_VIEW, currentPane.getId());
            if (subId != null) {
                navigatorElement.setAttribute(ATTRIBUTE_CURRENT_SUBVIEW, subId);
            }
        }
        this.splitterProportions.saveSplitterProportions((Component)this.myPanel);
        try {
            this.splitterProportions.writeExternal(navigatorElement);
        }
        catch (WriteExternalException subId) {
            // empty catch block
        }
        if (!JDOMUtil.isEmpty(navigatorElement)) {
            parentNode.addContent(navigatorElement);
        }
        Element panesElement = new Element(ELEMENT_PANES);
        this.writePaneState(panesElement);
        parentNode.addContent(panesElement);
        return parentNode;
    }

    private void writePaneState(@NotNull Element panesElement) {
        if (panesElement == null) {
            ProjectViewImpl.$$$reportNull$$$0(31);
        }
        for (AbstractProjectViewPane pane : this.myId2Pane.values()) {
            Element paneElement = new Element(ELEMENT_PANE);
            paneElement.setAttribute(ATTRIBUTE_ID, pane.getId());
            try {
                pane.writeExternal(paneElement);
            }
            catch (WriteExternalException e) {
                continue;
            }
            panesElement.addContent(paneElement);
        }
        for (Element element : this.myUninitializedPaneState.values()) {
            panesElement.addContent(element.clone());
        }
    }

    private static ProjectViewSharedSettings getGlobalOptions() {
        return ProjectViewSharedSettings.Companion.getInstance();
    }

    @Override
    public boolean isAutoscrollToSource(String paneId) {
        return this.myAutoscrollToSource.isSelected() && this.myAutoscrollToSource.isEnabled(paneId);
    }

    public void setAutoscrollToSource(boolean autoscrollMode, String paneId) {
        if (this.myAutoscrollToSource.isEnabled(paneId)) {
            this.myAutoscrollToSource.setSelected(autoscrollMode);
        }
    }

    @Override
    public boolean isAutoscrollFromSource(String paneId) {
        return this.isAutoscrollFromSourceEnabled(paneId) && this.isAutoscrollFromSourceNotBlocked(paneId);
    }

    private boolean isAutoscrollFromSourceEnabled(String paneId) {
        if (this.myProject.isDisposed()) {
            return false;
        }
        if (!this.myAutoscrollFromSource.isSelected()) {
            return false;
        }
        return this.myAutoscrollFromSource.isEnabled(paneId);
    }

    private boolean isAutoscrollFromSourceNotBlocked(String paneId) {
        AbstractProjectViewPane pane = this.getProjectViewPaneById(paneId);
        if (pane == null) {
            return false;
        }
        JTree tree = pane.getTree();
        if (tree == null || !tree.isShowing()) {
            return false;
        }
        return !ClientProperty.isTrue(tree, Tree.AUTO_SCROLL_FROM_SOURCE_BLOCKED);
    }

    public void setAutoscrollFromSource(boolean autoscrollMode, String paneId) {
        if (this.myAutoscrollFromSource.isEnabled(paneId)) {
            this.myAutoscrollFromSource.setSelected(autoscrollMode);
        }
    }

    @Override
    public boolean isFlattenPackages(String paneId) {
        return this.myFlattenPackages.isSelected() && this.myFlattenPackages.isEnabled(paneId);
    }

    public void setFlattenPackages(String paneId, boolean flattenPackages) {
        if (this.myFlattenPackages.isEnabled(paneId)) {
            this.myFlattenPackages.setSelected(flattenPackages);
        }
    }

    @Override
    public boolean isFoldersAlwaysOnTop(String paneId) {
        return this.myFoldersAlwaysOnTop.isSelected() && this.myFoldersAlwaysOnTop.isEnabled(paneId);
    }

    @Deprecated(forRemoval=true)
    public boolean isFoldersAlwaysOnTop() {
        return this.myFoldersAlwaysOnTop.isSelected() && this.myFoldersAlwaysOnTop.isEnabled();
    }

    public void setFoldersAlwaysOnTop(boolean foldersAlwaysOnTop) {
        if (this.myFoldersAlwaysOnTop.isEnabled()) {
            this.myFoldersAlwaysOnTop.setSelected(foldersAlwaysOnTop);
        }
    }

    @Override
    public boolean isShowMembers(String paneId) {
        return this.myShowMembers.isSelected() && this.myShowMembers.isEnabled(paneId);
    }

    @Override
    public boolean isHideEmptyMiddlePackages(String paneId) {
        return this.myHideEmptyMiddlePackages.isSelected() && this.myHideEmptyMiddlePackages.isEnabled(paneId);
    }

    @Override
    public boolean isAbbreviatePackageNames(String paneId) {
        return this.myAbbreviatePackageNames.isSelected() && this.myAbbreviatePackageNames.isEnabled(paneId);
    }

    @Override
    public boolean isShowExcludedFiles(String paneId) {
        return this.myShowExcludedFiles.isSelected() && this.myShowExcludedFiles.isEnabled(paneId);
    }

    @Override
    public boolean isShowVisibilityIcons(String paneId) {
        return this.myShowVisibilityIcons.isSelected() && this.myShowVisibilityIcons.isEnabled(paneId);
    }

    @Override
    public boolean isShowLibraryContents(String paneId) {
        return this.myShowLibraryContents.isSelected() && this.myShowLibraryContents.isEnabled(paneId);
    }

    @Override
    public void setShowLibraryContents(@NotNull String paneId, boolean showLibraryContents) {
        if (paneId == null) {
            ProjectViewImpl.$$$reportNull$$$0(32);
        }
        if (this.myShowLibraryContents.isEnabled(paneId)) {
            this.myShowLibraryContents.setSelected(showLibraryContents);
        }
    }

    @Override
    public boolean isShowModules(String paneId) {
        return this.myShowModules.isSelected() && this.myShowModules.isEnabled(paneId);
    }

    @Override
    public void setShowModules(@NotNull String paneId, boolean showModules) {
        if (paneId == null) {
            ProjectViewImpl.$$$reportNull$$$0(33);
        }
        if (this.myShowModules.isEnabled(paneId)) {
            this.myShowModules.setSelected(showModules);
        }
    }

    @Override
    public boolean isFlattenModules(String paneId) {
        return this.myFlattenModules.isSelected() && this.myFlattenModules.isEnabled(paneId);
    }

    @Override
    public void setFlattenModules(@NotNull String paneId, boolean flattenModules) {
        if (paneId == null) {
            ProjectViewImpl.$$$reportNull$$$0(34);
        }
        if (this.myFlattenModules.isEnabled(paneId)) {
            this.myFlattenModules.setSelected(flattenModules);
        }
    }

    @Override
    public boolean isShowURL(String paneId) {
        return Registry.is("project.tree.structure.show.url");
    }

    @Override
    public boolean isShowScratchesAndConsoles(String paneId) {
        return this.myShowScratchesAndConsoles.isEnabled(paneId) ? this.myShowScratchesAndConsoles.isSelected() : false;
    }

    @Override
    public void setHideEmptyPackages(@NotNull String paneId, boolean hideEmptyPackages) {
        if (paneId == null) {
            ProjectViewImpl.$$$reportNull$$$0(35);
        }
        if (this.myHideEmptyMiddlePackages.isEnabled(paneId)) {
            this.myHideEmptyMiddlePackages.setSelected(hideEmptyPackages);
        }
    }

    @Override
    public boolean isUseFileNestingRules(String paneId) {
        if (!this.myCurrentState.getUseFileNestingRules()) {
            return false;
        }
        AbstractProjectViewPane pane = this.myId2Pane.get(paneId);
        return pane != null && pane.isFileNestingEnabled();
    }

    @Override
    public void setUseFileNestingRules(boolean useFileNestingRules) {
        if (this.myProject.isDisposed()) {
            return;
        }
        boolean updated = useFileNestingRules != this.myCurrentState.getUseFileNestingRules();
        this.myCurrentState.setUseFileNestingRules(useFileNestingRules);
        ProjectViewImpl.getDefaultState().setUseFileNestingRules(useFileNestingRules);
        if (updated) {
            this.updatePanes(false);
        }
    }

    @Override
    public boolean isCompactDirectories(String paneId) {
        return this.myCompactDirectories.isSelected() && this.myCompactDirectories.isEnabled(paneId);
    }

    @Override
    public void setCompactDirectories(@NotNull String paneId, boolean compactDirectories) {
        if (paneId == null) {
            ProjectViewImpl.$$$reportNull$$$0(36);
        }
        if (this.myCompactDirectories.isEnabled(paneId)) {
            this.myCompactDirectories.setSelected(compactDirectories);
        }
    }

    @Override
    public void setAbbreviatePackageNames(@NotNull String paneId, boolean abbreviatePackageNames) {
        if (paneId == null) {
            ProjectViewImpl.$$$reportNull$$$0(37);
        }
        if (this.myAbbreviatePackageNames.isEnabled(paneId)) {
            this.myAbbreviatePackageNames.setSelected(abbreviatePackageNames);
        }
    }

    @Override
    public boolean isManualOrder(String paneId) {
        return this.myManualOrder.isSelected() && this.myManualOrder.isEnabled(paneId);
    }

    @Override
    public void setManualOrder(@NotNull String paneId, boolean enabled) {
        if (paneId == null) {
            ProjectViewImpl.$$$reportNull$$$0(38);
        }
        if (this.myManualOrder.isEnabled(paneId)) {
            this.myManualOrder.setSelected(enabled);
        }
    }

    @Override
    public boolean isSortByType(String paneId) {
        return this.mySortByType.isSelected() && this.mySortByType.isEnabled(paneId);
    }

    @Override
    public void setSortByType(@NotNull String paneId, boolean sortByType) {
        if (paneId == null) {
            ProjectViewImpl.$$$reportNull$$$0(39);
        }
        if (this.mySortByType.isEnabled(paneId)) {
            this.mySortByType.setSelected(sortByType);
        }
    }

    boolean isSelectOpenedFileEnabled() {
        return !this.isAutoscrollFromSourceEnabled(this.myCurrentViewId);
    }

    @Nullable
    Runnable getSelectOpenedFile() {
        SimpleSelectInContext context2 = this.myAutoScrollFromSourceHandler.findSelectInContext();
        return context2 == null ? null : () -> context2.selectInCurrentTarget(true);
    }

    @Override
    @NotNull
    public Collection<String> getPaneIds() {
        Collection<String> collection = Collections.unmodifiableCollection(this.myId2Pane.keySet());
        if (collection == null) {
            ProjectViewImpl.$$$reportNull$$$0(40);
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<SelectInTarget> getSelectInTargets() {
        this.ensurePanesLoaded();
        Collection<SelectInTarget> collection = this.mySelectInTargets.values();
        if (collection == null) {
            ProjectViewImpl.$$$reportNull$$$0(41);
        }
        return collection;
    }

    @NotNull
    public ActionCallback getReady(@NotNull Object requestor) {
        AbstractProjectViewPane pane;
        if (requestor == null) {
            ProjectViewImpl.$$$reportNull$$$0(42);
        }
        if ((pane = this.myId2Pane.get(this.myCurrentViewSubId)) == null) {
            pane = this.myId2Pane.get(this.myCurrentViewId);
        }
        ActionCallback actionCallback = pane != null ? pane.getReady(requestor) : ActionCallback.DONE;
        if (actionCallback == null) {
            ProjectViewImpl.$$$reportNull$$$0(43);
        }
        return actionCallback;
    }

    private void updatePanes(boolean withComparator) {
        for (AbstractProjectViewPane pane : this.myId2Pane.values()) {
            SelectionInfo info2;
            JTree tree = pane.getTree();
            if (tree == null) continue;
            SelectionInfo selectionInfo = info2 = pane.getId().equals(this.myCurrentViewId) ? SelectionInfo.create(pane) : null;
            if (withComparator) {
                pane.installComparator();
            }
            pane.updateFromRoot(false);
            if (info2 == null) continue;
            info2.apply(pane);
        }
        if (withComparator) {
            this.myProject.getMessageBus().syncPublisher(BookmarksListener.TOPIC).structureChanged(null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 12, 16, 17, 18, 22, 23, 24, 27, 40, 41, 43 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 40: 
            case 41: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/ProjectViewImpl";
                break;
            }
            case 3: 
            case 4: 
            case 13: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = ELEMENT_PANE;
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPane";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "titleActions";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabActions";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewId";
                break;
            }
            case 25: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panesElement";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paneId";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/ProjectViewImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActions";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "loadPanes";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "selectCB";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "changeViewCB";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultViewId";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getPaneIds";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectInTargets";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getReady";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 40: 
            case 41: 
            case 43: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addProjectPane";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeProjectPane";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doAddPane";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showPane";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "logProjectViewPaneChangedEvent";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setupImpl";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setupToolwindowActions";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createToolbarActions";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createTitleActions";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createTabActions";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "changeView";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "changeViewCB";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "selectPsiElement";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "readPaneState";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "applyPaneState";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "writePaneState";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "setShowLibraryContents";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "setShowModules";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "setFlattenModules";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "setHideEmptyPackages";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "setCompactDirectories";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "setAbbreviatePackageNames";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "setManualOrder";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "setSortByType";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getReady";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2, 12, 16, 17, 18, 22, 23, 24, 27, 40, 41, 43 -> new IllegalStateException(string2);
        };
    }

    abstract class Option
    implements ToggleOptionAction.Option {
        Option() {
        }

        public boolean isEnabled() {
            return this.isEnabled(ProjectViewImpl.this.getCurrentViewId());
        }

        boolean isEnabled(@Nullable String paneId) {
            AbstractProjectViewPane pane = ProjectViewImpl.this.myId2Pane.get(paneId);
            return pane != null ? this.isEnabled(pane) : ApplicationManager.getApplication().isUnitTestMode();
        }

        boolean isEnabled(@NotNull AbstractProjectViewPane pane) {
            if (pane == null) {
                Option.$$$reportNull$$$0(0);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ProjectViewImpl.ELEMENT_PANE, "com/intellij/ide/projectView/impl/ProjectViewImpl$Option", "isEnabled"));
        }
    }

    private final class MyAutoScrollFromSourceHandler
    extends AutoScrollFromSourceHandler {
        private MyAutoScrollFromSourceHandler() {
            super(ProjectViewImpl.this.myProject, (JComponent)ProjectViewImpl.this.myViewContentPanel, (Disposable)ProjectViewImpl.this.myProject);
        }

        void cancelAllRequests() {
            this.myAlarm.cancelAllRequests();
        }

        void addRequest(@NotNull Runnable request2) {
            if (request2 == null) {
                MyAutoScrollFromSourceHandler.$$$reportNull$$$0(0);
            }
            this.myAlarm.cancelAllRequests();
            this.myAlarm.addRequest(request2, this.getAlarmDelay(), this.getModalityState());
        }

        protected void selectElementFromEditor(@NotNull FileEditor fileEditor) {
            SimpleSelectInContext context2;
            if (fileEditor == null) {
                MyAutoScrollFromSourceHandler.$$$reportNull$$$0(1);
            }
            if (this.myProject.isDisposed() || !ProjectViewImpl.this.myViewContentPanel.isShowing()) {
                return;
            }
            if (ProjectViewImpl.this.isAutoscrollFromSource(ProjectViewImpl.this.getCurrentViewId()) && !this.isCurrentProjectViewPaneFocused() && (context2 = this.getSelectInContext(fileEditor)) != null) {
                context2.selectInCurrentTarget(false);
            }
        }

        void scrollFromSource(boolean requestFocus) {
            SimpleSelectInContext context2 = this.findSelectInContext();
            if (context2 != null) {
                context2.selectInCurrentTarget(requestFocus);
            }
        }

        @Nullable
        SimpleSelectInContext findSelectInContext() {
            FileEditorManager fileEditorManager = FileEditorManager.getInstance(this.myProject);
            SimpleSelectInContext context2 = this.getSelectInContext(fileEditorManager.getSelectedEditor());
            if (context2 != null) {
                return context2;
            }
            for (FileEditor fileEditor : fileEditorManager.getSelectedEditors()) {
                context2 = this.getSelectInContext(fileEditor);
                if (context2 == null) continue;
                return context2;
            }
            return null;
        }

        @Nullable
        private SimpleSelectInContext getSelectInContext(@Nullable FileEditor fileEditor) {
            if (fileEditor instanceof TextEditor) {
                TextEditor textEditor = (TextEditor)fileEditor;
                PsiFile psiFile = PsiDocumentManager.getInstance(this.myProject).getPsiFile(textEditor.getEditor().getDocument());
                return psiFile == null ? null : new EditorSelectInContext(psiFile, textEditor.getEditor());
            }
            PsiFile psiFile = this.getPsiFile(this.getVirtualFile(fileEditor));
            return psiFile == null ? null : new SimpleSelectInContext(psiFile);
        }

        private PsiFile getPsiFile(VirtualFile file2) {
            return file2 == null || !file2.isValid() ? null : PsiManager.getInstance(this.myProject).findFile(file2);
        }

        private VirtualFile getVirtualFile(FileEditor fileEditor) {
            return fileEditor == null ? null : fileEditor.getFile();
        }

        private boolean isCurrentProjectViewPaneFocused() {
            AbstractProjectViewPane pane = ProjectViewImpl.this.getCurrentProjectViewPane();
            return pane != null && IJSwingUtilities.hasFocus((Component)pane.getComponentToFocus());
        }

        protected boolean isAutoScrollEnabled() {
            return ProjectViewImpl.this.myAutoscrollFromSource.isSelected();
        }

        protected void setAutoScrollEnabled(boolean state) {
            ProjectViewImpl.this.myAutoscrollFromSource.setSelected(state);
        }

        protected String getActionName() {
            return ActionsBundle.message((String)"action.ProjectView.AutoscrollFromSource.text", (Object[])new Object[0]);
        }

        protected String getActionDescription() {
            return ActionsBundle.message((String)"action.ProjectView.AutoscrollFromSource.description", (Object[])new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileEditor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/projectView/impl/ProjectViewImpl$MyAutoScrollFromSourceHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addRequest";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "selectElementFromEditor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class MyPanel
    extends JPanel
    implements DataProvider {
        MyPanel() {
            super(new BorderLayout());
            ArrayList<AbstractProjectViewPane> snapshot = new ArrayList<AbstractProjectViewPane>(ProjectViewImpl.this.myId2Pane.values());
            ComponentUtil.putClientProperty(this, UIUtil.NOT_IN_HIERARCHY_COMPONENTS, () -> JBIterable.from(snapshot).map(pane -> {
                JComponent last2 = null;
                for (Component c2 : UIUtil.uiParents(pane.getComponentToFocus(), false)) {
                    if (c2 == this || !(c2 instanceof JComponent)) {
                        return null;
                    }
                    last2 = (JComponent)c2;
                }
                return last2;
            }).filter(Conditions.notNull()).iterator());
        }

        public Object getData(@NotNull String dataId) {
            Object paneData;
            if (dataId == null) {
                MyPanel.$$$reportNull$$$0(0);
            }
            AbstractProjectViewPane selectedPane = ProjectViewImpl.this.getCurrentProjectViewPane();
            if (PlatformCoreDataKeys.BGT_DATA_PROVIDER.is(dataId)) {
                DataProvider paneProvider = selectedPane == null ? null : (DataProvider)PlatformCoreDataKeys.BGT_DATA_PROVIDER.getData((DataProvider)selectedPane);
                return CompositeDataProvider.compose(slowId -> this.getSlowData(slowId, paneProvider), (DataProvider)paneProvider);
            }
            Object object = paneData = selectedPane == null ? null : selectedPane.getData(dataId);
            if (paneData != null) {
                return DataValidators.validOrNull((Object)paneData, (String)dataId, (Object)selectedPane);
            }
            if (PlatformDataKeys.CUT_PROVIDER.is(dataId)) {
                return ProjectViewImpl.this.myCopyPasteDelegator.getCutProvider();
            }
            if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
                return ProjectViewImpl.this.myCopyPasteDelegator.getCopyProvider();
            }
            if (PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
                return ProjectViewImpl.this.myCopyPasteDelegator.getPasteProvider();
            }
            if (LangDataKeys.IDE_VIEW.is(dataId)) {
                return ProjectViewImpl.this.myIdeView;
            }
            if (PlatformCoreDataKeys.HELP_ID.is(dataId)) {
                return "viewingStructure.projectViews";
            }
            if (QuickActionProvider.KEY.is(dataId)) {
                return ProjectViewImpl.this;
            }
            return null;
        }

        @Nullable
        private Object getSlowData(@NotNull String dataId, @Nullable DataProvider paneSlowProvider) {
            if (dataId == null) {
                MyPanel.$$$reportNull$$$0(1);
            }
            if (PlatformCoreDataKeys.MODULE.is(dataId)) {
                VirtualFile[] virtualFiles;
                VirtualFile[] virtualFileArray = virtualFiles = paneSlowProvider == null ? null : (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(paneSlowProvider);
                if (virtualFiles == null || virtualFiles.length < 1) {
                    return null;
                }
                if (virtualFiles.length == 1) {
                    return ModuleUtilCore.findModuleForFile(virtualFiles[0], ProjectViewImpl.this.myProject);
                }
                HashSet modules2 = new HashSet();
                for (VirtualFile virtualFile2 : virtualFiles) {
                    ContainerUtil.addIfNotNull(modules2, ModuleUtilCore.findModuleForFile(virtualFile2, ProjectViewImpl.this.myProject));
                }
                return ContainerUtil.getOnlyItem(modules2);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "dataId";
            objectArray2[1] = "com/intellij/ide/projectView/impl/ProjectViewImpl$MyPanel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getSlowData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class ChangeViewAction
    extends AnAction {
        @NotNull
        private final String myId;
        @Nullable
        private final String mySubId;

        private ChangeViewAction(@Nullable String id, String subId) {
            if (id == null) {
                ChangeViewAction.$$$reportNull$$$0(0);
            }
            this.myId = id;
            this.mySubId = subId;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ChangeViewAction.$$$reportNull$$$0(1);
            }
            AbstractProjectViewPane pane = ProjectViewImpl.this.getProjectViewPaneById(this.myId);
            e.getPresentation().setText(this.mySubId != null ? pane.getPresentableSubIdName(this.mySubId) : pane.getTitle());
            e.getPresentation().setIcon(this.mySubId != null ? pane.getPresentableSubIdIcon(this.mySubId) : pane.getIcon());
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                ChangeViewAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ChangeViewAction.$$$reportNull$$$0(3);
            }
            ProjectViewImpl.this.changeView(this.myId, this.mySubId);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = ProjectViewImpl.ATTRIBUTE_ID;
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/projectView/impl/ProjectViewImpl$ChangeViewAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/projectView/impl/ProjectViewImpl$ChangeViewAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2 -> new IllegalStateException(string2);
            };
        }
    }

    private static final class ProjectViewPaneChangesCollector
    extends CounterUsagesCollector {
        private static final EventLogGroup GROUP = new EventLogGroup("project.view.pane.changes", 2);
        private static final ClassEventField TO_PROJECT_VIEW = EventFields.Class((String)"to_class_name");
        private static final ClassEventField TO_SCOPE = EventFields.Class((String)"to_scope_class_name");
        private static final ClassEventField FROM_PROJECT_VIEW = EventFields.Class((String)"from_class_name");
        private static final ClassEventField FROM_SCOPE = EventFields.Class((String)"from_scope_class_name");
        private static final VarargEventId CHANGED = GROUP.registerVarargEvent("changed", new EventField[]{TO_PROJECT_VIEW, TO_SCOPE, FROM_PROJECT_VIEW, FROM_SCOPE});

        private ProjectViewPaneChangesCollector() {
        }

        public EventLogGroup getGroup() {
            return GROUP;
        }
    }

    private class SimpleSelectInContext
    extends SmartSelectInContext {
        SimpleSelectInContext(PsiFile psiFile) {
            if (psiFile == null) {
                SimpleSelectInContext.$$$reportNull$$$0(0);
            }
            super(psiFile, (PsiElement)psiFile);
        }

        void selectInCurrentTarget(boolean requestFocus) {
            SelectInTarget target2 = ProjectViewImpl.this.getCurrentSelectInTarget();
            if (target2 != null && this.getPsiFile() != null) {
                this.selectIn(target2, requestFocus);
            }
        }

        @NotNull
        public FileEditorProvider getFileEditorProvider() {
            FileEditorProvider fileEditorProvider = () -> ArrayUtil.getFirstElement(FileEditorManager.getInstance(ProjectViewImpl.this.myProject).openFile(this.getVirtualFile(), false));
            if (fileEditorProvider == null) {
                SimpleSelectInContext.$$$reportNull$$$0(1);
            }
            return fileEditorProvider;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/projectView/impl/ProjectViewImpl$SimpleSelectInContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/projectView/impl/ProjectViewImpl$SimpleSelectInContext";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileEditorProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1 -> new IllegalStateException(string2);
            };
        }
    }

    private static final class SelectionInfo {
        private final Object @NotNull [] myElements;

        private SelectionInfo(Object @NotNull [] elements) {
            if (elements == null) {
                SelectionInfo.$$$reportNull$$$0(0);
            }
            this.myElements = elements;
        }

        public void apply(AbstractProjectViewPane viewPane) {
            if (viewPane == null) {
                return;
            }
            AbstractTreeBuilder treeBuilder = viewPane.getTreeBuilder();
            DnDAwareTree tree = viewPane.myTree;
            if (treeBuilder != null) {
                DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
                ArrayList<TreePath> paths2 = new ArrayList<TreePath>(this.myElements.length);
                for (Object element : this.myElements) {
                    DefaultMutableTreeNode node2 = treeBuilder.getNodeForElement(element);
                    if (node2 == null) {
                        treeBuilder.buildNodeForElement(element);
                        node2 = treeBuilder.getNodeForElement(element);
                    }
                    if (node2 == null) continue;
                    paths2.add(new TreePath(treeModel.getPathToRoot(node2)));
                }
                if (!paths2.isEmpty()) {
                    tree.setSelectionPaths(TreePathUtil.toTreePathArray(paths2));
                }
            } else {
                List<TreeVisitor> visitors = AbstractProjectViewPane.createVisitors(this.myElements);
                if (1 == visitors.size()) {
                    TreeUtil.promiseSelect((JTree)tree, (TreeVisitor)visitors.get(0));
                } else if (!visitors.isEmpty()) {
                    TreeUtil.promiseSelect((JTree)tree, visitors.stream());
                }
            }
        }

        @NotNull
        public static SelectionInfo create(AbstractProjectViewPane viewPane) {
            TreePath[] selectionPaths;
            List selectedElements = Collections.emptyList();
            if (viewPane != null && (selectionPaths = viewPane.getSelectionPaths()) != null) {
                selectedElements = new ArrayList();
                for (TreePath path2 : selectionPaths) {
                    NodeDescriptor descriptor2 = (NodeDescriptor)TreeUtil.getLastUserObject(NodeDescriptor.class, (TreePath)path2);
                    if (descriptor2 == null) continue;
                    selectedElements.add(descriptor2.getElement());
                }
            }
            return new SelectionInfo(selectedElements.toArray());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/ide/projectView/impl/ProjectViewImpl$SelectionInfo", "<init>"));
        }
    }

    static class Action
    extends ToggleOptionAction
    implements DumbAware {
        private Action(@NotNull Function<? super ProjectViewImpl, ? extends ToggleOptionAction.Option> optionSupplier) {
            if (optionSupplier == null) {
                Action.$$$reportNull$$$0(0);
            }
            super(event -> {
                Project project2 = event.getProject();
                ProjectView view = project2 == null || project2.isDisposed() ? null : ProjectView.getInstance(project2);
                return view instanceof ProjectViewImpl ? (ToggleOptionAction.Option)optionSupplier.apply((ProjectViewImpl)view) : null;
            });
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                Action.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "optionSupplier";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/projectView/impl/ProjectViewImpl$Action";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/projectView/impl/ProjectViewImpl$Action";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1 -> new IllegalStateException(string2);
            };
        }

        static final class SortByType
        extends Action {
            SortByType() {
                super(view -> view.mySortByType);
            }
        }

        static final class ShowVisibilityIcons
        extends Action {
            ShowVisibilityIcons() {
                super(view -> view.myShowVisibilityIcons);
            }
        }

        static final class ShowModules
        extends Action {
            ShowModules() {
                super(view -> view.myShowModules);
            }
        }

        static final class ShowMembers
        extends Action {
            ShowMembers() {
                super(view -> view.myShowMembers);
            }
        }

        static final class ShowLibraryContents
        extends Action {
            ShowLibraryContents() {
                super(view -> view.myShowLibraryContents);
            }
        }

        static final class ShowExcludedFiles
        extends Action {
            ShowExcludedFiles() {
                super(view -> view.myShowExcludedFiles);
            }
        }

        static final class ManualOrder
        extends Action {
            ManualOrder() {
                super(view -> view.myManualOrder);
            }
        }

        static final class HideEmptyMiddlePackages
        extends Action {
            HideEmptyMiddlePackages() {
                super(view -> view.myHideEmptyMiddlePackages);
            }
        }

        static final class ShowScratchesAndConsoles
        extends Action {
            ShowScratchesAndConsoles() {
                super(view -> view.myShowScratchesAndConsoles);
            }
        }

        static final class FoldersAlwaysOnTop
        extends Action {
            FoldersAlwaysOnTop() {
                super(view -> view.myFoldersAlwaysOnTop);
            }
        }

        static final class FlattenPackages
        extends Action {
            FlattenPackages() {
                super(view -> view.myFlattenPackages);
            }
        }

        static final class FlattenModules
        extends Action {
            FlattenModules() {
                super(view -> view.myFlattenModules);
            }
        }

        static final class CompactDirectories
        extends Action {
            CompactDirectories() {
                super(view -> view.myCompactDirectories);
            }
        }

        static final class OpenInPreviewTab
        extends Action {
            OpenInPreviewTab() {
                super(view -> view.myOpenInPreviewTab);
            }
        }

        static final class AutoscrollToSource
        extends Action {
            AutoscrollToSource() {
                super(view -> view.myAutoscrollToSource);
            }
        }

        static final class AutoscrollFromSource
        extends Action {
            AutoscrollFromSource() {
                super(view -> view.myAutoscrollFromSource);
            }
        }

        static final class AbbreviatePackageNames
        extends Action {
            AbbreviatePackageNames() {
                super(view -> view.myAbbreviatePackageNames);
            }
        }
    }

    private class EditorSelectInContext
    extends SimpleSelectInContext {
        private final Editor editor;

        EditorSelectInContext(@NotNull PsiFile psiFile, Editor editor2) {
            if (psiFile == null) {
                EditorSelectInContext.$$$reportNull$$$0(0);
            }
            if (editor2 == null) {
                EditorSelectInContext.$$$reportNull$$$0(1);
            }
            super(psiFile);
            this.editor = editor2;
        }

        @Override
        void selectInCurrentTarget(boolean requestFocus) {
            if (PsiDocumentManager.getInstance(this.getProject()) == null) {
                return;
            }
            this.runWhenPsiAtCaretIsParsed(() -> super.selectInCurrentTarget(requestFocus));
        }

        private void runWhenPsiAtCaretIsParsed(Runnable runnable) {
            int offset2 = this.editor.getCaretModel().getOffset();
            ReadAction.nonBlocking(() -> {
                PsiFile file2 = this.getPsiFile();
                return file2 == null ? null : file2.findElementAt(offset2);
            }).withDocumentsCommitted(this.getProject()).finishOnUiThread(ModalityState.defaultModalityState(), parsedLeaf -> {
                if (this.editor.getCaretModel().getOffset() != offset2) {
                    this.runWhenPsiAtCaretIsParsed(runnable);
                } else {
                    runnable.run();
                }
            }).coalesceBy(EditorSelectInContext.class, ProjectViewImpl.this).expireWhen(() -> ((Editor)this.editor).isDisposed()).submit(AppExecutorUtil.getAppExecutorService());
        }

        public Object getSelectorInFile() {
            PsiFile file2 = this.getPsiFile();
            if (file2 != null) {
                int offset2 = this.editor.getCaretModel().getOffset();
                PsiDocumentManager manager = PsiDocumentManager.getInstance(this.getProject());
                LOG.assertTrue(manager.isCommitted(this.editor.getDocument()));
                PsiElement element = file2.findElementAt(offset2);
                if (element != null) {
                    return element;
                }
            }
            return file2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "psiFile";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ide/projectView/impl/ProjectViewImpl$EditorSelectInContext";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

