/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.InplaceCommentAppender;
import com.intellij.openapi.fileEditor.impl.IdeDocumentHistoryImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.text.JBDateFormat;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\u00020\u00012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\"\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a8\u0006\n"}, d2={"appendInplaceComments", "", "node", "Lcom/intellij/ide/projectView/ProjectViewNode;", "appender", "Lcom/intellij/ide/util/treeView/InplaceCommentAppender;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.platform.lang.impl"})
public final class ProjectViewInplaceCommentProducerImplKt {
    public static final void appendInplaceComments(@NotNull ProjectViewNode<?> node2, @NotNull InplaceCommentAppender appender) {
        Intrinsics.checkNotNullParameter(node2, (String)"node");
        Intrinsics.checkNotNullParameter((Object)appender, (String)"appender");
        AbstractTreeNode parentNode = node2.getParent();
        Object content2 = node2.getValue();
        if (content2 instanceof PsiFileSystemItem || !(content2 instanceof PsiElement) || parentNode != null && parentNode.getValue() instanceof PsiDirectory) {
            ProjectViewInplaceCommentProducerImplKt.appendInplaceComments(appender, node2.getProject(), node2.getVirtualFile());
        }
    }

    public static final void appendInplaceComments(@NotNull InplaceCommentAppender appender, @Nullable Project project2, @Nullable VirtualFile file2) {
        BasicFileAttributes basicFileAttributes;
        Intrinsics.checkNotNullParameter((Object)appender, (String)"appender");
        Path ioFile = file2 == null || file2.isDirectory() || !file2.isInLocalFileSystem() ? null : file2.toNioPath();
        try {
            Path path2 = ioFile;
            basicFileAttributes = path2 == null ? null : Files.readAttributes(path2, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (Exception ignored) {
            basicFileAttributes = null;
        }
        BasicFileAttributes fileAttributes = basicFileAttributes;
        if (fileAttributes != null) {
            appender.append("  ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
            SimpleTextAttributes attributes = SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES;
            appender.append(JBDateFormat.getFormatter().formatDateTime(fileAttributes.lastModifiedTime().toMillis()), attributes);
            appender.append(", " + StringUtil.formatFileSize(fileAttributes.size()), attributes);
        }
        if (Registry.is("show.last.visited.timestamps") && file2 != null && project2 != null) {
            IdeDocumentHistoryImpl.appendTimestamp((Project)project2, (InplaceCommentAppender)appender, (VirtualFile)file2);
        }
    }
}

